/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.hepromo.model.calc;

import ch.wsl.fps.hepromo.model.Ergebnis;
import ch.wsl.fps.hepromo.model.HeProMoInputData;
import ch.wsl.fps.hepromo.model.aobj.ArbeitsobjektVorruecken2018;
import ch.wsl.fps.hepromo.model.asys.ArbeitssystemVorruecken2018;
import ch.wsl.fps.hepromo.model.calc.AbstractCalculatorSingleModel2014;

public class CalculatorVorruecken2018
extends AbstractCalculatorSingleModel2014 {
    public CalculatorVorruecken2018(HeProMoInputData inputData) {
        super(inputData);
    }

    @Override
    public ArbeitsobjektVorruecken2018 getArbeitsobjekt() {
        return (ArbeitsobjektVorruecken2018)super.getArbeitsobjekt();
    }

    @Override
    public ArbeitssystemVorruecken2018 getArbeitssystem() {
        return (ArbeitssystemVorruecken2018)super.getArbeitssystem();
    }

    @Override
    public Ergebnis calculate() {
        Ergebnis ergebnis = super.calculate();
        double pmh15Motorsaege_hProM3 = 1.0 / this.calcProduktivitaetMotorsaege_m3oRproPMH15();
        double pmh15Motorsaege_total = pmh15Motorsaege_hProM3 * this.getRelevanteHolzmenge();
        ergebnis.setZeitMaschine2(pmh15Motorsaege_total *= this.faktoren.getKorrekturFaktor());
        ergebnis.setKostenMaschine2_total(this.getArbeitssystem().getKostensatzMaschine2_proH() * pmh15Motorsaege_total);
        return ergebnis;
    }

    @Override
    protected double calcPsh0_hProM3() {
        double m3ProPMH15 = this.calcProduktivitaetSystem_m3oRproPMH15();
        double pmh15_hProM3 = 1.0 / m3ProPMH15;
        double psh0_hProM3 = pmh15_hProM3 / this.f_0bis15;
        return psh0_hProM3;
    }

    private double calcProduktivitaetSystem_m3oRproPMH15() {
        return this.convertZeitaufwandProBaumOhneZuschlaege_min_to_m3oRproPMH15(this.getZeitaufwandSystemProBaumOhneZuschlaege_min());
    }

    private double calcProduktivitaetMotorsaege_m3oRproPMH15() {
        return this.convertZeitaufwandProBaumOhneZuschlaege_min_to_m3oRproPMH15(this.getZeitaufwandMotorsaegeProBaumOhneZuschlaege_min());
    }

    private double convertZeitaufwandProBaumOhneZuschlaege_min_to_m3oRproPMH15(double zeitaufwandProBaum_min) {
        double vMit = this.getVMit();
        double mfHang = this.getMfHangneigung();
        double f_iR_oR = this.rindenAbzugBeruecksichtigen ? this.getArbeitsobjekt().getRindenAbzugFaktor() : 1.0;
        double effSteig = this.getArbeitssystem().getMaschinentyp() == ArbeitssystemVorruecken2018.Maschinentyp.Rueckeraupe ? this.getArbeitssystem().getProduktivtaetssteigerungRueckeraupe() : 1.0;
        double zeitaufwandProBaum_h = zeitaufwandProBaum_min / 60.0;
        double zeitaufwandProM3_h = zeitaufwandProBaum_h / vMit;
        double zeitaufwand_PMH15proM3iR = zeitaufwandProM3_h * mfHang;
        double zeitaufwand_PMH15proM3oR = zeitaufwand_PMH15proM3iR / f_iR_oR;
        double produktivitaetSystem_m3oRproPMH15 = 1.0 / zeitaufwand_PMH15proM3oR * effSteig;
        return produktivitaetSystem_m3oRproPMH15;
    }

    private double getZeitaufwandSystemProBaumOhneZuschlaege_min() {
        double bhd = this.getArbeitsobjekt().getBhd_cm();
        boolean isAbzopf = this.getArbeitsobjekt().isAbzopfenDerKrone();
        double result = 0.1786 * bhd + 1.275;
        if (!isAbzopf) {
            result -= 0.25;
        }
        return result;
    }

    private double getZeitaufwandMotorsaegeProBaumOhneZuschlaege_min() {
        double bhd = this.getArbeitsobjekt().getBhd_cm();
        boolean isAbzopf = this.getArbeitsobjekt().isAbzopfenDerKrone();
        double result = 0.0918 * bhd + 0.3409;
        if (!isAbzopf) {
            result -= 0.5;
        }
        return result;
    }

    private double getVMit() {
        ArbeitsobjektVorruecken2018.Standortguete standortguete = this.getArbeitsobjekt().getStandortguete();
        double bhd_cm = this.getArbeitsobjekt().getBhd_cm();
        double result = CalculatorVorruecken2018.getVMit(standortguete, bhd_cm);
        return result;
    }

    public static double getVMit(ArbeitsobjektVorruecken2018.Standortguete standortguete, double bhd_cm) {
        LuzernerTarif tarif = LuzernerTarif.getTarifForStandortguete(standortguete);
        double a = tarif.a;
        double b = tarif.b;
        double result = a * Math.pow(bhd_cm, b);
        return result;
    }

    private double getMfHangneigung() {
        ArbeitsobjektVorruecken2018.Hangneigung hangneigung = this.getArbeitsobjekt().getHangneigung();
        return CalculatorVorruecken2018.getMultiplikationsfaktorHangneigung(hangneigung);
    }

    private static double getMultiplikationsfaktorHangneigung(ArbeitsobjektVorruecken2018.Hangneigung hangneigung) {
        switch (hangneigung) {
            case HN_BIS_15_PRZ: {
                return 1.0;
            }
            case HN_GROESSER_15_BIS_25_PRZ: {
                return 1.07;
            }
            case HN_GROESSER_25_BIS_35_PRZ: {
                return 1.18;
            }
            case HN_GROESSER_35_BIS_45_PRZ: {
                return 1.33;
            }
            case HN_GROESSER_45_BIS_55_PRZ: {
                return 1.53;
            }
            case HN_GROESSER_55_PRZ: {
                return 1.78;
            }
        }
        throw new RuntimeException(hangneigung.name());
    }

    @Override
    protected double getAnzahlPersonalVollzeitAequivalente() {
        return 2.0;
    }

    private static enum LuzernerTarif {
        TARIF1(9.0E-4, 2.0478),
        TARIF2(3.0E-4, 2.3531),
        TARIF3(2.0E-4, 2.42),
        TARIF4(8.0E-5, 2.5894),
        TARIF5(2.0E-5, 2.8915);

        private final double a;
        private final double b;

        private LuzernerTarif(double a, double b) {
            this.a = a;
            this.b = b;
        }

        private static LuzernerTarif getTarifForStandortguete(ArbeitsobjektVorruecken2018.Standortguete standort) {
            switch (standort) {
                case SEHR_GUT: {
                    return TARIF1;
                }
                case GUT: {
                    return TARIF2;
                }
                case MITTEL: {
                    return TARIF3;
                }
                case WENIGER_GUT: {
                    return TARIF4;
                }
                case ARM: {
                    return TARIF5;
                }
            }
            throw new RuntimeException(standort.name());
        }
    }
}

