/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.hepromo.model.calc;

import ch.wsl.fps.hepromo.model.HeProMoInputData;
import ch.wsl.fps.hepromo.model.aobj.ArbeitsobjektSchlepper2014;
import ch.wsl.fps.hepromo.model.asys.ArbeitssystemSchlepper2014;
import ch.wsl.fps.hepromo.model.calc.AbstractCalculatorSingleModel2014;

public class CalculatorSchlepper2014
extends AbstractCalculatorSingleModel2014 {
    public CalculatorSchlepper2014(HeProMoInputData inputData) {
        super(inputData);
    }

    @Override
    protected ArbeitsobjektSchlepper2014 getArbeitsobjekt() {
        return (ArbeitsobjektSchlepper2014)super.getArbeitsobjekt();
    }

    @Override
    protected double calcPsh0_hProM3() {
        double m3ProPsh15 = this.calcProduktivitaet_m3oRProPsh15();
        if (this.rindenAbzugBeruecksichtigen) {
            double rindenabzug_fix = 0.9;
            double rindenabzug_variabel = this.getArbeitsobjekt().getRindenAbzugFaktor();
            m3ProPsh15 *= rindenabzug_variabel / rindenabzug_fix;
        }
        double psh15ProM3 = 1.0 / m3ProPsh15;
        double psh0ProM3 = psh15ProM3 / this.f_0bis15;
        return psh0ProM3;
    }

    private double calcProduktivitaet_m3oRProPsh15() {
        double a = 15.8005;
        double b = -1.7838;
        double c = -1.0;
        double d = -1.0;
        switch (this.getArbeitssystem().getMaschinenkategorie()) {
            case Seilschlepper: {
                c = -6.4945;
                d = 1.1923;
                break;
            }
            case Kranschlepper: {
                c = -3.5725;
                d = 3.0337;
                break;
            }
            case Klemmbankschlepper: {
                c = 0.0;
                d = 8.0771;
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        double vMit = this.getArbeitsobjekt().getMittlererStueckinhalt();
        if (vMit < 0.05) {
            throw new RuntimeException("Mittlerer St\u00fcckinhalt muss mindestens 0.05m3 sein!");
        }
        if (this.getArbeitssystem().getMaschinenkategorie() == ArbeitssystemSchlepper2014.Maschinenkategorie.Klemmbankschlepper && vMit < 0.36) {
            throw new RuntimeException("Beim Klemmbankschlepper muss der mittlerer St\u00fcckinhalt mindestens 0.36m3 sein!");
        }
        double lowVMitFactor = 1.0;
        if (vMit < 0.14) {
            lowVMitFactor = vMit / 0.14;
            vMit = 0.14;
        }
        double tap = a + b * Math.log(this.getArbeitsobjekt().getMittlereFahrentfernung().value()) + c + d * Math.log(vMit);
        tap *= lowVMitFactor;
        return tap *= this.getArbeitsobjekt().getGesamtfaktorAllerZuschlaege();
    }

    @Override
    protected ArbeitssystemSchlepper2014 getArbeitssystem() {
        return (ArbeitssystemSchlepper2014)super.getArbeitssystem();
    }
}

