/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.hepromo.model.calc;

import ch.wsl.fps.hepromo.model.Ergebnis;
import ch.wsl.fps.hepromo.model.Faktoren;
import ch.wsl.fps.hepromo.model.HeProMoInputData;
import ch.wsl.fps.hepromo.model.aobj.Arbeitsobjekt;
import ch.wsl.fps.hepromo.model.aobj.ArbeitsobjektEntastenMotormanuell;
import ch.wsl.fps.hepromo.model.aobj.ArbeitsobjektEntrinden;
import ch.wsl.fps.hepromo.model.aobj.ArbeitsobjektFaellenMotormanuell;
import ch.wsl.fps.hepromo.model.aobj.ArbeitsobjektIhLangAufarbeiten;
import ch.wsl.fps.hepromo.model.aobj.ArbeitsobjektMotormanuellGesamt;
import ch.wsl.fps.hepromo.model.aobj.ArbeitsobjektSchichtholzAufarbeiten;
import ch.wsl.fps.hepromo.model.aobj.ArbeitsobjektStammholzAufarbeiten;
import ch.wsl.fps.hepromo.model.asys.Arbeitssystem;
import ch.wsl.fps.hepromo.model.calc.AbstractCalculatorComposedModel;
import ch.wsl.fps.hepromo.model.calc.CalculatorEntastenMotormanuell;
import ch.wsl.fps.hepromo.model.calc.CalculatorEntrindenMitBiber;
import ch.wsl.fps.hepromo.model.calc.CalculatorEntrindenVonHand;
import ch.wsl.fps.hepromo.model.calc.CalculatorFaellenMotormanuell;
import ch.wsl.fps.hepromo.model.calc.CalculatorIhLangAufarbeiten;
import ch.wsl.fps.hepromo.model.calc.CalculatorSchichtholzAufarbeiten;
import ch.wsl.fps.hepromo.model.calc.CalculatorStammholzAufarbeiten;

public class CalculatorMotormanuellGesamt
extends AbstractCalculatorComposedModel {
    public CalculatorMotormanuellGesamt(HeProMoInputData inputData) {
        super(inputData);
    }

    @Override
    protected ArbeitsobjektMotormanuellGesamt getArbeitsobjekt() {
        return (ArbeitsobjektMotormanuellGesamt)super.getArbeitsobjekt();
    }

    @Override
    public Ergebnis calculate() {
        Ergebnis eFaellen = this.getErgebnisFaellen();
        Ergebnis eEntasten = this.getErgebnisEntasten();
        Ergebnis eEntrindenVonHand = this.getErgebnisEntrindenVonHand();
        Ergebnis eAufarbeiten = this.getSummierteTeilergebnisseAufarbeiten();
        Ergebnis ergebnis = new Ergebnis();
        ergebnis.setAnzahl_m3(eFaellen.getAnzahl_m3());
        ergebnis.setZeitPersonal(eFaellen.getZeitPersonal() + eEntasten.getZeitPersonal() + eEntrindenVonHand.getZeitPersonal() + eAufarbeiten.getZeitPersonal());
        ergebnis.setZeitMaschine1(eFaellen.getZeitMaschine1() + eEntasten.getZeitMaschine1() + 0.0 + eAufarbeiten.getZeitMaschine1());
        ergebnis.setZeitMaschine2(eEntrindenVonHand.getZeitMaschine1());
        ergebnis.setZeitUmsetzen(this.getArbeitssystem().getUmsetzenZeit_h());
        ergebnis.setZeitWeitereAufwaende(this.getArbeitssystem().getWeitereAufwaendeZeit_h());
        ergebnis.setKostenPersonal_total(eFaellen.getKostenPersonal_total() + eEntasten.getKostenPersonal_total() + eEntrindenVonHand.getKostenPersonal_total() + eAufarbeiten.getKostenPersonal_total());
        ergebnis.setKostenMaschine1_total(eFaellen.getKostenMaschine1_total() + eEntasten.getKostenMaschine1_total() + eAufarbeiten.getKostenMaschine1_total());
        ergebnis.setKostenMaschine2_total(eEntrindenVonHand.getKostenMaschine1_total());
        ergebnis.setKostenUmsetzen_total(this.getArbeitssystem().getUmsetzenBetrag_CHF());
        ergebnis.setKostenWeitereAufwaende_total(this.getArbeitssystem().getWeitereAufwaendeBetrag_CHF());
        ergebnis.setRisikoVerwaltungGewinn_Prz(eFaellen.getRisikoVerwaltungGewinn_Prz());
        ergebnis.setMehrwertsteuer_Prz(eFaellen.getMehrwertsteuer_Prz());
        ergebnis.setLabelPersonal1(this.getArbeitssystem().getLabelPersonal1());
        ergebnis.setLabelMaschine1(this.getArbeitssystem().getLabelMaschine1());
        ergebnis.setLabelMaschine2(this.getArbeitssystem().getLabelMaschine2());
        ergebnis.hideDauerDerArbeit();
        ergebnis.hideProduktivitaet();
        return ergebnis;
    }

    private Ergebnis getSummierteTeilergebnisseAufarbeiten() {
        Ergebnis eStammholzAufarbeiten = this.getErgebnisStammholzAufarbeiten();
        Ergebnis eIndustrieholzAufarbeiten = this.getErgebnisIndustrieholzAufarbeiten();
        Ergebnis eSchichtholzAufarbeiten = this.getErgebnisSchichtholzAufarbeiten();
        Ergebnis ergebnis = new Ergebnis();
        ergebnis.setZeitPersonal(eStammholzAufarbeiten.getZeitPersonal() + eIndustrieholzAufarbeiten.getZeitPersonal() + eSchichtholzAufarbeiten.getZeitPersonal());
        ergebnis.setZeitMaschine1(eStammholzAufarbeiten.getZeitMaschine1() + eIndustrieholzAufarbeiten.getZeitMaschine1() + eSchichtholzAufarbeiten.getZeitMaschine1());
        ergebnis.setKostenPersonal_total(eStammholzAufarbeiten.getKostenPersonal_total() + eIndustrieholzAufarbeiten.getKostenPersonal_total() + eSchichtholzAufarbeiten.getKostenPersonal_total());
        ergebnis.setKostenMaschine1_total(eStammholzAufarbeiten.getKostenMaschine1_total() + eIndustrieholzAufarbeiten.getKostenMaschine1_total() + eSchichtholzAufarbeiten.getKostenMaschine1_total());
        return ergebnis;
    }

    private HeProMoInputData getInputDataMotormanuell(Arbeitsobjekt ao) {
        Faktoren faktoren = this.faktoren;
        Arbeitssystem as = super.getArbeitssystem();
        HeProMoInputData inputData = this.createHeProMoInputData(ao, as, faktoren);
        return inputData;
    }

    private Ergebnis getErgebnisFaellen() {
        ArbeitsobjektFaellenMotormanuell ao = this.getArbeitsobjekt().getTeilobjektFaellen();
        HeProMoInputData inputData = this.getInputDataMotormanuell(ao);
        CalculatorFaellenMotormanuell calc = new CalculatorFaellenMotormanuell(inputData);
        Ergebnis ergebnis = calc.calculate();
        return ergebnis;
    }

    private Ergebnis getErgebnisEntasten() {
        ArbeitsobjektEntastenMotormanuell ao = this.getArbeitsobjekt().getTeilobjektEntasten();
        HeProMoInputData inputData = this.getInputDataMotormanuell(ao);
        CalculatorEntastenMotormanuell calc = new CalculatorEntastenMotormanuell(inputData);
        Ergebnis ergebnis = calc.calculate();
        return ergebnis;
    }

    private Ergebnis getErgebnisEntrindenVonHand() {
        ArbeitsobjektEntrinden ao = this.getArbeitsobjekt().getTeilobjektEntrinden();
        HeProMoInputData inputData = this.getInputDataMotormanuell(ao);
        double kostenansatzMaschine1 = inputData.getArbeitssystem().getKostensatzMaschine1_proH();
        double kostenansatzMaschine2 = inputData.getArbeitssystem().getKostensatzMaschine2_proH();
        inputData.getArbeitssystem().setKostensatzMaschine1_proH(kostenansatzMaschine2);
        CalculatorEntrindenVonHand calc = new CalculatorEntrindenVonHand(inputData);
        Ergebnis ergebnis = calc.calculate();
        inputData.getArbeitssystem().setKostensatzMaschine1_proH(kostenansatzMaschine1);
        return ergebnis;
    }

    private Ergebnis getErgebnisEntrindenMitBiber() {
        ArbeitsobjektEntrinden ao = this.getArbeitsobjekt().getTeilobjektEntrinden();
        HeProMoInputData inputData = this.getInputDataMotormanuell(ao);
        CalculatorEntrindenMitBiber calc = new CalculatorEntrindenMitBiber(inputData);
        Ergebnis ergebnis = calc.calculate();
        return ergebnis;
    }

    private Ergebnis getErgebnisIndustrieholzAufarbeiten() {
        ArbeitsobjektIhLangAufarbeiten ao = this.getArbeitsobjekt().getTeilobjektIndustrieholzAufarbeiten();
        HeProMoInputData inputData = this.getInputDataMotormanuell(ao);
        CalculatorIhLangAufarbeiten calc = new CalculatorIhLangAufarbeiten(inputData);
        Ergebnis ergebnis = calc.calculate();
        return ergebnis;
    }

    private Ergebnis getErgebnisSchichtholzAufarbeiten() {
        ArbeitsobjektSchichtholzAufarbeiten ao = this.getArbeitsobjekt().getTeilobjektSchichtholzAufarbeiten();
        HeProMoInputData inputData = this.getInputDataMotormanuell(ao);
        CalculatorSchichtholzAufarbeiten calc = new CalculatorSchichtholzAufarbeiten(inputData);
        Ergebnis ergebnis = calc.calculate();
        return ergebnis;
    }

    private Ergebnis getErgebnisStammholzAufarbeiten() {
        ArbeitsobjektStammholzAufarbeiten ao = this.getArbeitsobjekt().getTeilobjektStammholzAufarbeiten();
        HeProMoInputData inputData = this.getInputDataMotormanuell(ao);
        CalculatorStammholzAufarbeiten calc = new CalculatorStammholzAufarbeiten(inputData);
        Ergebnis ergebnis = calc.calculate();
        return ergebnis;
    }
}

