/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.hepromo.model.calc;

import ch.wsl.fps.hepromo.model.HeProMoInputData;
import ch.wsl.fps.hepromo.model.aobj.ArbeitsobjektMobilseilkranInstallation;
import ch.wsl.fps.hepromo.model.asys.ArbeitssystemSeilkran;
import ch.wsl.fps.hepromo.model.calc.AbstractCalculatorSingleModel;

public class CalculatorMobilseilkranInstallation
extends AbstractCalculatorSingleModel {
    public CalculatorMobilseilkranInstallation(HeProMoInputData inputData) {
        super(inputData);
    }

    @Override
    protected ArbeitsobjektMobilseilkranInstallation getArbeitsobjekt() {
        return (ArbeitsobjektMobilseilkranInstallation)super.getArbeitsobjekt();
    }

    @Override
    protected ArbeitssystemSeilkran getArbeitssystem() {
        return (ArbeitssystemSeilkran)super.getArbeitssystem();
    }

    @Override
    protected double calcPsh0_hProM3() {
        double psh0_Grundzeit = this.getPsh0_Grundzeit();
        double psh0_Endmasten = this.getPsh0_Endmasten();
        double psh0_Stuetzen = this.getPsh0_Stuetzen();
        double psh0_Mehrbaumanker = this.getPsh0_Mehrbaumanker();
        double psh0_MaschinenStandortOben = this.getPsh0_MaschinenStandortOben();
        double psh0_Installation = psh0_Grundzeit + psh0_Endmasten + psh0_Stuetzen + psh0_Mehrbaumanker - psh0_MaschinenStandortOben;
        this.f_stoer = 1.0;
        this.f_0bis15 = 1.1;
        this.f_indir = 1.5;
        return psh0_Installation /= this.getRelevanteHolzmenge();
    }

    private double getPsh0_Grundzeit() {
        double a = -1.0;
        double b = -1.0;
        switch (this.getArbeitsobjekt().getSeilsystem()) {
            case ZweiseilSystem: {
                a = 497.0;
                b = 0.577;
                break;
            }
            case MehrseilSystem: {
                a = 281.0;
                b = 2.332;
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        double linienLaenge = this.getArbeitsobjekt().getLinienLaenge_m();
        double anzPers = this.getArbeitssystem().getAnzahlPersonal();
        double psh0 = 0.016666666666666666 * (1.0 / anzPers) * (a + b * linienLaenge);
        return psh0;
    }

    private double getPsh0_Endmasten() {
        if (!this.getArbeitsobjekt().isEndmast()) {
            return 0.0;
        }
        double tragseilHoehe = this.getArbeitsobjekt().getTragseilHoeheEndmast();
        double anzPers = this.getArbeitssystem().getAnzahlPersonal();
        double psh0 = 0.016666666666666666 * (1.0 / anzPers) * (-1.0 + 19.57 * tragseilHoehe);
        return psh0;
    }

    private double getPsh0_Stuetzen() {
        double psh0 = 0.0;
        double anzPers = this.getArbeitssystem().getAnzahlPersonal();
        double anzahlStuetzen = this.getArbeitsobjekt().getStuetzenTragseilHoehen().size();
        int i = 0;
        while ((double)i < anzahlStuetzen) {
            double tragseilHoehe = this.getArbeitsobjekt().getStuetzenTragseilHoehen().get(i).intValue();
            psh0 += 0.016666666666666666 * (1.0 / anzPers) * (177.0 + 10.5 * tragseilHoehe);
            ++i;
        }
        return psh0;
    }

    private double getPsh0_Mehrbaumanker() {
        double linienLaenge = this.getArbeitsobjekt().getLinienLaenge_m();
        if (linienLaenge < 150.0) {
            linienLaenge = 150.0;
        }
        double anzPers = this.getArbeitssystem().getAnzahlPersonal();
        double psh0 = 0.016666666666666666 * (1.0 / anzPers) * (-17.0 + 0.149 * linienLaenge);
        return psh0;
    }

    private double getPsh0_MaschinenStandortOben() {
        double psh0 = 0.0;
        if (this.getArbeitsobjekt().getSeilsystem() == ArbeitsobjektMobilseilkranInstallation.Seilsystem.MehrseilSystem && this.getArbeitsobjekt().getMaschinenStandort() == ArbeitsobjektMobilseilkranInstallation.MaschinenStandort.Oben) {
            double linienLaenge = this.getArbeitsobjekt().getLinienLaenge_m();
            double anzPers = this.getArbeitssystem().getAnzahlPersonal();
            psh0 = 0.016666666666666666 * (1.0 / anzPers) * (8.0 + 0.08 * linienLaenge);
        }
        return psh0;
    }

    @Override
    protected double getAnzahlPersonalVollzeitAequivalente() {
        return this.getArbeitssystem().getAnzahlPersonal();
    }

    @Override
    protected double getLaufzeitAnteilMaschine() {
        return (double)this.getArbeitssystem().getAnteilSeilkranLaufzeit_Prz() / 100.0;
    }
}

