/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.hepromo.model.calc;

import ch.wsl.fps.hepromo.model.HeProMoInputData;
import ch.wsl.fps.hepromo.model.aobj.ArbeitsobjektKonventionellerSeilkranSeilen;
import ch.wsl.fps.hepromo.model.asys.ArbeitssystemSeilkran;
import ch.wsl.fps.hepromo.model.calc.AbstractCalculatorSingleModel;

public class CalculatorKonventionellerSeilkranSeilen
extends AbstractCalculatorSingleModel {
    public CalculatorKonventionellerSeilkranSeilen(HeProMoInputData inputData) {
        super(inputData);
        this.f_indir = 1.0;
        this.f_stoer = 1.022;
    }

    @Override
    protected ArbeitsobjektKonventionellerSeilkranSeilen getArbeitsobjekt() {
        return (ArbeitsobjektKonventionellerSeilkranSeilen)super.getArbeitsobjekt();
    }

    @Override
    protected ArbeitssystemSeilkran getArbeitssystem() {
        return (ArbeitssystemSeilkran)super.getArbeitssystem();
    }

    @Override
    protected double calcPsh0_hProM3() {
        double psh0_Anhaengen = this.getPsh0_Anhaengen();
        double psh0_SeitlicherZuzug = this.getPsh0_SeitlicherZuzug();
        double psh0_VertikalbewegungImBestand = this.getPsh0_VertikalbewegungImBestand();
        double psh0_FahrtAmTragseil = this.getPsh0_FahrtAmTragseil();
        double psh0_VertikalbewegungAmLagerplatz = this.getPsh0_VertikalbewegungAmLagerplatz();
        double psh0_Abhaengen = this.getPsh0_Abhaengen();
        double psh0_SeilenLast = psh0_Anhaengen + psh0_SeitlicherZuzug + psh0_VertikalbewegungImBestand + psh0_FahrtAmTragseil + psh0_VertikalbewegungAmLagerplatz + psh0_Abhaengen;
        double lastVolumen = this.getLastVolumen();
        double psh0_Seilen = psh0_SeilenLast / lastVolumen;
        if (this.rindenAbzugBeruecksichtigen) {
            psh0_Seilen /= this.getArbeitsobjekt().getRindenAbzugFaktor();
        }
        return psh0_Seilen;
    }

    private double getLastVolumen() {
        double lastVolumen = 0.0;
        double stueckVolumen = this.getArbeitsobjekt().getMittleresStueckvolumen_m3();
        if (this.getArbeitsobjekt().getHolzSeilOrt() == ArbeitsobjektKonventionellerSeilkranSeilen.HolzSeilOrt.AusSchlagflaeche) {
            double stueckLaenge = this.getArbeitsobjekt().getStuecklaenge_m();
            double fd = this.getArbeitsobjekt().getMittlereFahrdistanz_m();
            lastVolumen = 0.825 - 0.017 * stueckLaenge + 0.395 * Math.log(stueckVolumen) + 0.15 * Math.log(fd);
        } else {
            lastVolumen = 1.843 + 0.216 * Math.log(stueckVolumen);
        }
        return lastVolumen;
    }

    private double getPsh0_Anhaengen() {
        double psh0 = 0.0;
        double lastVolumen = this.getLastVolumen();
        double stueckVolumen = this.getArbeitsobjekt().getMittleresStueckvolumen_m3();
        double hangneigung = (double)this.getArbeitsobjekt().getHangneigung_Prz() / 100.0;
        double seitlicherZuzug = this.getArbeitsobjekt().getMittlereDistanzSeitlicherZuzug_m();
        int anzahlPersonenAnhaengen = this.getArbeitssystem().getAnzahlPersonal() - 1;
        if (anzahlPersonenAnhaengen < 1) {
            throw new RuntimeException("zuwenig Personen");
        }
        psh0 = anzahlPersonenAnhaengen == 1 ? 0.016666666666666666 * ((0.01 * seitlicherZuzug + 0.45 * hangneigung) / stueckVolumen + 0.32) * lastVolumen : 0.016666666666666666 * (0.45 * hangneigung / stueckVolumen + 0.32) * lastVolumen;
        return psh0;
    }

    private double getPsh0_SeitlicherZuzug() {
        double psh0 = 0.0;
        double seitlicherZuzug = this.getArbeitsobjekt().getMittlereDistanzSeitlicherZuzug_m();
        double hangneigung = (double)this.getArbeitsobjekt().getHangneigung_Prz() / 100.0;
        int eingriffsArt = this.getEingriffsArtValue();
        int hindernisse = this.getHindernisseValue();
        psh0 = 0.016666666666666666 * (0.081 * seitlicherZuzug + 0.061 * hangneigung - 0.034 * (double)eingriffsArt + 0.041 * (double)hindernisse);
        return psh0;
    }

    private int getEingriffsArtValue() {
        switch (this.getArbeitsobjekt().getEingriffsart()) {
            case Durchforstung: {
                return 1;
            }
            case Lichtung: {
                return 2;
            }
            case Raeumung: {
                return 3;
            }
        }
        throw new RuntimeException();
    }

    private int getHindernisseValue() {
        switch (this.getArbeitsobjekt().getHindernisse()) {
            case Normal: {
                return 1;
            }
            case Erschwert: {
                return 2;
            }
            case Extrem: {
                return 3;
            }
        }
        throw new RuntimeException();
    }

    private double getPsh0_VertikalbewegungImBestand() {
        double tragseilHoehe = this.getArbeitsobjekt().getTragseilHoeheBestand_m();
        double psh0 = 0.016666666666666666 * (0.258 + 0.025 * tragseilHoehe);
        return psh0;
    }

    private double getPsh0_FahrtAmTragseil() {
        double psh0;
        double fahrdistanz = this.getArbeitsobjekt().getMittlereFahrdistanz_m();
        switch (this.getArbeitsobjekt().getFahrtrichtung()) {
            case Bergauf: {
                psh0 = 0.016666666666666666 * (0.861 + 0.01151 * fahrdistanz);
                break;
            }
            case Bergab: {
                psh0 = 0.016666666666666666 * (1.064 + 0.00792 * fahrdistanz);
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        return psh0;
    }

    private double getPsh0_VertikalbewegungAmLagerplatz() {
        double tragseilHoehe = this.getArbeitsobjekt().getTragseilHoeheLagerplatz_m();
        double psh0 = 0.016666666666666666 * (0.37 + 0.036 * tragseilHoehe);
        return psh0;
    }

    private double getPsh0_Abhaengen() {
        double psh0 = 0.0;
        double lastVolumen = this.getLastVolumen();
        double stueckVolumen = this.getArbeitsobjekt().getMittleresStueckvolumen_m3();
        psh0 = 0.016666666666666666 * (0.144 / stueckVolumen + 0.3) * lastVolumen;
        return psh0;
    }

    @Override
    protected double getAnzahlPersonalVollzeitAequivalente() {
        return this.getArbeitssystem().getAnzahlPersonal();
    }

    @Override
    protected double getLaufzeitAnteilMaschine() {
        return (double)this.getArbeitssystem().getAnteilSeilkranLaufzeit_Prz() / 100.0;
    }
}

