/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.hepromo.model.calc;

import ch.wsl.fps.hepromo.model.HeProMoInputData;
import ch.wsl.fps.hepromo.model.aobj.ArbeitsobjektKonventionellerSeilkranMontageDemontage;
import ch.wsl.fps.hepromo.model.asys.ArbeitssystemSeilkran;
import ch.wsl.fps.hepromo.model.calc.AbstractCalculatorSingleModel;

public abstract class CalculatorKonventionellerSeilkranMontageDemontage
extends AbstractCalculatorSingleModel {
    public CalculatorKonventionellerSeilkranMontageDemontage(HeProMoInputData inputData) {
        super(inputData);
        this.f_indir = 1.39;
    }

    @Override
    protected ArbeitsobjektKonventionellerSeilkranMontageDemontage getArbeitsobjekt() {
        return (ArbeitsobjektKonventionellerSeilkranMontageDemontage)super.getArbeitsobjekt();
    }

    @Override
    protected ArbeitssystemSeilkran getArbeitssystem() {
        return (ArbeitssystemSeilkran)super.getArbeitssystem();
    }

    protected abstract boolean isSeilverlegung();

    @Override
    protected double calcPsh0_hProM3() {
        double psh0_Grundzeit = this.getPsh0_Grundzeit();
        double psh0_EndmastenSt\u00fctzen = this.getPsh0_EndmastenStuetzen();
        double psh0_Windenselbstfahrt = this.getPsh0_Windenselbstfahrt();
        double psh0_WindenTransport_Heli = this.getPsh0_WindenTransport_Heli();
        double psh0_Verlegung = this.getPsh0_Verlegung();
        double psh0_MontageDemontage = -1.0;
        psh0_MontageDemontage = this.isSeilverlegung() ? psh0_Grundzeit + psh0_EndmastenSt\u00fctzen - psh0_Verlegung : psh0_Grundzeit + psh0_EndmastenSt\u00fctzen + psh0_Windenselbstfahrt + psh0_WindenTransport_Heli;
        return psh0_MontageDemontage /= this.getRelevanteHolzmenge();
    }

    protected abstract double getPsh0_Grundzeit();

    protected abstract double getPsh0_EndmastenStuetzen();

    protected double getPsh0_Windenselbstfahrt() {
        double wsd = 0.0;
        if (this.getArbeitsobjekt().getDistanzWindenSelbstfahrt() >= 150) {
            wsd = this.getArbeitsobjekt().getDistanzWindenSelbstfahrt() - 150;
        }
        double psh0 = 0.0;
        double anzPers = this.getAnzahlPersonenTotal();
        if (this.getArbeitsobjekt().getWindenTransport() == ArbeitsobjektKonventionellerSeilkranMontageDemontage.WindenTransport.SelbstfahrtBergauf) {
            psh0 = 0.016666666666666666 * (1.0 / anzPers) * (177.0 + 0.76 * wsd);
        } else if (this.getArbeitsobjekt().getWindenTransport() == ArbeitsobjektKonventionellerSeilkranMontageDemontage.WindenTransport.SelbstfahrtBergab) {
            psh0 = 0.016666666666666666 * (1.0 / anzPers) * (179.0 + 1.21 * wsd);
        }
        return psh0;
    }

    protected double getPsh0_WindenTransport_Heli() {
        double psh0 = 0.0;
        double anzPers = this.getAnzahlPersonenTotal();
        if (this.getArbeitsobjekt().getWindenTransport() == ArbeitsobjektKonventionellerSeilkranMontageDemontage.WindenTransport.MitHeli) {
            psh0 = 0.016666666666666666 * (1.0 / anzPers) * 328.0;
        }
        return psh0;
    }

    protected abstract double getPsh0_Verlegung();

    protected double getAnzahlPersonenTotal() {
        return this.getArbeitssystem().getAnzahlPersonal();
    }

    @Override
    protected double getAnzahlPersonalVollzeitAequivalente() {
        return this.getArbeitssystem().getAnzahlPersonal();
    }

    @Override
    protected double getLaufzeitAnteilMaschine() {
        return (double)this.getArbeitssystem().getAnteilSeilkranLaufzeit_Prz() / 100.0;
    }
}

