/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.hepromo.model.calc;

import ch.wsl.fps.hepromo.model.Ergebnis;
import ch.wsl.fps.hepromo.model.HeProMoInputData;
import ch.wsl.fps.hepromo.model.ModelStrings;
import ch.wsl.fps.hepromo.model.aobj.ArbeitsobjektKombiseilgeraet2018;
import ch.wsl.fps.hepromo.model.asys.ArbeitssystemKombiseilgeraet2018;
import ch.wsl.fps.hepromo.model.calc.AbstractCalculatorSingleModel2014;

public class CalculatorKombiseilgeraet2018
extends AbstractCalculatorSingleModel2014 {
    private ErgebnisAnzeige ergebnisAnzeige = ErgebnisAnzeige.AlleArbeitsschritte;
    private static final double FAKTOR_MASCHINENLAUFZEIT = 0.8;

    public CalculatorKombiseilgeraet2018(HeProMoInputData inputData) {
        super(inputData);
    }

    @Override
    public ArbeitsobjektKombiseilgeraet2018 getArbeitsobjekt() {
        return (ArbeitsobjektKombiseilgeraet2018)super.getArbeitsobjekt();
    }

    @Override
    public ArbeitssystemKombiseilgeraet2018 getArbeitssystem() {
        return (ArbeitssystemKombiseilgeraet2018)super.getArbeitssystem();
    }

    @Override
    public Ergebnis calculate() {
        this.f_wegzeitenUndPausen = this.getArbeitssystem().getFaktorWegzeitenUndPausen();
        Ergebnis ergebnis = this.getNewErgebnisInstance();
        double holzmenge = this.getRelevanteHolzmenge();
        double psh15 = this.getZeitaufwandPersonal_PPH15();
        double wsh = psh15 * this.f_indir;
        double wpsh = wsh * this.f_wegzeitenUndPausen * this.f_stoer;
        double anzahlPersonen_fte = this.getAnzahlPersonalVollzeitAequivalente();
        double pph15 = anzahlPersonen_fte * this.getZeitaufwandPersonal_PPH15();
        double wph = pph15 * this.f_indir;
        double wpph = wph * this.f_wegzeitenUndPausen * this.f_stoer;
        double pmh15 = this.getMaschinenzeitKSG_PMH15();
        double kf = this.faktoren.getKorrekturFaktor();
        psh15 *= kf;
        ergebnis.setZeitPersonal(wpph *= kf);
        ergebnis.setZeitMaschine1(this.adaptZeitKSG(wpsh *= kf, pmh15 *= kf));
        if (this.getErgebnisAnzeige() == ErgebnisAnzeige.NurFaellenRuecken) {
            ergebnis.setZeitMaschine2(this.getMaschinenzeitMotorsaege_PMH15());
        }
        if (this.getErgebnisAnzeige() == ErgebnisAnzeige.NurVerziehen) {
            ergebnis.setZeitMaschine3(this.getMaschinenzeitVerzugsfahrzeug_PMH15());
        }
        if (this.getErgebnisAnzeige() == ErgebnisAnzeige.AlleArbeitsschritte) {
            ergebnis.setZeitMaschine2(this.getMaschinenzeitMotorsaege_PMH15());
            ergebnis.setZeitMaschine3(this.getMaschinenzeitVerzugsfahrzeug_PMH15());
        }
        ergebnis.setZeitUmsetzen(this.getArbeitssystem().getUmsetzenZeit_h());
        ergebnis.setZeitWeitereAufwaende(this.getArbeitssystem().getWeitereAufwaendeZeit_h());
        if (this.getErgebnisAnzeige() != ErgebnisAnzeige.NurVerziehen) {
            ergebnis.setZeitTotal(wpsh);
        } else {
            ergebnis.setZeitTotal(this.getMaschinenzeitVerzugsfahrzeug_PMH15() * this.f_indir * this.f_wegzeitenUndPausen * this.f_stoer * kf);
        }
        ergebnis.setKostenPersonal_total(this.getArbeitssystem().getAnsatzPersonalKombiniertGewichtet() * wpph);
        ergebnis.setKostenMaschine1_total(this.getArbeitssystem().getKostensatzMaschine1_proH() * ergebnis.getZeitMaschine1());
        ergebnis.setKostenMaschine2_total(this.getArbeitssystem().getKostensatzMaschine2_proH() * ergebnis.getZeitMaschine2());
        ergebnis.setKostenMaschine3_total(this.getArbeitssystem().getKostensatzVerzugsfahrzeug_proH() * ergebnis.getZeitMaschine3());
        ergebnis.setKostenUmsetzen_total(this.getArbeitssystem().getUmsetzenBetrag_CHF());
        ergebnis.setKostenWeitereAufwaende_total(this.getArbeitssystem().getWeitereAufwaendeBetrag_CHF());
        this.setProduktivitaet(ergebnis, Ergebnis.ProdEinheit.M3_OR_PRO_WSH, holzmenge / wsh);
        this.setProduktivitaet(ergebnis, Ergebnis.ProdEinheit.M3_IR_PRO_WSH, holzmenge / wsh / this.getArbeitsobjekt().getRindenAbzugFaktor());
        this.setProduktivitaet(ergebnis, Ergebnis.ProdEinheit.M3_PRO_PSH15, holzmenge / psh15);
        this.setProduktivitaet(ergebnis, Ergebnis.ProdEinheit.M3_OR_PRO_PSH15, holzmenge / psh15);
        this.setProduktivitaet(ergebnis, Ergebnis.ProdEinheit.M3_IR_PRO_PSH15, holzmenge / psh15 / this.getArbeitsobjekt().getRindenAbzugFaktor());
        this.setProduktivitaet(ergebnis, Ergebnis.ProdEinheit.M3_PRO_PMH15, holzmenge / (pmh15 + this.getMaschinenzeitVerzugsfahrzeug_PMH15()));
        this.setProduktivitaet(ergebnis, Ergebnis.ProdEinheit.FM_OR_PRO_WPPH, holzmenge / wpph);
        if (this.getErgebnisAnzeige() == ErgebnisAnzeige.NurMontageDemontage) {
            this.setProduktivitaet(ergebnis, Ergebnis.ProdEinheit.EMPTY, -1.0);
            ergebnis.hideProduktivitaet();
        } else if (this.getErgebnisAnzeige() == ErgebnisAnzeige.NurVerziehen) {
            this.setProduktivitaet(ergebnis, Ergebnis.ProdEinheit.EMPTY, -1.0);
            ergebnis.hideProduktivitaet();
        }
        ergebnis.setAnzahl_m3(holzmenge);
        ergebnis.setRisikoVerwaltungGewinn_Prz(this.faktoren.getMargin());
        ergebnis.setMehrwertsteuer_Prz(this.faktoren.getMehrwertsteuer());
        ergebnis.setLabelPersonal1(this.getArbeitssystem().getLabelPersonal1());
        ergebnis.setLabelMaschine1(this.getArbeitssystem().getLabelMaschine1());
        ergebnis.setLabelMaschine2(this.getArbeitssystem().getLabelMaschine2());
        ergebnis.setLabelMaschine3(ModelStrings.getString("CalculatorKombiseilgeraet2018.VerzugsfahrzeugInklFahrer"));
        return ergebnis;
    }

    @Override
    protected Ergebnis.ProdEinheit getProdEinheit1() {
        if (this.getErgebnisAnzeige() == ErgebnisAnzeige.NurMontageDemontage) {
            return Ergebnis.ProdEinheit.EMPTY;
        }
        if (this.getErgebnisAnzeige() == ErgebnisAnzeige.NurFaellenRuecken) {
            return Ergebnis.ProdEinheit.M3_IR_PRO_PSH15;
        }
        if (this.getErgebnisAnzeige() == ErgebnisAnzeige.NurVerziehen) {
            return Ergebnis.ProdEinheit.EMPTY;
        }
        if (this.getErgebnisAnzeige() == ErgebnisAnzeige.AlleArbeitsschritte) {
            return Ergebnis.ProdEinheit.M3_IR_PRO_WSH;
        }
        throw new IllegalStateException();
    }

    @Override
    protected Ergebnis.ProdEinheit getProdEinheit2() {
        if (this.getErgebnisAnzeige() == ErgebnisAnzeige.NurMontageDemontage) {
            return Ergebnis.ProdEinheit.EMPTY;
        }
        if (this.getErgebnisAnzeige() == ErgebnisAnzeige.NurFaellenRuecken) {
            return Ergebnis.ProdEinheit.M3_OR_PRO_PSH15;
        }
        if (this.getErgebnisAnzeige() == ErgebnisAnzeige.NurVerziehen) {
            return Ergebnis.ProdEinheit.EMPTY;
        }
        if (this.getErgebnisAnzeige() == ErgebnisAnzeige.AlleArbeitsschritte) {
            return Ergebnis.ProdEinheit.M3_OR_PRO_WSH;
        }
        throw new IllegalStateException();
    }

    private double adaptZeitKSG(double wpsh, double ksg_pmh15) {
        double ksg_max_pmh15 = (wpsh /= this.faktoren.getKorrekturFaktor()) / this.f_indir / this.f_wegzeitenUndPausen / this.f_stoer;
        return Math.min(ksg_pmh15, ksg_max_pmh15);
    }

    @Override
    protected double getAnzahlPersonalVollzeitAequivalente() {
        return this.getArbeitssystem().getEquipeAnzahlPersonen().asDouble();
    }

    @Override
    protected double calcPsh0_hProM3() {
        throw new UnsupportedOperationException();
    }

    private double getZeitaufwandPersonal_PPH15() {
        int anzahlAufstellungen = this.getArbeitsobjekt().getAnzahlAufstellungen();
        double anzahlPersonen_fte = this.getAnzahlPersonalVollzeitAequivalente();
        double zeitaufwandPersonalTotalMontageDemontage_PPH15 = (double)anzahlAufstellungen * this.calcZeitaufwandPersonalProAufstellungMontageDemontage_PPH15() / anzahlPersonen_fte;
        double zeitaufwandPersonalTotalFaellenRuecken_PPH15 = this.getArbeitsobjekt().getHolzmenge_m3() / this.calcProduktivitaetPersonalFaellenRuecken_m3oRproPPH15() / anzahlPersonen_fte;
        double zeitaufwandPersonalTotal_PPH15 = zeitaufwandPersonalTotalMontageDemontage_PPH15 + zeitaufwandPersonalTotalFaellenRuecken_PPH15;
        switch (this.getErgebnisAnzeige()) {
            case NurMontageDemontage: {
                return zeitaufwandPersonalTotalMontageDemontage_PPH15;
            }
            case NurFaellenRuecken: {
                return zeitaufwandPersonalTotalFaellenRuecken_PPH15;
            }
            case NurVerziehen: {
                return 0.0;
            }
            case AlleArbeitsschritte: {
                return zeitaufwandPersonalTotal_PPH15;
            }
        }
        throw new RuntimeException(this.getErgebnisAnzeige().toString());
    }

    private double getMaschinenzeitMotorsaege_PMH15() {
        double anzahlPersonen_fte = this.getAnzahlPersonalVollzeitAequivalente();
        double maschinenzeitTotalFaellenRuecken_PMH15 = this.getArbeitsobjekt().getHolzmenge_m3() / this.calcProduktivitaetPersonalFaellenRuecken_m3oRproPPH15() / anzahlPersonen_fte;
        return maschinenzeitTotalFaellenRuecken_PMH15 * 0.5;
    }

    private double getMaschinenzeitVerzugsfahrzeug_PMH15() {
        double anzahlPersonen_fte = this.getAnzahlPersonalVollzeitAequivalente();
        double maschinenzeitTotalFaellenRuecken_PMH15 = this.getArbeitsobjekt().getHolzmenge_m3() / this.calcProduktivitaetPersonalFaellenRuecken_m3oRproPPH15() / anzahlPersonen_fte;
        return (maschinenzeitTotalFaellenRuecken_PMH15 *= 0.8) * ((double)this.getArbeitssystem().getAnteilEinsatzzeitVerzugsfahrzeug_Prz() / 100.0);
    }

    private double getMaschinenzeitKSG_PMH15() {
        int anzahlAufstellungen = this.getArbeitsobjekt().getAnzahlAufstellungen();
        double anzahlPersonen_fte = this.getAnzahlPersonalVollzeitAequivalente();
        double maschinenzeitTotalMontageDemontage_PMH15 = (double)anzahlAufstellungen * this.calcMaschinenzeitProAufstellungMontageDemontage_PMH15();
        double maschinenzeitTotalFaellenRuecken_PMH15 = this.getArbeitsobjekt().getHolzmenge_m3() / this.calcProduktivitaetPersonalFaellenRuecken_m3oRproPPH15() / anzahlPersonen_fte;
        double maschinenzeitTotal_PMH15 = maschinenzeitTotalMontageDemontage_PMH15 + (maschinenzeitTotalFaellenRuecken_PMH15 *= 0.8);
        switch (this.getErgebnisAnzeige()) {
            case NurMontageDemontage: {
                return maschinenzeitTotalMontageDemontage_PMH15;
            }
            case NurFaellenRuecken: {
                return maschinenzeitTotalFaellenRuecken_PMH15;
            }
            case NurVerziehen: {
                return 0.0;
            }
            case AlleArbeitsschritte: {
                return maschinenzeitTotal_PMH15;
            }
        }
        throw new RuntimeException(this.getErgebnisAnzeige().toString());
    }

    private double calcZeitaufwandPersonalProAufstellungMontageDemontage_PPH15() {
        double a = -15.8938;
        double b = 0.0573;
        double c = 0.2645;
        double d = 9.2746;
        double e = 10.9707;
        double erschwernisValue = this.getArbeitsobjekt().getErschwernisse() != ArbeitsobjektKombiseilgeraet2018.Erschwernisse.Keine ? 1 : 0;
        double pph = a + b * (double)this.getArbeitsobjekt().getLaengeProAufstellung_m() + c * (double)this.getArbeitsobjekt().getHangneigung_Prz() + d * (double)this.getArbeitsobjekt().getAnzahlStuetzenProAufstellung() + e * erschwernisValue;
        return pph;
    }

    private double calcMaschinenzeitProAufstellungMontageDemontage_PMH15() {
        double a = 1.5166;
        double b = 0.007;
        double d = 1.2922;
        double pmh15 = a + b * (double)this.getArbeitsobjekt().getLaengeProAufstellung_m() + d * (double)this.getArbeitsobjekt().getAnzahlStuetzenProAufstellung();
        return pmh15;
    }

    private double calcProduktivitaetPersonalFaellenRuecken_m3oRproPPH15() {
        double a = 4.0613;
        double c = -0.015;
        double e = -0.4276;
        double f = -0.0097;
        double erschwernisValue = this.getArbeitsobjekt().getErschwernisse() != ArbeitsobjektKombiseilgeraet2018.Erschwernisse.Keine ? 1 : 0;
        double result = a + c * (double)this.getArbeitsobjekt().getHangneigung_Prz() + e * erschwernisValue + f * (double)this.getArbeitsobjekt().getAnteilLaubholz_Prz();
        return result;
    }

    public ErgebnisAnzeige getErgebnisAnzeige() {
        return this.ergebnisAnzeige;
    }

    public void setErgebnisAnzeige(ErgebnisAnzeige ergebnisAnzeige) {
        this.ergebnisAnzeige = ergebnisAnzeige;
    }

    public static enum ErgebnisAnzeige {
        NurMontageDemontage("CalculatorKombiseilgeraet2018.enumNurMontageDemontage"),
        NurFaellenRuecken("CalculatorKombiseilgeraet2018.enumFaellenRuecken"),
        NurVerziehen("CalculatorKombiseilgeraet2018.enumNurVerziehen"),
        AlleArbeitsschritte("CalculatorKombiseilgeraet2018.enumGesamteArbeit");

        private final String text;

        private ErgebnisAnzeige(String text) {
            this.text = text;
        }

        public String toString() {
            return ModelStrings.getString(this.text);
        }
    }
}

