/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.hepromo.model.calc;

import ch.wsl.fps.hepromo.model.Ergebnis;
import ch.wsl.fps.hepromo.model.ErgebnisHelikopterFliegen;
import ch.wsl.fps.hepromo.model.ErgebnisHelikopterGesamt;
import ch.wsl.fps.hepromo.model.HeProMoInputData;
import ch.wsl.fps.hepromo.model.aobj.ArbeitsobjektHelikopterAufarbeiten;
import ch.wsl.fps.hepromo.model.aobj.ArbeitsobjektHelikopterFliegen;
import ch.wsl.fps.hepromo.model.aobj.ArbeitsobjektHelikopterGesamt;
import ch.wsl.fps.hepromo.model.asys.ArbeitssystemHelikopterAufarbeiten;
import ch.wsl.fps.hepromo.model.asys.ArbeitssystemHelikopterFliegen;
import ch.wsl.fps.hepromo.model.asys.ArbeitssystemHelikopterGesamt;
import ch.wsl.fps.hepromo.model.calc.AbstractCalculatorComposedModel;
import ch.wsl.fps.hepromo.model.calc.CalculatorHelikopterAufarbeiten;
import ch.wsl.fps.hepromo.model.calc.CalculatorHelikopterFliegen;

public class CalculatorHelikopterGesamt
extends AbstractCalculatorComposedModel {
    public CalculatorHelikopterGesamt(HeProMoInputData inputData) {
        super(inputData);
    }

    @Override
    public ArbeitsobjektHelikopterGesamt getArbeitsobjekt() {
        return (ArbeitsobjektHelikopterGesamt)super.getArbeitsobjekt();
    }

    @Override
    public ArbeitssystemHelikopterGesamt getArbeitssystem() {
        return (ArbeitssystemHelikopterGesamt)super.getArbeitssystem();
    }

    @Override
    public ErgebnisHelikopterGesamt calculate() {
        ArbeitsobjektHelikopterAufarbeiten.BaumartenGruppe ba = this.getArbeitsobjekt().getTeilobjektAufarbeiten().getBaumartenGruppe();
        ArbeitsobjektHelikopterFliegen.Holztyp ht = this.getArbeitsobjekt().getTeilobjektFliegen().getHolztyp();
        if (ba == ArbeitsobjektHelikopterAufarbeiten.BaumartenGruppe.Laubholz && (ht == ArbeitsobjektHelikopterFliegen.Holztyp.Nadelholz_frisch || ht == ArbeitsobjektHelikopterFliegen.Holztyp.Nadelholz_angetrocknet)) {
            throw new RuntimeException("Baumarten nicht konsistent!");
        }
        ErgebnisHelikopterFliegen eFliegen = this.getErgebnisFliegen();
        Ergebnis eAufarbeiten = this.getErgebnisAufarbeiten();
        ErgebnisHelikopterGesamt ergebnis = new ErgebnisHelikopterGesamt();
        if (this.getArbeitssystem().isKalkulationInklLagerplatzarbeit()) {
            ergebnis.setAnzahl_m3(eFliegen.getAnzahl_m3());
            ergebnis.setZeitTotalFliegen(eFliegen.getZeitTotal());
            ergebnis.setZeitTotalAbsenkplatz(eAufarbeiten.getZeitTotal());
            ergebnis.setZeitHelifirma(eFliegen.getZeitMaschine1());
            ergebnis.setZeitPersonal(eFliegen.getZeitPersonal() + eAufarbeiten.getZeitPersonal());
            ergebnis.setZeitMaschine1(eAufarbeiten.getZeitMaschine1());
            ergebnis.setZeitMaschine2(eAufarbeiten.getZeitMaschine2());
            ergebnis.setZeitUmsetzen(eAufarbeiten.getZeitUmsetzen());
            ergebnis.setZeitWeitereAufwaende(eFliegen.getZeitWeitereAufwaende());
            ergebnis.setKostenHeli_total(eFliegen.getKostenMaschine1_total());
            ergebnis.setKostenPersonal_total(eFliegen.getKostenPersonal_total() + eAufarbeiten.getKostenPersonal_total());
            ergebnis.setKostenMaschine1_total(eAufarbeiten.getKostenMaschine1_total());
            ergebnis.setKostenMaschine2_total(eAufarbeiten.getKostenMaschine2_total());
            ergebnis.setKostenUmsetzen_total(eAufarbeiten.getKostenUmsetzen_total());
            ergebnis.setKostenWeitereAufwaende_total(eFliegen.getKostenWeitereAufwaende_total());
            ergebnis.setRotationszeit(eFliegen.getRotationszeit());
            ergebnis.setRisikoVerwaltungGewinn_Prz(eFliegen.getRisikoVerwaltungGewinn_Prz());
            ergebnis.setMehrwertsteuer_Prz(eFliegen.getMehrwertsteuer_Prz());
        } else {
            ergebnis.setAnzahl_m3(eFliegen.getAnzahl_m3());
            ergebnis.setZeitTotalFliegen(eFliegen.getZeitTotal());
            ergebnis.setZeitTotalAbsenkplatz(0.0);
            ergebnis.setZeitHelifirma(eFliegen.getZeitMaschine1());
            ergebnis.setZeitPersonal(eFliegen.getZeitPersonal());
            ergebnis.setZeitMaschine1(0.0);
            ergebnis.setZeitMaschine2(0.0);
            ergebnis.setZeitUmsetzen(eAufarbeiten.getZeitUmsetzen());
            ergebnis.setZeitWeitereAufwaende(eFliegen.getZeitWeitereAufwaende());
            ergebnis.setKostenHeli_total(eFliegen.getKostenMaschine1_total());
            ergebnis.setKostenPersonal_total(eFliegen.getKostenPersonal_total());
            ergebnis.setKostenMaschine1_total(0.0);
            ergebnis.setKostenMaschine2_total(0.0);
            ergebnis.setKostenUmsetzen_total(eAufarbeiten.getKostenUmsetzen_total());
            ergebnis.setKostenWeitereAufwaende_total(eFliegen.getKostenWeitereAufwaende_total());
            ergebnis.setRotationszeit(eFliegen.getRotationszeit());
            ergebnis.setRisikoVerwaltungGewinn_Prz(eFliegen.getRisikoVerwaltungGewinn_Prz());
            ergebnis.setMehrwertsteuer_Prz(eFliegen.getMehrwertsteuer_Prz());
        }
        ergebnis.setLabelPersonal1(this.getArbeitssystem().getLabelPersonal1());
        ergebnis.setLabelMaschine1(this.getArbeitssystem().getLabelMaschine1());
        ergebnis.setLabelMaschine2(this.getArbeitssystem().getLabelMaschine2());
        return ergebnis;
    }

    private ErgebnisHelikopterFliegen getErgebnisFliegen() {
        ArbeitsobjektHelikopterFliegen arbeitsObjekt = this.getArbeitsobjekt().getTeilobjektFliegen();
        ArbeitssystemHelikopterFliegen arbeitsSystem = this.getArbeitssystem().getTeilsystemFliegen();
        HeProMoInputData inputData = this.createHeProMoInputData(arbeitsObjekt, arbeitsSystem, this.faktoren);
        CalculatorHelikopterFliegen calc = new CalculatorHelikopterFliegen(inputData);
        calc.setRindenAbzugBeruecksichtigen(this.rindenAbzugBeruecksichtigen);
        ErgebnisHelikopterFliegen ergebnis = calc.calculate();
        return ergebnis;
    }

    private Ergebnis getErgebnisAufarbeiten() {
        ArbeitsobjektHelikopterAufarbeiten arbeitsObjekt = this.getArbeitsobjekt().getTeilobjektAufarbeiten();
        ArbeitssystemHelikopterAufarbeiten arbeitsSystem = this.getArbeitssystem().getTeilsystemAufarbeiten();
        HeProMoInputData inputData = this.createHeProMoInputData(arbeitsObjekt, arbeitsSystem, this.faktoren);
        CalculatorHelikopterAufarbeiten calc = new CalculatorHelikopterAufarbeiten(inputData);
        calc.setRindenAbzugBeruecksichtigen(this.rindenAbzugBeruecksichtigen);
        Ergebnis ergebnis = calc.calculate();
        return ergebnis;
    }
}

