/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.hepromo.model.calc;

import ch.wsl.fps.hepromo.model.Ergebnis;
import ch.wsl.fps.hepromo.model.ErgebnisHackschnitzelTransport2018;
import ch.wsl.fps.hepromo.model.HeProMoInputData;
import ch.wsl.fps.hepromo.model.aobj.ArbeitsobjektHacker2018;
import ch.wsl.fps.hepromo.model.aobj.ArbeitsobjektHackschnitzelTransport2018;
import ch.wsl.fps.hepromo.model.asys.ArbeitssystemHackschnitzelTransport2018;
import ch.wsl.fps.hepromo.model.calc.AbstractCalculatorSingleModel2014;
import ch.wsl.fps.hepromo.model.calc.CalculatorHacker2018;

public class CalculatorHackschnitzelTransport2018
extends AbstractCalculatorSingleModel2014 {
    public CalculatorHackschnitzelTransport2018(HeProMoInputData inputData) {
        super(inputData);
    }

    @Override
    protected Ergebnis getNewErgebnisInstance() {
        return new ErgebnisHackschnitzelTransport2018();
    }

    @Override
    public ArbeitsobjektHackschnitzelTransport2018 getArbeitsobjekt() {
        return (ArbeitsobjektHackschnitzelTransport2018)super.getArbeitsobjekt();
    }

    @Override
    public ArbeitssystemHackschnitzelTransport2018 getArbeitssystem() {
        return (ArbeitssystemHackschnitzelTransport2018)super.getArbeitssystem();
    }

    @Override
    public Ergebnis calculate() {
        ErgebnisHackschnitzelTransport2018 ergebnis = (ErgebnisHackschnitzelTransport2018)super.calculate();
        ergebnis.setZeitLaden_h(this.calcZeitLaden_min() / 60.0);
        ergebnis.setZeitLastfahrt_h(this.calcZeitLastfahrt_min() / 60.0);
        ergebnis.setZeitEntladen_h(this.calcZeitEntladen_min() / 60.0);
        ergebnis.setZeitLeerfahrt_h(this.calcZeitLeerfahrt_min() / 60.0);
        ergebnis.setAnzahlZyklen(this.calcAnzahlZyklen());
        this.setProduktivitaet(ergebnis, Ergebnis.ProdEinheit.SRM_PRO_PMH15, ergebnis.getProduktivitaet(Ergebnis.ProdEinheit.M3_PRO_PSH15));
        return ergebnis;
    }

    @Override
    protected Ergebnis.ProdEinheit getProdEinheit1() {
        return Ergebnis.ProdEinheit.SRM_PRO_PMH15;
    }

    @Override
    protected Ergebnis.ProdEinheit getProdEinheit2() {
        return Ergebnis.ProdEinheit.EMPTY;
    }

    @Override
    protected double calcPsh0_hProM3() {
        double zeitLaden_min = this.calcZeitLaden_min();
        double zeitLastfahrt_min = this.calcZeitLastfahrt_min();
        double zeitEntladen_min = this.calcZeitEntladen_min();
        double zeitLeerfahrt_min = this.calcZeitLeerfahrt_min();
        double zeitTotal_min = zeitLaden_min + zeitLastfahrt_min + zeitEntladen_min + zeitLeerfahrt_min;
        double zeitTotal_h = zeitTotal_min / 60.0;
        int anzahlZyklen = this.calcAnzahlZyklen();
        double avgSrmProFahrt = this.getArbeitsobjekt().getHolzmenge_m3() / (double)anzahlZyklen;
        double produktivitaetProFahrt_SrmProPMH15 = avgSrmProFahrt / zeitTotal_h;
        double pmh15 = 1.0 / produktivitaetProFahrt_SrmProPMH15;
        double pmh0 = pmh15 / this.f_0bis15;
        return pmh0;
    }

    private int calcAnzahlZyklen() {
        double muldeninhalt_Srm = this.getArbeitssystem().getMuldeninhalt_Srm();
        return (int)Math.ceil(this.getArbeitsobjekt().getHolzmenge_m3() / muldeninhalt_Srm);
    }

    private double calcZeitLaden_min() {
        if (this.getArbeitsobjekt().isAufnehmenBeladenerMulde()) {
            return 10.0;
        }
        if (this.getArbeitsobjekt().getHolzmenge_m3() > 0.0) {
            ArbeitsobjektHacker2018.Zielsortiment zielsortiment = this.getArbeitsobjekt().getZielsortiment();
            int motorleistungHacker_kW = this.getArbeitsobjekt().getHackerMotorleistung().getMotorleistungCalc_Kw();
            double produktivitaet_SrmProPMH15 = CalculatorHacker2018.getProduktivitaet_SrmProMAS(zielsortiment, motorleistungHacker_kW);
            double zeit_min = this.getArbeitsobjekt().getHolzmenge_m3() / produktivitaet_SrmProPMH15 * 60.0;
            return zeit_min /= (double)this.calcAnzahlZyklen();
        }
        return 0.0;
    }

    private double calcZeitLastfahrt_min() {
        double fahrzeitWaldstrasse_min = this.getArbeitsobjekt().getDistanzWaldstrasse_km() * 3.0;
        double fahrzeitInnerAusserorts_min = this.getArbeitsobjekt().getDistanzInnerAusserorts_km() * 1.5;
        double fahrzeitAutobahn_min = this.getArbeitsobjekt().getDistanzAutobahn_km() * 0.86;
        double sum_min = fahrzeitWaldstrasse_min + fahrzeitInnerAusserorts_min + fahrzeitAutobahn_min;
        return sum_min;
    }

    private double calcZeitEntladen_min() {
        return 15.0;
    }

    private double calcZeitLeerfahrt_min() {
        return this.calcZeitLastfahrt_min() * 0.95;
    }
}

