/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.hepromo.model.calc;

import ch.wsl.fps.hepromo.model.ModelStrings;
import ch.wsl.fps.hepromo.model.calc.BiomasseCalculatorKompartimente2018;
import java.util.HashMap;

public class BiomasseCalculatorSchaftholztarif2018 {
    private static final HashMap<Tarifnummer, Double[]> modelKoeffizienten = new HashMap();

    static {
        modelKoeffizienten.put(Tarifnummer.T201, new Double[]{-9.6939329, 2.8757162, -0.00360841, 2.38E-5, 0.006454553, -0.35423996, -1.9064E-4});
        modelKoeffizienten.put(Tarifnummer.T202, new Double[]{-10.190717, 3.01181565, -0.00436003, 5.66E-5, 0.005186263, 0.0, -5.09E-5});
        modelKoeffizienten.put(Tarifnummer.T203, new Double[]{-10.40762, 3.14895427, -0.00476514, 3.67E-5, 0.005617423, -0.29285027, -2.0783E-4});
        modelKoeffizienten.put(Tarifnummer.T204, new Double[]{-11.225599, 3.43239299, -0.0058899, 3.39E-5, 0.005502126, -0.28350633, -2.2606E-4});
        modelKoeffizienten.put(Tarifnummer.T205, new Double[]{-11.024619, 3.20871603, -0.0050543, 1.15564E-4, 0.003814261, -0.25367643, -4.37E-5});
        modelKoeffizienten.put(Tarifnummer.T216, new Double[]{-9.7605762, 2.83855622, -0.00324786, 4.15E-5, 0.006981857, -0.19001432, -1.5251E-4});
        modelKoeffizienten.put(Tarifnummer.T217, new Double[]{-10.869359, 3.20963764, -0.00453908, 5.83E-5, 0.00326154, -0.08886847, 0.0});
        modelKoeffizienten.put(Tarifnummer.T218, new Double[]{-10.596355, 3.11284073, -0.00462775, 4.7E-5, 0.008531597, -0.28987184, -1.5084E-4});
        modelKoeffizienten.put(Tarifnummer.T219, new Double[]{-11.036856, 3.27767482, -0.00587506, 3.35E-5, 0.014177976, -0.12590653, -3.9528E-4});
        modelKoeffizienten.put(Tarifnummer.T220, new Double[]{-8.1151843, 2.17166411, -8.6928E-4, 0.0, 0.007345411, -0.22094684, 0.0});
    }

    public static void main(String[] args) {
        System.out.println(BiomasseCalculatorSchaftholztarif2018.getSchaftholzVolumen_m3iR(Tarifnummer.T201, 35, Gesamtwuchsleistung.Gut, Entwicklungsstufe.Baumholz2_41bis50cm, 800));
    }

    public static double getSchaftholzVolumen_m3iR(Tarifnummer tarif, int bhd_cm, Gesamtwuchsleistung gwl, Entwicklungsstufe es, int hoeheUeberMeer_m) {
        Double[] b = modelKoeffizienten.get((Object)tarif);
        double vk = Math.exp(b[0] + b[1] * Math.log(bhd_cm) + b[2] * Math.pow(Math.log(bhd_cm), 4.0) + b[3] * (double)gwl.getValue() + b[4] * (double)es.getValue() + b[6] * (double)hoeheUeberMeer_m);
        return vk;
    }

    public static enum Entwicklungsstufe {
        Stangenholz_12bis30cm("BiomasseCalculatorSchaftholztarif2018.enumStangenholz", 21),
        Baumholz1_31bis40cm("BiomasseCalculatorSchaftholztarif2018.enumBaumholz1", 35),
        Baumholz2_41bis50cm("BiomasseCalculatorSchaftholztarif2018.enumBaumholz2", 45),
        Baumholz3_ueber50cm("BiomasseCalculatorSchaftholztarif2018.enumBaumholz3", 55);

        private final String title;
        private final int value;

        private Entwicklungsstufe(String title, int value) {
            this.title = title;
            this.value = value;
        }

        public String toString() {
            return ModelStrings.getString(this.title);
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum Gesamtwuchsleistung {
        Gering("BiomasseCalculatorSchaftholztarif2018.enumGering", 1500),
        Maessig("BiomasseCalculatorSchaftholztarif2018.enumMaessig", 2300),
        Gut("BiomasseCalculatorSchaftholztarif2018.enumGut", 3700),
        SehrGut("BiomasseCalculatorSchaftholztarif2018.enumSehrGut", 5000);

        private final String title;
        private final int value;

        private Gesamtwuchsleistung(String title, int value) {
            this.title = title;
            this.value = value;
        }

        public String toString() {
            return ModelStrings.getString(this.title);
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum Tarifnummer {
        T201,
        T202,
        T203,
        T204,
        T205,
        T216,
        T217,
        T218,
        T219,
        T220;


        public static Tarifnummer[] values(BiomasseCalculatorKompartimente2018.Standort standort) {
            if (standort == null) {
                return Tarifnummer.values();
            }
            switch (standort) {
                case Allg_Alpen_Hoehe1000bis1400m: 
                case Allg_Alpen_Hoehe1401bis3000m: {
                    return new Tarifnummer[]{T204, T219};
                }
                case Allg_Jura_Hoehe0bis1250m: 
                case Allg_Jura_Hoehe1251bis3000m: {
                    return new Tarifnummer[]{T201, T216};
                }
                case Allg_Mittelland_Hoehe0bis1250m: 
                case Allg_Mittelland_Hoehe1251bis3000m: {
                    return new Tarifnummer[]{T202, T217};
                }
                case Allg_Voralpen_Hoehe0bis1250m: 
                case Allg_Voralpen_Hoehe1251bis3000m: {
                    return new Tarifnummer[]{T203, T218};
                }
                case Allg_AlpenSuedseite_Hoehe0bis1250m: 
                case Allg_AlpenSuedseite_Hoehe1251bis3000m: {
                    return new Tarifnummer[]{T205, T220};
                }
            }
            throw new IllegalArgumentException(standort.toString());
        }

        public String toString() {
            switch (this) {
                case T201: {
                    return ModelStrings.getString("BiomasseCalculatorSchaftholztarif2018.enum201");
                }
                case T202: {
                    return ModelStrings.getString("BiomasseCalculatorSchaftholztarif2018.enum202");
                }
                case T203: {
                    return ModelStrings.getString("BiomasseCalculatorSchaftholztarif2018.enum203");
                }
                case T204: {
                    return ModelStrings.getString("BiomasseCalculatorSchaftholztarif2018.enum204");
                }
                case T205: {
                    return ModelStrings.getString("BiomasseCalculatorSchaftholztarif2018.enum205");
                }
                case T216: {
                    return ModelStrings.getString("BiomasseCalculatorSchaftholztarif2018.enum216");
                }
                case T217: {
                    return ModelStrings.getString("BiomasseCalculatorSchaftholztarif2018.enum217");
                }
                case T218: {
                    return ModelStrings.getString("BiomasseCalculatorSchaftholztarif2018.enum218");
                }
                case T219: {
                    return ModelStrings.getString("BiomasseCalculatorSchaftholztarif2018.enum219");
                }
                case T220: {
                    return ModelStrings.getString("BiomasseCalculatorSchaftholztarif2018.enum220");
                }
            }
            throw new RuntimeException(this.name());
        }

        public int nr() {
            return Integer.valueOf(this.name().replaceAll("T", ""));
        }

        public static Tarifnummer[] values() {
            Tarifnummer[] tarifnummerArray = ENUM$VALUES;
            int n = tarifnummerArray.length;
            Tarifnummer[] tarifnummerArray2 = new Tarifnummer[n];
            System.arraycopy(ENUM$VALUES, 0, tarifnummerArray2, 0, n);
            return tarifnummerArray2;
        }
    }
}

