/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.hepromo.model.calc;

import ch.wsl.fps.hepromo.model.Ergebnis;
import ch.wsl.fps.hepromo.model.Faktoren;
import ch.wsl.fps.hepromo.model.HeProMoInputData;
import ch.wsl.fps.hepromo.model.aobj.Arbeitsobjekt;
import ch.wsl.fps.hepromo.model.asys.Arbeitssystem;

public abstract class AbstractCalculator {
    private final Arbeitsobjekt arbeitsobjekt;
    private final Arbeitssystem arbeitssystem;
    protected final Faktoren faktoren;
    protected boolean rindenAbzugBeruecksichtigen = true;

    public AbstractCalculator(HeProMoInputData inputData) {
        this.arbeitsobjekt = inputData.getArbeitsobjekt();
        this.arbeitssystem = inputData.getArbeitssystem();
        this.faktoren = inputData.getFaktoren();
    }

    public abstract Ergebnis calculate();

    protected Arbeitsobjekt getArbeitsobjekt() {
        return this.arbeitsobjekt;
    }

    protected Arbeitssystem getArbeitssystem() {
        return this.arbeitssystem;
    }

    public void setRindenAbzugBeruecksichtigen(boolean flag) {
        this.rindenAbzugBeruecksichtigen = flag;
    }

    protected Ergebnis.ProdEinheit getProdEinheit1() {
        return Ergebnis.ProdEinheit.M3_PRO_PSH15;
    }

    protected Ergebnis.ProdEinheit getProdEinheit2() {
        return Ergebnis.ProdEinheit.EMPTY;
    }

    protected final void setProduktivitaet(Ergebnis ergebnis, Ergebnis.ProdEinheit prodEinheit, double produktivitaet) {
        if (prodEinheit == this.getProdEinheit1()) {
            ergebnis.setProduktivitaet(Ergebnis.Purpose.FIRST, prodEinheit, produktivitaet);
        }
        if (prodEinheit == this.getProdEinheit2()) {
            ergebnis.setProduktivitaet(Ergebnis.Purpose.SECOND, prodEinheit, produktivitaet);
        }
        if (prodEinheit != this.getProdEinheit1() && prodEinheit != this.getProdEinheit2()) {
            ergebnis.setProduktivitaet(Ergebnis.Purpose.ADDITIONAL, prodEinheit, produktivitaet);
        }
    }
}

