/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.hepromo.model.asys;

import ch.wsl.fps.hepromo.model.LabelValuePairList;
import ch.wsl.fps.hepromo.model.asys.Arbeitssystem;
import java.text.DecimalFormat;

public class ArbeitssystemSchlepper
extends Arbeitssystem {
    private static final long serialVersionUID = 1L;
    private boolean rueckegehilfe;
    private double kostensatzRueckegehilfe;
    private RueckgehilfeEinsatzanteil rueckgehilfeEinsatzanteil;
    private SchlepperTyp schlepperTyp;

    public boolean isRueckegehilfe() {
        return this.rueckegehilfe;
    }

    public void setRueckegehilfe(boolean rueckegehilfe) {
        this.rueckegehilfe = rueckegehilfe;
    }

    public double getKostensatzRueckegehilfe() {
        return this.kostensatzRueckegehilfe;
    }

    public void setKostensatzRueckegehilfe(double kostensatzRueckegehilfe) {
        this.kostensatzRueckegehilfe = kostensatzRueckegehilfe;
    }

    public RueckgehilfeEinsatzanteil getRueckgehilfeEinsatzanteil() {
        return this.rueckgehilfeEinsatzanteil;
    }

    public void setRueckgehilfeEinsatzanteil(RueckgehilfeEinsatzanteil rueckgehilfeEinsatzanteil) {
        this.rueckgehilfeEinsatzanteil = rueckgehilfeEinsatzanteil;
    }

    public SchlepperTyp getSchlepperTyp() {
        return this.schlepperTyp;
    }

    public void setSchlepperTyp(SchlepperTyp schlepperTyp) {
        this.schlepperTyp = schlepperTyp;
    }

    @Override
    public LabelValuePairList getLabelValuePairList(DecimalFormat decimalFormat, String waehrung) {
        LabelValuePairList list = super.getLabelValuePairList(decimalFormat, waehrung);
        list.add("R\u00fcckegehilfe", this.rueckegehilfe);
        list.add("R\u00fcckegehilfe Einsatzanteil", this.rueckgehilfeEinsatzanteil);
        list.add("Schleppertyp", this.schlepperTyp);
        return list;
    }

    @Override
    public double getAnsatzPersonalKombiniertGewichtet() {
        double ansatz1 = this.getKostensatzPersonal1_proH() * 1.0;
        double ansatz2 = this.getKostensatzRueckegehilfe() * this.getRueckgehilfeEinsatzanteil().getRueckgehilfeEinsatzZeitFaktor();
        double fte = 1.0 + this.getRueckgehilfeEinsatzanteil().getRueckgehilfeEinsatzZeitFaktor();
        double gesamtkostensatz = (ansatz1 + ansatz2) / fte;
        return gesamtkostensatz;
    }

    public static enum RueckgehilfeEinsatzanteil {
        Unbekannt,
        Prz_0,
        Prz_1bis25,
        Prz_26bis50,
        Prz_51bis75,
        Prz_76bis100;


        public double getRueckgehilfeEinsatzZeitFaktor() {
            switch (this) {
                case Unbekannt: 
                case Prz_0: {
                    return 0.0;
                }
                case Prz_1bis25: {
                    return 0.25;
                }
                case Prz_26bis50: {
                    return 0.5;
                }
                case Prz_51bis75: {
                    return 0.75;
                }
                case Prz_76bis100: {
                    return 1.0;
                }
            }
            throw new RuntimeException();
        }

        public String toString() {
            switch (this) {
                case Unbekannt: {
                    return "unbekannt";
                }
                case Prz_0: {
                    return "0%";
                }
                case Prz_1bis25: {
                    return "1 - 25%";
                }
                case Prz_26bis50: {
                    return "26 - 50%";
                }
                case Prz_51bis75: {
                    return "51 - 75%";
                }
                case Prz_76bis100: {
                    return "76 - 100%";
                }
            }
            throw new RuntimeException();
        }

        public static RueckgehilfeEinsatzanteil parseDouble_Prz(double value) {
            if (value <= 0.0) {
                return Prz_0;
            }
            if (value <= 25.0) {
                return Prz_1bis25;
            }
            if (value <= 50.0) {
                return Prz_26bis50;
            }
            if (value <= 75.0) {
                return Prz_51bis75;
            }
            return Prz_76bis100;
        }
    }

    public static enum SchlepperTyp {
        Forstspezialschlepper,
        AndereSchleppertypen;


        public String toString() {
            switch (this) {
                case Forstspezialschlepper: {
                    return "Forstspezialschlepper";
                }
                case AndereSchleppertypen: {
                    return "andere Schleppertypen";
                }
            }
            throw new RuntimeException();
        }
    }
}

