/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.hepromo.model.asys;

import ch.wsl.fps.hepromo.model.LabelValuePairList;
import ch.wsl.fps.hepromo.model.ModelStrings;
import ch.wsl.fps.hepromo.model.asys.Arbeitssystem;
import java.text.DecimalFormat;

public class ArbeitssystemHelikopterFliegen
extends Arbeitssystem {
    private static final long serialVersionUID = 1L;
    private double anflugPauschale;
    private HelikopterKlasse helikopterKlasse;
    private double lastVolumen;
    private boolean lastVolumenAutomatischBerechnen;
    private int anzahlPersonal;

    public double getKostensatzMaschine1_proMin() {
        return super.getKostensatzMaschine1_proH() / 60.0;
    }

    public void setKostensatzMaschine1_proMin(double value) {
        super.setKostensatzMaschine1_proH(value * 60.0);
    }

    public double getAnflugPauschale() {
        return this.anflugPauschale;
    }

    public void setAnflugPauschale(double anflugPauschale) {
        this.anflugPauschale = anflugPauschale;
    }

    public HelikopterKlasse getHelikopterKlasse() {
        return this.helikopterKlasse;
    }

    public void setHelikopterKlasse(HelikopterKlasse helikopterKlasse) {
        this.helikopterKlasse = helikopterKlasse;
    }

    public double getLastVolumen() {
        return this.lastVolumen;
    }

    public void setLastVolumen(double lastVolumen) {
        this.lastVolumen = lastVolumen;
    }

    public boolean isLastVolumenAutomatischBerechnen() {
        return this.lastVolumenAutomatischBerechnen;
    }

    public void setLastVolumenAutomatischBerechnen(boolean flag) {
        this.lastVolumenAutomatischBerechnen = flag;
    }

    public int getAnzahlPersonal() {
        return this.anzahlPersonal;
    }

    public void setAnzahlPersonal(int anzahlPersonal) {
        this.anzahlPersonal = anzahlPersonal;
    }

    @Override
    public LabelValuePairList getLabelValuePairList(DecimalFormat decimalFormat, String waehrung) {
        LabelValuePairList list = new LabelValuePairList(decimalFormat);
        list.add("Kostensatz " + this.getLabelPersonal1() + " (" + waehrung + "/Std.)", this.getKostensatzPersonal1_proH());
        list.add("Kostensatz " + this.getLabelMaschine1() + " (" + waehrung + "/B'Min.)", this.getKostensatzMaschine1_proMin());
        list.add("Anflugpauschale (" + waehrung + ")", this.anflugPauschale);
        list.add("Helikopterklasse", this.helikopterKlasse);
        list.add("Lastvolumen", this.lastVolumen);
        list.add("Lastvolumen automatisch berechnen", this.lastVolumenAutomatischBerechnen);
        list.add("Anzahl Personen", this.anzahlPersonal);
        list.add("T\u00e4gliche Arbeitszeit (Min.)", this.getTaeglicheArbeitszeit_Min());
        list.add("davon bezahlte Wegzeiten und Pausen (Min.)", this.getWegzeitenUndPausen_Min());
        list.add("Umsetzen (" + waehrung + ")", this.getUmsetzenBetrag_CHF());
        list.add("Umsetzen (Std.)", this.getUmsetzenZeit_h());
        list.add("Weitere Aufw\u00e4nde (" + waehrung + ")", this.getWeitereAufwaendeBetrag_CHF());
        list.add("Weitere Aufw\u00e4nde (Std.)", this.getWeitereAufwaendeZeit_h());
        return list;
    }

    public static enum HelikopterKlasse {
        Leicht,
        Mittel,
        Schwer;


        public String toString() {
            switch (this) {
                case Leicht: {
                    return ModelStrings.PdfLabels.ArbeitssystemHelikopterFliegen_HeliklasseLeicht.toString();
                }
                case Mittel: {
                    return ModelStrings.PdfLabels.ArbeitssystemHelikopterFliegen_HeliklasseMittel.toString();
                }
                case Schwer: {
                    return ModelStrings.PdfLabels.ArbeitssystemHelikopterFliegen_HeliklasseSchwer.toString();
                }
            }
            throw new RuntimeException();
        }
    }
}

