/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.hepromo.model.aobj;

import ch.wsl.fps.hepromo.model.LabelValuePairList;
import ch.wsl.fps.hepromo.model.ModelStrings;
import ch.wsl.fps.hepromo.model.aobj.Arbeitsobjekt;
import ch.wsl.fps.hepromo.model.calc.CalculatorVorruecken2018;
import java.text.DecimalFormat;

public class ArbeitsobjektVorruecken2018
extends Arbeitsobjekt {
    private static final long serialVersionUID = 1L;
    private int bhd_cm;
    private Standortguete standortguete;
    private Hangneigung hangneigung;
    private boolean abzopfenDerKrone;

    public int getBhd_cm() {
        return this.bhd_cm;
    }

    public void setBhd_cm(int bhd_cm) {
        if (bhd_cm < 10 || bhd_cm > 30) {
            throw new IllegalArgumentException("BHD ausserhalb Wertebreich [10,30]!");
        }
        this.bhd_cm = bhd_cm;
    }

    public Standortguete getStandortguete() {
        return this.standortguete;
    }

    public void setStandortguete(Standortguete standortguete) {
        this.standortguete = standortguete;
    }

    public Hangneigung getHangneigung() {
        return this.hangneigung;
    }

    public void setHangneigung(Hangneigung hangneigung) {
        this.hangneigung = hangneigung;
    }

    public boolean isAbzopfenDerKrone() {
        return this.abzopfenDerKrone;
    }

    public void setAbzopfenDerKrone(boolean abzopfenDerKrone) {
        this.abzopfenDerKrone = abzopfenDerKrone;
    }

    public double getMittelstammvolumen() {
        return CalculatorVorruecken2018.getVMit(this.standortguete, this.bhd_cm);
    }

    @Override
    protected double getRindenAbzugFaktorBerechnet() {
        return 0.89;
    }

    @Override
    public LabelValuePairList getLabelValuePairList(DecimalFormat decimalFormat) {
        LabelValuePairList list = super.getLabelValuePairList(decimalFormat);
        list.add(ModelStrings.getString("ArbeitsobjektVorruecken2018.Bhd_cm"), this.bhd_cm);
        list.add(ModelStrings.getString("ArbeitsobjektVorruecken2018.Standortguete"), this.standortguete);
        list.add(ModelStrings.getString("ArbeitsobjektVorruecken2018.Mittelstammvolumen"), this.getMittelstammvolumen());
        list.add(ModelStrings.getString("ArbeitsobjektVorruecken2018.Hangneigung"), this.hangneigung);
        list.add(ModelStrings.getString("ArbeitsobjektVorruecken2018.AbzopfenDerKrone"), this.abzopfenDerKrone);
        return list;
    }

    public static enum Hangneigung {
        HN_BIS_15_PRZ,
        HN_GROESSER_15_BIS_25_PRZ,
        HN_GROESSER_25_BIS_35_PRZ,
        HN_GROESSER_35_BIS_45_PRZ,
        HN_GROESSER_45_BIS_55_PRZ,
        HN_GROESSER_55_PRZ;


        public String toString() {
            switch (this) {
                case HN_BIS_15_PRZ: {
                    return "0 - 15 %";
                }
                case HN_GROESSER_15_BIS_25_PRZ: {
                    return "16 - 25 %";
                }
                case HN_GROESSER_25_BIS_35_PRZ: {
                    return "26 - 35 %";
                }
                case HN_GROESSER_35_BIS_45_PRZ: {
                    return "36 - 45 %";
                }
                case HN_GROESSER_45_BIS_55_PRZ: {
                    return "46 - 55 %";
                }
                case HN_GROESSER_55_PRZ: {
                    return "> 55 %";
                }
            }
            throw new RuntimeException(this.name());
        }
    }

    public static enum Standortguete {
        SEHR_GUT,
        GUT,
        MITTEL,
        WENIGER_GUT,
        ARM;


        public String toString() {
            switch (this) {
                case SEHR_GUT: {
                    return ModelStrings.getString("ArbeitsobjektVorruecken2018.EnumStandortgueteSehrGut");
                }
                case GUT: {
                    return ModelStrings.getString("ArbeitsobjektVorruecken2018.EnumStandortgueteGut");
                }
                case MITTEL: {
                    return ModelStrings.getString("ArbeitsobjektVorruecken2018.EnumStandortgueteMittel");
                }
                case WENIGER_GUT: {
                    return ModelStrings.getString("ArbeitsobjektVorruecken2018.EnumStandortgueteWenigerGut");
                }
                case ARM: {
                    return ModelStrings.getString("ArbeitsobjektVorruecken2018.EnumStandortgueteArm");
                }
            }
            throw new RuntimeException(this.name());
        }
    }
}

