/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.hepromo.model.aobj;

import ch.wsl.fps.hepromo.model.LabelValuePairList;
import ch.wsl.fps.hepromo.model.ModelStrings;
import ch.wsl.fps.hepromo.model.aobj.Arbeitsobjekt;
import java.text.DecimalFormat;

public class ArbeitsobjektMotormanuellGesamt2014
extends Arbeitsobjekt {
    private static final long serialVersionUID = 1L;
    private int bhd_cm;
    private int anteilLaubholz_Prz;
    private int anteilKiefer_Prz;
    private Region region;

    public int getBhd_cm() {
        return this.bhd_cm;
    }

    public void setBhd_cm(int bhd_cm) {
        this.bhd_cm = bhd_cm;
    }

    public int getAnteilLaubholz_Prz() {
        return this.anteilLaubholz_Prz;
    }

    public void setAnteilLaubholz_Prz(int anteilLaubholz_Prz) {
        this.anteilLaubholz_Prz = anteilLaubholz_Prz;
    }

    public int getAnteilKiefer_Prz() {
        return this.anteilKiefer_Prz;
    }

    public void setAnteilKiefer_Prz(int anteilKiefer_Prz) {
        this.anteilKiefer_Prz = anteilKiefer_Prz;
    }

    public Region getRegion() {
        return this.region;
    }

    public void setRegion(Region region) {
        this.region = region;
    }

    @Override
    public LabelValuePairList getLabelValuePairList(DecimalFormat decimalFormat) {
        LabelValuePairList list = super.getLabelValuePairList(decimalFormat);
        list.add((Enum<ModelStrings.PdfLabels>)ModelStrings.PdfLabels.ArbeitsobjektMotormanuellGesamt2014_BHD_cm, this.bhd_cm);
        list.add((Enum<ModelStrings.PdfLabels>)ModelStrings.PdfLabels.ArbeitsobjektMotormanuellGesamt2014_AnteilLaubholz_Prz, this.anteilLaubholz_Prz);
        list.add((Enum<ModelStrings.PdfLabels>)ModelStrings.PdfLabels.ArbeitsobjektMotormanuellGesamt2014_AnteilKiefer_Prz, this.anteilKiefer_Prz);
        list.add((Enum<ModelStrings.PdfLabels>)ModelStrings.PdfLabels.ArbeitsobjektMotormanuellGesamt2014_Region, this.region);
        return list;
    }

    @Override
    protected double getRindenAbzugFaktorBerechnet() {
        double faktorRinde = 0.88 * (100.0 - (double)this.getAnteilLaubholz_Prz() - (double)this.getAnteilKiefer_Prz()) / 100.0 + (double)this.getAnteilLaubholz_Prz() / 100.0 * 0.9 + (double)this.getAnteilKiefer_Prz() / 100.0 * 0.87;
        return faktorRinde;
    }

    public static enum Region {
        Huegelland,
        Gebirge;


        public String toString() {
            switch (this) {
                case Gebirge: {
                    return ModelStrings.PdfLabels.ArbeitsobjektMotormanuellGesamt2014_Gebirge.toString();
                }
                case Huegelland: {
                    return ModelStrings.PdfLabels.ArbeitsobjektMotormanuellGesamt2014_FlachHuegelland.toString();
                }
            }
            throw new RuntimeException();
        }
    }
}

