/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.hepromo.model;

import ch.wsl.fps.hepromo.model.ModelStrings;
import java.text.DecimalFormat;
import java.util.ArrayList;

public class LabelValuePairList {
    private ArrayList<LabelValuePair> list = new ArrayList();
    private final DecimalFormat decimalFormat;

    public LabelValuePairList(DecimalFormat decimalFormat) {
        this.decimalFormat = decimalFormat;
    }

    public void add(String label, String value) {
        this.list.add(new LabelValuePair(label, value));
    }

    public void addOnTop(String label, String value) {
        this.list.add(0, new LabelValuePair(label, value));
    }

    public void add(String label, int value) {
        this.add(label, String.valueOf(value));
    }

    public void add(String label, double value) {
        this.add(label, this.decimalFormat.format(value));
    }

    public void addOnTop(String label, double value) {
        this.addOnTop(label, this.decimalFormat.format(value));
    }

    public void add(String label, boolean value) {
        String text = value ? ModelStrings.PdfLabels.LabelValuePairList_ja.toString() : ModelStrings.PdfLabels.LabelValuePairList_nein.toString();
        this.add(label, text);
    }

    public void add(String label, Enum<?> value) {
        this.add(label, String.valueOf(value));
    }

    public void addOnTop(String label, Enum<?> value) {
        this.addOnTop(label, String.valueOf(value));
    }

    public void add(Enum<ModelStrings.PdfLabels> label, String value) {
        this.list.add(new LabelValuePair(label.toString(), value));
    }

    public void addOnTop(Enum<ModelStrings.PdfLabels> label, String value) {
        this.list.add(0, new LabelValuePair(label.toString(), value));
    }

    public void add(Enum<ModelStrings.PdfLabels> label, int value) {
        this.add(label, String.valueOf(value));
    }

    public void add(Enum<ModelStrings.PdfLabels> label, double value) {
        this.add(label, this.decimalFormat.format(value));
    }

    public void add(Enum<ModelStrings.PdfLabels> label, boolean value) {
        String text = value ? ModelStrings.PdfLabels.LabelValuePairList_ja.toString() : ModelStrings.PdfLabels.LabelValuePairList_nein.toString();
        this.add(label, text);
    }

    public void add(Enum<ModelStrings.PdfLabels> label, Enum<?> value) {
        this.add(label, String.valueOf(value));
    }

    public void addOnTop(Enum<ModelStrings.PdfLabels> label, Enum<?> value) {
        this.addOnTop(label, String.valueOf(value));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (LabelValuePair element : this.list) {
            sb.append(String.valueOf(element.label) + ": " + element.value);
        }
        return sb.toString();
    }

    public String getAsXmlString(String enclosingTag) {
        StringBuilder sb = new StringBuilder();
        sb.append("<" + enclosingTag + ">\n");
        for (LabelValuePair element : this.list) {
            sb.append("\t<entry>\n");
            sb.append("\t\t<label>");
            sb.append(this.escapeXmlField(element.label));
            sb.append("</label>\n");
            sb.append("\t\t<value>");
            sb.append(this.escapeXmlField(element.value));
            sb.append("</value>\n");
            sb.append("\t</entry>\n");
        }
        sb.append("</" + enclosingTag + ">\n");
        return sb.toString();
    }

    private String escapeXmlField(String field) {
        if (field.contains("<")) {
            return field.replace("<", "<![CDATA[<]]>");
        }
        if (field.contains(">")) {
            return field.replace(">", "<![CDATA[>]]>");
        }
        return field;
    }

    public class LabelValuePair {
        public final String label;
        public final String value;

        public LabelValuePair(String label, String value) {
            this.label = label;
            this.value = value;
        }
    }
}

