/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.hepromo.model;

import ch.wsl.fps.hepromo.model.LabelValuePairList;
import ch.wsl.fps.hepromo.model.ModelStrings;
import java.io.Serializable;
import java.text.DecimalFormat;

public class Faktoren
implements Serializable {
    private static final long serialVersionUID = 1L;
    private boolean risikoVerwaltungGewinnMerged = true;
    private double margin;
    private double risiko;
    private double verwaltung;
    private double gewinn;
    private double mehrwertsteuer = 0.0;
    private String waehrungskuerzel;
    private double korrekturFaktor;

    public boolean isRisikoVerwaltungGewinnMerged() {
        return this.risikoVerwaltungGewinnMerged;
    }

    public void setRisikoVerwaltungGewinnMerged(boolean risikoVerwaltungGewinnMerged) {
        this.risikoVerwaltungGewinnMerged = risikoVerwaltungGewinnMerged;
    }

    public double getMargin() {
        if (this.isRisikoVerwaltungGewinnMerged()) {
            return this.margin;
        }
        return ((1.0 + this.risiko / 100.0) * (1.0 + this.verwaltung / 100.0) * (1.0 + this.gewinn / 100.0) - 1.0) * 100.0;
    }

    public void setMargin(double margin) {
        this.margin = margin;
    }

    public double getRisiko() {
        return this.risiko;
    }

    public void setRisiko(double risiko) {
        this.risiko = risiko;
    }

    public double getVerwaltung() {
        return this.verwaltung;
    }

    public void setVerwaltung(double verwaltung) {
        this.verwaltung = verwaltung;
    }

    public double getGewinn() {
        return this.gewinn;
    }

    public void setGewinn(double gewinn) {
        this.gewinn = gewinn;
    }

    public double getMehrwertsteuer() {
        return this.mehrwertsteuer;
    }

    public void setMehrwertsteuer(double mehrwertsteuer) {
        this.mehrwertsteuer = mehrwertsteuer;
    }

    public String getWaehrungskuerzel() {
        return this.waehrungskuerzel;
    }

    public void setWaehrungskuerzel(String waehrungskuerzel) {
        this.waehrungskuerzel = waehrungskuerzel;
    }

    public double getKorrekturFaktor() {
        return this.korrekturFaktor;
    }

    public void setKorrekturFaktor(double korrekturFaktor) {
        this.korrekturFaktor = korrekturFaktor;
    }

    public LabelValuePairList getLabelValuePairList(DecimalFormat decimalFormat) {
        LabelValuePairList list = new LabelValuePairList(decimalFormat);
        if (this.isRisikoVerwaltungGewinnMerged()) {
            list.add((Enum<ModelStrings.PdfLabels>)ModelStrings.PdfLabels.Faktoren_RisikoVerwaltungGewinn, this.margin);
        } else {
            list.add((Enum<ModelStrings.PdfLabels>)ModelStrings.PdfLabels.Faktoren_Risiko, this.risiko);
            list.add((Enum<ModelStrings.PdfLabels>)ModelStrings.PdfLabels.Faktoren_Verwaltung, this.verwaltung);
            list.add((Enum<ModelStrings.PdfLabels>)ModelStrings.PdfLabels.Faktoren_Gewinn, this.gewinn);
        }
        list.add((Enum<ModelStrings.PdfLabels>)ModelStrings.PdfLabels.Faktoren_Mehrwertsteuer, this.mehrwertsteuer);
        list.add((Enum<ModelStrings.PdfLabels>)ModelStrings.PdfLabels.Faktoren_Waehrungskuerzel, this.waehrungskuerzel);
        list.add((Enum<ModelStrings.PdfLabels>)ModelStrings.PdfLabels.Faktoren_Korrekturfaktor, this.korrekturFaktor);
        return list;
    }
}

