/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.hepromo.gui.modelle.panel.asys;

import ch.wsl.fps.hepromo.gui.GuiStrings;
import ch.wsl.fps.hepromo.gui.HeProMoWindow;
import ch.wsl.fps.hepromo.gui.TitledBorderFactory;
import ch.wsl.fps.hepromo.gui.modelle.panel.asys.IWaehrungsanzeige;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class WeitereAufwaendePanel
extends JPanel
implements IWaehrungsanzeige {
    private static final long serialVersionUID = 1L;
    private final HeProMoWindow parent;
    private JLabel lblTitleWaehrung = new JLabel("SFr.", 0);
    private JSpinner txtUmsetzenBetrag = new JSpinner();
    private JSpinner txtUmsetzenZeit = new JSpinner();
    private JSpinner txtWeitereAufwaendeBetrag = new JSpinner();
    private JSpinner txtWeitereAufwaendeZeit = new JSpinner();

    public WeitereAufwaendePanel(HeProMoWindow parent, boolean umsetzenAusblenden) {
        this.parent = parent;
        this.initPanel(umsetzenAusblenden);
        this.initData();
    }

    public WeitereAufwaendePanel(HeProMoWindow parent) {
        this(parent, false);
    }

    private void initPanel(boolean umsetzenAusblenden) {
        this.setBorder(TitledBorderFactory.createTitledBorder(GuiStrings.getString("WeitereAufwaendePanel.Title")));
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 0;
        c.fill = 2;
        c.weightx = 100.0;
        c.insets = new Insets(0, 0, 0, 5);
        this.add((Component)this.lblTitleWaehrung, c);
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = 0;
        c.fill = 2;
        c.weightx = 100.0;
        JLabel lblTitleZeiteinheit = new JLabel(GuiStrings.getString("WeitereAufwaendePanel.Std"), 0);
        this.add((Component)lblTitleZeiteinheit, c);
        if (!umsetzenAusblenden) {
            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 1;
            c.fill = 2;
            c.weightx = 100.0;
            JLabel lblUmsetzen = new JLabel(GuiStrings.getString("WeitereAufwaendePanel.Umsetzen"));
            this.add((Component)lblUmsetzen, c);
            c = new GridBagConstraints();
            c.gridx = 1;
            c.gridy = 1;
            c.fill = 2;
            c.weightx = 100.0;
            c.insets = new Insets(0, 0, 0, 5);
            this.add((Component)this.txtUmsetzenBetrag, c);
            c = new GridBagConstraints();
            c.gridx = 2;
            c.gridy = 1;
            c.fill = 2;
            c.weightx = 100.0;
            this.add((Component)this.txtUmsetzenZeit, c);
            c = new GridBagConstraints();
            c.gridx = 3;
            c.gridy = 1;
            c.insets = new Insets(0, 5, 0, 0);
            JLabel lblUmsetzen_Info = GuiStrings.getInfoButtonBlue(GuiStrings.getString("WeitereAufwaendePanel.InfoButton"));
            this.add((Component)lblUmsetzen_Info, c);
        }
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 2;
        c.fill = 2;
        c.weightx = 100.0;
        c.insets = new Insets(0, 0, 0, 5);
        JLabel lblMotorsaege1 = new JLabel(GuiStrings.getString("WeitereAufwaendePanel.WeitereAufwaende"));
        this.add((Component)lblMotorsaege1, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 2;
        c.fill = 2;
        c.weightx = 100.0;
        c.insets = new Insets(0, 0, 0, 5);
        this.add((Component)this.txtWeitereAufwaendeBetrag, c);
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = 2;
        c.fill = 2;
        c.weightx = 100.0;
        this.add((Component)this.txtWeitereAufwaendeZeit, c);
        c = new GridBagConstraints();
        c.gridx = 3;
        c.gridy = 2;
        c.insets = new Insets(0, 5, 0, 0);
        JLabel lblWeitereAufwaende_Info = GuiStrings.getInfoButtonBlue(GuiStrings.getString("WeitereAufwaendePanel.InfoButton"));
        this.add((Component)lblWeitereAufwaende_Info, c);
    }

    private void initData() {
        this.txtUmsetzenBetrag.setModel(new SpinnerNumberModel(0.0, 0.0, 100000.0, 1.0));
        this.txtUmsetzenBetrag.setEditor(new JSpinner.NumberEditor(this.txtUmsetzenBetrag, "0.##"));
        this.parent.addDefaultChangeListenerAndAdjustJSpinnerFormatter(this.txtUmsetzenBetrag);
        this.txtUmsetzenZeit.setModel(new SpinnerNumberModel(0.0, 0.0, 1000.0, 1.0));
        this.txtUmsetzenZeit.setEditor(new JSpinner.NumberEditor(this.txtUmsetzenZeit, "0.##"));
        this.parent.addDefaultChangeListenerAndAdjustJSpinnerFormatter(this.txtUmsetzenZeit);
        this.txtWeitereAufwaendeBetrag.setModel(new SpinnerNumberModel(0.0, 0.0, 100000.0, 1.0));
        this.txtWeitereAufwaendeBetrag.setEditor(new JSpinner.NumberEditor(this.txtWeitereAufwaendeBetrag, "0.##"));
        this.parent.addDefaultChangeListenerAndAdjustJSpinnerFormatter(this.txtWeitereAufwaendeBetrag);
        this.txtWeitereAufwaendeZeit.setModel(new SpinnerNumberModel(0.0, 0.0, 1000.0, 1.0));
        this.txtWeitereAufwaendeZeit.setEditor(new JSpinner.NumberEditor(this.txtWeitereAufwaendeZeit, "0.##"));
        this.parent.addDefaultChangeListenerAndAdjustJSpinnerFormatter(this.txtWeitereAufwaendeZeit);
    }

    public double getUmsetzenBetrag_CHF() {
        return (Double)this.txtUmsetzenBetrag.getValue();
    }

    public double getUmsetzenZeit_h() {
        return (Double)this.txtUmsetzenZeit.getValue();
    }

    public double getWeitereAufwaendeBetrag_CHF() {
        return (Double)this.txtWeitereAufwaendeBetrag.getValue();
    }

    public double getWeitereAufwaendeZeit_h() {
        return (Double)this.txtWeitereAufwaendeZeit.getValue();
    }

    public void setUmsetzenBetrag_CHF(double umsetzenBetrag_CHF) {
        this.txtUmsetzenBetrag.setValue(umsetzenBetrag_CHF);
    }

    public void setUmsetzenZeit_h(double umsetzenZeit_h) {
        this.txtUmsetzenZeit.setValue(umsetzenZeit_h);
    }

    public void setWeitereAufwaendeBetrag_CHF(double weitereAufwaendeBetrag_CHF) {
        this.txtWeitereAufwaendeBetrag.setValue(weitereAufwaendeBetrag_CHF);
    }

    public void setWeitereAufwaendeZeit_h(double weitereAufwaendeZeit_h) {
        this.txtWeitereAufwaendeZeit.setValue(weitereAufwaendeZeit_h);
    }

    @Override
    public void updateWaehrungskuerzel(String newValue) {
        this.lblTitleWaehrung.setText(newValue);
    }
}

