/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.hepromo.gui.modelle.panel.asys;

import ch.wsl.fps.hepromo.gui.GuiStrings;
import ch.wsl.fps.hepromo.gui.HeProMoWindow;
import ch.wsl.fps.hepromo.gui.TitledBorderFactory;
import ch.wsl.fps.hepromo.model.asys.ArbeitssystemForwarder;
import ch.wsl.fps.hepromo.model.modelle.ModelForwarder;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;

public class ForwarderPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final HeProMoWindow parent;
    private JComboBox<ArbeitssystemForwarder.ForwarderTyp> cmbForwarderTyp;
    private JSpinner txtLadeQuerschnittsFlaeche_m2;

    public ForwarderPanel(HeProMoWindow parent) {
        this.parent = parent;
        this.initPanel();
        this.initData();
    }

    private void initPanel() {
        this.setBorder(TitledBorderFactory.createTitledBorder(GuiStrings.getString("ForwarderPanel.Title")));
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 2;
        c.weightx = 100.0;
        c.gridwidth = 2;
        JLabel lblForwarderTyp = new JLabel(GuiStrings.getString("ForwarderPanel.Typ"));
        this.add((Component)lblForwarderTyp, c);
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = 0;
        c.fill = 2;
        c.weightx = 100.0;
        this.cmbForwarderTyp = new JComboBox();
        this.add(this.cmbForwarderTyp, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.fill = 2;
        JLabel lblLadeQuerschnittsFlaeche_m2 = new JLabel("<html>" + GuiStrings.getString("ForwarderPanel.Ladequerschnittsflaeche_m2") + " m<sup>2</sup></html>");
        this.add((Component)lblLadeQuerschnittsFlaeche_m2, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 1;
        c.fill = 2;
        c.weightx = 100.0;
        c.insets = new Insets(2, 5, 0, 5);
        JLabel lblLadeQuerschnittsFlaeche_Info = GuiStrings.getInfoButtonBlue(GuiStrings.getString("ForwarderPanel.Ladequerschnittsflaeche_Info"));
        lblLadeQuerschnittsFlaeche_Info.setHorizontalAlignment(2);
        this.add((Component)lblLadeQuerschnittsFlaeche_Info, c);
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = 1;
        c.fill = 2;
        c.weightx = 100.0;
        this.txtLadeQuerschnittsFlaeche_m2 = new JSpinner(new SpinnerNumberModel(4.1, 0.1, 100.0, 0.1));
        this.txtLadeQuerschnittsFlaeche_m2.setEditor(new JSpinner.NumberEditor(this.txtLadeQuerschnittsFlaeche_m2, "0.#"));
        this.parent.addDefaultChangeListenerAndAdjustJSpinnerFormatter(this.txtLadeQuerschnittsFlaeche_m2);
        this.add((Component)this.txtLadeQuerschnittsFlaeche_m2, c);
    }

    private void initData() {
        int i = 0;
        while (i < ArbeitssystemForwarder.ForwarderTyp.values().length) {
            this.cmbForwarderTyp.addItem(ArbeitssystemForwarder.ForwarderTyp.values()[i]);
            ++i;
        }
        this.parent.addDefaultActionListener(this.cmbForwarderTyp);
        this.cmbForwarderTyp.setSelectedItem((Object)ArbeitssystemForwarder.ForwarderTyp.Mittel);
    }

    public void onInputChangedBeforeCalculation(Object eventSource) {
        if (this.cmbForwarderTyp.equals(eventSource)) {
            SwingUtilities.invokeLater(() -> {
                String message = GuiStrings.getString("ForwarderPanel.DialogForwarderTypGeaendert");
                JOptionPane.showMessageDialog(this, message, GuiStrings.getString("ForwarderPanel.DialogTitleWarnung"), 2);
            });
            this.parent.loadGUIToModel();
            ModelForwarder model = (ModelForwarder)this.parent.getModel();
            model.getArbeitssystem().setForwarderTyp(this.getForwarderTyp());
            this.parent.loadModelToGUI(model);
        }
    }

    public ArbeitssystemForwarder.ForwarderTyp getForwarderTyp() {
        return (ArbeitssystemForwarder.ForwarderTyp)((Object)this.cmbForwarderTyp.getSelectedItem());
    }

    public double getLadeQuerschnittsFlaeche_m2() {
        return (Double)this.txtLadeQuerschnittsFlaeche_m2.getValue();
    }

    public void setForwarderTyp(ArbeitssystemForwarder.ForwarderTyp forwarderTyp) {
        this.cmbForwarderTyp.setSelectedItem((Object)forwarderTyp);
    }

    public void setLadeQuerschnittsFlaeche_m2(double ladeQuerschnittsFlaeche_m2) {
        this.txtLadeQuerschnittsFlaeche_m2.setValue(ladeQuerschnittsFlaeche_m2);
    }
}

