/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.hepromo.gui.modelle.panel.aobj;

import ch.wsl.fps.hepromo.gui.GuiStrings;
import ch.wsl.fps.hepromo.gui.HeProMoWindow;
import ch.wsl.fps.hepromo.gui.TitledBorderFactory;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.DecimalFormat;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class BestandPanelRadharvester2014
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final HeProMoWindow parent;
    private JSpinner txtHolzmenge_m3iR;
    private JLabel lblHolzmenge_m3oR_readOnly;
    private JSpinner txtBhd_cm;

    public BestandPanelRadharvester2014(HeProMoWindow parent) {
        this.parent = parent;
        this.initPanel();
        this.initData();
    }

    private void initPanel() {
        this.setBorder(TitledBorderFactory.createTitledBorder(GuiStrings.getString("BestandPanelRadharvester2014.AusscheidenderBestand")));
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 2;
        c.weightx = 100.0;
        c.insets = new Insets(5, 5, 0, 5);
        JLabel lblHolzmenge_iR = new JLabel(GuiStrings.getString("BestandPanelRadharvester2014.1"));
        this.add((Component)lblHolzmenge_iR, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 0;
        c.fill = 2;
        c.weightx = 100.0;
        c.insets = new Insets(5, 5, 0, 5);
        this.txtHolzmenge_m3iR = new JSpinner();
        this.txtHolzmenge_m3iR.setName("txtHolzmenge_m3iR");
        this.add((Component)this.txtHolzmenge_m3iR, c);
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = 0;
        c.anchor = 13;
        c.insets = new Insets(0, 15, 0, 0);
        this.lblHolzmenge_m3oR_readOnly = GuiStrings.getInfoButtonBlue(GuiStrings.getString("BestandPanelRadharvester2014.2"));
        this.lblHolzmenge_m3oR_readOnly.setHorizontalTextPosition(2);
        this.add((Component)this.lblHolzmenge_m3oR_readOnly, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.fill = 2;
        c.weightx = 100.0;
        c.insets = new Insets(0, 5, 5, 5);
        JLabel lblBhd = new JLabel(GuiStrings.getString("BestandPanelRadharvester2014.BHD_cm_iR"));
        this.add((Component)lblBhd, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 1;
        c.fill = 2;
        c.weightx = 100.0;
        c.insets = new Insets(0, 5, 5, 5);
        this.txtBhd_cm = new JSpinner();
        this.txtBhd_cm.setName("txtBhd_cm");
        this.add((Component)this.txtBhd_cm, c);
    }

    private void initData() {
        this.txtHolzmenge_m3iR.setModel(new SpinnerNumberModel(150.0, 0.0, 100000.0, 50.0));
        this.parent.addDefaultChangeListenerAndAdjustJSpinnerFormatter(this.txtHolzmenge_m3iR);
        this.txtHolzmenge_m3iR.addChangeListener(evt -> this.updateLabelHolzmenge_m3iR());
        this.txtBhd_cm.setModel(new SpinnerNumberModel(35, 12, 75, 1));
        this.parent.addDefaultChangeListenerAndAdjustJSpinnerFormatter(this.txtBhd_cm);
    }

    public void updateLabelHolzmengeMitRindenabzug() {
        this.updateLabelHolzmenge_m3iR();
    }

    private void updateLabelHolzmenge_m3iR() {
        DecimalFormat df = new DecimalFormat(",###.##");
        double value = (Double)this.txtHolzmenge_m3iR.getValue();
        this.lblHolzmenge_m3oR_readOnly.setText("<html>(" + df.format(value *= this.parent.getModel().getArbeitsobjekt().getRindenAbzugFaktor()) + " m<sup>3</sup> " + GuiStrings.getString("BestandPanelRadharvester2014.oR") + ")</html>");
    }

    public double getHolzmenge_m3() {
        return (Double)this.txtHolzmenge_m3iR.getValue();
    }

    public void setHolzmenge_m3(double holzmenge_m3) {
        this.txtHolzmenge_m3iR.setValue(holzmenge_m3);
        this.updateLabelHolzmenge_m3iR();
    }

    public int getBhd_cm() {
        return (Integer)this.txtBhd_cm.getValue();
    }

    public void setBhd_cm(int bhd_cm) {
        this.txtBhd_cm.setValue(bhd_cm);
    }

    public void setMinBhd_cm(int value) {
        ((SpinnerNumberModel)this.txtBhd_cm.getModel()).setMinimum(Integer.valueOf(value));
    }
}

