/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.hepromo.gui.modelle.panel.aobj;

import ch.wsl.fps.hepromo.gui.GuiStrings;
import ch.wsl.fps.hepromo.gui.HeProMoWindow;
import ch.wsl.fps.hepromo.gui.TitledBorderFactory;
import ch.wsl.fps.hepromo.model.aobj.ArbeitsobjektMotormanuellGesamt2014;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.DecimalFormat;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class BestandPanelMotormanuellGesamt2014
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final HeProMoWindow parent;
    private JSpinner txtHolzmenge_m3iR;
    private JLabel lblHolzmenge_m3oR_readOnly;
    private JSpinner txtBhd_cm;
    private JSpinner txtAnteilNadelholz_Prz;
    private JSpinner txtAnteilLaubholz_Prz;
    private JSpinner txtAnteilKiefer_Prz;
    private JComboBox<ArbeitsobjektMotormanuellGesamt2014.Region> cmbRegion;

    public BestandPanelMotormanuellGesamt2014(HeProMoWindow parent) {
        this.parent = parent;
        this.initPanel();
        this.initData();
    }

    private void initPanel() {
        this.setBorder(TitledBorderFactory.createTitledBorder(GuiStrings.getString("BestandPanelMotormanuellGesamt2014.lblAusscheidenderBestand")));
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 2;
        c.weightx = 100.0;
        JLabel lblHolzmenge_iR = new JLabel(GuiStrings.getString("BestandPanelMotormanuellGesamt2014.lblHolzmenge"));
        this.add((Component)lblHolzmenge_iR, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 0;
        c.fill = 2;
        c.weightx = 100.0;
        this.txtHolzmenge_m3iR = new JSpinner();
        this.add((Component)this.txtHolzmenge_m3iR, c);
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = 0;
        c.anchor = 13;
        c.insets = new Insets(0, 10, 0, 0);
        this.lblHolzmenge_m3oR_readOnly = GuiStrings.getInfoButtonBlue(GuiStrings.getString("BestandPanelMotormanuellGesamt2014.lblInfoButtonUmrechnung_iRoR"));
        this.lblHolzmenge_m3oR_readOnly.setHorizontalTextPosition(2);
        this.add((Component)this.lblHolzmenge_m3oR_readOnly, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.fill = 2;
        c.weightx = 100.0;
        JLabel lblBhd = new JLabel(GuiStrings.getString("BestandPanelMotormanuellGesamt2014.lblBHD"));
        this.add((Component)lblBhd, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 1;
        c.fill = 2;
        c.weightx = 100.0;
        this.txtBhd_cm = new JSpinner();
        this.add((Component)this.txtBhd_cm, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 2;
        c.fill = 2;
        c.weightx = 100.0;
        JLabel lblAnteilNadelholz = new JLabel(GuiStrings.getString("BestandPanelMotormanuellGesamt2014.AnteilNadelholzOhneFoehre"));
        this.add((Component)lblAnteilNadelholz, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 2;
        c.fill = 2;
        c.weightx = 100.0;
        this.txtAnteilNadelholz_Prz = new JSpinner();
        this.add((Component)this.txtAnteilNadelholz_Prz, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 3;
        c.fill = 2;
        c.weightx = 100.0;
        JLabel lblAnteilKiefer = new JLabel(GuiStrings.getString("BestandPanelMotormanuellGesamt2014.lblAnteilKiefer"));
        this.add((Component)lblAnteilKiefer, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 3;
        c.fill = 2;
        c.weightx = 100.0;
        this.txtAnteilKiefer_Prz = new JSpinner();
        this.add((Component)this.txtAnteilKiefer_Prz, c);
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = 3;
        c.anchor = 17;
        c.insets = new Insets(0, 10, 0, 0);
        JLabel lblAnteilKiefer_Info = GuiStrings.getInfoButtonBlue(GuiStrings.getString("BestandPanelMotormanuellGesamt2014.AnteilKieferInfoButton"));
        lblAnteilKiefer_Info.setHorizontalTextPosition(2);
        this.add((Component)lblAnteilKiefer_Info, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 4;
        c.fill = 2;
        c.weightx = 100.0;
        JLabel lblAnteilLaubholz = new JLabel(GuiStrings.getString("BestandPanelMotormanuellGesamt2014.lblAnteilLaubholz"));
        this.add((Component)lblAnteilLaubholz, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 4;
        c.fill = 2;
        c.weightx = 100.0;
        this.txtAnteilLaubholz_Prz = new JSpinner();
        this.add((Component)this.txtAnteilLaubholz_Prz, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 5;
        c.fill = 2;
        c.weightx = 100.0;
        c.insets = new Insets(10, 0, 0, 0);
        JLabel lblRegion = new JLabel(GuiStrings.getString("BestandPanelMotormanuellGesamt2014.lblRegion"));
        this.add((Component)lblRegion, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 5;
        c.fill = 2;
        c.weightx = 100.0;
        this.cmbRegion = new JComboBox();
        this.add(this.cmbRegion, c);
    }

    private void initData() {
        this.txtHolzmenge_m3iR.setModel(new SpinnerNumberModel(150.0, 0.0, 100000.0, 50.0));
        this.parent.addDefaultChangeListenerAndAdjustJSpinnerFormatter(this.txtHolzmenge_m3iR);
        this.txtHolzmenge_m3iR.addChangeListener(evt -> this.updateLabelHolzmenge_m3iR());
        this.txtBhd_cm.setModel(new SpinnerNumberModel(35, 15, 100, 1));
        this.parent.addDefaultChangeListenerAndAdjustJSpinnerFormatter(this.txtBhd_cm);
        this.txtAnteilNadelholz_Prz.setModel(new SpinnerNumberModel(0, 0, 100, 1));
        this.txtAnteilNadelholz_Prz.setEnabled(false);
        this.txtAnteilLaubholz_Prz.setModel(new SpinnerNumberModel(0, 0, 100, 1));
        this.parent.addDefaultChangeListenerAndAdjustJSpinnerFormatter(this.txtAnteilLaubholz_Prz);
        this.txtAnteilLaubholz_Prz.addChangeListener(evt -> this.updateAnteilNadelholz());
        this.txtAnteilKiefer_Prz.setModel(new SpinnerNumberModel(0, 0, 100, 1));
        this.parent.addDefaultChangeListenerAndAdjustJSpinnerFormatter(this.txtAnteilKiefer_Prz);
        this.txtAnteilKiefer_Prz.addChangeListener(evt -> this.updateAnteilNadelholz());
        int i = 0;
        while (i < ArbeitsobjektMotormanuellGesamt2014.Region.values().length) {
            this.cmbRegion.addItem(ArbeitsobjektMotormanuellGesamt2014.Region.values()[i]);
            ++i;
        }
        this.parent.addDefaultActionListener(this.cmbRegion);
        this.updateAnteilNadelholz();
    }

    public void updateLabelHolzmengeMitRindenabzug() {
        this.updateLabelHolzmenge_m3iR();
    }

    private void updateAnteilNadelholz() {
        int anteilLaub = (Integer)this.txtAnteilLaubholz_Prz.getValue();
        int anteilKiefer = (Integer)this.txtAnteilKiefer_Prz.getValue();
        this.txtAnteilNadelholz_Prz.setValue(100 - anteilLaub - anteilKiefer);
    }

    private void updateLabelHolzmenge_m3iR() {
        DecimalFormat df = new DecimalFormat(",###.##");
        double value = (Double)this.txtHolzmenge_m3iR.getValue();
        this.lblHolzmenge_m3oR_readOnly.setText("<html>(" + df.format(value *= this.parent.getModel().getArbeitsobjekt().getRindenAbzugFaktor()) + " m<sup>3</sup> " + GuiStrings.getString("BestandPanelMotormanuellGesamt2014.oR") + ")</html>");
    }

    public double getHolzmenge_m3() {
        return (Double)this.txtHolzmenge_m3iR.getValue();
    }

    public int getBhd_cm() {
        return (Integer)this.txtBhd_cm.getValue();
    }

    public int getAnteilLaubholz_Prz() {
        return (Integer)this.txtAnteilLaubholz_Prz.getValue();
    }

    public int getAnteilKiefer_Prz() {
        return (Integer)this.txtAnteilKiefer_Prz.getValue();
    }

    public ArbeitsobjektMotormanuellGesamt2014.Region getRegion() {
        return (ArbeitsobjektMotormanuellGesamt2014.Region)((Object)this.cmbRegion.getSelectedItem());
    }

    public void setHolzmenge_m3(double holzmenge) {
        this.txtHolzmenge_m3iR.setValue(holzmenge);
        this.updateLabelHolzmenge_m3iR();
    }

    public void setBhd_cm(int bhd_cm) {
        this.txtBhd_cm.setValue(bhd_cm);
    }

    public void setAnteilLaubholz_Prz(int anteilLaubholz_Prz) {
        this.txtAnteilLaubholz_Prz.setValue(anteilLaubholz_Prz);
    }

    public void setAnteilKiefer_Prz(int anteilKiefer_Prz) {
        this.txtAnteilKiefer_Prz.setValue(anteilKiefer_Prz);
    }

    public void setRegion(ArbeitsobjektMotormanuellGesamt2014.Region region) {
        this.cmbRegion.setSelectedItem((Object)region);
    }

    public void onInputChangedBeforeCalculation(Object eventSource) {
        int otherMax;
        int myVal;
        if (this.txtAnteilLaubholz_Prz.equals(eventSource)) {
            myVal = (Integer)this.txtAnteilLaubholz_Prz.getValue();
            otherMax = 100 - myVal;
            ((SpinnerNumberModel)this.txtAnteilKiefer_Prz.getModel()).setMaximum(Integer.valueOf(otherMax));
        }
        if (this.txtAnteilKiefer_Prz.equals(eventSource)) {
            myVal = (Integer)this.txtAnteilKiefer_Prz.getValue();
            otherMax = 100 - myVal;
            ((SpinnerNumberModel)this.txtAnteilLaubholz_Prz.getModel()).setMaximum(Integer.valueOf(otherMax));
        }
    }
}

