/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.hepromo.gui.modelle.panel.aobj;

import ch.wsl.fps.hepromo.gui.HeProMoWindow;
import ch.wsl.fps.hepromo.gui.TitledBorderFactory;
import ch.wsl.fps.hepromo.model.aobj.ArbeitsobjektMobilerHacker;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;

public class AushiebUndHackgutPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final HeProMoWindow parent;
    private JSpinner txtLaubholzanteil;
    private JSpinner txtAnzahlBaeume;
    private JTextField txtHackgutMenge;
    private JComboBox<ArbeitsobjektMobilerHacker.Hackgutart> cmbHackgutArt;
    private JSpinner txtMittlererBhdAushieb;
    private JSpinner txtMittlererZopfDurchmesser;

    public AushiebUndHackgutPanel(HeProMoWindow parent) {
        this.parent = parent;
        this.initPanel();
        this.initData();
    }

    private void initPanel() {
        this.setBorder(TitledBorderFactory.createTitledBorder("Aushieb und Hackgut"));
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 2;
        c.weightx = 100.0;
        JLabel lblLaubholzanteil = new JLabel("Laubholzanteil (%)");
        this.add((Component)lblLaubholzanteil, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 0;
        c.fill = 2;
        c.weightx = 100.0;
        this.txtLaubholzanteil = new JSpinner(new SpinnerNumberModel(0.0, 0.0, 100.0, 1.0));
        this.parent.addDefaultChangeListenerAndAdjustJSpinnerFormatter(this.txtLaubholzanteil);
        this.add((Component)this.txtLaubholzanteil, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.fill = 2;
        c.weightx = 100.0;
        JLabel lblAnzahlBaeume = new JLabel("Anzahl B\u00e4ume beim Aushieb");
        this.add((Component)lblAnzahlBaeume, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 1;
        c.fill = 2;
        c.weightx = 100.0;
        this.txtAnzahlBaeume = new JSpinner(new SpinnerNumberModel(550, 0, 2000, 1));
        this.parent.addDefaultChangeListenerAndAdjustJSpinnerFormatter(this.txtAnzahlBaeume);
        this.add((Component)this.txtAnzahlBaeume, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 2;
        c.fill = 2;
        c.weightx = 100.0;
        JLabel lblHackgutmenge = new JLabel("<html>Hackgutmenge (m<sup>3</sup>)</html>");
        this.add((Component)lblHackgutmenge, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 2;
        c.fill = 2;
        c.weightx = 100.0;
        this.txtHackgutMenge = new JTextField();
        this.txtHackgutMenge.setEditable(false);
        this.add((Component)this.txtHackgutMenge, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 3;
        c.fill = 2;
        c.weightx = 100.0;
        c.insets = new Insets(5, 0, 0, 0);
        JLabel lblHackgutart = new JLabel("Hackgutart");
        this.add((Component)lblHackgutart, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 3;
        c.fill = 2;
        c.weightx = 100.0;
        c.insets = new Insets(5, 0, 0, 0);
        this.cmbHackgutArt = new JComboBox();
        this.add(this.cmbHackgutArt, c);
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = 0;
        c.fill = 2;
        c.weightx = 15.0;
        JPanel placeholder = new JPanel();
        this.add((Component)placeholder, c);
        c = new GridBagConstraints();
        c.gridx = 3;
        c.gridy = 0;
        c.fill = 2;
        c.weightx = 100.0;
        JLabel lblMittlererBhdAushieb = new JLabel("Mittlerer BHD Aushieb (m)");
        this.add((Component)lblMittlererBhdAushieb, c);
        c = new GridBagConstraints();
        c.gridx = 4;
        c.gridy = 0;
        c.fill = 2;
        c.weightx = 100.0;
        this.txtMittlererBhdAushieb = new JSpinner(new SpinnerNumberModel(0.3, 0.0, 1.0, 0.01));
        this.parent.addDefaultChangeListenerAndAdjustJSpinnerFormatter(this.txtMittlererBhdAushieb);
        this.add((Component)this.txtMittlererBhdAushieb, c);
        c = new GridBagConstraints();
        c.gridx = 3;
        c.gridy = 1;
        c.fill = 2;
        c.weightx = 100.0;
        JLabel lblMittlererZopfDrm = new JLabel("<html>Mittlerer Zopfdurchmesser, resp. Basisdurchmesser des Kronenmaterials (m)</html>");
        this.add((Component)lblMittlererZopfDrm, c);
        c = new GridBagConstraints();
        c.gridx = 4;
        c.gridy = 1;
        c.fill = 2;
        c.weightx = 100.0;
        this.txtMittlererZopfDurchmesser = new JSpinner(new SpinnerNumberModel(0.08, 0.0, 1.0, 0.01));
        this.parent.addDefaultChangeListenerAndAdjustJSpinnerFormatter(this.txtMittlererZopfDurchmesser);
        this.add((Component)this.txtMittlererZopfDurchmesser, c);
    }

    private void initData() {
        int i = 0;
        while (i < ArbeitsobjektMobilerHacker.Hackgutart.values().length) {
            this.cmbHackgutArt.addItem(ArbeitsobjektMobilerHacker.Hackgutart.values()[i]);
            ++i;
        }
        this.parent.addDefaultActionListener(this.cmbHackgutArt);
        this.cmbHackgutArt.setSelectedItem((Object)ArbeitsobjektMobilerHacker.Hackgutart.Kronen);
    }

    public double getLaubholzAnteil_Prz() {
        return (Double)this.txtLaubholzanteil.getValue();
    }

    public int getAnzahlBaeume() {
        return (Integer)this.txtAnzahlBaeume.getValue();
    }

    public ArbeitsobjektMobilerHacker.Hackgutart getHackgutart() {
        return (ArbeitsobjektMobilerHacker.Hackgutart)((Object)this.cmbHackgutArt.getSelectedItem());
    }

    public double getMittlererBhdAushieb_m() {
        return (Double)this.txtMittlererBhdAushieb.getValue();
    }

    public double getMittlererZopfDurchmesser_m() {
        return (Double)this.txtMittlererZopfDurchmesser.getValue();
    }

    public void setLaubholzAnteil_Prz(double laubholzAnteil_Prz) {
        this.txtLaubholzanteil.setValue(laubholzAnteil_Prz);
    }

    public void setAnzahlBaeume(int anzahlBaeume) {
        this.txtAnzahlBaeume.setValue(anzahlBaeume);
    }

    public void setHackgutMenge_m3(double hackgutMenge_m3) {
        this.txtHackgutMenge.setText(this.parseDouble(hackgutMenge_m3, 2));
    }

    public void setHackgutart(ArbeitsobjektMobilerHacker.Hackgutart hackgutart) {
        this.cmbHackgutArt.setSelectedItem((Object)hackgutart);
    }

    public void setMittlererBhdAushieb_m(double mittlererBhdAushieb_m) {
        this.txtMittlererBhdAushieb.setValue(mittlererBhdAushieb_m);
    }

    public void setMittlererZopfDurchmesser_m(double mittlererZopfDrm_m) {
        this.txtMittlererZopfDurchmesser.setValue(mittlererZopfDrm_m);
    }

    protected final String parseDouble(double value, int anzahlNachkommastellen) {
        int factor = (int)Math.pow(10.0, anzahlNachkommastellen);
        double roundedValue = (double)Math.round(value * (double)factor) / (0.0 + (double)factor);
        if (Math.abs(roundedValue - value) > 1.0) {
            throw new ArithmeticException("overflow (" + value + "/" + roundedValue + ")");
        }
        String result = String.valueOf(roundedValue);
        if (anzahlNachkommastellen == 0) {
            result = result.replace(".0", "");
        }
        return result;
    }
}

