/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.hepromo.gui.modelle;

import ch.wsl.fps.hepromo.gui.GuiStrings;
import ch.wsl.fps.hepromo.gui.HeProMoWindow2014;
import ch.wsl.fps.hepromo.gui.MainWindow;
import ch.wsl.fps.hepromo.gui.modelle.panel.aobj.BestandPanelSchlepper2014;
import ch.wsl.fps.hepromo.gui.modelle.panel.aobj.ZuschlaegePanelSchlepper2014;
import ch.wsl.fps.hepromo.model.HeProMoInputData;
import ch.wsl.fps.hepromo.model.aobj.ArbeitsobjektSchlepper2014;
import ch.wsl.fps.hepromo.model.asys.ArbeitssystemSchlepper2014;
import ch.wsl.fps.hepromo.model.modelle.ModelSchlepper2014;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class Schlepper2014
extends HeProMoWindow2014 {
    private static final long serialVersionUID = 1L;
    private BestandPanelSchlepper2014 panelBestand;
    private ZuschlaegePanelSchlepper2014 panelZuschlaege;
    private JComboBox<ArbeitssystemSchlepper2014.Maschinenkategorie> cmbMaschinenkategorie;
    private ModelSchlepper2014 model = new ModelSchlepper2014();

    public Schlepper2014() {
        super.setTitle(GuiStrings.getString("Schlepper2014.Title"));
        super.setSize((int)(645.0f * MainWindow.SIZE * MainWindow.WIDTH_FACTOR), (int)(630.0f * MainWindow.SIZE));
        super.initalize();
    }

    @Override
    protected void initPanelArbeitsobjekt(JPanel panel) {
        panel.removeAll();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 1;
        c.weightx = 100.0;
        this.panelBestand = new BestandPanelSchlepper2014(this);
        panel.add((Component)this.panelBestand, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.fill = 1;
        c.weightx = 100.0;
        c.insets = new Insets(15, 0, 0, 0);
        this.panelZuschlaege = new ZuschlaegePanelSchlepper2014(this);
        panel.add((Component)this.panelZuschlaege, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 2;
        c.fill = 1;
        c.weightx = 100.0;
        c.weighty = 100.0;
        panel.add((Component)new JPanel(), c);
    }

    @Override
    protected JPanel initSpecialPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 2;
        c.weightx = 100.0;
        c.insets = new Insets(10, 8, 20, 5);
        JLabel lblMaschinenkategorie = new JLabel(GuiStrings.getString("Schlepper2014.Schlepperart"));
        panel.add((Component)lblMaschinenkategorie, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 0;
        c.fill = 2;
        c.weightx = 100.0;
        c.insets = new Insets(10, 5, 20, 5);
        this.cmbMaschinenkategorie = new JComboBox();
        panel.add(this.cmbMaschinenkategorie, c);
        return panel;
    }

    @Override
    protected void initData() {
        String labelPersonal = this.getModel().getArbeitssystem().getLabelPersonal1();
        String labelMaschine = this.getModel().getArbeitssystem().getLabelMaschine1();
        this.panelKostensaetze.setLabelPersonal(labelPersonal);
        this.panelKostensaetze.setLabelMaschine1(labelMaschine);
        ArbeitssystemSchlepper2014.Maschinenkategorie[] maschinenkategorieArray = ArbeitssystemSchlepper2014.Maschinenkategorie.values();
        int n = maschinenkategorieArray.length;
        int n2 = 0;
        while (n2 < n) {
            ArbeitssystemSchlepper2014.Maschinenkategorie value = maschinenkategorieArray[n2];
            this.cmbMaschinenkategorie.addItem(value);
            ++n2;
        }
        this.addDefaultActionListener(this.cmbMaschinenkategorie);
    }

    @Override
    protected void onInputChangedBeforeCalculation(Object eventSource) {
        if (this.cmbMaschinenkategorie.equals(eventSource)) {
            SwingUtilities.invokeLater(() -> {
                String message = GuiStrings.getString("Schlepper2014.WarnungKostensatz");
                JOptionPane.showMessageDialog(this, message, GuiStrings.getString("Schlepper2014.Warnung"), 2);
            });
        }
        this.panelZuschlaege.onInputChangedBeforeCalculation(eventSource);
    }

    @Override
    public void loadGUIToModel() {
        super.loadGUIToModel();
        this.panelBestand.updateLabelHolzmengeMitRindenabzug();
        this.model.getArbeitssystem().setMaschinenkategorie(this.getMaschinenkategorie());
        this.model.getArbeitsobjekt().setHolzmenge_m3(this.panelBestand.getHolzmenge_m3());
        this.model.getArbeitsobjekt().setMittlererStueckinhalt(this.panelBestand.getMittlererStueckinhalt());
        this.model.getArbeitsobjekt().setMittlereFahrentfernung(this.panelBestand.getMittlereFahrentfernung());
        this.model.getArbeitsobjekt().setBeizugsdistanzArrayWithSelection(this.panelZuschlaege.getBeizugsdistanzArrayWithSelection());
    }

    @Override
    public ModelSchlepper2014 getModel() {
        return this.model;
    }

    @Override
    public void loadModelToGUI(HeProMoInputData data) {
        super.setReactOnInputChange(false);
        super.loadModelToGUI(data);
        this.setMaschinenkategorie(((ArbeitssystemSchlepper2014)data.getArbeitssystem()).getMaschinenkategorie());
        this.panelBestand.setHolzmenge_m3(data.getArbeitsobjekt().getHolzmenge_m3());
        this.panelBestand.setMittlererStueckinhalt(((ArbeitsobjektSchlepper2014)data.getArbeitsobjekt()).getMittlererStueckinhalt());
        this.panelBestand.setMittlereFahrentfernung(((ArbeitsobjektSchlepper2014)data.getArbeitsobjekt()).getMittlereFahrentfernung());
        this.panelZuschlaege.setBeizugsdistanzArrayWithSelection(((ArbeitsobjektSchlepper2014)data.getArbeitsobjekt()).getBeizugsdistanzArrayWithSelection());
        super.setReactOnInputChange(true);
    }

    public ArbeitssystemSchlepper2014.Maschinenkategorie getMaschinenkategorie() {
        return (ArbeitssystemSchlepper2014.Maschinenkategorie)((Object)this.cmbMaschinenkategorie.getSelectedItem());
    }

    public void setMaschinenkategorie(ArbeitssystemSchlepper2014.Maschinenkategorie maschinenkategorie) {
        this.cmbMaschinenkategorie.setSelectedItem((Object)maschinenkategorie);
    }
}

