/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.hepromo.gui.modelle;

import ch.wsl.fps.hepromo.gui.AbstractErgebnisPanel;
import ch.wsl.fps.hepromo.gui.ErgebnisPanel;
import ch.wsl.fps.hepromo.gui.GuiStrings;
import ch.wsl.fps.hepromo.gui.HeProMoWindow2014;
import ch.wsl.fps.hepromo.gui.MainWindow;
import ch.wsl.fps.hepromo.gui.modelle.panel.aobj.BestandPanelRadharvester2014;
import ch.wsl.fps.hepromo.gui.modelle.panel.aobj.TraktionshilfswindePanel;
import ch.wsl.fps.hepromo.gui.modelle.panel.aobj.ZuschlaegePanelRadharvester2014;
import ch.wsl.fps.hepromo.gui.modelle.panel.asys.KostensaetzePanel2014;
import ch.wsl.fps.hepromo.model.HeProMoInputData;
import ch.wsl.fps.hepromo.model.aobj.ArbeitsobjektRadharvester2014;
import ch.wsl.fps.hepromo.model.asys.ArbeitssystemRadharvester2014;
import ch.wsl.fps.hepromo.model.modelle.ModelRadharvester2014;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class Radharvester2014
extends HeProMoWindow2014 {
    private static final long serialVersionUID = 1L;
    private BestandPanelRadharvester2014 panelBestand;
    private ZuschlaegePanelRadharvester2014 panelZuschlaege;
    private TraktionshilfswindePanel panelThw;
    private JComboBox<ArbeitssystemRadharvester2014.Maschinentyp> cmbMaschinentyp;
    private ModelRadharvester2014 model = new ModelRadharvester2014();

    public Radharvester2014() {
        super.setTitle(GuiStrings.getString("Radharvester2014.Title"));
        super.setSize((int)(645.0f * MainWindow.SIZE * MainWindow.WIDTH_FACTOR), (int)(720.0f * MainWindow.SIZE));
        super.initalize();
    }

    @Override
    protected void initPanelArbeitsobjekt(JPanel panel) {
        panel.removeAll();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 1;
        c.weightx = 100.0;
        this.panelBestand = new BestandPanelRadharvester2014(this);
        panel.add((Component)this.panelBestand, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.fill = 1;
        c.weightx = 100.0;
        c.insets = new Insets(10, 0, 0, 0);
        this.panelZuschlaege = new ZuschlaegePanelRadharvester2014(this);
        panel.add((Component)this.panelZuschlaege, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 2;
        c.fill = 1;
        c.weightx = 100.0;
        c.insets = new Insets(10, 0, 0, 0);
        this.panelThw = new TraktionshilfswindePanel(this);
        panel.add((Component)this.panelThw, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 3;
        c.fill = 1;
        c.weightx = 100.0;
        c.weighty = 100.0;
        panel.add((Component)new JPanel(), c);
    }

    @Override
    protected AbstractErgebnisPanel initErgebnisPanel() {
        ErgebnisPanel panel = new ErgebnisPanel.Builder().enableRowPersonal().enableRowMaschine1().enableRowMaschine2().enableRowUmsetzen().enableRowProduktivitaet().enableColumnProM3().build();
        panel.setZeitMaschine2Unit("ISH");
        panel.setZeitMaschine2UnitInfo(GuiStrings.getString("Thw.IndirectSystemHours"));
        panel.setLabelProduktivitaet(GuiStrings.getString("HeProMoWindow2014.Produktivitaet_m3_iR_pro_PMH15"));
        panel.setLabelProduktivitaet2(GuiStrings.getString("HeProMoWindow2014.m3_oR_pro_PMH15"));
        panel.setLabelKostenProM3(GuiStrings.getString("HeProMoWindow2014.ProM3oR"));
        return panel;
    }

    @Override
    protected JPanel initSpecialPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 2;
        c.weightx = 100.0;
        c.insets = new Insets(10, 8, 20, 5);
        JLabel lblMaschinentyp = new JLabel(GuiStrings.getString("Radharvester2014.Maschinentyp"));
        panel.add((Component)lblMaschinentyp, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 0;
        c.fill = 2;
        c.weightx = 100.0;
        c.insets = new Insets(10, 5, 20, 5);
        this.cmbMaschinentyp = new JComboBox();
        panel.add(this.cmbMaschinentyp, c);
        return panel;
    }

    @Override
    protected KostensaetzePanel2014 initKostensaetzePanel() {
        KostensaetzePanel2014 panel = new KostensaetzePanel2014.Builder(this).showPersonal1().showMaschine2().setUnitMaschine2ToISH().build();
        panel.setLabelMaschine2(GuiStrings.getString("Thw.TraktionshilfswindeMaschine"));
        return panel;
    }

    @Override
    protected void initData() {
        String labelPersonal = this.getModel().getArbeitssystem().getLabelPersonal1();
        String labelMaschine = this.getModel().getArbeitssystem().getLabelMaschine1();
        this.panelKostensaetze.setLabelPersonal(labelPersonal);
        this.panelKostensaetze.setLabelMaschine1(labelMaschine);
        int i = 0;
        while (i < ArbeitssystemRadharvester2014.Maschinentyp.values().length) {
            this.cmbMaschinentyp.addItem(ArbeitssystemRadharvester2014.Maschinentyp.values()[i]);
            ++i;
        }
        this.addDefaultActionListener(this.cmbMaschinentyp);
    }

    @Override
    protected void onInputChangedBeforeCalculation(Object eventSource) {
        if (this.cmbMaschinentyp.equals(eventSource)) {
            ArbeitssystemRadharvester2014.Maschinentyp selection = (ArbeitssystemRadharvester2014.Maschinentyp)((Object)this.cmbMaschinentyp.getSelectedItem());
            switch (selection) {
                case Mittel: {
                    this.panelBestand.setMinBhd_cm(12);
                    SwingUtilities.invokeLater(() -> {
                        String message = GuiStrings.getString("Radharvester2014.WarnungKostensatz");
                        JOptionPane.showMessageDialog(this, message, GuiStrings.getString("Radharvester2014.Warnung"), 2);
                    });
                    break;
                }
                case Gross: {
                    if (this.panelBestand.getBhd_cm() < 15) {
                        this.panelBestand.setBhd_cm(15);
                    }
                    this.panelBestand.setMinBhd_cm(15);
                    SwingUtilities.invokeLater(() -> {
                        String message = "<html><li>" + GuiStrings.getString("Radharvester2014.WarnungKostensatzZeile1") + GuiStrings.getString("Radharvester2014.WarnungKostensatzZeile2") + "<li>" + GuiStrings.getString("Radharvester2014.WarnungKostensatz") + "</html>";
                        JOptionPane.showMessageDialog(this, message, GuiStrings.getString("Radharvester2014.Warnung"), 2);
                    });
                    break;
                }
                default: {
                    throw new RuntimeException();
                }
            }
        }
        this.panelZuschlaege.onInputChangedBeforeCalculation(eventSource);
    }

    @Override
    public void loadGUIToModel() {
        super.loadGUIToModel();
        this.panelBestand.updateLabelHolzmengeMitRindenabzug();
        this.model.getArbeitsobjekt().setHolzmenge_m3(this.panelBestand.getHolzmenge_m3());
        this.model.getArbeitsobjekt().setBhd_cm(this.panelBestand.getBhd_cm());
        this.model.getArbeitsobjekt().setFoermigkeitArrayWithSelection(this.panelZuschlaege.getFoermigkeitArrayWithSelection());
        this.model.getArbeitsobjekt().setLaubholzAnteilArrayWithSelection(this.panelZuschlaege.getLaubholzAnteilArrayWithSelection());
        this.model.getArbeitsobjekt().setLiegendesHolzArrayWithSelection(this.panelZuschlaege.getLiegendesHolzArrayWithSelection());
        this.model.getArbeitsobjekt().setHangneigungArrayWithSelection(this.panelZuschlaege.getHangneigungArrayWithSelection());
        this.model.getArbeitsobjekt().setEinsatzThw(this.panelThw.isEinsatzThw());
        this.model.getArbeitsobjekt().setAnzahlRueckegassen(this.panelThw.getAnzahlRueckegassen());
        this.model.getArbeitssystem().setMaschinentyp(this.getMaschinentyp());
        this.model.getArbeitssystem().setKostensatzMaschine2_proH(this.panelKostensaetze.getAnsatzMaschine2());
    }

    @Override
    public ModelRadharvester2014 getModel() {
        return this.model;
    }

    @Override
    public void loadModelToGUI(HeProMoInputData data) {
        super.setReactOnInputChange(false);
        super.loadModelToGUI(data);
        this.setMaschinentyp(((ArbeitssystemRadharvester2014)data.getArbeitssystem()).getMaschinentyp());
        this.panelBestand.setHolzmenge_m3(data.getArbeitsobjekt().getHolzmenge_m3());
        this.panelBestand.setBhd_cm(((ArbeitsobjektRadharvester2014)data.getArbeitsobjekt()).getBhd_cm());
        this.panelZuschlaege.setFoermigkeitArrayWithSelection(((ArbeitsobjektRadharvester2014)data.getArbeitsobjekt()).getFoermigkeitArrayWithSelection());
        this.panelZuschlaege.setLaubholzAnteilArrayWithSelection(((ArbeitsobjektRadharvester2014)data.getArbeitsobjekt()).getLaubholzAnteilArrayWithSelection());
        this.panelZuschlaege.setLiegendesHolzArrayWithSelection(((ArbeitsobjektRadharvester2014)data.getArbeitsobjekt()).getLiegendesHolzArrayWithSelection());
        this.panelZuschlaege.setHangneigungArrayWithSelection(((ArbeitsobjektRadharvester2014)data.getArbeitsobjekt()).getHangneigungArrayWithSelection());
        this.panelThw.setEinsatzThw(((ArbeitsobjektRadharvester2014)data.getArbeitsobjekt()).isEinsatzThw());
        this.panelThw.setAnzahlRueckegassen(((ArbeitsobjektRadharvester2014)data.getArbeitsobjekt()).getAnzahlRueckegassen());
        this.panelKostensaetze.setAnsatzMaschine2(data.getArbeitssystem().getKostensatzMaschine2_proH());
        super.setReactOnInputChange(true);
    }

    public ArbeitssystemRadharvester2014.Maschinentyp getMaschinentyp() {
        return (ArbeitssystemRadharvester2014.Maschinentyp)((Object)this.cmbMaschinentyp.getSelectedItem());
    }

    public void setMaschinentyp(ArbeitssystemRadharvester2014.Maschinentyp maschinentyp) {
        this.cmbMaschinentyp.setSelectedItem((Object)maschinentyp);
        switch (maschinentyp) {
            case Mittel: {
                this.panelBestand.setMinBhd_cm(12);
                break;
            }
            case Gross: {
                if (this.panelBestand.getBhd_cm() < 15) {
                    this.panelBestand.setBhd_cm(15);
                }
                this.panelBestand.setMinBhd_cm(15);
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
    }
}

