/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.hepromo.gui.modelle;

import ch.wsl.fps.hepromo.gui.GuiStrings;
import ch.wsl.fps.hepromo.gui.modelle.PoltervolumenSchaetzmethode;
import ch.wsl.fps.hepromo.model.aobj.ArbeitsobjektHacker2018;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class PoltervolumenSchaetzen
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JComboBox<PoltervolumenSchaetzmethode> cmbSchaetzmethode;
    private JPanel pnlSchaetzmethode = new JPanel();

    public PoltervolumenSchaetzen(ArbeitsobjektHacker2018.Zielsortiment zielsortiment) {
        this.initContent();
        this.setDefaultSchaetzmethode(zielsortiment);
    }

    protected void setDefaultSchaetzmethode(ArbeitsobjektHacker2018.Zielsortiment zielsortiment) {
        switch (zielsortiment) {
            case Energierundholz: {
                this.cmbSchaetzmethode.setSelectedItem(this.cmbSchaetzmethode.getItemAt(0));
                break;
            }
            case Waldrestholz: {
                this.cmbSchaetzmethode.setSelectedItem(this.cmbSchaetzmethode.getItemAt(4));
                break;
            }
            default: {
                throw new RuntimeException(zielsortiment.toString());
            }
        }
    }

    private void initContent() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 2;
        c.weightx = 100.0;
        c.insets = new Insets(0, 0, 0, 10);
        JLabel lblSchaetzmethode = new JLabel(GuiStrings.getString("PoltervolumenSchaetzen.Schaetzmethode"));
        this.add((Component)lblSchaetzmethode, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 0;
        c.fill = 1;
        c.weightx = 100.0;
        this.cmbSchaetzmethode = new JComboBox();
        this.cmbSchaetzmethode.addItem(new PoltervolumenSchaetzmethode.SchaetzmethodeRauricaKlein());
        this.cmbSchaetzmethode.addItem(new PoltervolumenSchaetzmethode.SchaetzmethodeRauricaGross());
        this.cmbSchaetzmethode.addItem(new PoltervolumenSchaetzmethode.SchaetzmethodeRauricaDetailliert());
        this.cmbSchaetzmethode.addItem(new PoltervolumenSchaetzmethode.SchaetzmethodeKuptz());
        this.cmbSchaetzmethode.addItem(new PoltervolumenSchaetzmethode.SchaetzmethodeKuptzWaldrestholz());
        this.cmbSchaetzmethode.setSelectedIndex(-1);
        this.cmbSchaetzmethode.addActionListener(evt -> {
            Object selection = this.cmbSchaetzmethode.getSelectedItem();
            if (selection instanceof PoltervolumenSchaetzmethode) {
                this.pnlSchaetzmethode.removeAll();
                this.pnlSchaetzmethode.setLayout(new GridBagLayout());
                GridBagConstraints c1 = new GridBagConstraints();
                c1.gridx = 0;
                c1.gridy = 0;
                c1.fill = 2;
                c1.weightx = 100.0;
                this.pnlSchaetzmethode.add((Component)((PoltervolumenSchaetzmethode)selection), c1);
                this.repaint();
                this.validate();
                Window window = SwingUtilities.getWindowAncestor(this);
                if (window != null) {
                    window.pack();
                }
            } else {
                this.pnlSchaetzmethode.removeAll();
                this.validate();
                Window window = SwingUtilities.getWindowAncestor(this);
                if (window != null) {
                    window.pack();
                }
            }
        });
        this.cmbSchaetzmethode.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component component = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (!isSelected) {
                    PoltervolumenSchaetzmethode schaetzmethode = (PoltervolumenSchaetzmethode)value;
                    if (schaetzmethode instanceof PoltervolumenSchaetzmethode.SchaetzmethodeKuptzWaldrestholz) {
                        component.setBackground(new Color(184, 134, 11));
                    } else {
                        component.setBackground(new Color(144, 238, 144));
                    }
                }
                return component;
            }
        });
        this.add(this.cmbSchaetzmethode, c);
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = 0;
        c.fill = 2;
        c.weightx = 100.0;
        c.insets = new Insets(0, 10, 0, 0);
        JLabel lblInfoButton = GuiStrings.getInfoButtonBlue("<html> " + GuiStrings.getString("PoltervolumenSchaetzen.begriffserklaerungPolter") + GuiStrings.getString("PoltervolumenSchaetzen.begriffserklaerungEnergierundholz") + GuiStrings.getString("PoltervolumenSchaetzen.begriffserklaerungWaldrestholz") + "</html>");
        this.add((Component)lblInfoButton, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 3;
        c.fill = 2;
        c.weightx = 100.0;
        c.insets = new Insets(10, 0, 0, 0);
        this.add((Component)this.pnlSchaetzmethode, c);
    }

    public double getHolzmenge_Srm() {
        Object selection = this.cmbSchaetzmethode.getSelectedItem();
        if (selection instanceof PoltervolumenSchaetzmethode) {
            double result = ((PoltervolumenSchaetzmethode)selection).getResult();
            result = (float)Math.round(result * 10.0) / 10.0f;
            return result;
        }
        return -1.0;
    }
}

