/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.hepromo.gui.modelle;

import ch.wsl.fps.hepromo.gui.AbstractErgebnisPanel;
import ch.wsl.fps.hepromo.gui.ErgebnisPanelHelikopterGesamt;
import ch.wsl.fps.hepromo.gui.GuiStrings;
import ch.wsl.fps.hepromo.gui.MainWindow;
import ch.wsl.fps.hepromo.gui.modelle.HelikopterFliegenBase;
import ch.wsl.fps.hepromo.gui.modelle.panel.asys.ArbeitswegePausenPanel;
import ch.wsl.fps.hepromo.gui.modelle.panel.asys.HelikopterPanel;
import ch.wsl.fps.hepromo.gui.modelle.panel.asys.KostensaetzePanelHelikopterGesamtForstbetrieb;
import ch.wsl.fps.hepromo.gui.modelle.panel.asys.WeitereAufwaendePanel;
import ch.wsl.fps.hepromo.model.HeProMoInputData;
import ch.wsl.fps.hepromo.model.aobj.ArbeitsobjektHelikopterAufarbeiten;
import ch.wsl.fps.hepromo.model.aobj.ArbeitsobjektHelikopterFliegen;
import ch.wsl.fps.hepromo.model.aobj.ArbeitsobjektHelikopterGesamt;
import ch.wsl.fps.hepromo.model.asys.ArbeitssystemHelikopterGesamt;
import ch.wsl.fps.hepromo.model.modelle.ModelHelikopterGesamt;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.DecimalFormat;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class HelikopterGesamt
extends HelikopterFliegenBase {
    private static final long serialVersionUID = 1L;
    private JLabel lblHolzmenge_m3oR_readOnly;
    private JComboBox<ArbeitsobjektHelikopterAufarbeiten.ArbeitsVerfahren> cmbArbeitsVerfahren;
    private JLabel lblBaumartenGruppe;
    private JComboBox<ArbeitsobjektHelikopterAufarbeiten.BaumartenGruppe> cmbBaumartenGruppe;
    private KostensaetzePanelHelikopterGesamtForstbetrieb panelKostensaetze;
    private JCheckBox chkKalkulationInklLagerplatzarbeit;
    private ModelHelikopterGesamt model = new ModelHelikopterGesamt();

    public HelikopterGesamt() {
        super.setTitle(GuiStrings.getString("HelikopterGesamt.Title"));
        super.setSize((int)(710.0f * MainWindow.SIZE * MainWindow.WIDTH_FACTOR), (int)(730.0f * MainWindow.SIZE));
        super.initalize();
    }

    @Override
    protected void initPanelArbeitsobjekt(JPanel panel) {
        panel.removeAll();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 1;
        c.weightx = 100.0;
        c.insets = new Insets(5, 5, 0, 5);
        JLabel lblHolzmenge = new JLabel(GuiStrings.getString("HelikopterGesamt.Holzmenge"));
        panel.add((Component)lblHolzmenge, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 0;
        c.fill = 1;
        c.weightx = 100.0;
        c.insets = new Insets(5, 5, 0, 5);
        this.txtHolzmenge_m3iR = new JSpinner(new SpinnerNumberModel(250.0, 0.0, 5000.0, 1.0));
        this.addDefaultChangeListenerAndAdjustJSpinnerFormatter(this.txtHolzmenge_m3iR);
        this.txtHolzmenge_m3iR.addChangeListener(evt -> this.updateLabelHolzmenge_m3iR());
        panel.add((Component)this.txtHolzmenge_m3iR, c);
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = 0;
        c.anchor = 13;
        c.insets = new Insets(0, 5, 0, 5);
        this.lblHolzmenge_m3oR_readOnly = GuiStrings.getInfoButtonBlue(GuiStrings.getString("Allgemein.lblInfoButtonUmrechnung_iRoR"));
        this.lblHolzmenge_m3oR_readOnly.setHorizontalTextPosition(2);
        panel.add((Component)this.lblHolzmenge_m3oR_readOnly, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.fill = 1;
        c.weightx = 100.0;
        c.insets = new Insets(0, 5, 0, 5);
        JLabel lblArbeitsVerfahren = new JLabel(GuiStrings.getString("HelikopterGesamt.Arbeitsverfahren"));
        panel.add((Component)lblArbeitsVerfahren, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 1;
        c.gridwidth = 2;
        c.fill = 1;
        c.weightx = 100.0;
        c.insets = new Insets(0, 5, 0, 5);
        this.cmbArbeitsVerfahren = new JComboBox();
        panel.add(this.cmbArbeitsVerfahren, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 2;
        c.fill = 1;
        c.weightx = 100.0;
        c.insets = new Insets(0, 5, 0, 5);
        JLabel lblHolztyp = new JLabel(GuiStrings.getString("HelikopterGesamt.Holztyp"));
        panel.add((Component)lblHolztyp, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 2;
        c.gridwidth = 2;
        c.fill = 1;
        c.weightx = 100.0;
        c.insets = new Insets(0, 5, 0, 5);
        this.cmbHolztyp = new JComboBox();
        panel.add((Component)this.cmbHolztyp, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 3;
        c.fill = 1;
        c.weightx = 100.0;
        c.insets = new Insets(0, 5, 0, 5);
        this.lblBaumartenGruppe = new JLabel(GuiStrings.getString("HelikopterGesamt.Baumartengruppe"));
        panel.add((Component)this.lblBaumartenGruppe, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 3;
        c.gridwidth = 2;
        c.fill = 1;
        c.weightx = 100.0;
        c.insets = new Insets(0, 5, 0, 5);
        this.cmbBaumartenGruppe = new JComboBox();
        panel.add(this.cmbBaumartenGruppe, c);
        c = new GridBagConstraints();
        c.gridx = 3;
        c.gridy = 0;
        c.fill = 2;
        c.weightx = 25.0;
        JPanel placeholder1 = new JPanel();
        panel.add((Component)placeholder1, c);
        c = new GridBagConstraints();
        c.gridx = 4;
        c.gridy = 0;
        c.fill = 1;
        c.weightx = 100.0;
        c.insets = new Insets(5, 5, 0, 5);
        JLabel lblHorizontaldistanz = new JLabel(GuiStrings.getString("HelikopterGesamt.Horizontaldistanz_m"));
        panel.add((Component)lblHorizontaldistanz, c);
        c = new GridBagConstraints();
        c.gridx = 5;
        c.gridy = 0;
        c.fill = 1;
        c.weightx = 100.0;
        c.insets = new Insets(5, 5, 0, 5);
        this.txtHorizontalDistanz_m = new JSpinner(new SpinnerNumberModel(300, 0, 5000, 1));
        this.addDefaultChangeListenerAndAdjustJSpinnerFormatter(this.txtHorizontalDistanz_m);
        panel.add((Component)this.txtHorizontalDistanz_m, c);
        c = new GridBagConstraints();
        c.gridx = 4;
        c.gridy = 1;
        c.fill = 1;
        c.weightx = 100.0;
        c.insets = new Insets(0, 5, 0, 5);
        JLabel lblVertikaldistanz = new JLabel(GuiStrings.getString("HelikopterGesamt.Vertikaldistanz_m"));
        panel.add((Component)lblVertikaldistanz, c);
        c = new GridBagConstraints();
        c.gridx = 5;
        c.gridy = 1;
        c.fill = 1;
        c.weightx = 100.0;
        c.insets = new Insets(0, 5, 0, 5);
        this.txtVertikalDistanz_m = new JSpinner(new SpinnerNumberModel(100, 0, 5000, 1));
        this.addDefaultChangeListenerAndAdjustJSpinnerFormatter(this.txtVertikalDistanz_m);
        panel.add((Component)this.txtVertikalDistanz_m, c);
        c = new GridBagConstraints();
        c.gridx = 6;
        c.gridy = 1;
        c.anchor = 17;
        c.insets = new Insets(0, 0, 0, 10);
        JLabel lblVertikaldistanz_Info = GuiStrings.getInfoButtonBlue(GuiStrings.getString("HelikopterGesamt.InfoButtonVertikaldistanz"));
        panel.add((Component)lblVertikaldistanz_Info, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 4;
        c.fill = 1;
        c.gridwidth = 7;
        c.weightx = 100.0;
        c.insets = new Insets(30, 10, 0, 10);
        JLabel lblModellInfo = new JLabel(GuiStrings.getString("HelikopterGesamt.ModellInfo"));
        panel.add((Component)lblModellInfo, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 7;
        c.fill = 3;
        c.weighty = 100.0;
        JPanel placeholder2 = new JPanel();
        panel.add((Component)placeholder2, c);
    }

    @Override
    protected void initPanelArbeitssystem(JPanel panel) {
        panel.removeAll();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 2;
        c.weightx = 100.0;
        c.anchor = 11;
        this.panelHelikopter = new HelikopterPanel(this);
        panel.add((Component)this.panelHelikopter, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.fill = 2;
        c.weightx = 100.0;
        this.panelArbeitswegePausen = new ArbeitswegePausenPanel(this);
        panel.add((Component)this.panelArbeitswegePausen, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 0;
        c.gridheight = 2;
        c.fill = 2;
        c.weightx = 100.0;
        this.panelKostensaetze = new KostensaetzePanelHelikopterGesamtForstbetrieb(this);
        panel.add((Component)this.panelKostensaetze, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 2;
        c.fill = 2;
        c.gridwidth = 2;
        c.weightx = 100.0;
        this.panelWeitereAufwaende = new WeitereAufwaendePanel(this);
        panel.add((Component)this.panelWeitereAufwaende, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 2;
        c.fill = 2;
        c.anchor = 11;
        c.weightx = 100.0;
        this.chkKalkulationInklLagerplatzarbeit = new JCheckBox(GuiStrings.getString("HelikopterGesamt.KalkulationInklLagerplatzarbeit"));
        this.addDefaultItemListener(this.chkKalkulationInklLagerplatzarbeit);
        this.chkKalkulationInklLagerplatzarbeit.setSelected(true);
        panel.add((Component)this.chkKalkulationInklLagerplatzarbeit, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 3;
        c.fill = 1;
        c.weightx = 100.0;
        c.weighty = 100.0;
        panel.add((Component)new JPanel(), c);
    }

    @Override
    protected AbstractErgebnisPanel initErgebnisPanel() {
        return new ErgebnisPanelHelikopterGesamt();
    }

    @Override
    protected void initData() {
        Enum[] enumArray = ArbeitsobjektHelikopterAufarbeiten.ArbeitsVerfahren.values();
        int n = enumArray.length;
        int n2 = 0;
        while (n2 < n) {
            ArbeitsobjektHelikopterAufarbeiten.ArbeitsVerfahren arbeitsVerfahren = enumArray[n2];
            this.cmbArbeitsVerfahren.addItem(arbeitsVerfahren);
            ++n2;
        }
        this.addDefaultActionListener(this.cmbArbeitsVerfahren);
        this.cmbArbeitsVerfahren.setSelectedItem((Object)ArbeitsobjektHelikopterAufarbeiten.ArbeitsVerfahren.Sortimentsverfahren);
        enumArray = ArbeitsobjektHelikopterFliegen.Holztyp.values();
        n = enumArray.length;
        n2 = 0;
        while (n2 < n) {
            Enum holztyp = enumArray[n2];
            this.cmbHolztyp.addItem(holztyp);
            ++n2;
        }
        this.addDefaultActionListener(this.cmbHolztyp);
        this.cmbHolztyp.setSelectedItem((Object)ArbeitsobjektHelikopterFliegen.Holztyp.Nadelholz_frisch);
        this.cmbBaumartenGruppe.addItem(ArbeitsobjektHelikopterAufarbeiten.BaumartenGruppe.Fichte);
        this.cmbBaumartenGruppe.addItem(ArbeitsobjektHelikopterAufarbeiten.BaumartenGruppe.Tanne);
        this.cmbBaumartenGruppe.addItem(ArbeitsobjektHelikopterAufarbeiten.BaumartenGruppe.Foehre_Laerche);
        this.addDefaultActionListener(this.cmbBaumartenGruppe);
        this.cmbBaumartenGruppe.setSelectedItem((Object)ArbeitsobjektHelikopterAufarbeiten.BaumartenGruppe.Fichte);
        this.checkShowComboBaumartengruppe();
        this.adaptItemsInComboBaumartengruppe();
        this.adaptLastvolumen();
    }

    private void updateLabelHolzmenge_m3iR() {
        DecimalFormat df = new DecimalFormat(",###.##");
        double value = (Double)this.txtHolzmenge_m3iR.getValue();
        this.lblHolzmenge_m3oR_readOnly.setText("<html><nobr>(" + df.format(value *= this.getModel().getArbeitsobjekt().getRindenAbzugFaktor()) + " m<sup>3</sup> " + GuiStrings.getString("Allgemein.oR") + ")</nobr></html>");
    }

    @Override
    public void loadGUIToModel() {
        super.loadGUIToModel();
        this.updateLabelHolzmenge_m3iR();
        this.model.getArbeitsobjekt().setHolzmenge_m3((Double)this.txtHolzmenge_m3iR.getValue());
        this.model.getArbeitsobjekt().setHolztyp((ArbeitsobjektHelikopterFliegen.Holztyp)((Object)this.cmbHolztyp.getSelectedItem()));
        this.model.getArbeitsobjekt().setArbeitsVerfahren((ArbeitsobjektHelikopterAufarbeiten.ArbeitsVerfahren)((Object)this.cmbArbeitsVerfahren.getSelectedItem()));
        this.model.getArbeitsobjekt().setHorizontalDistanz_m((Integer)this.txtHorizontalDistanz_m.getValue());
        this.model.getArbeitsobjekt().setVertikalDistanz_m((Integer)this.txtVertikalDistanz_m.getValue());
        this.model.getArbeitsobjekt().setBaumartenGruppe((ArbeitsobjektHelikopterAufarbeiten.BaumartenGruppe)((Object)this.cmbBaumartenGruppe.getSelectedItem()));
        this.model.getArbeitssystem().setHelikopterKosten_proMin(this.panelHelikopter.getHelikopterKosten_proMin());
        this.model.getArbeitssystem().setAnflugPauschale(this.panelHelikopter.getAnflugpauschale());
        this.model.getArbeitssystem().setHelikopterKlasse(this.panelHelikopter.getHelikopterKlasse());
        this.model.getArbeitssystem().setLastVolumen(this.panelHelikopter.getLastvolumen_m3());
        this.model.getArbeitssystem().setLastVolumenAutomatischBerechnen(this.panelHelikopter.isLastvolumenAutomatischBerechnen());
        this.model.getArbeitssystem().setAnzahlPersonalBeimHolzFliegen(this.panelKostensaetze.getAnzahlPersonalFliegen());
        this.model.getArbeitssystem().setAnzahlPersonalNachHolzFliegen(this.panelKostensaetze.getAnzahlPersonalLagerplatz());
        this.model.getArbeitssystem().setKostensatzPersonal1_proH(this.panelKostensaetze.getAnsatzPersonal());
        this.model.getArbeitssystem().setAnzahlMotorsaegen(this.panelKostensaetze.getAnzahlMotorsaegen());
        this.model.getArbeitssystem().setKostensatzMaschine1_proH(this.panelKostensaetze.getAnsatzMotorsaegen());
        this.model.getArbeitssystem().setAnzahlKranfahrzeuge(this.panelKostensaetze.getAnzahlKranfahrzeuge());
        this.model.getArbeitssystem().setKostensatzMaschine2_proH(this.panelKostensaetze.getAnsatzKranfahrzeuge());
        this.model.getArbeitssystem().setTaeglicheArbeitszeit_Min(this.panelArbeitswegePausen.getArbeitszeit_min());
        this.model.getArbeitssystem().setWegzeitenUndPausen_Min(this.panelArbeitswegePausen.getWegzeitenUndPausen_min());
        this.model.getArbeitssystem().setUmsetzenBetrag_CHF(this.panelWeitereAufwaende.getUmsetzenBetrag_CHF());
        this.model.getArbeitssystem().setUmsetzenZeit_h(this.panelWeitereAufwaende.getUmsetzenZeit_h());
        this.model.getArbeitssystem().setWeitereAufwaendeBetrag_CHF(this.panelWeitereAufwaende.getWeitereAufwaendeBetrag_CHF());
        this.model.getArbeitssystem().setWeitereAufwaendeZeit_h(this.panelWeitereAufwaende.getWeitereAufwaendeZeit_h());
        this.model.getArbeitssystem().setKalkulationInklLagerplatzarbeit(this.chkKalkulationInklLagerplatzarbeit.isSelected());
    }

    @Override
    public ModelHelikopterGesamt getModel() {
        return this.model;
    }

    @Override
    public void loadModelToGUI(HeProMoInputData data) {
        super.setReactOnInputChange(false);
        this.txtHolzmenge_m3iR.setValue(((ArbeitsobjektHelikopterGesamt)data.getArbeitsobjekt()).getHolzmenge_m3());
        this.updateLabelHolzmenge_m3iR();
        this.cmbHolztyp.setSelectedItem((Object)((ArbeitsobjektHelikopterGesamt)data.getArbeitsobjekt()).getHolztyp());
        this.txtHorizontalDistanz_m.setValue(((ArbeitsobjektHelikopterGesamt)data.getArbeitsobjekt()).getHorizontalDistanz_m());
        this.txtVertikalDistanz_m.setValue(((ArbeitsobjektHelikopterGesamt)data.getArbeitsobjekt()).getVertikalDistanz_m());
        this.cmbBaumartenGruppe.setSelectedItem((Object)((ArbeitsobjektHelikopterGesamt)data.getArbeitsobjekt()).getBaumartenGruppe());
        this.cmbArbeitsVerfahren.setSelectedItem((Object)((ArbeitsobjektHelikopterGesamt)data.getArbeitsobjekt()).getArbeitsVerfahren());
        this.panelHelikopter.setHelikopterKosten_proMin((int)((ArbeitssystemHelikopterGesamt)data.getArbeitssystem()).getHelikopterKosten_proMin());
        this.panelHelikopter.setAnflugpauschale((int)((ArbeitssystemHelikopterGesamt)data.getArbeitssystem()).getAnflugPauschale());
        this.panelHelikopter.setHelikopterKlasse(((ArbeitssystemHelikopterGesamt)data.getArbeitssystem()).getHelikopterKlasse());
        this.panelHelikopter.setLastvolumen_m3(((ArbeitssystemHelikopterGesamt)data.getArbeitssystem()).getLastVolumen());
        this.panelHelikopter.setLastvolumenAutomatischBerechnen(((ArbeitssystemHelikopterGesamt)data.getArbeitssystem()).isLastVolumenAutomatischBerechnen());
        this.adaptLastvolumen();
        this.panelKostensaetze.setAnzahlPersonalFliegen(((ArbeitssystemHelikopterGesamt)data.getArbeitssystem()).getAnzahlPersonalBeimHolzFliegen());
        this.panelKostensaetze.setAnzahlPersonalLagerplatz(((ArbeitssystemHelikopterGesamt)data.getArbeitssystem()).getAnzahlPersonalNachHolzFliegen());
        this.panelKostensaetze.setAnsatzPersonal(((ArbeitssystemHelikopterGesamt)data.getArbeitssystem()).getKostensatzPersonal1_proH());
        this.panelKostensaetze.setAnzahlMotorsaegen(((ArbeitssystemHelikopterGesamt)data.getArbeitssystem()).getAnzahlMotorsaegen());
        this.panelKostensaetze.setAnsatzMotorsaegen(((ArbeitssystemHelikopterGesamt)data.getArbeitssystem()).getKostensatzMaschine1_proH());
        this.panelKostensaetze.setAnzahlKranfahrzeuge(((ArbeitssystemHelikopterGesamt)data.getArbeitssystem()).getAnzahlKranfahrzeuge());
        this.panelKostensaetze.setAnsatzKranfahrzeuge(((ArbeitssystemHelikopterGesamt)data.getArbeitssystem()).getKostensatzMaschine2_proH());
        this.panelArbeitswegePausen.setArbeitszeit_min(((ArbeitssystemHelikopterGesamt)data.getArbeitssystem()).getTaeglicheArbeitszeit_Min());
        this.panelArbeitswegePausen.setWegzeitenUndPausen_min(((ArbeitssystemHelikopterGesamt)data.getArbeitssystem()).getWegzeitenUndPausen_Min());
        this.panelWeitereAufwaende.setUmsetzenBetrag_CHF(((ArbeitssystemHelikopterGesamt)data.getArbeitssystem()).getUmsetzenBetrag_CHF());
        this.panelWeitereAufwaende.setUmsetzenZeit_h(((ArbeitssystemHelikopterGesamt)data.getArbeitssystem()).getUmsetzenZeit_h());
        this.panelWeitereAufwaende.setWeitereAufwaendeBetrag_CHF(((ArbeitssystemHelikopterGesamt)data.getArbeitssystem()).getWeitereAufwaendeBetrag_CHF());
        this.panelWeitereAufwaende.setWeitereAufwaendeZeit_h(((ArbeitssystemHelikopterGesamt)data.getArbeitssystem()).getWeitereAufwaendeZeit_h());
        this.chkKalkulationInklLagerplatzarbeit.setSelected(((ArbeitssystemHelikopterGesamt)data.getArbeitssystem()).isKalkulationInklLagerplatzarbeit());
        this.loadFaktoren(data);
        super.setReactOnInputChange(true);
    }

    @Override
    protected void onInputChangedBeforeCalculation(Object eventSource) {
        if (this.cmbArbeitsVerfahren.equals(eventSource)) {
            if (this.cmbArbeitsVerfahren.getSelectedItem() == ArbeitsobjektHelikopterAufarbeiten.ArbeitsVerfahren.Sortimentsverfahren) {
                this.panelKostensaetze.setAnzahlPersonalLagerplatz(2);
                this.panelKostensaetze.setAnzahlMotorsaegen(1);
                this.panelKostensaetze.setAnzahlKranfahrzeuge(1);
            } else {
                this.panelKostensaetze.setAnzahlPersonalLagerplatz(3);
                this.panelKostensaetze.setAnzahlMotorsaegen(2);
                this.panelKostensaetze.setAnzahlKranfahrzeuge(1);
            }
            this.checkShowComboBaumartengruppe();
            this.adaptItemsInComboBaumartengruppe();
            this.adaptLastvolumen();
        } else if (this.cmbHolztyp.equals(eventSource)) {
            this.checkShowComboBaumartengruppe();
            this.adaptItemsInComboBaumartengruppe();
            this.adaptLastvolumen();
        }
        this.panelHelikopter.onInputChangedBeforeCalculation(eventSource);
    }

    private void checkShowComboBaumartengruppe() {
        if (this.cmbArbeitsVerfahren.getSelectedItem() == ArbeitsobjektHelikopterAufarbeiten.ArbeitsVerfahren.Vollbaumverfahren && (this.cmbHolztyp.getSelectedItem() == ArbeitsobjektHelikopterFliegen.Holztyp.Nadelholz_frisch || this.cmbHolztyp.getSelectedItem() == ArbeitsobjektHelikopterFliegen.Holztyp.Nadelholz_angetrocknet)) {
            this.lblBaumartenGruppe.setVisible(true);
            this.cmbBaumartenGruppe.setVisible(true);
            return;
        }
        this.lblBaumartenGruppe.setVisible(false);
        this.cmbBaumartenGruppe.setVisible(false);
    }

    private void adaptItemsInComboBaumartengruppe() {
        if (this.cmbHolztyp.getSelectedItem() == ArbeitsobjektHelikopterFliegen.Holztyp.Laubholz_angetrocknet || this.cmbHolztyp.getSelectedItem() == ArbeitsobjektHelikopterFliegen.Holztyp.Laubholz_frisch) {
            this.cmbBaumartenGruppe.removeAllItems();
            this.cmbBaumartenGruppe.addItem(ArbeitsobjektHelikopterAufarbeiten.BaumartenGruppe.Laubholz);
            this.cmbBaumartenGruppe.setSelectedItem((Object)ArbeitsobjektHelikopterAufarbeiten.BaumartenGruppe.Laubholz);
        } else {
            this.cmbBaumartenGruppe.removeAllItems();
            this.cmbBaumartenGruppe.addItem(ArbeitsobjektHelikopterAufarbeiten.BaumartenGruppe.Fichte);
            this.cmbBaumartenGruppe.addItem(ArbeitsobjektHelikopterAufarbeiten.BaumartenGruppe.Tanne);
            this.cmbBaumartenGruppe.addItem(ArbeitsobjektHelikopterAufarbeiten.BaumartenGruppe.Foehre_Laerche);
            this.cmbBaumartenGruppe.setSelectedItem((Object)ArbeitsobjektHelikopterAufarbeiten.BaumartenGruppe.Fichte);
        }
    }

    @Override
    protected void updateWaehrungskuerzel(String newValue) {
        super.updateWaehrungskuerzel(newValue);
        this.panelKostensaetze.updateWaehrungskuerzel(newValue);
    }
}

