/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.hepromo.gui.modelle;

import ch.wsl.fps.hepromo.gui.AbstractErgebnisPanel;
import ch.wsl.fps.hepromo.gui.DocumentationBroker;
import ch.wsl.fps.hepromo.gui.ErgebnisPanel;
import ch.wsl.fps.hepromo.gui.GuiStrings;
import ch.wsl.fps.hepromo.gui.HeProMoExceptionHandler;
import ch.wsl.fps.hepromo.gui.HeProMoWindow;
import ch.wsl.fps.hepromo.gui.MainWindow;
import ch.wsl.fps.hepromo.gui.TitledBorderFactory;
import ch.wsl.fps.hepromo.gui.modelle.Forwarder2018;
import ch.wsl.fps.hepromo.model.calc.BiomasseCalculatorAnteilEnergieholz2018;
import ch.wsl.fps.hepromo.model.calc.BiomasseCalculatorKompartimente2018;
import ch.wsl.fps.hepromo.model.calc.BiomasseCalculatorSchaftholztarif2018;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Locale;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ChangeListener;

public class BiomasseschaetzerEnergie2018
extends JDialog {
    private final double constSchaftholzmengeGesamt_m3iR;
    private JSpinner txtAnteilLaubholz;
    private JSpinner txtBhd_cm;
    private JLabel lblBhd_cm_Info;
    private JComboBox<BiomasseCalculatorKompartimente2018.Standort> cmbStandort;
    private JComboBox<BiomasseCalculatorSchaftholztarif2018.Gesamtwuchsleistung> cmbGesamtwuchsleistung;
    private JLabel lblAnzahlStaemme;
    private JSpinner txtAnzahlStaemme;
    private JLabel lblZopf_cm;
    private JComboBox<BiomasseCalculatorAnteilEnergieholz2018.Zopfklasse> cmbZopf_cm;
    private JLabel lblZopf_cm_Info;
    private JLabel lblAnteilVolumenRundholz;
    private JSpinner txtAnteilVolumenRundholz;
    private JLabel lblAnteilVolumenRundholz_Info;
    private JLabel lblAnteilVolumenAstderbholz;
    private JSpinner txtAnteilVolumenAstderbholz;
    private JLabel lblAnteilVolumenAstderbholz_Info;
    private JLabel lblAnteilVolumenReisig;
    private JSpinner txtAnteilVolumenReisig;
    private JLabel lblAnteilVolumenReisig_Info;
    private JLabel lblErnteverlustDerbholzNadel;
    private JSpinner txtErnteverlustDerbholzNadel;
    private JLabel lblErnteverlustDerbholzNadel_Info;
    private JLabel lblErnteverlustDerbholzLaub;
    private JSpinner txtErnteverlustDerbholzLaub;
    private JLabel lblErnteverlustDerbholzLaub_Info;
    private JLabel lblErnteverlustNichtderbholzNadel;
    private JSpinner txtErnteverlustNichtderbholzNadel;
    private JLabel lblErnteverlustNichtderbholzNadel_Info;
    private JTextField txtVolumenSchaftholz_m3iR;
    private JTextField txtVolumenEnergierundholzUnterhalbZopf;
    private JTextField txtVolumenEnergieholzAmSchaftOberhalbZopf;
    private JTextField txtVolumenAstderbholz;
    private JTextField txtVolumenReisig;
    private JLabel lblVolumenEnergieholz;
    private JTextField txtVolumenEnergieholz;
    private JLabel lblStatus;
    private JButton btnUebernehmen;
    private BiomasseCalculatorKompartimente2018.ErgebnisEnergieholz letztesErgebnis = null;
    private final ChangeListener defaultChangeListner = evt -> this.onInputChanged();
    private final ActionListener defaultActionListener = evt -> {
        Object selectedItem = ((JComboBox)evt.getSource()).getSelectedItem();
        if (selectedItem != null) {
            this.onInputChanged();
        }
    };
    private static final DecimalFormat decimalFormat = new DecimalFormat("0.00");
    private boolean dependentValuesAreBeingSet = false;

    public static void main(String[] args) {
        new BiomasseschaetzerEnergie2018();
    }

    public BiomasseschaetzerEnergie2018() {
        this(-1, -1, null, -1.0);
    }

    public BiomasseschaetzerEnergie2018(int bhd_cm, int zopf_cm, Forwarder2018 parent, double constSchaftholzmengeGesamt_m3iR) {
        this.constSchaftholzmengeGesamt_m3iR = constSchaftholzmengeGesamt_m3iR;
        SwingUtilities.invokeLater(() -> {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e) {
                HeProMoExceptionHandler.handle(e);
            }
            ToolTipManager.sharedInstance().setInitialDelay(0);
            ToolTipManager.sharedInstance().setDismissDelay(Integer.MAX_VALUE);
            this.setTitle(GuiStrings.getString("BiomasseschaetzerEnergie2018.Title"));
            int width = MainWindow.getCurrentLocale().getLanguage().equals("de") ? 1040 : 1220;
            this.setSize((int)((float)width * MainWindow.SIZE * MainWindow.WIDTH_FACTOR), (int)(570.0f * MainWindow.SIZE));
            this.setLocationByPlatform(true);
            this.setDefaultCloseOperation(2);
            this.setModal(false);
            this.setIconImage(MainWindow.getWslLogo().getImage());
            this.initContent();
            this.initData();
            if (bhd_cm > 0) {
                this.setBhd_cm(bhd_cm);
            }
            if (zopf_cm > 0) {
                this.setZopf_cm(zopf_cm);
            }
            if (constSchaftholzmengeGesamt_m3iR > 0.0) {
                this.txtAnzahlStaemme.setEnabled(false);
                this.lblAnzahlStaemme.setVisible(false);
                this.txtAnzahlStaemme.setVisible(false);
                Dimension size = this.getSize();
                size.height -= 20;
                this.setSize(size);
            }
            if (parent != null) {
                this.setModal(true);
                this.btnUebernehmen.addActionListener(evt -> {
                    parent.setZopf_cm(((BiomasseCalculatorAnteilEnergieholz2018.Zopfklasse)((Object)((Object)((Object)this.cmbZopf_cm.getSelectedItem())))).getValue());
                    parent.setEnergieholzErgebnis(this.letztesErgebnis);
                    this.setVisible(false);
                });
            } else {
                this.lblStatus.setHorizontalAlignment(0);
                this.btnUebernehmen.setVisible(false);
            }
            this.setVisible(true);
        });
    }

    private void initContent() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 3;
        c.fill = 2;
        c.weightx = 20.0;
        c.insets = new Insets(10, 10, 5, 10);
        JPanel pnlInput = new JPanel();
        this.initPanelInput(pnlInput);
        this.add((Component)pnlInput, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 3;
        c.fill = 2;
        c.weightx = 20.0;
        c.insets = new Insets(5, 10, 5, 10);
        JPanel pnlOutput = new JPanel();
        this.initPanelOutput(pnlOutput);
        this.add((Component)pnlOutput, c);
        c = new GridBagConstraints();
        c.gridx = 3;
        c.gridy = 0;
        c.gridheight = 4;
        ImageIcon imageIconSkizzeBaumteile = BiomasseschaetzerEnergie2018.getImageIcon(BiomasseschaetzerEnergie2018.getSkizzeBaumteilePath());
        Image imageSkizzeBaumteile = imageIconSkizzeBaumteile.getImage().getScaledInstance(-1, 410, 4);
        JLabel lblSkizzeBaumteile = new JLabel(new ImageIcon(imageSkizzeBaumteile));
        this.add((Component)lblSkizzeBaumteile, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 2;
        c.insets = new Insets(0, 10, 0, 0);
        JButton btnDokumentation = new JButton(GuiStrings.getString("HeProMoWindow.btnGrundlagen"));
        btnDokumentation.addActionListener(evt -> DocumentationBroker.showDocumentation(DocumentationBroker.Documentation.Energieholzschaetzer2018, (Component)this, btnDokumentation));
        this.add((Component)btnDokumentation, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 2;
        c.fill = 2;
        c.weightx = 100.0;
        c.insets = new Insets(0, 0, 0, 30);
        this.lblStatus = new JLabel(" ", 4);
        this.add((Component)this.lblStatus, c);
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = 2;
        c.insets = new Insets(0, 0, 0, 40);
        this.btnUebernehmen = new JButton(GuiStrings.getString("BiomasseschaetzerEnergie2018.EnergieholzvolumenUebernehmen"));
        this.add((Component)this.btnUebernehmen, c);
    }

    private static String getSkizzeBaumteilePath() {
        Locale locale = MainWindow.getCurrentLocale();
        String langCode = locale.getLanguage().toUpperCase();
        return "data/SkizzeBaumteile_" + langCode + ".png";
    }

    private static ImageIcon getImageIcon(String filePath) {
        URL imgURL = MainWindow.class.getClassLoader().getResource(filePath);
        if (imgURL != null) {
            return new ImageIcon(imgURL);
        }
        return new ImageIcon(filePath);
    }

    private void initPanelInput(JPanel pnlInput) {
        pnlInput.setBorder(TitledBorderFactory.createTitledBorderBold(GuiStrings.getString("BiomasseschaetzerEnergie2018.Eingaben")));
        pnlInput.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 2;
        c.weightx = 20.0;
        JLabel lblAnteilLaubholz = new JLabel(GuiStrings.getString("BiomasseschaetzerEnergie2018.AnteilLaubholz"));
        pnlInput.add((Component)lblAnteilLaubholz, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 0;
        c.fill = 2;
        c.weightx = 100.0;
        this.txtAnteilLaubholz = new JSpinner();
        pnlInput.add((Component)this.txtAnteilLaubholz, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.fill = 2;
        c.weightx = 20.0;
        JLabel lblBhd = new JLabel(GuiStrings.getString("BiomasseschaetzerEnergie2018.MittlererBhd_cm"));
        pnlInput.add((Component)lblBhd, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 1;
        c.fill = 2;
        c.weightx = 100.0;
        this.txtBhd_cm = new JSpinner();
        pnlInput.add((Component)this.txtBhd_cm, c);
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = 1;
        c.fill = 2;
        c.weightx = 20.0;
        c.insets = new Insets(0, 5, 0, 5);
        this.lblBhd_cm_Info = GuiStrings.getInfoButtonBlue(GuiStrings.getString("BiomasseschaetzerEnergie2018.InfoButton_MittlererBhd"));
        pnlInput.add((Component)this.lblBhd_cm_Info, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 2;
        c.fill = 2;
        c.weightx = 20.0;
        JLabel lblStandort = new JLabel(GuiStrings.getString("BiomasseschaetzerEnergie2018.Standort"));
        pnlInput.add((Component)lblStandort, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 2;
        c.fill = 2;
        c.weightx = 100.0;
        this.cmbStandort = new JComboBox();
        this.cmbStandort.setMaximumRowCount(10);
        pnlInput.add(this.cmbStandort, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 3;
        c.fill = 2;
        c.weightx = 20.0;
        c.insets = new Insets(0, 0, 0, 10);
        JLabel lblGesamtwuchsleistung = new JLabel(GuiStrings.getString("BiomasseschaetzerAbTarif2018.Gesamtwuchsleistung"));
        pnlInput.add((Component)lblGesamtwuchsleistung, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 3;
        c.fill = 2;
        c.weightx = 100.0;
        this.cmbGesamtwuchsleistung = new JComboBox();
        pnlInput.add(this.cmbGesamtwuchsleistung, c);
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = 3;
        c.fill = 2;
        c.insets = new Insets(0, 5, 0, 5);
        JLabel lblInfoButton3 = GuiStrings.getInfoButtonBlue(GuiStrings.getString("BiomasseschaetzerAbTarif2018.GesamtwuchsleistungInfoButton"));
        pnlInput.add((Component)lblInfoButton3, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 4;
        c.fill = 2;
        c.weightx = 20.0;
        this.lblAnzahlStaemme = new JLabel(GuiStrings.getString("BiomasseschaetzerEnergie2018.AnzahlStaemme"));
        pnlInput.add((Component)this.lblAnzahlStaemme, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 4;
        c.fill = 2;
        c.weightx = 100.0;
        this.txtAnzahlStaemme = new JSpinner();
        pnlInput.add((Component)this.txtAnzahlStaemme, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 5;
        c.fill = 2;
        c.weightx = 20.0;
        this.lblZopf_cm = new JLabel(GuiStrings.getString("BiomasseschaetzerEnergie2018.Zopfdurchmesser"));
        pnlInput.add((Component)this.lblZopf_cm, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 5;
        c.fill = 2;
        c.weightx = 100.0;
        this.cmbZopf_cm = new JComboBox();
        pnlInput.add(this.cmbZopf_cm, c);
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = 5;
        c.fill = 2;
        c.weightx = 20.0;
        c.insets = new Insets(0, 5, 0, 5);
        this.lblZopf_cm_Info = GuiStrings.getInfoButtonBlue(GuiStrings.getString("BiomasseschaetzerEnergie2018.InfoButtonZopfdurchmesser"));
        pnlInput.add((Component)this.lblZopf_cm_Info, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 6;
        c.fill = 2;
        c.weightx = 20.0;
        this.lblAnteilVolumenRundholz = new JLabel(GuiStrings.getString("BiomasseschaetzerEnergie2018.VolumenanteilRundholz"));
        pnlInput.add((Component)this.lblAnteilVolumenRundholz, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 6;
        c.fill = 2;
        c.weightx = 100.0;
        this.txtAnteilVolumenRundholz = new JSpinner();
        pnlInput.add((Component)this.txtAnteilVolumenRundholz, c);
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = 6;
        c.fill = 2;
        c.weightx = 20.0;
        c.insets = new Insets(0, 5, 0, 5);
        this.lblAnteilVolumenRundholz_Info = GuiStrings.getInfoButtonBlue(GuiStrings.getString("BiomasseschaetzerEnergie2018.InfoButtonRundholz"));
        pnlInput.add((Component)this.lblAnteilVolumenRundholz_Info, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 7;
        c.fill = 2;
        c.weightx = 20.0;
        c.insets = new Insets(8, 0, 2, 0);
        JLabel lblNadelholz = new JLabel(GuiStrings.getString("BiomasseschaetzerEnergie2018.TitleNadelholz"));
        pnlInput.add((Component)lblNadelholz, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 8;
        c.fill = 2;
        c.weightx = 20.0;
        c.insets = new Insets(0, 5, 0, 0);
        this.lblAnteilVolumenReisig = new JLabel(GuiStrings.getString("BiomasseschaetzerEnergie2018.VolumenanteilReisig"));
        pnlInput.add((Component)this.lblAnteilVolumenReisig, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 8;
        c.fill = 2;
        c.weightx = 100.0;
        this.txtAnteilVolumenReisig = new JSpinner();
        pnlInput.add((Component)this.txtAnteilVolumenReisig, c);
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = 8;
        c.fill = 2;
        c.weightx = 20.0;
        c.insets = new Insets(0, 5, 0, 5);
        this.lblAnteilVolumenReisig_Info = GuiStrings.getInfoButtonBlue(GuiStrings.getString("BiomasseschaetzerEnergie2018.InfoButtonReisig"));
        pnlInput.add((Component)this.lblAnteilVolumenReisig_Info, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 9;
        c.fill = 2;
        c.weightx = 20.0;
        c.insets = new Insets(0, 5, 0, 0);
        this.lblErnteverlustDerbholzNadel = new JLabel(GuiStrings.getString("BiomasseschaetzerEnergie2018.ErnteverlustNadelderbholz"));
        pnlInput.add((Component)this.lblErnteverlustDerbholzNadel, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 9;
        c.fill = 2;
        c.weightx = 100.0;
        this.txtErnteverlustDerbholzNadel = new JSpinner();
        pnlInput.add((Component)this.txtErnteverlustDerbholzNadel, c);
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = 9;
        c.fill = 2;
        c.weightx = 20.0;
        c.insets = new Insets(0, 5, 0, 5);
        this.lblErnteverlustDerbholzNadel_Info = GuiStrings.getInfoButtonBlue(GuiStrings.getString("BiomasseschaetzerEnergie2018.InfoButtonDerbholz"));
        pnlInput.add((Component)this.lblErnteverlustDerbholzNadel_Info, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 10;
        c.fill = 2;
        c.weightx = 20.0;
        c.insets = new Insets(0, 5, 0, 5);
        this.lblErnteverlustNichtderbholzNadel = new JLabel(GuiStrings.getString("BiomasseschaetzerEnergie2018.ErnteverlustNadelNichtDerbholz"));
        pnlInput.add((Component)this.lblErnteverlustNichtderbholzNadel, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 10;
        c.fill = 2;
        c.weightx = 100.0;
        this.txtErnteverlustNichtderbholzNadel = new JSpinner();
        pnlInput.add((Component)this.txtErnteverlustNichtderbholzNadel, c);
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = 10;
        c.fill = 2;
        c.weightx = 20.0;
        c.insets = new Insets(0, 5, 0, 5);
        this.lblErnteverlustNichtderbholzNadel_Info = GuiStrings.getInfoButtonBlue(GuiStrings.getString("BiomasseschaetzerEnergie2018.InfoButtonNichtDerbholz"));
        pnlInput.add((Component)this.lblErnteverlustNichtderbholzNadel_Info, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 11;
        c.fill = 2;
        c.weightx = 20.0;
        c.insets = new Insets(8, 0, 2, 0);
        JLabel lblLaubhholz = new JLabel(GuiStrings.getString("BiomasseschaetzerEnergie2018.TitleLaubholz"));
        pnlInput.add((Component)lblLaubhholz, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 12;
        c.fill = 2;
        c.weightx = 20.0;
        c.insets = new Insets(0, 5, 0, 5);
        this.lblAnteilVolumenAstderbholz = new JLabel(GuiStrings.getString("BiomasseschaetzerEnergie2018.VolumenanteilAstderbholz"));
        pnlInput.add((Component)this.lblAnteilVolumenAstderbholz, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 12;
        c.fill = 2;
        c.weightx = 100.0;
        this.txtAnteilVolumenAstderbholz = new JSpinner();
        pnlInput.add((Component)this.txtAnteilVolumenAstderbholz, c);
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = 12;
        c.fill = 2;
        c.weightx = 20.0;
        c.insets = new Insets(0, 5, 0, 5);
        this.lblAnteilVolumenAstderbholz_Info = GuiStrings.getInfoButtonBlue(GuiStrings.getString("BiomasseschaetzerEnergie2018.InfoButtonAstderbholz"));
        pnlInput.add((Component)this.lblAnteilVolumenAstderbholz_Info, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 13;
        c.fill = 2;
        c.weightx = 20.0;
        c.insets = new Insets(0, 5, 0, 0);
        this.lblErnteverlustDerbholzLaub = new JLabel(GuiStrings.getString("BiomasseschaetzerEnergie2018.ErnteverlustLaubderbholz"));
        pnlInput.add((Component)this.lblErnteverlustDerbholzLaub, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 13;
        c.fill = 2;
        c.weightx = 100.0;
        this.txtErnteverlustDerbholzLaub = new JSpinner();
        pnlInput.add((Component)this.txtErnteverlustDerbholzLaub, c);
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = 13;
        c.fill = 2;
        c.weightx = 20.0;
        c.insets = new Insets(0, 5, 0, 5);
        this.lblErnteverlustDerbholzLaub_Info = GuiStrings.getInfoButtonBlue(GuiStrings.getString("BiomasseschaetzerEnergie2018.InfoButtonDerbholz"));
        pnlInput.add((Component)this.lblErnteverlustDerbholzLaub_Info, c);
    }

    private void initPanelOutput(JPanel pnlOutput) {
        pnlOutput.setBorder(TitledBorderFactory.createTitledBorderBold(GuiStrings.getString("BiomasseschaetzerEnergie2018.Ergebnis")));
        pnlOutput.setBackground(ErgebnisPanel.ERGEBNIS_PANEL_BACKGROUND_COLOR);
        pnlOutput.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 2;
        c.insets = new Insets(0, 0, 0, 5);
        JLabel lblSchaftholzvolumen = new JLabel(GuiStrings.getString("BiomasseschaetzerEnergie2018.VolumenSchaftholzMittlererBaum_m3iR"));
        pnlOutput.add((Component)lblSchaftholzvolumen, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 0;
        c.fill = 2;
        c.weightx = 100.0;
        this.txtVolumenSchaftholz_m3iR = AbstractErgebnisPanel.getNewLockedTextField();
        pnlOutput.add((Component)this.txtVolumenSchaftholz_m3iR, c);
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = 0;
        c.fill = 2;
        c.insets = new Insets(0, 5, 0, 5);
        JLabel lblVolumenSchaftholz_m3iR = GuiStrings.getInfoButtonBlue(GuiStrings.getString("BiomasseschaetzerEnergie2018.VolumenSchaftholz_m3iR"));
        pnlOutput.add((Component)lblVolumenSchaftholz_m3iR, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.fill = 2;
        c.weightx = 20.0;
        JLabel lblVolumenEnergierundholzUnterhalbZopf = new JLabel(GuiStrings.getString("BiomasseschaetzerEnergie2018.VolumenEnergierundholz"));
        pnlOutput.add((Component)lblVolumenEnergierundholzUnterhalbZopf, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 1;
        c.fill = 2;
        c.weightx = 100.0;
        this.txtVolumenEnergierundholzUnterhalbZopf = AbstractErgebnisPanel.getNewLockedTextField();
        pnlOutput.add((Component)this.txtVolumenEnergierundholzUnterhalbZopf, c);
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = 1;
        c.fill = 2;
        c.insets = new Insets(0, 5, 0, 5);
        JLabel lblVolumenEnergieholzAmRundholzUnterhalbZopf_Info = GuiStrings.getInfoButtonBlue(GuiStrings.getString("BiomasseschaetzerEnergie2018.InfoButtonEnergierundholz"));
        pnlOutput.add((Component)lblVolumenEnergieholzAmRundholzUnterhalbZopf_Info, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 2;
        c.fill = 2;
        c.weightx = 20.0;
        JLabel lblVolumenEnergieholzAmSchaftOberhalbZopf = new JLabel(GuiStrings.getString("BiomasseschaetzerEnergie2018.VolumenEnergieholzAmSchaft"));
        pnlOutput.add((Component)lblVolumenEnergieholzAmSchaftOberhalbZopf, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 2;
        c.fill = 2;
        c.weightx = 100.0;
        this.txtVolumenEnergieholzAmSchaftOberhalbZopf = AbstractErgebnisPanel.getNewLockedTextField();
        pnlOutput.add((Component)this.txtVolumenEnergieholzAmSchaftOberhalbZopf, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 3;
        c.fill = 2;
        c.weightx = 20.0;
        JLabel lblVolumenAstderbholz = new JLabel(GuiStrings.getString("BiomasseschaetzerEnergie2018.VolumenAstderbholz"));
        pnlOutput.add((Component)lblVolumenAstderbholz, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 3;
        c.fill = 2;
        c.weightx = 100.0;
        this.txtVolumenAstderbholz = AbstractErgebnisPanel.getNewLockedTextField();
        pnlOutput.add((Component)this.txtVolumenAstderbholz, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 4;
        c.fill = 2;
        c.weightx = 20.0;
        JLabel lblVolumenReisig = new JLabel(GuiStrings.getString("BiomasseschaetzerEnergie2018.VolumenReisig"));
        pnlOutput.add((Component)lblVolumenReisig, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 4;
        c.fill = 2;
        c.weightx = 100.0;
        this.txtVolumenReisig = AbstractErgebnisPanel.getNewLockedTextField();
        pnlOutput.add((Component)this.txtVolumenReisig, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 5;
        c.fill = 2;
        c.weightx = 20.0;
        this.lblVolumenEnergieholz = new JLabel(GuiStrings.getString("BiomasseschaetzerEnergie2018.VolumenEnergieholz"));
        pnlOutput.add((Component)this.lblVolumenEnergieholz, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 5;
        c.fill = 2;
        c.weightx = 100.0;
        this.txtVolumenEnergieholz = AbstractErgebnisPanel.getNewLockedTextField();
        pnlOutput.add((Component)this.txtVolumenEnergieholz, c);
    }

    private void initData() {
        Enum value;
        this.txtAnteilLaubholz.setModel(new SpinnerNumberModel(0, 0, 100, 1));
        this.addListener(this.txtAnteilLaubholz);
        this.txtAnteilLaubholz.addChangeListener(evt -> this.setDefaultValuesBasedOnAnteilLaubholz());
        Enum[] enumArray = BiomasseCalculatorKompartimente2018.Standort.getAllNadelLaubGemischt();
        int n = enumArray.length;
        int n2 = 0;
        while (n2 < n) {
            value = enumArray[n2];
            this.cmbStandort.addItem((BiomasseCalculatorKompartimente2018.Standort)value);
            ++n2;
        }
        this.addListener(this.cmbStandort);
        enumArray = BiomasseCalculatorAnteilEnergieholz2018.Zopfklasse.values();
        n = enumArray.length;
        n2 = 0;
        while (n2 < n) {
            value = enumArray[n2];
            this.cmbZopf_cm.addItem((BiomasseCalculatorAnteilEnergieholz2018.Zopfklasse)value);
            ++n2;
        }
        this.cmbZopf_cm.setSelectedItem((Object)BiomasseCalculatorAnteilEnergieholz2018.Zopfklasse.Zopf15);
        this.addListener(this.cmbZopf_cm);
        this.txtBhd_cm.setModel(new SpinnerNumberModel(20, 15, 55, 1));
        this.addListener(this.txtBhd_cm);
        enumArray = BiomasseCalculatorSchaftholztarif2018.Gesamtwuchsleistung.values();
        n = enumArray.length;
        n2 = 0;
        while (n2 < n) {
            value = enumArray[n2];
            this.cmbGesamtwuchsleistung.addItem((BiomasseCalculatorSchaftholztarif2018.Gesamtwuchsleistung)value);
            ++n2;
        }
        this.addListener(this.cmbGesamtwuchsleistung);
        this.txtAnzahlStaemme.setModel(new SpinnerNumberModel(10.0, 1.0, 10000.0, 1.0));
        if (this.constSchaftholzmengeGesamt_m3iR < 0.0) {
            this.addListener(this.txtAnzahlStaemme);
        }
        this.txtAnteilVolumenRundholz.setModel(new SpinnerNumberModel(5, 0, 100, 1));
        this.addListener(this.txtAnteilVolumenRundholz);
        this.txtAnteilVolumenAstderbholz.setModel(new SpinnerNumberModel(100, 0, 100, 1));
        this.addListener(this.txtAnteilVolumenAstderbholz);
        this.txtAnteilVolumenReisig.setModel(new SpinnerNumberModel(100, 0, 100, 1));
        this.addListener(this.txtAnteilVolumenReisig);
        this.txtErnteverlustDerbholzNadel.setModel(new SpinnerNumberModel(8, 0, 100, 1));
        this.addListener(this.txtErnteverlustDerbholzNadel);
        this.txtErnteverlustDerbholzLaub.setModel(new SpinnerNumberModel(13, 0, 100, 1));
        this.addListener(this.txtErnteverlustDerbholzLaub);
        this.txtErnteverlustNichtderbholzNadel.setModel(new SpinnerNumberModel(58, 0, 100, 1));
        this.addListener(this.txtErnteverlustNichtderbholzNadel);
        this.setDefaultValuesBasedOnAnteilLaubholz();
    }

    private void addListener(JComponent comp) {
        if (comp instanceof JSpinner) {
            HeProMoWindow.adjustJSpinnerFormatter((JSpinner)comp, false);
            ((JSpinner)comp).addChangeListener(this.defaultChangeListner);
        } else if (comp instanceof JComboBox) {
            ((JComboBox)comp).addActionListener(this.defaultActionListener);
        } else {
            throw new IllegalArgumentException(comp.toString());
        }
    }

    private void setDefaultValuesBasedOnAnteilLaubholz() {
        this.dependentValuesAreBeingSet = true;
        int anteilLaubholz_Prz = (Integer)this.txtAnteilLaubholz.getValue();
        if (anteilLaubholz_Prz == 0) {
            this.txtAnteilVolumenAstderbholz.setEnabled(false);
            this.txtAnteilVolumenReisig.setEnabled(true);
            this.txtErnteverlustDerbholzNadel.setEnabled(true);
            this.txtErnteverlustDerbholzLaub.setEnabled(false);
            this.txtErnteverlustNichtderbholzNadel.setEnabled(true);
        } else if (anteilLaubholz_Prz == 100) {
            this.txtAnteilVolumenAstderbholz.setEnabled(true);
            this.txtAnteilVolumenReisig.setEnabled(false);
            this.txtErnteverlustDerbholzNadel.setEnabled(false);
            this.txtErnteverlustDerbholzLaub.setEnabled(true);
            this.txtErnteverlustNichtderbholzNadel.setEnabled(false);
        } else {
            this.txtAnteilVolumenAstderbholz.setEnabled(true);
            this.txtAnteilVolumenReisig.setEnabled(true);
            this.txtErnteverlustDerbholzNadel.setEnabled(true);
            this.txtErnteverlustDerbholzLaub.setEnabled(true);
            this.txtErnteverlustNichtderbholzNadel.setEnabled(true);
        }
        this.dependentValuesAreBeingSet = false;
        this.onInputChanged();
    }

    private void onInputChanged() {
        if (this.dependentValuesAreBeingSet) {
            return;
        }
        this.txtVolumenSchaftholz_m3iR.setText(decimalFormat.format(this.calcVolumenSchaftholz_m3iR()));
        if (this.constSchaftholzmengeGesamt_m3iR > 0.0) {
            try {
                this.txtAnzahlStaemme.setValue(this.constSchaftholzmengeGesamt_m3iR / (Double)decimalFormat.parse(this.txtVolumenSchaftholz_m3iR.getText()));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        try {
            BiomasseCalculatorKompartimente2018.ErgebnisEnergieholz ergebnis;
            this.letztesErgebnis = ergebnis = BiomasseCalculatorKompartimente2018.calc((Double)decimalFormat.parse(this.txtVolumenSchaftholz_m3iR.getText()), (Integer)this.txtAnteilLaubholz.getValue(), (BiomasseCalculatorKompartimente2018.Standort)((Object)this.cmbStandort.getSelectedItem()), (BiomasseCalculatorAnteilEnergieholz2018.Zopfklasse)((Object)this.cmbZopf_cm.getSelectedItem()), (Integer)this.txtBhd_cm.getValue(), (Integer)this.txtAnteilVolumenRundholz.getValue(), (Integer)this.txtAnteilVolumenAstderbholz.getValue(), (Integer)this.txtAnteilVolumenReisig.getValue(), (Integer)this.txtErnteverlustDerbholzNadel.getValue(), (Integer)this.txtErnteverlustDerbholzLaub.getValue(), (Integer)this.txtErnteverlustNichtderbholzNadel.getValue(), (Double)this.txtAnzahlStaemme.getValue());
            this.txtVolumenEnergieholzAmSchaftOberhalbZopf.setText(decimalFormat.format(ergebnis.getVolumenEnergieholzAmSchaftOberhalbZopf_m3iR()));
            this.txtVolumenEnergierundholzUnterhalbZopf.setText(decimalFormat.format(ergebnis.getVolumenEnergierundholzUnterhalbZopf_m3iR()));
            this.txtVolumenAstderbholz.setText(decimalFormat.format(ergebnis.getVolumenAstderbholz_m3iR()));
            this.txtVolumenReisig.setText(decimalFormat.format(ergebnis.getVolumenReisig_m3iR()));
            this.txtVolumenEnergieholz.setText(decimalFormat.format(ergebnis.getVolumenEnergieholz_m3iR()));
            this.lblStatus.setText(" ");
            this.btnUebernehmen.setEnabled(true);
        }
        catch (IllegalArgumentException e) {
            this.clearAllOutputFields();
            this.btnUebernehmen.setEnabled(false);
            this.setErrorStatus(GuiStrings.getString("BiomasseschaetzerEnergie2018.UngueltigeZopfBhdKombination"));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.clearAllOutputFields();
            this.btnUebernehmen.setEnabled(false);
            this.setErrorStatus(String.valueOf(GuiStrings.getString("BiomasseschaetzerEnergie2018.Fehler")) + e.getMessage());
        }
    }

    private double calcVolumenSchaftholz_m3iR() {
        int anteilLaubholz_Prz = (Integer)this.txtAnteilLaubholz.getValue();
        int bhd_cm = (Integer)this.txtBhd_cm.getValue();
        BiomasseCalculatorKompartimente2018.Standort standort = (BiomasseCalculatorKompartimente2018.Standort)((Object)this.cmbStandort.getSelectedItem());
        BiomasseCalculatorSchaftholztarif2018.Entwicklungsstufe entwicklungsstufe = null;
        entwicklungsstufe = bhd_cm <= 30 ? BiomasseCalculatorSchaftholztarif2018.Entwicklungsstufe.Stangenholz_12bis30cm : (bhd_cm <= 40 ? BiomasseCalculatorSchaftholztarif2018.Entwicklungsstufe.Baumholz1_31bis40cm : (bhd_cm <= 50 ? BiomasseCalculatorSchaftholztarif2018.Entwicklungsstufe.Baumholz2_41bis50cm : BiomasseCalculatorSchaftholztarif2018.Entwicklungsstufe.Baumholz3_ueber50cm));
        int hoeheUeberMeer_m = standort.defaultHoehe;
        BiomasseCalculatorSchaftholztarif2018.Tarifnummer[] tarife = BiomasseCalculatorSchaftholztarif2018.Tarifnummer.values(standort);
        if (tarife.length != 2) {
            throw new RuntimeException("this should never happen!");
        }
        Mischtarif mischtarif = new Mischtarif(tarife[0], tarife[1], anteilLaubholz_Prz);
        double volumenSchaftholz_m3iR_TarifNadel = BiomasseCalculatorSchaftholztarif2018.getSchaftholzVolumen_m3iR(mischtarif.tarifNadel, (Integer)this.txtBhd_cm.getValue(), (BiomasseCalculatorSchaftholztarif2018.Gesamtwuchsleistung)((Object)this.cmbGesamtwuchsleistung.getSelectedItem()), entwicklungsstufe, hoeheUeberMeer_m);
        double volumenSchaftholz_m3iR_TarifLaub = BiomasseCalculatorSchaftholztarif2018.getSchaftholzVolumen_m3iR(mischtarif.tarifLaub, (Integer)this.txtBhd_cm.getValue(), (BiomasseCalculatorSchaftholztarif2018.Gesamtwuchsleistung)((Object)this.cmbGesamtwuchsleistung.getSelectedItem()), entwicklungsstufe, hoeheUeberMeer_m);
        double anteilTarifLaub = (double)mischtarif.anteilTarifLaub_Prz / 100.0;
        double anteilTarifNadel = 1.0 - anteilTarifLaub;
        double volumenSchaftholz_m3iR = anteilTarifNadel * volumenSchaftholz_m3iR_TarifNadel + anteilTarifLaub * volumenSchaftholz_m3iR_TarifLaub;
        return volumenSchaftholz_m3iR;
    }

    private void clearAllOutputFields() {
        this.txtVolumenEnergieholzAmSchaftOberhalbZopf.setText("");
        this.txtVolumenEnergierundholzUnterhalbZopf.setText("");
        this.txtVolumenAstderbholz.setText("");
        this.txtVolumenReisig.setText("");
        this.txtVolumenEnergieholz.setText("");
    }

    private void setErrorStatus(String msg) {
        this.lblStatus.setText("<html><font color=\"red\"><b>" + msg + "</b></font></html>");
    }

    protected void setBhd_cm(int bhd_cm) {
        this.txtBhd_cm.setValue(bhd_cm);
        this.txtBhd_cm.setEnabled(false);
    }

    protected void setZopf_cm(int zopf_cm) {
        this.cmbZopf_cm.setSelectedItem((Object)BiomasseCalculatorAnteilEnergieholz2018.Zopfklasse.getNaechstKleinere(zopf_cm));
    }

    private class Mischtarif {
        public final BiomasseCalculatorSchaftholztarif2018.Tarifnummer tarifNadel;
        public final BiomasseCalculatorSchaftholztarif2018.Tarifnummer tarifLaub;
        public final int anteilTarifLaub_Prz;

        private Mischtarif(BiomasseCalculatorSchaftholztarif2018.Tarifnummer tarifNadel, BiomasseCalculatorSchaftholztarif2018.Tarifnummer tarifLaub, int anteilTarifLaub_Prz) {
            this.tarifNadel = tarifNadel;
            this.tarifLaub = tarifLaub;
            this.anteilTarifLaub_Prz = anteilTarifLaub_Prz;
        }

        public String toString() {
            return String.valueOf(100 - this.anteilTarifLaub_Prz) + "% " + this.tarifNadel.nr() + ", " + this.anteilTarifLaub_Prz + "% " + this.tarifLaub.nr();
        }
    }
}

