/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.hepromo.gui.modelle;

import ch.wsl.fps.hepromo.gui.AbstractErgebnisPanel;
import ch.wsl.fps.hepromo.gui.DocumentationBroker;
import ch.wsl.fps.hepromo.gui.ErgebnisPanel;
import ch.wsl.fps.hepromo.gui.GuiStrings;
import ch.wsl.fps.hepromo.gui.HeProMoExceptionHandler;
import ch.wsl.fps.hepromo.gui.HeProMoWindow;
import ch.wsl.fps.hepromo.gui.MainWindow;
import ch.wsl.fps.hepromo.gui.TitledBorderFactory;
import ch.wsl.fps.hepromo.model.calc.BiomasseCalculatorKompartimente2018;
import ch.wsl.fps.hepromo.model.calc.BiomasseCalculatorSchaftholztarif2018;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.text.ParseException;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ChangeListener;

public class BiomasseschaetzerAbTarif2018
extends JFrame {
    private JLabel lblTarifnummer;
    private JComboBox<BiomasseCalculatorSchaftholztarif2018.Tarifnummer> cmbTarifnummer;
    private JSpinner txtBhd_cm;
    private JComboBox<BiomasseCalculatorSchaftholztarif2018.Gesamtwuchsleistung> cmbGesamtwuchsleistung;
    private JComboBox<BiomasseCalculatorSchaftholztarif2018.Entwicklungsstufe> cmbEntwicklungsstufe;
    private JSpinner txtHoeheUeberMeer_m;
    private JTextField txtVolumenSchaftholz;
    private JButton btnUebernehmen;
    private static final DecimalFormat decimalFormat = new DecimalFormat("0.000");
    private final ChangeListener defaultChangeListner = evt -> this.onInputChanged();
    private final ActionListener defaultActionListener = evt -> {
        Object selectedItem = ((JComboBox)evt.getSource()).getSelectedItem();
        if (selectedItem != null) {
            this.onInputChanged();
        }
    };

    public static void main(String[] args) {
        new BiomasseschaetzerAbTarif2018();
    }

    public BiomasseschaetzerAbTarif2018() {
        this(-1, null, null, null);
    }

    public BiomasseschaetzerAbTarif2018(int bhd_cm, Boolean isNadelholz, BiomasseCalculatorKompartimente2018.Standort standort, JSpinner txtTargetSpinner) {
        SwingUtilities.invokeLater(() -> {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e) {
                HeProMoExceptionHandler.handle(e);
            }
            ToolTipManager.sharedInstance().setInitialDelay(0);
            ToolTipManager.sharedInstance().setDismissDelay(Integer.MAX_VALUE);
            this.setTitle(GuiStrings.getString("BiomasseschaetzerAbTarif2018.TitleSchaftholzschaetzer"));
            this.setSize((int)(500.0f * MainWindow.SIZE * MainWindow.WIDTH_FACTOR), (int)(275.0f * MainWindow.SIZE));
            this.setLocationByPlatform(true);
            this.setDefaultCloseOperation(2);
            this.setIconImage(MainWindow.getWslLogo().getImage());
            this.initContent();
            this.initData(isNadelholz, standort);
            if (bhd_cm > 0) {
                this.txtBhd_cm.setValue(bhd_cm);
                this.txtBhd_cm.setEnabled(false);
            }
            if (txtTargetSpinner != null) {
                this.btnUebernehmen.addActionListener(evt -> {
                    try {
                        txtTargetSpinner.setValue(decimalFormat.parse(this.txtVolumenSchaftholz.getText()));
                    }
                    catch (ParseException e1) {
                        e1.printStackTrace();
                    }
                    this.dispose();
                });
            } else {
                this.btnUebernehmen.setVisible(false);
            }
            this.onInputChanged();
            this.setVisible(true);
        });
    }

    private void initContent() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        c.fill = 2;
        c.weightx = 20.0;
        c.insets = new Insets(10, 30, 5, 30);
        JPanel pnlInput = new JPanel();
        this.initPanelInput(pnlInput);
        this.add((Component)pnlInput, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 2;
        c.fill = 2;
        c.weightx = 20.0;
        c.insets = new Insets(5, 30, 10, 30);
        JPanel pnlOutput = new JPanel();
        this.initPanelOutput(pnlOutput);
        this.add((Component)pnlOutput, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 2;
        c.anchor = 13;
        c.weightx = 100.0;
        c.insets = new Insets(0, 0, 0, 20);
        this.btnUebernehmen = new JButton(GuiStrings.getString("BiomasseschaetzerAbTarif2018.SchaftholzvolumenUebernehmen"));
        this.add((Component)this.btnUebernehmen, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 2;
        c.anchor = 13;
        c.insets = new Insets(0, 0, 0, 10);
        JButton btnDokumentation = new JButton(GuiStrings.getString("HeProMoWindow.btnGrundlagen"));
        btnDokumentation.addActionListener(evt -> DocumentationBroker.showDocumentation(DocumentationBroker.Documentation.Schaftholzschaetzer2018, (Component)this, btnDokumentation));
        this.add((Component)btnDokumentation, c);
    }

    private void initPanelInput(JPanel pnlInput) {
        pnlInput.setBorder(TitledBorderFactory.createTitledBorderBold(GuiStrings.getString("BiomasseschaetzerAbTarif2018.TitleEingaben")));
        pnlInput.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 2;
        c.weightx = 20.0;
        this.lblTarifnummer = new JLabel(GuiStrings.getString("BiomasseschaetzerAbTarif2018.Tarif"));
        pnlInput.add((Component)this.lblTarifnummer, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 0;
        c.fill = 2;
        c.weightx = 100.0;
        this.cmbTarifnummer = new JComboBox();
        pnlInput.add(this.cmbTarifnummer, c);
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = 0;
        c.fill = 2;
        c.insets = new Insets(0, 10, 0, 0);
        JLabel lblInfoButton1 = GuiStrings.getInfoButtonBlue(GuiStrings.getString("BiomasseschaetzerAbTarif2018.TarifnummernGemaessLFI"));
        pnlInput.add((Component)lblInfoButton1, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.fill = 2;
        c.weightx = 20.0;
        JLabel lblBhd_cm = new JLabel(GuiStrings.getString("BiomasseschaetzerAbTarif2018.Bhd_cm"));
        pnlInput.add((Component)lblBhd_cm, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 1;
        c.fill = 2;
        c.weightx = 100.0;
        this.txtBhd_cm = new JSpinner();
        pnlInput.add((Component)this.txtBhd_cm, c);
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = 1;
        c.fill = 2;
        c.insets = new Insets(0, 10, 0, 0);
        JLabel lblInfoButton2 = GuiStrings.getInfoButtonBlue(GuiStrings.getString("BiomasseschaetzerAbTarif2018.BhdInfoButton"));
        pnlInput.add((Component)lblInfoButton2, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 2;
        c.fill = 2;
        c.weightx = 20.0;
        c.insets = new Insets(0, 0, 0, 10);
        JLabel lblGesamtwuchsleistung = new JLabel(GuiStrings.getString("BiomasseschaetzerAbTarif2018.Gesamtwuchsleistung"));
        pnlInput.add((Component)lblGesamtwuchsleistung, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 2;
        c.fill = 2;
        c.weightx = 100.0;
        this.cmbGesamtwuchsleistung = new JComboBox();
        pnlInput.add(this.cmbGesamtwuchsleistung, c);
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = 2;
        c.fill = 2;
        c.insets = new Insets(0, 10, 0, 0);
        JLabel lblInfoButton3 = GuiStrings.getInfoButtonBlue(GuiStrings.getString("BiomasseschaetzerAbTarif2018.GesamtwuchsleistungInfoButton"));
        pnlInput.add((Component)lblInfoButton3, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 3;
        c.fill = 2;
        c.weightx = 20.0;
        JLabel lblEntwicklungsstufe = new JLabel(GuiStrings.getString("BiomasseschaetzerAbTarif2018.Entwicklungsstufe"));
        pnlInput.add((Component)lblEntwicklungsstufe, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 3;
        c.fill = 2;
        c.weightx = 100.0;
        this.cmbEntwicklungsstufe = new JComboBox();
        pnlInput.add(this.cmbEntwicklungsstufe, c);
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = 3;
        c.fill = 2;
        c.insets = new Insets(0, 10, 0, 0);
        JLabel lblInfoButton4 = GuiStrings.getInfoButtonBlue(GuiStrings.getString("BiomasseschaetzerAbTarif2018.EntwicklungsstufeInfoButton"));
        pnlInput.add((Component)lblInfoButton4, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 4;
        c.fill = 2;
        c.weightx = 20.0;
        JLabel lblHoeheUeberMeer_m = new JLabel(GuiStrings.getString("BiomasseschaetzerAbTarif2018.HoeheUeberMeer"));
        pnlInput.add((Component)lblHoeheUeberMeer_m, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 4;
        c.fill = 2;
        c.weightx = 100.0;
        this.txtHoeheUeberMeer_m = new JSpinner();
        pnlInput.add((Component)this.txtHoeheUeberMeer_m, c);
    }

    private void initPanelOutput(JPanel pnlOutput) {
        pnlOutput.setBorder(TitledBorderFactory.createTitledBorderBold(GuiStrings.getString("BiomasseschaetzerAbTarif2018.TitleErgebnis")));
        pnlOutput.setBackground(ErgebnisPanel.ERGEBNIS_PANEL_BACKGROUND_COLOR);
        pnlOutput.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 2;
        c.weightx = 20.0;
        JLabel lblVolumenSchaftholz = new JLabel(GuiStrings.getString("BiomasseschaetzerAbTarif2018.VolumenSchaftholz"));
        pnlOutput.add((Component)lblVolumenSchaftholz, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 0;
        c.fill = 2;
        c.weightx = 100.0;
        this.txtVolumenSchaftholz = AbstractErgebnisPanel.getNewLockedTextField();
        pnlOutput.add((Component)this.txtVolumenSchaftholz, c);
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = 0;
        c.fill = 2;
        c.insets = new Insets(0, 10, 0, 0);
        JLabel lblInfoButton = GuiStrings.getInfoButtonBlue(GuiStrings.getString("BiomasseschaetzerAbTarif2018.SchaftholzInfoButton"));
        pnlOutput.add((Component)lblInfoButton, c);
    }

    private void initData(Boolean isNadelholz, BiomasseCalculatorKompartimente2018.Standort standort) {
        Enum value;
        int n;
        int n2;
        Enum[] enumArray;
        if (isNadelholz == null) {
            enumArray = BiomasseCalculatorSchaftholztarif2018.Tarifnummer.values();
            n2 = enumArray.length;
            n = 0;
            while (n < n2) {
                value = enumArray[n];
                this.cmbTarifnummer.addItem((BiomasseCalculatorSchaftholztarif2018.Tarifnummer)value);
                ++n;
            }
        } else {
            enumArray = BiomasseCalculatorSchaftholztarif2018.Tarifnummer.values(isNadelholz, standort);
            n2 = enumArray.length;
            n = 0;
            while (n < n2) {
                value = enumArray[n];
                this.cmbTarifnummer.addItem((BiomasseCalculatorSchaftholztarif2018.Tarifnummer)value);
                ++n;
            }
        }
        this.cmbTarifnummer.setMaximumRowCount(10);
        if (this.cmbTarifnummer.getItemCount() <= 1) {
            this.cmbTarifnummer.setEnabled(false);
        }
        this.addListener(this.cmbTarifnummer);
        this.txtBhd_cm.setModel(new SpinnerNumberModel(20, 12, 100, 1));
        this.addListener(this.txtBhd_cm);
        this.txtBhd_cm.addChangeListener(evt -> this.entwicklungsstufeAnBhdAnpassen((Integer)this.txtBhd_cm.getValue()));
        enumArray = BiomasseCalculatorSchaftholztarif2018.Gesamtwuchsleistung.values();
        n2 = enumArray.length;
        n = 0;
        while (n < n2) {
            value = enumArray[n];
            this.cmbGesamtwuchsleistung.addItem((BiomasseCalculatorSchaftholztarif2018.Gesamtwuchsleistung)value);
            ++n;
        }
        this.addListener(this.cmbGesamtwuchsleistung);
        enumArray = BiomasseCalculatorSchaftholztarif2018.Entwicklungsstufe.values();
        n2 = enumArray.length;
        n = 0;
        while (n < n2) {
            value = enumArray[n];
            this.cmbEntwicklungsstufe.addItem((BiomasseCalculatorSchaftholztarif2018.Entwicklungsstufe)value);
            ++n;
        }
        this.addListener(this.cmbEntwicklungsstufe);
        this.cmbEntwicklungsstufe.setEnabled(false);
        this.txtHoeheUeberMeer_m.setModel(new SpinnerNumberModel(500, 0, 3000, 100));
        if (standort != null) {
            ((SpinnerNumberModel)this.txtHoeheUeberMeer_m.getModel()).setMinimum(Integer.valueOf(standort.minHoehe));
            ((SpinnerNumberModel)this.txtHoeheUeberMeer_m.getModel()).setMaximum(Integer.valueOf(standort.maxHoehe));
            ((SpinnerNumberModel)this.txtHoeheUeberMeer_m.getModel()).setValue(standort.defaultHoehe);
        }
        this.addListener(this.txtHoeheUeberMeer_m);
    }

    private void entwicklungsstufeAnBhdAnpassen(int bhd) {
        BiomasseCalculatorSchaftholztarif2018.Entwicklungsstufe entwicklungsstufe = BiomasseschaetzerAbTarif2018.getEntwicklungsstufeFromBhd(bhd);
        this.cmbEntwicklungsstufe.setSelectedItem((Object)entwicklungsstufe);
    }

    public static BiomasseCalculatorSchaftholztarif2018.Entwicklungsstufe getEntwicklungsstufeFromBhd(int bhd) {
        if (bhd <= 30) {
            return BiomasseCalculatorSchaftholztarif2018.Entwicklungsstufe.Stangenholz_12bis30cm;
        }
        if (bhd <= 40) {
            return BiomasseCalculatorSchaftholztarif2018.Entwicklungsstufe.Baumholz1_31bis40cm;
        }
        if (bhd <= 50) {
            return BiomasseCalculatorSchaftholztarif2018.Entwicklungsstufe.Baumholz2_41bis50cm;
        }
        return BiomasseCalculatorSchaftholztarif2018.Entwicklungsstufe.Baumholz3_ueber50cm;
    }

    private void addListener(JComponent comp) {
        if (comp instanceof JSpinner) {
            HeProMoWindow.adjustJSpinnerFormatter((JSpinner)comp, false);
            ((JSpinner)comp).addChangeListener(this.defaultChangeListner);
        } else if (comp instanceof JComboBox) {
            ((JComboBox)comp).addActionListener(this.defaultActionListener);
        } else {
            throw new IllegalArgumentException(comp.toString());
        }
    }

    private void onInputChanged() {
        double volumenSchaftholz_m3iR = BiomasseCalculatorSchaftholztarif2018.getSchaftholzVolumen_m3iR((BiomasseCalculatorSchaftholztarif2018.Tarifnummer)((Object)this.cmbTarifnummer.getSelectedItem()), (Integer)this.txtBhd_cm.getValue(), (BiomasseCalculatorSchaftholztarif2018.Gesamtwuchsleistung)((Object)this.cmbGesamtwuchsleistung.getSelectedItem()), (BiomasseCalculatorSchaftholztarif2018.Entwicklungsstufe)((Object)this.cmbEntwicklungsstufe.getSelectedItem()), (Integer)this.txtHoeheUeberMeer_m.getValue());
        this.txtVolumenSchaftholz.setText(decimalFormat.format(volumenSchaftholz_m3iR));
    }
}

