/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.hepromo.gui.modelle;

import ch.wsl.fps.hepromo.gui.AbstractErgebnisPanel;
import ch.wsl.fps.hepromo.gui.DocumentationBroker;
import ch.wsl.fps.hepromo.gui.ErgebnisPanel;
import ch.wsl.fps.hepromo.gui.GuiStrings;
import ch.wsl.fps.hepromo.gui.HeProMoExceptionHandler;
import ch.wsl.fps.hepromo.gui.HeProMoWindow;
import ch.wsl.fps.hepromo.gui.MainWindow;
import ch.wsl.fps.hepromo.gui.TitledBorderFactory;
import ch.wsl.fps.hepromo.gui.modelle.BiomasseschaetzerAbTarif2018;
import ch.wsl.fps.hepromo.model.calc.BiomasseCalculatorKompartimente2018;
import ch.wsl.fps.hepromo.model.calc.BiomasseCalculatorSchaftholztarif2018;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ChangeListener;

public class Biomasseschaetzer2018
extends JFrame {
    private JComboBox<BiomasseCalculatorKompartimente2018.NadelLaub> cmbBaumart;
    private JComboBox<BiomasseCalculatorKompartimente2018.Standort> cmbStandort;
    private JComboBox<BiomasseCalculatorSchaftholztarif2018.Gesamtwuchsleistung> cmbGesamtwuchsleistung;
    private JSpinner txtBhd_cm;
    private JSpinner txtAnzahlStaemme;
    private JTextField txtVolumenSchaftholz_m3iR;
    private JTextField txtVolumenSchaftholzInRinde;
    private JTextField txtVolumenAstderbholz;
    private JTextField txtVolumenReisig;
    private JTextField txtVolumenBiomasse;
    private JTextField txtMasseNadelnBlaetter;
    private JLabel lblStatus;
    private final ChangeListener defaultChangeListner = evt -> this.onInputChanged();
    private final ActionListener defaultActionListener = evt -> {
        Object selectedItem = ((JComboBox)evt.getSource()).getSelectedItem();
        if (selectedItem != null) {
            this.onInputChanged();
        }
    };
    private static final DecimalFormat decimalFormat = new DecimalFormat(",##0.00");
    private boolean dependentValuesAreBeingSet = false;

    public static void main(String[] args) {
        new Biomasseschaetzer2018();
    }

    public Biomasseschaetzer2018() {
        SwingUtilities.invokeLater(() -> {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e) {
                HeProMoExceptionHandler.handle(e);
            }
            ToolTipManager.sharedInstance().setInitialDelay(0);
            ToolTipManager.sharedInstance().setDismissDelay(Integer.MAX_VALUE);
            this.setTitle(GuiStrings.getString("Biomasseschaetzer2018.Title"));
            this.setSize((int)(480.0f * MainWindow.SIZE * MainWindow.WIDTH_FACTOR), (int)(370.0f * MainWindow.SIZE));
            this.setLocationByPlatform(true);
            this.setDefaultCloseOperation(2);
            this.setIconImage(MainWindow.getWslLogo().getImage());
            this.initContent();
            this.initData();
            this.setVisible(true);
        });
    }

    protected void initContent() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        c.fill = 2;
        c.weightx = 20.0;
        c.insets = new Insets(10, 10, 5, 10);
        JPanel pnlInput = new JPanel();
        this.initPanelInput(pnlInput);
        this.add((Component)pnlInput, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 2;
        c.fill = 2;
        c.weightx = 20.0;
        c.insets = new Insets(5, 10, 5, 10);
        JPanel pnlOutput = new JPanel();
        this.initPanelOutput(pnlOutput);
        this.add((Component)pnlOutput, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 2;
        c.fill = 2;
        c.weightx = 100.0;
        c.anchor = 13;
        c.insets = new Insets(10, 30, 0, 0);
        this.lblStatus = new JLabel(" ", 0);
        this.add((Component)this.lblStatus, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 2;
        c.anchor = 13;
        c.insets = new Insets(0, 0, 0, 10);
        JButton btnDokumentation = new JButton(GuiStrings.getString("HeProMoWindow.btnGrundlagen"));
        btnDokumentation.addActionListener(evt -> DocumentationBroker.showDocumentation(DocumentationBroker.Documentation.Biomasseschaetzer2018, (Component)this, btnDokumentation));
        this.add((Component)btnDokumentation, c);
    }

    private void initPanelInput(JPanel pnlInput) {
        pnlInput.setBorder(TitledBorderFactory.createTitledBorderBold(GuiStrings.getString("Biomasseschaetzer2018.Eingaben")));
        pnlInput.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 2;
        c.weightx = 20.0;
        JLabel lblBaumart = new JLabel(GuiStrings.getString("Biomasseschaetzer2018.Baumart"));
        pnlInput.add((Component)lblBaumart, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 0;
        c.fill = 2;
        c.weightx = 100.0;
        this.cmbBaumart = new JComboBox();
        pnlInput.add(this.cmbBaumart, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.fill = 2;
        c.weightx = 20.0;
        JLabel lblStandort = new JLabel(GuiStrings.getString("Biomasseschaetzer2018.Standort"));
        pnlInput.add((Component)lblStandort, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 1;
        c.fill = 2;
        c.weightx = 100.0;
        this.cmbStandort = new JComboBox();
        this.cmbStandort.setMaximumRowCount(10);
        pnlInput.add(this.cmbStandort, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 2;
        c.fill = 2;
        c.weightx = 20.0;
        c.insets = new Insets(0, 0, 0, 10);
        JLabel lblGesamtwuchsleistung = new JLabel(GuiStrings.getString("BiomasseschaetzerAbTarif2018.Gesamtwuchsleistung"));
        pnlInput.add((Component)lblGesamtwuchsleistung, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 2;
        c.fill = 2;
        c.weightx = 100.0;
        this.cmbGesamtwuchsleistung = new JComboBox();
        pnlInput.add(this.cmbGesamtwuchsleistung, c);
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = 2;
        c.fill = 2;
        c.insets = new Insets(0, 5, 0, 5);
        JLabel lblInfoButton3 = GuiStrings.getInfoButtonBlue(GuiStrings.getString("BiomasseschaetzerAbTarif2018.GesamtwuchsleistungInfoButton"));
        pnlInput.add((Component)lblInfoButton3, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 3;
        c.fill = 2;
        c.weightx = 20.0;
        JLabel lblBhd = new JLabel(GuiStrings.getString("Biomasseschaetzer2018.MittlererBhd_cm"));
        pnlInput.add((Component)lblBhd, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 3;
        c.fill = 2;
        c.weightx = 100.0;
        this.txtBhd_cm = new JSpinner();
        pnlInput.add((Component)this.txtBhd_cm, c);
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = 3;
        c.fill = 2;
        c.insets = new Insets(0, 5, 0, 5);
        JLabel lblBhd_cm_Info = GuiStrings.getInfoButtonBlue(GuiStrings.getString("Biomasseschaetzer2018.InfoButtonMittlererBhd"));
        pnlInput.add((Component)lblBhd_cm_Info, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 4;
        c.fill = 2;
        c.weightx = 20.0;
        JLabel lblAnzahlStaemme = new JLabel(GuiStrings.getString("Biomasseschaetzer2018.AnzahlStaemme"));
        pnlInput.add((Component)lblAnzahlStaemme, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 4;
        c.fill = 2;
        c.weightx = 100.0;
        this.txtAnzahlStaemme = new JSpinner();
        pnlInput.add((Component)this.txtAnzahlStaemme, c);
    }

    private void initPanelOutput(JPanel pnlOutput) {
        pnlOutput.setBorder(TitledBorderFactory.createTitledBorderBold(GuiStrings.getString("Biomasseschaetzer2018.Ergebnis")));
        pnlOutput.setBackground(ErgebnisPanel.ERGEBNIS_PANEL_BACKGROUND_COLOR);
        pnlOutput.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.fill = 2;
        c.insets = new Insets(0, 0, 0, 5);
        JLabel lblSchaftholzvolumen = new JLabel(GuiStrings.getString("Biomasseschaetzer2018.VolumenSchaftholzMittlererBarum_m3iR"));
        pnlOutput.add((Component)lblSchaftholzvolumen, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 1;
        c.fill = 2;
        c.weightx = 100.0;
        this.txtVolumenSchaftholz_m3iR = AbstractErgebnisPanel.getNewLockedTextField();
        pnlOutput.add((Component)this.txtVolumenSchaftholz_m3iR, c);
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = 1;
        c.fill = 2;
        c.insets = new Insets(0, 5, 0, 5);
        JLabel lblVolumenSchaftholz_Info = GuiStrings.getInfoButtonBlue(GuiStrings.getString("Biomasseschaetzer2018.InfoButtonSchaftholz"));
        pnlOutput.add((Component)lblVolumenSchaftholz_Info, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 2;
        c.fill = 2;
        c.weightx = 20.0;
        JLabel lblVolumenSchaftholzInRinde = new JLabel(GuiStrings.getString("Biomasseschaetzer2018.VolumenSchaftholz_m3iR"));
        pnlOutput.add((Component)lblVolumenSchaftholzInRinde, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 2;
        c.fill = 2;
        c.weightx = 100.0;
        this.txtVolumenSchaftholzInRinde = AbstractErgebnisPanel.getNewLockedTextField();
        pnlOutput.add((Component)this.txtVolumenSchaftholzInRinde, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 3;
        c.fill = 2;
        c.weightx = 20.0;
        JLabel lblVolumenAstderbholz = new JLabel(GuiStrings.getString("Biomasseschaetzer2018.VolumenAstderbholz_m3iR"));
        pnlOutput.add((Component)lblVolumenAstderbholz, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 3;
        c.fill = 2;
        c.weightx = 100.0;
        this.txtVolumenAstderbholz = AbstractErgebnisPanel.getNewLockedTextField();
        pnlOutput.add((Component)this.txtVolumenAstderbholz, c);
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = 3;
        c.fill = 2;
        c.insets = new Insets(0, 5, 0, 5);
        JLabel lblAstderbholz_Info2 = GuiStrings.getInfoButtonBlue(GuiStrings.getString("Biomasseschaetzer2018.InfoButtonAstderbholz"));
        pnlOutput.add((Component)lblAstderbholz_Info2, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 4;
        c.fill = 2;
        c.weightx = 20.0;
        JLabel lblVolumenReisig = new JLabel(GuiStrings.getString("Biomasseschaetzer2018.VolumenReisig_m3iR"));
        pnlOutput.add((Component)lblVolumenReisig, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 4;
        c.fill = 2;
        c.weightx = 100.0;
        this.txtVolumenReisig = AbstractErgebnisPanel.getNewLockedTextField();
        pnlOutput.add((Component)this.txtVolumenReisig, c);
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = 4;
        c.fill = 2;
        c.insets = new Insets(0, 5, 0, 5);
        JLabel lblReisig_Info2 = GuiStrings.getInfoButtonBlue(GuiStrings.getString("Biomasseschaetzer2018.InfoButtonReisig"));
        pnlOutput.add((Component)lblReisig_Info2, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 5;
        c.fill = 2;
        c.weightx = 20.0;
        JLabel lblVolumenBiomasse = new JLabel(GuiStrings.getString("Biomasseschaetzer2018.VolumenBiomasse"));
        pnlOutput.add((Component)lblVolumenBiomasse, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 5;
        c.fill = 2;
        c.weightx = 100.0;
        this.txtVolumenBiomasse = AbstractErgebnisPanel.getNewLockedTextField();
        pnlOutput.add((Component)this.txtVolumenBiomasse, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 6;
        c.fill = 2;
        c.weightx = 20.0;
        JLabel lblMasseNadelnBlaetter = new JLabel(GuiStrings.getString("Biomasseschaetzer2018.MasseNadelnBlaetter"));
        pnlOutput.add((Component)lblMasseNadelnBlaetter, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 6;
        c.fill = 2;
        c.weightx = 100.0;
        this.txtMasseNadelnBlaetter = AbstractErgebnisPanel.getNewLockedTextField();
        pnlOutput.add((Component)this.txtMasseNadelnBlaetter, c);
    }

    protected void initData() {
        Enum value;
        Enum[] enumArray = BiomasseCalculatorKompartimente2018.NadelLaub.values();
        int n = enumArray.length;
        int n2 = 0;
        while (n2 < n) {
            value = enumArray[n2];
            this.cmbBaumart.addItem((BiomasseCalculatorKompartimente2018.NadelLaub)value);
            ++n2;
        }
        this.addListener(this.cmbBaumart);
        this.cmbBaumart.addActionListener(evt -> {
            Object selectedItem = ((JComboBox)evt.getSource()).getSelectedItem();
            if (selectedItem != null) {
                this.setDefaultValuesBasedOnNadelholzOrLaubholz();
            }
        });
        this.addListener(this.cmbStandort);
        enumArray = BiomasseCalculatorSchaftholztarif2018.Gesamtwuchsleistung.values();
        n = enumArray.length;
        n2 = 0;
        while (n2 < n) {
            value = enumArray[n2];
            this.cmbGesamtwuchsleistung.addItem((BiomasseCalculatorSchaftholztarif2018.Gesamtwuchsleistung)value);
            ++n2;
        }
        this.addListener(this.cmbGesamtwuchsleistung);
        this.txtBhd_cm.setModel(new SpinnerNumberModel(20, 10, 100, 1));
        this.addListener(this.txtBhd_cm);
        this.txtAnzahlStaemme.setModel(new SpinnerNumberModel(10, 1, 10000, 1));
        this.addListener(this.txtAnzahlStaemme);
        this.setDefaultValuesBasedOnNadelholzOrLaubholz();
    }

    private void addListener(JComponent comp) {
        if (comp instanceof JSpinner) {
            HeProMoWindow.adjustJSpinnerFormatter((JSpinner)comp, false);
            ((JSpinner)comp).addChangeListener(this.defaultChangeListner);
        } else if (comp instanceof JComboBox) {
            ((JComboBox)comp).addActionListener(this.defaultActionListener);
        } else {
            throw new IllegalArgumentException(comp.toString());
        }
    }

    private void setDefaultValuesBasedOnNadelholzOrLaubholz() {
        this.dependentValuesAreBeingSet = true;
        if (this.cmbBaumart.getSelectedItem() == BiomasseCalculatorKompartimente2018.NadelLaub.Nadelholz) {
            this.cmbStandort.removeAllItems();
            BiomasseCalculatorKompartimente2018.Standort[] standortArray = BiomasseCalculatorKompartimente2018.Standort.getAllRelevantForReisigNadel();
            int n = standortArray.length;
            int n2 = 0;
            while (n2 < n) {
                BiomasseCalculatorKompartimente2018.Standort value = standortArray[n2];
                this.cmbStandort.addItem(value);
                ++n2;
            }
        } else {
            this.cmbStandort.removeAllItems();
            BiomasseCalculatorKompartimente2018.Standort[] standortArray = BiomasseCalculatorKompartimente2018.Standort.getAllRelevantForAstderbholzLaub();
            int n = standortArray.length;
            int n3 = 0;
            while (n3 < n) {
                BiomasseCalculatorKompartimente2018.Standort value = standortArray[n3];
                this.cmbStandort.addItem(value);
                ++n3;
            }
        }
        this.dependentValuesAreBeingSet = false;
        this.onInputChanged();
    }

    private void onInputChanged() {
        if (this.dependentValuesAreBeingSet) {
            return;
        }
        try {
            double volumenSchaftholz_m3iR = BiomasseCalculatorSchaftholztarif2018.getSchaftholzVolumen_m3iR(BiomasseCalculatorSchaftholztarif2018.Tarifnummer.values(this.cmbBaumart.getSelectedItem().equals((Object)BiomasseCalculatorKompartimente2018.NadelLaub.Nadelholz), (BiomasseCalculatorKompartimente2018.Standort)((Object)this.cmbStandort.getSelectedItem()))[0], (Integer)this.txtBhd_cm.getValue(), (BiomasseCalculatorSchaftholztarif2018.Gesamtwuchsleistung)((Object)this.cmbGesamtwuchsleistung.getSelectedItem()), BiomasseschaetzerAbTarif2018.getEntwicklungsstufeFromBhd((Integer)this.txtBhd_cm.getValue()), ((BiomasseCalculatorKompartimente2018.Standort)((Object)this.cmbStandort.getSelectedItem())).defaultHoehe);
            this.txtVolumenSchaftholz_m3iR.setText(decimalFormat.format(volumenSchaftholz_m3iR));
            BiomasseCalculatorKompartimente2018.ErgebnisBiomasse ergebnis = BiomasseCalculatorKompartimente2018.calc(volumenSchaftholz_m3iR, (BiomasseCalculatorKompartimente2018.NadelLaub)((Object)this.cmbBaumart.getSelectedItem()), (BiomasseCalculatorKompartimente2018.Standort)((Object)this.cmbStandort.getSelectedItem()), (Integer)this.txtBhd_cm.getValue(), (Integer)this.txtAnzahlStaemme.getValue());
            this.txtVolumenSchaftholzInRinde.setText(decimalFormat.format(ergebnis.getVolumenSchaftholz_m3iR()));
            this.txtVolumenAstderbholz.setText(decimalFormat.format(ergebnis.getVolumenAstderbholz_m3iR()));
            this.txtVolumenReisig.setText(decimalFormat.format(ergebnis.getVolumenReisig_m3iR()));
            this.txtVolumenBiomasse.setText(decimalFormat.format(ergebnis.getVolumenBiomasseOhneNadelnUndBlaetter()));
            this.txtMasseNadelnBlaetter.setText(decimalFormat.format(ergebnis.getMasseNadelnUndBlaetter_kg()));
            this.lblStatus.setText(" ");
        }
        catch (IllegalArgumentException e) {
            this.clearAllOutputFields();
            this.setErrorStatus(GuiStrings.getString("Biomasseschaetzer2018.UngueltigeZopfBhdKombination"));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.clearAllOutputFields();
            this.setErrorStatus(String.valueOf(GuiStrings.getString("Biomasseschaetzer2018.Fehler")) + e.getMessage());
        }
    }

    private void clearAllOutputFields() {
        this.txtVolumenSchaftholzInRinde.setText("");
        this.txtVolumenAstderbholz.setText("");
        this.txtVolumenReisig.setText("");
        this.txtVolumenBiomasse.setText("");
        this.txtMasseNadelnBlaetter.setText("");
    }

    private void setErrorStatus(String msg) {
        this.lblStatus.setText("<html><font color=\"red\"><b>" + msg + "</b></font></html>");
    }
}

