/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.hepromo.gui;

import java.awt.Color;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;

public class TitledBorderFactory {
    public static TitledBorder createTitledBorder(String title) {
        return BorderFactory.createTitledBorder(TitledBorderFactory.getBaseBorder(), title);
    }

    public static TitledBorder createTitledBorderBold(String title) {
        TitledBorder result = BorderFactory.createTitledBorder(TitledBorderFactory.getBaseBorder(), title);
        Font titleFont = result.getTitleFont();
        if (titleFont == null) {
            titleFont = UIManager.getFont("TitledBorder.font");
        }
        result.setTitleFont(titleFont.deriveFont(1));
        return result;
    }

    public static Border getBaseBorder() {
        if (TitledBorderFactory.isWindowsAndJava9OrHigher()) {
            Border baseBorderOuter = BorderFactory.createLineBorder(new Color(213, 223, 229), 1, true);
            Border baseBorderInner = BorderFactory.createLineBorder(Color.WHITE, 1, true);
            CompoundBorder baseBorder = BorderFactory.createCompoundBorder(baseBorderOuter, baseBorderInner);
            return baseBorder;
        }
        return null;
    }

    private static boolean isWindowsAndJava9OrHigher() {
        return TitledBorderFactory.isWindows() && TitledBorderFactory.isJava9OrHigher();
    }

    private static boolean isWindows() {
        try {
            String osName = System.getProperty("os.name");
            return osName.startsWith("Windows");
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private static boolean isJava9OrHigher() {
        try {
            String javaVersion = System.getProperty("java.version");
            boolean isJava9OrHigher = !javaVersion.startsWith("1.");
            return isJava9OrHigher;
        }
        catch (Exception e) {
            e.printStackTrace();
            return true;
        }
    }
}

