/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.hepromo.gui;

import ch.wsl.fps.hepromo.gui.GuiStrings;
import ch.wsl.fps.hepromo.gui.HeProMoExceptionHandler;
import ch.wsl.fps.hepromo.gui.modelle.Biomasseschaetzer2018;
import ch.wsl.fps.hepromo.gui.modelle.BiomasseschaetzerAbTarif2018;
import ch.wsl.fps.hepromo.gui.modelle.BiomasseschaetzerEnergie2018;
import ch.wsl.fps.hepromo.gui.modelle.FaellenMotormanuell;
import ch.wsl.fps.hepromo.gui.modelle.Forwarder;
import ch.wsl.fps.hepromo.gui.modelle.ForwarderEnergieholz2018;
import ch.wsl.fps.hepromo.gui.modelle.ForwarderRundholz2018;
import ch.wsl.fps.hepromo.gui.modelle.Hacker2018;
import ch.wsl.fps.hepromo.gui.modelle.HackschnitzelTransport2018;
import ch.wsl.fps.hepromo.gui.modelle.HelikopterGesamt;
import ch.wsl.fps.hepromo.gui.modelle.Kombiseilgeraet2018;
import ch.wsl.fps.hepromo.gui.modelle.KonventionellerSeilkranGesamt;
import ch.wsl.fps.hepromo.gui.modelle.MobilseilkranGesamt;
import ch.wsl.fps.hepromo.gui.modelle.MotormanuellGesamt;
import ch.wsl.fps.hepromo.gui.modelle.MotormanuellGesamt2014;
import ch.wsl.fps.hepromo.gui.modelle.Radharvester2014;
import ch.wsl.fps.hepromo.gui.modelle.Schlepper;
import ch.wsl.fps.hepromo.gui.modelle.Schlepper2014;
import ch.wsl.fps.hepromo.gui.modelle.Vorruecken2018;
import ch.wsl.fps.hepromo.model.ModelStrings;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.OverlayLayout;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.FontUIResource;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class MainWindow
extends JFrame {
    private static final long serialVersionUID = 1L;
    private JTree tree = this.initJTree();
    private JLabel lblWait;
    private static final String betaSuffix = " <font size=6 color=red>BETA</font>";
    private static final boolean isBeta = false;
    private static final String hepromoVersion = "2.6";
    private static final int hepromoMonth = 7;
    private static boolean LOG_TO_FILE = false;
    private static final int hepromoYear = 2024;
    private static Locale locale = new Locale("de");
    public static float SIZE = 1.0f;
    public static float WIDTH_FACTOR = 1.0f;

    public static void main(String[] args) {
        String arg;
        int i = 0;
        while (i < args.length) {
            arg = args[i];
            System.out.println("arg" + i + ": " + arg);
            if (arg.equalsIgnoreCase("-logtofile") || arg.equalsIgnoreCase("logtofile")) {
                LOG_TO_FILE = true;
            } else if (arg.equalsIgnoreCase("-logdialog") || arg.equalsIgnoreCase("logdialog")) {
                HeProMoExceptionHandler.setLogDialog(true);
            } else if (arg.equalsIgnoreCase("-stacktrace") || arg.equalsIgnoreCase("stacktrace")) {
                HeProMoExceptionHandler.setLogStackTrace(true);
            }
            ++i;
        }
        if (LOG_TO_FILE) {
            try {
                FileOutputStream os = new FileOutputStream("hepromo.log", true);
                PrintStream ps = new PrintStream(os);
                System.setOut(ps);
                System.setErr(ps);
            }
            catch (FileNotFoundException e) {
                HeProMoExceptionHandler.handle(e);
            }
        }
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                HeProMoExceptionHandler.handle(e, "Uncaught Exception in Thread " + t + "\n");
            }
        });
        System.out.println("Default Locale: " + Locale.getDefault());
        if (Locale.getDefault().getLanguage().equals(Locale.FRENCH.getLanguage())) {
            locale = new Locale("fr");
        }
        if (Locale.getDefault().getLanguage().equals(Locale.ITALIAN.getLanguage())) {
            locale = new Locale("it");
        }
        i = 0;
        while (i < args.length) {
            arg = args[i];
            System.out.println("arg" + i + ": " + arg);
            if (arg.equalsIgnoreCase("-fr") || arg.equalsIgnoreCase("fr")) {
                locale = new Locale("fr");
            } else if (arg.equalsIgnoreCase("-de") || arg.equalsIgnoreCase("de")) {
                locale = new Locale("de");
            } else if (arg.equalsIgnoreCase("-en") || arg.equalsIgnoreCase("en")) {
                locale = new Locale("en");
            } else if (arg.equalsIgnoreCase("-it") || arg.equalsIgnoreCase("it")) {
                locale = new Locale("it");
            }
            ++i;
        }
        SwingUtilities.invokeLater(() -> {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                Font defaultFont = new JLabel().getFont();
                SIZE = (float)defaultFont.getSize() / 11.0f;
                SIZE = Math.max(1.0f, SIZE);
                if (System.getProperty("os.name") != null && System.getProperty("os.name").indexOf("Mac") >= 0) {
                    WIDTH_FACTOR = 1.15f;
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e) {
                HeProMoExceptionHandler.handle(e);
            }
            ToolTipManager.sharedInstance().setInitialDelay(0);
            ToolTipManager.sharedInstance().setDismissDelay(Integer.MAX_VALUE);
            MainWindow.setAllLocales(locale);
            new MainWindow();
        });
    }

    private static void setDefaultFont(FontUIResource font) {
        for (Object key : Collections.list(UIManager.getDefaults().keys())) {
            Object value = UIManager.get(key);
            if (!(value instanceof FontUIResource)) continue;
            UIManager.put(key, font);
        }
    }

    public MainWindow() {
        this.setSize((int)(420.0 * Math.pow(SIZE, 0.6) * (double)WIDTH_FACTOR), (int)(580.0 * Math.pow(SIZE, 0.6)));
        this.setMinimumSize(new Dimension(350, 300));
        this.setLocationByPlatform(true);
        this.setTitle("HeProMo");
        this.setDefaultCloseOperation(3);
        this.createMenu();
        this.initContent();
        this.setIconImage(MainWindow.getWslLogo().getImage());
        this.setVisible(true);
    }

    private void createMenu() {
        JMenuBar menuBar = new JMenuBar();
        menuBar.setBorderPainted(false);
        this.setJMenuBar(menuBar);
        JMenu menuFile = new JMenu(GuiStrings.getString("MainWindow.menuDatei"));
        menuBar.add(menuFile);
        JMenu menuLanguage = new JMenu(GuiStrings.getString("MainWindow.menuSprache"));
        menuBar.add(menuLanguage);
        JMenu menuKontakt = new JMenu(GuiStrings.getString("MainWindow.menuKontakt"));
        menuBar.add(menuKontakt);
        JMenu menuHelp = new JMenu(GuiStrings.getString("MainWindow.menuInfo"));
        menuBar.add(menuHelp);
        menuFile.addSeparator();
        AbstractAction aMenuClose = new AbstractAction(GuiStrings.getString("MainWindow.menuBeenden")){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        };
        menuFile.add(aMenuClose);
        ButtonGroup btnGroupLang = new ButtonGroup();
        ArrayList<Locale> listLanguages = new ArrayList<Locale>();
        listLanguages.add(new Locale("de"));
        listLanguages.add(new Locale("fr"));
        listLanguages.add(new Locale("it"));
        listLanguages.add(new Locale("en"));
        for (final Locale lang : listLanguages) {
            AbstractAction aMenuLanguageX = new AbstractAction(lang.toString()){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MainWindow.this.changeLanguage(lang);
                }
            };
            JRadioButtonMenuItem menuLanguageX = new JRadioButtonMenuItem();
            menuLanguageX.setAction(aMenuLanguageX);
            menuLanguageX.setSelected(lang.equals(locale));
            menuLanguageX.setText(lang.getDisplayLanguage(locale));
            menuLanguageX.setName(lang.getLanguage());
            menuLanguage.add(menuLanguageX);
            btnGroupLang.add(menuLanguageX);
        }
        AbstractAction aMenuKontakt = new AbstractAction(GuiStrings.getString("MainWindow.menuKontakt")){

            @Override
            public void actionPerformed(ActionEvent e) {
                StringBuilder sb = new StringBuilder();
                sb.append("<html>");
                sb.append(String.valueOf(GuiStrings.getString("MainWindow.InfoDialog.EidgForschungsanstaltWSL")) + "<br>");
                sb.append("Z\u00fcrcherstrasse 111<br>");
                sb.append("CH-8903 Birmensdorf<br>");
                sb.append("<br>");
                sb.append("<b>" + GuiStrings.getString("MainWindow.InfoDialog.TitleKontakt") + "</b><br>");
                sb.append("Janine Schweier / janine.schweier@wsl.ch / +41 44 739 24 78<br>");
                sb.append("<br>");
                sb.append("<b>" + GuiStrings.getString("MainWindow.InfoDialog.TitleProgrammierung") + "</b><br>");
                sb.append("\tStefan Holm / stefan.holm@wsl.ch / +41 44 739 22 63<br>");
                if (locale.equals(new Locale("fr"))) {
                    sb.append("<br>");
                    sb.append("<b>Traduction:</b><br>");
                    sb.append("\tFran\u00e7ois Fahrni / fahrni@bzwlyss.ch / +41 32 387 49 21<br>");
                }
                if (locale.equals(new Locale("it"))) {
                    sb.append("<br>");
                    sb.append("<b>Traduzione:</b><br>");
                    sb.append("\tFulvio Giudici / fulvio.guidici@gmail.com<br>");
                }
                if (locale.equals(new Locale("en"))) {
                    sb.append("<br>");
                    sb.append("<b>Translation:</b><br>");
                    sb.append("\tFritz Frutig<br>");
                }
                sb.append("</html>");
                JOptionPane.showMessageDialog(MainWindow.this, sb.toString(), GuiStrings.getString("MainWindow.menuKontakt"), 1);
            }
        };
        menuKontakt.add(aMenuKontakt);
        AbstractAction aMenuInfo = new AbstractAction(GuiStrings.getString("MainWindow.menuInfo")){

            @Override
            public void actionPerformed(ActionEvent e) {
                int fontSize = (double)SIZE > 1.3 ? 6 : 5;
                StringBuilder sb1 = new StringBuilder();
                sb1.append("<html>");
                sb1.append("<b><font size=" + fontSize + " color=#006666>HeProMo v" + MainWindow.hepromoVersion + " / " + MainWindow.this.getHeProMoDate() + "</font></b><br>");
                sb1.append("<br>");
                sb1.append("<b>" + GuiStrings.getString("MainWindow.InfoDialog.TitleBereitgestelltDurch") + "</b><br>");
                sb1.append(String.valueOf(GuiStrings.getString("MainWindow.InfoDialog.EidgForschungsanstaltWSL")) + "<br>");
                sb1.append("Z\u00fcrcherstrasse 111<br>");
                sb1.append("CH-8903 Birmensdorf<br>");
                sb1.append("<br>");
                sb1.append("<b>" + GuiStrings.getString("MainWindow.InfoDialog.TitleNeueModelle2024") + "</b><br>");
                sb1.append("Marc Werder und Janine Schweier<br>");
                sb1.append("<br>");
                sb1.append("<b>" + GuiStrings.getString("MainWindow.InfoDialog.TitleNeueModelle2014") + "</b><br>");
                sb1.append("D. Pedolin, F. Frutig, R. Lemm, O. Thees<br>");
                sb1.append("<br>");
                sb1.append("<b>" + GuiStrings.getString("MainWindow.InfoDialog.TitleAlteModelle") + "</b><br>");
                sb1.append("V. Erni, R. Lemm, F. Frutig, M. Breitenstein, D. Riechsteiner, K. Oswald, O. Thees<br>");
                sb1.append("<br>");
                sb1.append("<b>" + GuiStrings.getString("MainWindow.InfoDialog.TitleProgrammierung") + "</b><br>");
                sb1.append("\tStefan Holm<br>");
                sb1.append("<br>");
                sb1.append("<b>" + GuiStrings.getString("MainWindow.InfoDialog.TitleZitierung") + "</b><br>");
                sb1.append("\t- " + GuiStrings.getString("MainWindow.InfoDialog.EidgForschungsanstaltWSL") + ", " + 2024 + ": " + GuiStrings.getString("MainWindow.InfoDialog.HolzernteProduktivitaetsmodelle") + " HeProMo, " + GuiStrings.getString("MainWindow.Version") + " " + MainWindow.hepromoVersion);
                sb1.append("</html>");
                JLabel label1 = new JLabel(sb1.toString());
                StringBuilder sb2 = new StringBuilder();
                sb2.append("<html>\t- <u style=\"color:blue;\">Holm, S., Frutig, F., Lemm, R., Thees, O., & Schweier, J. (2020). HeProMo: A decision</u><br>&nbsp;&nbsp;<u style=\"color:blue;\">support tool to estimate wood harvesting productivities. PLoS One, 15(12), e0244289.</u><br><br>");
                sb2.append("</html>");
                JLabel label2 = new JLabel(sb2.toString());
                label2.setCursor(Cursor.getPredefinedCursor(12));
                label2.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        Desktop desktop;
                        Desktop desktop2 = desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
                        if (desktop != null && desktop.isSupported(Desktop.Action.BROWSE)) {
                            try {
                                URI uri = new URI("https://doi.org/10.1371/journal.pone.0244289");
                                desktop.browse(uri);
                            }
                            catch (Exception e1) {
                                e1.printStackTrace();
                            }
                        }
                    }
                });
                JPanel panel = new JPanel();
                panel.setLayout(new BoxLayout(panel, 1));
                panel.add(label1);
                panel.add(label2);
                JOptionPane.showMessageDialog(MainWindow.this, panel, GuiStrings.getString("MainWindow.menuInfo"), 1);
            }
        };
        menuHelp.add(aMenuInfo);
    }

    private void initContent() {
        this.getContentPane().removeAll();
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 1;
        c.insets = new Insets(10, 10, 10, 10);
        ImageIcon wslLogo = MainWindow.getWslLogo();
        int fontSize = (double)SIZE > 1.3 ? 6 : 5;
        String infoText = "<html><font size=" + fontSize + " color=#006666><b>" + GuiStrings.getString("MainWindow.InfoDialog.HolzernteProduktivitaetsmodelle") + "<font size=0><br><br></font>" + GuiStrings.getString("MainWindow.Version") + " " + hepromoVersion + " / " + this.getHeProMoDate() + "</b></font></html>";
        JLabel lblWslInfo = new JLabel(infoText, wslLogo, 2);
        lblWslInfo.setIconTextGap(12);
        this.getContentPane().add((Component)lblWslInfo, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.fill = 1;
        c.weightx = 100.0;
        c.weighty = 100.0;
        JScrollPane treeView = new JScrollPane(this.tree);
        this.tree.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.lblWait = new JLabel(this.getWaitImage());
        this.lblWait.setAlignmentX(0.5f);
        this.lblWait.setAlignmentY(0.5f);
        this.lblWait.setVisible(false);
        JPanel overlayPanel = new JPanel();
        overlayPanel.setLayout(new OverlayLayout(overlayPanel));
        overlayPanel.add(this.lblWait);
        overlayPanel.add(treeView);
        this.getContentPane().add((Component)overlayPanel, c);
    }

    private JTree initJTree() {
        final JTree tree = new JTree(this.getRootNode());
        tree.setRootVisible(false);
        tree.setShowsRootHandles(true);
        tree.expandRow(2);
        tree.expandRow(0);
        tree.setCellRenderer(new DefaultTreeCellRenderer(){
            private static final long serialVersionUID = 1L;
            private final JLabel infoButtonBlue = GuiStrings.getInfoButtonBlue("");
            private final JLabel infoButtonGrey = GuiStrings.getInfoButtonGrey("");
            private final JPanel panel = new JPanel(new BorderLayout());
            {
                this.panel.setOpaque(false);
                this.panel.add((Component)this, "West");
                this.setBackgroundSelectionColor(null);
                this.setTextSelectionColor(null);
                this.setBorderSelectionColor(Color.LIGHT_GRAY);
            }

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                JLabel label = (JLabel)super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
                label.setFont(tree.getFont());
                this.panel.removeAll();
                this.panel.add((Component)this, "West");
                if (value instanceof InfoTreeNode) {
                    if (MainWindow.this.lblWait != null && MainWindow.this.lblWait.isVisible()) {
                        this.panel.add((Component)this.infoButtonGrey, "East");
                    } else {
                        this.panel.add((Component)this.infoButtonBlue, "East");
                    }
                    this.panel.setToolTipText(((InfoTreeNode)value).getToolTip());
                } else {
                    this.panel.setToolTipText(null);
                }
                return this.panel;
            }
        });
        tree.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                int y;
                if (!tree.isEnabled()) {
                    return;
                }
                int x = (int)e.getPoint().getX();
                TreePath path = tree.getPathForLocation(x, y = (int)e.getPoint().getY());
                if (path != null && path.getLastPathComponent() instanceof HeProMoApplicationTreeNode) {
                    tree.setCursor(Cursor.getPredefinedCursor(12));
                } else {
                    tree.setCursor(Cursor.getDefaultCursor());
                }
            }
        });
        tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int y;
                if (!tree.isEnabled()) {
                    return;
                }
                int x = (int)e.getPoint().getX();
                TreePath path = tree.getPathForLocation(x, y = (int)e.getPoint().getY());
                if (path != null && path.getLastPathComponent() instanceof HeProMoApplicationTreeNode) {
                    HeProMoApplicationTreeNode selectedNode = (HeProMoApplicationTreeNode)path.getLastPathComponent();
                    selectedNode.run();
                }
            }
        });
        tree.setFont(tree.getFont().deriveFont((float)tree.getFont().getSize() + 1.0f));
        tree.setRowHeight(20);
        ToolTipManager.sharedInstance().registerComponent(tree);
        return tree;
    }

    private TreeNode getRootNode() {
        DefaultMutableTreeNode infoNode;
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode("Einzelprozesse");
        String tooltipAktuelleModelle = "<html>" + GuiStrings.getString("MainWindow.TooltipAktuelleModelleZeile1") + "<br><br>" + "&nbsp;&nbsp;&nbsp;" + GuiStrings.getString("MainWindow.TooltipAktuelleModelleZeile2") + "<br><br>" + "&nbsp;&nbsp;&nbsp;" + GuiStrings.getString("MainWindow.TooltipAktuelleModelleZeile3") + "<br>" + "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + GuiStrings.getString("MainWindow.TooltipAktuelleModelleZeile4") + "<font size=0><br><br></font>" + "</html>";
        String tooltipAlteModelle = "<html>" + GuiStrings.getString("MainWindow.TooltipAlteModelleZeile1") + "<br>" + GuiStrings.getString("MainWindow.TooltipAlteModelleZeile2") + "<br>" + GuiStrings.getString("MainWindow.TooltipAlteModelleZeile3") + "<br>" + GuiStrings.getString("MainWindow.TooltipAlteModelleZeile4") + "<br>" + GuiStrings.getString("MainWindow.TooltipAlteModelleZeile5") + "</html>";
        InfoTreeNode rootNodeAktuelleModelle = new InfoTreeNode(GuiStrings.getString("MainWindow.menuAktuelleModelle"), tooltipAktuelleModelle);
        InfoTreeNode rootNodeAlteModelle = new InfoTreeNode(GuiStrings.getString("MainWindow.menuAlteModelle"), tooltipAlteModelle);
        DefaultMutableTreeNode rootNodeBiomasse = new DefaultMutableTreeNode(GuiStrings.getString("MainWindow.menuVolumenberechnungen"));
        rootNode.add(rootNodeAktuelleModelle);
        rootNode.add(rootNodeAlteModelle);
        rootNode.add(rootNodeBiomasse);
        rootNodeAlteModelle.add(new HeProMoApplicationTreeNode(MotormanuellGesamt.class, "Holzhauerei motormanuell 1978", true));
        rootNodeAlteModelle.add(new HeProMoApplicationTreeNode(FaellenMotormanuell.class, "F\u00e4llen motormanuell 1978", true));
        HeProMoApplicationTreeNode nodeMotormanuell2014Root = new HeProMoApplicationTreeNode(MotormanuellGesamt2014.class, GuiStrings.getString("MainWindow.menuMotormanuell2014"), true);
        rootNodeAktuelleModelle.add(nodeMotormanuell2014Root);
        HeProMoApplicationTreeNode nodeRadharvester2014Root = new HeProMoApplicationTreeNode(Radharvester2014.class, GuiStrings.getString("MainWindow.menuRadharvester2014"), true);
        rootNodeAktuelleModelle.add(nodeRadharvester2014Root);
        HeProMoApplicationTreeNode nodeHackerRoot = new HeProMoApplicationTreeNode(Hacker2018.class, GuiStrings.getString("MainWindow.menuHacker"), true);
        rootNodeAktuelleModelle.add(nodeHackerRoot);
        HeProMoApplicationTreeNode nodeHackschnitzelTransportRoot = new HeProMoApplicationTreeNode(HackschnitzelTransport2018.class, GuiStrings.getString("MainWindow.menuWaldhackschnitzelTransport"), true);
        rootNodeAktuelleModelle.add(nodeHackschnitzelTransportRoot);
        HeProMoApplicationTreeNode nodeVorrueckenRoot = new HeProMoApplicationTreeNode(Vorruecken2018.class, GuiStrings.getString("MainWindow.menuFaellenUndVorruecken"), true);
        rootNodeAktuelleModelle.add(nodeVorrueckenRoot);
        HeProMoApplicationTreeNode nodeSchlepperRoot = new HeProMoApplicationTreeNode(Schlepper.class, "Schlepper 1980/1992", true);
        rootNodeAlteModelle.add(nodeSchlepperRoot);
        HeProMoApplicationTreeNode nodeSchlepper2014Root = new HeProMoApplicationTreeNode(Schlepper2014.class, GuiStrings.getString("MainWindow.menuSchlepper2014"), true);
        rootNodeAktuelleModelle.add(nodeSchlepper2014Root);
        HeProMoApplicationTreeNode nodeForwarderRoot = new HeProMoApplicationTreeNode(Forwarder.class, GuiStrings.getString("MainWindow.menuForwarder"), true);
        rootNodeAlteModelle.add(nodeForwarderRoot);
        HeProMoApplicationTreeNode nodeForwarderRundholz2018Root = new HeProMoApplicationTreeNode(ForwarderRundholz2018.class, GuiStrings.getString("MainWindow.menuForwarderNeuRundholz"), true);
        rootNodeAktuelleModelle.add(nodeForwarderRundholz2018Root);
        HeProMoApplicationTreeNode nodeForwarderEnergieholz2018Root = new HeProMoApplicationTreeNode(ForwarderEnergieholz2018.class, GuiStrings.getString("MainWindow.menuForwarderNeuEnergieholz"), true);
        rootNodeAktuelleModelle.add(nodeForwarderEnergieholz2018Root);
        rootNodeAktuelleModelle.add(new HeProMoApplicationTreeNode(KonventionellerSeilkranGesamt.class, GuiStrings.getString("MainWindow.menuKonventionellerSeilkran"), true));
        rootNodeAktuelleModelle.add(new HeProMoApplicationTreeNode(MobilseilkranGesamt.class, GuiStrings.getString("MainWindow.menuMobilseilkran"), true));
        HeProMoApplicationTreeNode nodeKombiseilgeraetRoot = new HeProMoApplicationTreeNode(Kombiseilgeraet2018.class, GuiStrings.getString("MainWindow.menuKombiseilgeraet"), true);
        rootNodeAktuelleModelle.add(nodeKombiseilgeraetRoot);
        rootNodeAktuelleModelle.add(new HeProMoApplicationTreeNode(HelikopterGesamt.class, GuiStrings.getString("MainWindow.menuHelikopter"), true));
        rootNodeBiomasse.add(new HeProMoApplicationTreeNode(Biomasseschaetzer2018.class, GuiStrings.getString("MainWindow.menuBiomasseschaetzer"), true));
        rootNodeBiomasse.add(new HeProMoApplicationTreeNode(BiomasseschaetzerEnergie2018.class, GuiStrings.getString("MainWindow.menuEnergieholzschaetzer"), true));
        rootNodeBiomasse.add(new HeProMoApplicationTreeNode(BiomasseschaetzerAbTarif2018.class, GuiStrings.getString("MainWindow.menuSchaftholzschaetzer"), true));
        if (locale.equals(new Locale("fr"))) {
            rootNodeAlteModelle.removeAllChildren();
            infoNode = new DefaultMutableTreeNode("<html><font color=\"gray\">mod\u00e8les seulement disponsible en allemand</font><html>");
            rootNodeAlteModelle.add(infoNode);
        }
        if (locale.equals(new Locale("it"))) {
            rootNodeAlteModelle.removeAllChildren();
            infoNode = new DefaultMutableTreeNode("<html><font color=\"gray\">Questi modelli sono disponibili solo in tedesco</font><html>");
            rootNodeAlteModelle.add(infoNode);
        }
        if (locale.equals(new Locale("en"))) {
            rootNodeAlteModelle.removeAllChildren();
            infoNode = new DefaultMutableTreeNode("<html><font color=\"gray\">these models are available in German only</font><html>");
            rootNodeAlteModelle.add(infoNode);
        }
        return rootNode;
    }

    private ImageIcon getWaitImage() {
        return MainWindow.getImageIcon("data/loadinganimation.gif");
    }

    public static ImageIcon getWslLogo() {
        return MainWindow.getImageIcon("data/WSL64.png");
    }

    private static ImageIcon getImageIcon(String filePath) {
        URL imgURL = MainWindow.class.getClassLoader().getResource(filePath);
        if (imgURL != null) {
            return new ImageIcon(imgURL);
        }
        return new ImageIcon(filePath);
    }

    private void changeLanguage(Locale locale) {
        if (!locale.equals(MainWindow.locale)) {
            MainWindow.setAllLocales(locale);
            MainWindow mainWindow = new MainWindow();
            mainWindow.setLocation(this.getLocation());
            this.dispose();
        }
    }

    private static void setAllLocales(Locale newLocale) {
        locale = newLocale;
        JComponent.setDefaultLocale(locale);
        GuiStrings.setLocale(locale);
        ModelStrings.setLocale(locale);
    }

    private String getHeProMoDate() {
        GregorianCalendar cal = new GregorianCalendar(2024, 7, 15);
        SimpleDateFormat sdf = new SimpleDateFormat("MMMM yyyy", locale);
        String hepromoDate = sdf.format(cal.getTime());
        return hepromoDate;
    }

    public static Locale getCurrentLocale() {
        return locale;
    }

    private class HeProMoApplicationTreeNode
    extends DefaultMutableTreeNode {
        private static final long serialVersionUID = 1L;
        private Class<?> clazz;
        private String label;
        private static final boolean labelAsHtmlLink = true;
        private boolean bold = false;

        public HeProMoApplicationTreeNode(Class<?> clazz, String label, boolean bold) {
            this.clazz = clazz;
            this.label = label;
            this.bold = bold;
        }

        public void run() {
            MainWindow.this.lblWait.setVisible(true);
            MainWindow.this.tree.setEnabled(false);
            SwingWorker<String, Integer> worker = new SwingWorker<String, Integer>(){

                @Override
                public String doInBackground() throws Exception {
                    try {
                        HeProMoApplicationTreeNode.this.clazz.newInstance();
                    }
                    catch (InstantiationException e) {
                        HeProMoExceptionHandler.handle(e);
                    }
                    catch (IllegalAccessException e) {
                        HeProMoExceptionHandler.handle(e);
                    }
                    catch (Exception e) {
                        HeProMoExceptionHandler.handle(e);
                    }
                    return null;
                }

                @Override
                public void done() {
                    MainWindow.this.lblWait.setVisible(false);
                    MainWindow.this.tree.setEnabled(true);
                }
            };
            worker.execute();
        }

        @Override
        public String toString() {
            if (MainWindow.this.lblWait != null && MainWindow.this.lblWait.isVisible()) {
                return this.label;
            }
            if (!this.bold) {
                return "<html><a href=\"\">" + this.label + "</a></html>";
            }
            if (this.bold) {
                return "<html><a href=\"\"><b>" + this.label + "</b></a></html>";
            }
            return this.label;
        }
    }

    private class InfoTreeNode
    extends DefaultMutableTreeNode {
        private static final long serialVersionUID = 1L;
        private final String label;
        private final String tooltip;

        public InfoTreeNode(String label, String tooltip) {
            this.label = label;
            this.tooltip = tooltip;
        }

        public String getToolTip() {
            return this.tooltip;
        }

        @Override
        public String toString() {
            if (MainWindow.this.lblWait != null && MainWindow.this.lblWait.isVisible()) {
                return this.label;
            }
            return "<html><nobr>" + this.label + "</nobr></html>";
        }
    }
}

