/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.hepromo.gui;

import java.net.URL;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public class GuiStrings {
    private static final String BUNDLE_NAME = "ch.wsl.fps.hepromo.gui.guistrings";
    private static ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle("ch.wsl.fps.hepromo.gui.guistrings", new Locale("de"));
    private static ImageIcon imageIconBlue = null;
    private static ImageIcon imageIconGrey = null;
    private static ImageIcon imageIconRed = null;

    public static JLabel getInfoButtonBlue(String text) {
        JLabel label = new JLabel(GuiStrings.getInfoIconBlue());
        label.setToolTipText(text);
        return label;
    }

    public static JLabel getInfoButtonGrey(String text) {
        JLabel label = new JLabel(GuiStrings.getInfoIconGrey());
        label.setToolTipText(text);
        return label;
    }

    public static JLabel getInfoButtonRed(String text) {
        JLabel label = new JLabel(GuiStrings.getInfoIconRed());
        label.setToolTipText(text);
        return label;
    }

    private static ImageIcon getInfoIconBlue() {
        if (imageIconBlue != null) {
            return imageIconBlue;
        }
        String filePath = "data/info.png";
        URL imgURL = GuiStrings.class.getClassLoader().getResource(filePath);
        if (imgURL != null) {
            imageIconBlue = new ImageIcon(imgURL);
            return imageIconBlue;
        }
        imageIconBlue = new ImageIcon(filePath);
        return imageIconBlue;
    }

    private static ImageIcon getInfoIconGrey() {
        if (imageIconGrey != null) {
            return imageIconGrey;
        }
        String filePath = "data/infoGrey.png";
        URL imgURL = GuiStrings.class.getClassLoader().getResource(filePath);
        if (imgURL != null) {
            imageIconGrey = new ImageIcon(imgURL);
            return imageIconGrey;
        }
        imageIconGrey = new ImageIcon(filePath);
        return imageIconGrey;
    }

    private static ImageIcon getInfoIconRed() {
        if (imageIconRed != null) {
            return imageIconRed;
        }
        String filePath = "data/info2.png";
        URL imgURL = GuiStrings.class.getClassLoader().getResource(filePath);
        if (imgURL != null) {
            imageIconRed = new ImageIcon(imgURL);
            return imageIconRed;
        }
        imageIconRed = new ImageIcon(filePath);
        return imageIconRed;
    }

    public static String getString(String key) {
        try {
            return RESOURCE_BUNDLE.getString(key);
        }
        catch (MissingResourceException e) {
            System.err.println("key not found: " + key);
            return "XXXXXXXX";
        }
    }

    public static void setLocale(Locale locale) {
        RESOURCE_BUNDLE = ResourceBundle.getBundle(BUNDLE_NAME, locale);
    }
}

