/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.hepromo.gui;

import ch.wsl.fps.hepromo.gui.AbstractErgebnisPanel;
import ch.wsl.fps.hepromo.gui.GuiStrings;
import ch.wsl.fps.hepromo.gui.TitledBorderFactory;
import ch.wsl.fps.hepromo.gui.ValueAndUnitLabel;
import ch.wsl.fps.hepromo.model.Ergebnis;
import ch.wsl.fps.hepromo.model.ErgebnisHelikopterFliegen;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class ErgebnisPanel
extends AbstractErgebnisPanel {
    private static final long serialVersionUID = 1L;
    public static final Color ERGEBNIS_PANEL_BACKGROUND_COLOR = new Color(255, 255, 225);
    private JLabel lblPersonal = new JLabel(GuiStrings.getString("ErgebnisPanel.Personal"));
    private JLabel lblMaschine1 = new JLabel(GuiStrings.getString("ErgebnisPanel.Maschine1"));
    private JLabel lblMaschine2 = new JLabel(GuiStrings.getString("ErgebnisPanel.Maschine2"));
    private JLabel lblMaschine3 = new JLabel(GuiStrings.getString("ErgebnisPanel.Maschine3"));
    private JLabel lblUmsetzen = new JLabel(GuiStrings.getString("ErgebnisPanel.Umsetzen"));
    private JLabel lblDauerDerArbeit;
    private JTextField txtZeitDauerDerArbeit;
    private JLabel lblZeitDauerDerArbeit;
    private JLabel lblZeitDauerDerArbeit_Info;
    private JTextField txtZeitPersonal = new JTextField();
    private JTextField txtZeitMaschine1 = new JTextField();
    private JTextField txtZeitMaschine2 = new JTextField();
    private JLabel lblZeitMaschine2;
    private JLabel lblZeitMaschine2_Info;
    private JTextField txtZeitMaschine3 = new JTextField();
    private JTextField txtZeitUmsetzen = new JTextField();
    private JTextField txtZeitWeitereAufwaende;
    private JTextField txtKostenPersonal_proM3 = new JTextField();
    private JTextField txtKostenMaschine1_proM3 = new JTextField();
    private JTextField txtKostenMaschine2_proM3 = new JTextField();
    private JTextField txtKostenMaschine3_proM3 = new JTextField();
    private JTextField txtKostenUmsetzen_proM3 = new JTextField();
    private JTextField txtKostenWeitereAufwaende_proM3 = new JTextField();
    private JTextField txtKostenTotal_proM3 = new JTextField();
    private JTextField txtKostenPersonal_total = new JTextField();
    private JTextField txtKostenMaschine1_total = new JTextField();
    private JTextField txtKostenMaschine2_total = new JTextField();
    private JTextField txtKostenMaschine3_total = new JTextField();
    private JTextField txtKostenUmsetzen_total = new JTextField();
    private JTextField txtKostenWeitereAufwaende_total;
    private JTextField txtKostenTotal_total;
    private JTextField txtProduktivitaet = new JTextField();
    protected JLabel lblRotationszeit;
    protected JTextField txtRotationszeit = new JTextField();
    private JLabel lblKostenproM3 = new JLabel(GuiStrings.getString("ErgebnisPanel.pro_m3"));
    private JLabel lblProduktivitaet = new JLabel(GuiStrings.getString("ErgebnisPanel.Produktivitaet_m3_pro_PSH15"));
    private JLabel lblProduktivitaet_Info;
    private final ValueAndUnitLabel lblProduktivitaet2 = new ValueAndUnitLabel();
    private final boolean enableRowPersonal;
    private final boolean enableRowMaschine1;
    private final boolean enableRowMaschine2;
    private final boolean enableRowMaschine3;
    private final boolean enableRowUmsetzen;
    private final boolean enableRowProduktivitaet;
    private final boolean enableRowRotationszeit;
    private final boolean enableColumnProM3;
    private final boolean showHintKostenProM3;
    private final boolean showHintProduktivitaet;

    protected ErgebnisPanel(Builder builder) {
        this.enableRowPersonal = builder.enableRowPersonal;
        this.enableRowMaschine1 = builder.enableRowMaschine1;
        this.enableRowMaschine2 = builder.enableRowMaschine2;
        this.enableRowMaschine3 = builder.enableRowMaschine3;
        this.enableRowUmsetzen = builder.enableRowUmsetzen;
        this.enableRowProduktivitaet = builder.enableRowProduktivitaet;
        this.enableRowRotationszeit = builder.enableRowRotationszeit;
        this.enableColumnProM3 = builder.enableColumnProM3;
        this.showHintKostenProM3 = builder.showHintKostenProM3;
        this.showHintProduktivitaet = builder.showHintProduktivitaet;
        this.setBorder(TitledBorderFactory.createTitledBorderBold(GuiStrings.getString("ErgebnisPanel.Title")));
        this.setBackground(ERGEBNIS_PANEL_BACKGROUND_COLOR);
        this.initContent();
    }

    @Override
    protected JPanel initPanelTitles() {
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        panel.setLayout(new GridBagLayout());
        Insets standardInsets = new Insets(4, 0, 2, 0);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 1;
        c.weightx = 100.0;
        c.insets = new Insets(19, 0, 2, 0);
        this.lblDauerDerArbeit = new JLabel(GuiStrings.getString("ErgebnisPanel.DauerDerArbeit"));
        panel.add((Component)this.lblDauerDerArbeit, c);
        if (this.enableRowPersonal) {
            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 1;
            c.fill = 1;
            c.weightx = 100.0;
            c.insets = standardInsets;
            panel.add((Component)this.lblPersonal, c);
        }
        if (this.enableRowMaschine1) {
            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 2;
            c.fill = 1;
            c.weightx = 100.0;
            c.insets = standardInsets;
            panel.add((Component)this.lblMaschine1, c);
        }
        if (this.enableRowMaschine2) {
            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 3;
            c.fill = 1;
            c.weightx = 100.0;
            c.insets = standardInsets;
            panel.add((Component)this.lblMaschine2, c);
        }
        if (this.enableRowMaschine3) {
            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 4;
            c.fill = 1;
            c.weightx = 100.0;
            c.insets = standardInsets;
            panel.add((Component)this.lblMaschine3, c);
        }
        if (this.enableRowUmsetzen) {
            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 5;
            c.fill = 1;
            c.weightx = 100.0;
            c.insets = standardInsets;
            panel.add((Component)this.lblUmsetzen, c);
        }
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 6;
        c.fill = 1;
        c.weightx = 100.0;
        c.insets = standardInsets;
        JLabel lblWeitereAufwaende = new JLabel(GuiStrings.getString("ErgebnisPanel.WeitereAufwaende"));
        panel.add((Component)lblWeitereAufwaende, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 7;
        c.fill = 1;
        c.weightx = 100.0;
        c.insets = standardInsets;
        JLabel lblTotal = new JLabel(GuiStrings.getString("ErgebnisPanel.Total"));
        panel.add((Component)lblTotal, c);
        return panel;
    }

    @Override
    protected JPanel initPanelZeitaufwand() {
        JPanel panel = new JPanel();
        panel.setBorder(TitledBorderFactory.createTitledBorder(GuiStrings.getString("ErgebnisPanel.ZeitaufwandStd")));
        panel.setOpaque(false);
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 1;
        c.weightx = 100.0;
        this.txtZeitDauerDerArbeit = ErgebnisPanel.getNewLockedTextField();
        panel.add((Component)this.txtZeitDauerDerArbeit, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 0;
        c.anchor = 17;
        c.insets = new Insets(0, 5, 0, 0);
        this.lblZeitDauerDerArbeit = new JLabel("WPSH");
        panel.add((Component)this.lblZeitDauerDerArbeit, c);
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = 0;
        c.insets = new Insets(0, 15, 0, 5);
        this.lblZeitDauerDerArbeit_Info = GuiStrings.getInfoButtonBlue(GuiStrings.getString("ErgebnisPanel.InfoButtonWPSH"));
        panel.add((Component)this.lblZeitDauerDerArbeit_Info, c);
        if (this.enableRowPersonal) {
            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 1;
            c.fill = 1;
            c.weightx = 100.0;
            this.txtZeitPersonal = ErgebnisPanel.getNewLockedTextField();
            panel.add((Component)this.txtZeitPersonal, c);
            c = new GridBagConstraints();
            c.gridx = 1;
            c.gridy = 1;
            c.anchor = 17;
            c.insets = new Insets(0, 5, 0, 0);
            JLabel lblZeitPersonal = new JLabel("WPPH");
            panel.add((Component)lblZeitPersonal, c);
            c = new GridBagConstraints();
            c.gridx = 2;
            c.gridy = 1;
            c.insets = new Insets(0, 15, 0, 5);
            JLabel lblZeitPersonal_Info = GuiStrings.getInfoButtonBlue(GuiStrings.getString("ErgebnisPanel.InfoButtonWPPH"));
            panel.add((Component)lblZeitPersonal_Info, c);
        }
        if (this.enableRowMaschine1) {
            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 2;
            c.fill = 1;
            c.weightx = 100.0;
            this.txtZeitMaschine1 = ErgebnisPanel.getNewLockedTextField();
            panel.add((Component)this.txtZeitMaschine1, c);
            c = new GridBagConstraints();
            c.gridx = 1;
            c.gridy = 2;
            c.anchor = 17;
            c.insets = new Insets(0, 5, 0, 0);
            JLabel lblZeitMaschine1 = new JLabel("PMH15");
            panel.add((Component)lblZeitMaschine1, c);
            c = new GridBagConstraints();
            c.gridx = 2;
            c.gridy = 2;
            c.insets = new Insets(0, 15, 0, 5);
            JLabel lblZeitMaschine1_Info = GuiStrings.getInfoButtonBlue(GuiStrings.getString("ErgebnisPanel.InfoButtonPMH15"));
            panel.add((Component)lblZeitMaschine1_Info, c);
        }
        if (this.enableRowMaschine2) {
            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 3;
            c.fill = 1;
            c.weightx = 100.0;
            this.txtZeitMaschine2 = ErgebnisPanel.getNewLockedTextField();
            panel.add((Component)this.txtZeitMaschine2, c);
            c = new GridBagConstraints();
            c.gridx = 1;
            c.gridy = 3;
            c.anchor = 17;
            c.insets = new Insets(0, 5, 0, 0);
            this.lblZeitMaschine2 = new JLabel("PMH15");
            panel.add((Component)this.lblZeitMaschine2, c);
            c = new GridBagConstraints();
            c.gridx = 2;
            c.gridy = 3;
            c.insets = new Insets(0, 15, 0, 5);
            this.lblZeitMaschine2_Info = GuiStrings.getInfoButtonBlue(GuiStrings.getString("ErgebnisPanel.InfoButtonPMH15"));
            panel.add((Component)this.lblZeitMaschine2_Info, c);
        }
        if (this.enableRowMaschine3) {
            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 4;
            c.fill = 1;
            c.weightx = 100.0;
            this.txtZeitMaschine3 = ErgebnisPanel.getNewLockedTextField();
            panel.add((Component)this.txtZeitMaschine3, c);
            c = new GridBagConstraints();
            c.gridx = 1;
            c.gridy = 4;
            c.anchor = 17;
            c.insets = new Insets(0, 5, 0, 0);
            JLabel lblZeitMaschine3 = new JLabel("PMH15");
            panel.add((Component)lblZeitMaschine3, c);
            c = new GridBagConstraints();
            c.gridx = 2;
            c.gridy = 4;
            c.insets = new Insets(0, 15, 0, 5);
            JLabel lblZeitMaschine3_Info = GuiStrings.getInfoButtonBlue(GuiStrings.getString("ErgebnisPanel.InfoButtonPMH15"));
            panel.add((Component)lblZeitMaschine3_Info, c);
        }
        if (this.enableRowUmsetzen) {
            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 5;
            c.fill = 1;
            c.weightx = 100.0;
            this.txtZeitUmsetzen = ErgebnisPanel.getNewLockedTextField();
            panel.add((Component)this.txtZeitUmsetzen, c);
            c = new GridBagConstraints();
            c.gridx = 1;
            c.gridy = 5;
            c.anchor = 17;
            c.insets = new Insets(0, 5, 0, 0);
            JLabel lblZeitUmsetzen = new JLabel("WPPH");
            panel.add((Component)lblZeitUmsetzen, c);
            c = new GridBagConstraints();
            c.gridx = 2;
            c.gridy = 5;
            c.insets = new Insets(0, 15, 0, 5);
            JLabel lblZeitUmsetzen_Info = GuiStrings.getInfoButtonBlue(GuiStrings.getString("ErgebnisPanel.InfoButtonWPPH"));
            panel.add((Component)lblZeitUmsetzen_Info, c);
        }
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 6;
        c.fill = 1;
        c.weightx = 100.0;
        this.txtZeitWeitereAufwaende = ErgebnisPanel.getNewLockedTextField();
        panel.add((Component)this.txtZeitWeitereAufwaende, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 6;
        c.anchor = 17;
        c.insets = new Insets(0, 5, 0, 0);
        JLabel lblZeitWeitereAufwaende = new JLabel("WPPH");
        panel.add((Component)lblZeitWeitereAufwaende, c);
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = 6;
        c.insets = new Insets(0, 15, 0, 5);
        JLabel lblZeitWeitereAufwaende_Info = GuiStrings.getInfoButtonBlue(GuiStrings.getString("ErgebnisPanel.InfoButtonWPPH"));
        panel.add((Component)lblZeitWeitereAufwaende_Info, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 7;
        c.fill = 1;
        c.weightx = 100.0;
        JLabel lblZeitTotal = new JLabel(" ");
        panel.add((Component)lblZeitTotal, c);
        return panel;
    }

    @Override
    protected JPanel initPanelKosten() {
        GridBagConstraints c;
        JPanel panel = new JPanel();
        panel.setBorder(TitledBorderFactory.createTitledBorder(GuiStrings.getString("ErgebnisPanel.Kosten_SFr")));
        panel.setOpaque(false);
        panel.setLayout(new GridBagLayout());
        if (this.enableColumnProM3) {
            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 0;
            c.fill = 1;
            c.weightx = 50.0;
            c.insets = new Insets(7, 0, 3, 0);
            this.lblKostenproM3.setHorizontalAlignment(4);
            panel.add((Component)this.lblKostenproM3, c);
            c = new GridBagConstraints();
            c.gridx = 1;
            c.gridy = 0;
            c.fill = 1;
            c.weightx = 50.0;
            c.insets = new Insets(2, 5, 0, 5);
            JLabel lblKostenProM3_Info = this.showHintKostenProM3 ? GuiStrings.getInfoButtonRed(GuiStrings.getString("ErgebnisPanel.InfoButtonKostenProM3")) : new JLabel();
            lblKostenProM3_Info.setHorizontalAlignment(2);
            panel.add((Component)lblKostenProM3_Info, c);
        }
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = 0;
        c.fill = 1;
        c.weightx = 100.0;
        c.insets = new Insets(7, 0, 3, 0);
        JLabel lblTotal = new JLabel(GuiStrings.getString("ErgebnisPanel.total"));
        lblTotal.setHorizontalAlignment(0);
        panel.add((Component)lblTotal, c);
        if (this.enableColumnProM3) {
            if (this.enableRowPersonal) {
                c = new GridBagConstraints();
                c.gridx = 0;
                c.gridy = 1;
                c.gridwidth = 2;
                c.fill = 1;
                c.weightx = 100.0;
                this.txtKostenPersonal_proM3 = ErgebnisPanel.getNewLockedTextField();
                panel.add((Component)this.txtKostenPersonal_proM3, c);
            }
            if (this.enableRowMaschine1) {
                c = new GridBagConstraints();
                c.gridx = 0;
                c.gridy = 2;
                c.gridwidth = 2;
                c.fill = 1;
                c.weightx = 100.0;
                this.txtKostenMaschine1_proM3 = ErgebnisPanel.getNewLockedTextField();
                panel.add((Component)this.txtKostenMaschine1_proM3, c);
            }
            if (this.enableRowMaschine2) {
                c = new GridBagConstraints();
                c.gridx = 0;
                c.gridy = 3;
                c.gridwidth = 2;
                c.fill = 1;
                c.weightx = 100.0;
                this.txtKostenMaschine2_proM3 = ErgebnisPanel.getNewLockedTextField();
                panel.add((Component)this.txtKostenMaschine2_proM3, c);
            }
            if (this.enableRowMaschine3) {
                c = new GridBagConstraints();
                c.gridx = 0;
                c.gridy = 4;
                c.gridwidth = 2;
                c.fill = 1;
                c.weightx = 100.0;
                this.txtKostenMaschine3_proM3 = ErgebnisPanel.getNewLockedTextField();
                panel.add((Component)this.txtKostenMaschine3_proM3, c);
            }
            if (this.enableRowUmsetzen) {
                c = new GridBagConstraints();
                c.gridx = 0;
                c.gridy = 5;
                c.gridwidth = 2;
                c.fill = 1;
                c.weightx = 100.0;
                this.txtKostenUmsetzen_proM3 = ErgebnisPanel.getNewLockedTextField();
                panel.add((Component)this.txtKostenUmsetzen_proM3, c);
            }
            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 6;
            c.gridwidth = 2;
            c.fill = 1;
            c.weightx = 100.0;
            this.txtKostenWeitereAufwaende_proM3 = ErgebnisPanel.getNewLockedTextField();
            panel.add((Component)this.txtKostenWeitereAufwaende_proM3, c);
            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 7;
            c.gridwidth = 2;
            c.fill = 1;
            c.weightx = 100.0;
            this.txtKostenTotal_proM3 = ErgebnisPanel.getNewLockedTextField();
            this.txtKostenTotal_proM3.setFont(this.txtKostenTotal_proM3.getFont().deriveFont(1));
            panel.add((Component)this.txtKostenTotal_proM3, c);
        }
        if (this.enableRowPersonal) {
            c = new GridBagConstraints();
            c.gridx = 2;
            c.gridy = 1;
            c.fill = 1;
            c.weightx = 100.0;
            this.txtKostenPersonal_total = ErgebnisPanel.getNewLockedTextField();
            panel.add((Component)this.txtKostenPersonal_total, c);
        }
        if (this.enableRowMaschine1) {
            c = new GridBagConstraints();
            c.gridx = 2;
            c.gridy = 2;
            c.fill = 1;
            c.weightx = 100.0;
            this.txtKostenMaschine1_total = ErgebnisPanel.getNewLockedTextField();
            panel.add((Component)this.txtKostenMaschine1_total, c);
        }
        if (this.enableRowMaschine2) {
            c = new GridBagConstraints();
            c.gridx = 2;
            c.gridy = 3;
            c.fill = 1;
            c.weightx = 100.0;
            this.txtKostenMaschine2_total = ErgebnisPanel.getNewLockedTextField();
            panel.add((Component)this.txtKostenMaschine2_total, c);
        }
        if (this.enableRowMaschine3) {
            c = new GridBagConstraints();
            c.gridx = 2;
            c.gridy = 4;
            c.fill = 1;
            c.weightx = 100.0;
            this.txtKostenMaschine3_total = ErgebnisPanel.getNewLockedTextField();
            panel.add((Component)this.txtKostenMaschine3_total, c);
        }
        if (this.enableRowUmsetzen) {
            c = new GridBagConstraints();
            c.gridx = 2;
            c.gridy = 5;
            c.fill = 1;
            c.weightx = 100.0;
            this.txtKostenUmsetzen_total = ErgebnisPanel.getNewLockedTextField();
            panel.add((Component)this.txtKostenUmsetzen_total, c);
        }
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = 6;
        c.fill = 1;
        c.weightx = 100.0;
        this.txtKostenWeitereAufwaende_total = ErgebnisPanel.getNewLockedTextField();
        panel.add((Component)this.txtKostenWeitereAufwaende_total, c);
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = 7;
        c.fill = 1;
        c.weightx = 100.0;
        this.txtKostenTotal_total = ErgebnisPanel.getNewLockedTextField();
        panel.add((Component)this.txtKostenTotal_total, c);
        return panel;
    }

    @Override
    protected JPanel initPanelProduktivitaetUndRotationszeit() {
        JPanel pnlPlaceholder;
        GridBagConstraints c;
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        panel.setLayout(new GridBagLayout());
        if (this.enableRowProduktivitaet) {
            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 0;
            c.fill = 1;
            if (!this.showHintProduktivitaet) {
                c.weightx = 50.0;
            }
            this.lblProduktivitaet.setName("lblProduktivitaet");
            panel.add((Component)this.lblProduktivitaet, c);
            if (this.showHintProduktivitaet) {
                c = new GridBagConstraints();
                c.gridx = 1;
                c.gridy = 0;
                c.fill = 1;
                c.weightx = 50.0;
                c.insets = new Insets(2, 5, 0, 5);
                this.lblProduktivitaet_Info = GuiStrings.getInfoButtonRed(GuiStrings.getString("ErgebnisPanel.InfoButtonProduktivitaet"));
                this.lblProduktivitaet_Info.setHorizontalAlignment(2);
                panel.add((Component)this.lblProduktivitaet_Info, c);
            }
            c = new GridBagConstraints();
            c.gridx = 2;
            c.gridy = 0;
            c.fill = 1;
            c.weightx = 50.0;
            this.txtProduktivitaet = ErgebnisPanel.getNewLockedTextField();
            this.txtProduktivitaet.setName("txtProduktivitaet");
            panel.add((Component)this.txtProduktivitaet, c);
            c = new GridBagConstraints();
            c.gridx = 3;
            c.gridy = 0;
            c.insets = new Insets(0, 15, 0, 0);
            c.anchor = 17;
            this.lblProduktivitaet2.setName("lblProduktivitaet2");
            panel.add((Component)this.lblProduktivitaet2, c);
        }
        if (!this.enableRowRotationszeit) {
            c = new GridBagConstraints();
            c.gridx = 3;
            c.gridy = 0;
            c.fill = 1;
            c.weightx = 200.0;
            pnlPlaceholder = new JPanel();
            pnlPlaceholder.setOpaque(false);
            panel.add((Component)pnlPlaceholder, c);
        }
        if (this.enableRowProduktivitaet && this.enableRowRotationszeit) {
            c = new GridBagConstraints();
            c.gridx = 3;
            c.gridy = 0;
            c.fill = 1;
            c.weightx = 250.0;
            pnlPlaceholder = new JPanel();
            pnlPlaceholder.setOpaque(false);
            panel.add((Component)pnlPlaceholder, c);
        }
        if (this.enableRowRotationszeit) {
            c = new GridBagConstraints();
            c.gridx = 4;
            c.gridy = 0;
            c.fill = 1;
            c.weightx = 100.0;
            this.lblRotationszeit = new JLabel(GuiStrings.getString("ErgebnisPanel.Rotationszeit_MinProRot"));
            panel.add((Component)this.lblRotationszeit, c);
            c = new GridBagConstraints();
            c.gridx = 5;
            c.gridy = 0;
            c.fill = 1;
            c.weightx = 100.0;
            this.txtRotationszeit = ErgebnisPanel.getNewLockedTextField();
            panel.add((Component)this.txtRotationszeit, c);
        }
        return panel;
    }

    public void setTitle(String title) {
        TitledBorder border = (TitledBorder)this.getBorder();
        border.setTitle(title);
    }

    @Override
    public void setErgebnis(Ergebnis ergebnis) {
        this.setLabels(ergebnis);
        this.txtZeitDauerDerArbeit.setText(this.parseDouble(ergebnis.getZeitTotal()));
        this.txtZeitPersonal.setText(this.parseDouble(ergebnis.getZeitPersonal()));
        this.txtZeitMaschine1.setText(this.parseDouble(ergebnis.getZeitMaschine1()));
        this.txtZeitMaschine2.setText(this.parseDouble(ergebnis.getZeitMaschine2()));
        this.txtZeitMaschine3.setText(this.parseDouble(ergebnis.getZeitMaschine3()));
        this.txtZeitUmsetzen.setText(this.parseDouble(ergebnis.getZeitUmsetzen()));
        this.txtZeitWeitereAufwaende.setText(this.parseDouble(ergebnis.getZeitWeitereAufwaende()));
        this.txtKostenPersonal_proM3.setText(this.parseDouble(ergebnis.getKostenPersonal_proM3()));
        this.txtKostenMaschine1_proM3.setText(this.parseDouble(ergebnis.getKostenMaschine1_proM3()));
        this.txtKostenMaschine2_proM3.setText(this.parseDouble(ergebnis.getKostenMaschine2_proM3()));
        this.txtKostenMaschine3_proM3.setText(this.parseDouble(ergebnis.getKostenMaschine3_proM3()));
        this.txtKostenUmsetzen_proM3.setText(this.parseDouble(ergebnis.getKostenUmsetzen_proM3()));
        this.txtKostenWeitereAufwaende_proM3.setText(this.parseDouble(ergebnis.getKostenWeitereAufwaende_proM3()));
        this.txtKostenTotal_proM3.setText(this.parseDouble(ergebnis.getKostenTotal_proM3()));
        this.txtKostenPersonal_total.setText(this.parseDouble(ergebnis.getKostenPersonal_total()));
        this.txtKostenMaschine1_total.setText(this.parseDouble(ergebnis.getKostenMaschine1_total()));
        this.txtKostenMaschine2_total.setText(this.parseDouble(ergebnis.getKostenMaschine2_total()));
        this.txtKostenMaschine3_total.setText(this.parseDouble(ergebnis.getKostenMaschine3_total()));
        this.txtKostenUmsetzen_total.setText(this.parseDouble(ergebnis.getKostenUmsetzen_total()));
        this.txtKostenWeitereAufwaende_total.setText(this.parseDouble(ergebnis.getKostenWeitereAufwaende_total()));
        this.txtKostenTotal_total.setText(this.parseDouble(ergebnis.getKostenTotal_total()));
        this.txtProduktivitaet.setText(this.parseDouble(ergebnis.getProduktivitaet()));
        if (ergebnis.getProduktivitaet() == -1.0) {
            this.txtProduktivitaet.setText("-");
        }
        if (ergebnis.getProduktivitaet2() > 0.0) {
            this.lblProduktivitaet2.setValue(ergebnis.getProduktivitaet2());
        } else {
            this.lblProduktivitaet2.setValue(null);
        }
        if (ergebnis instanceof ErgebnisHelikopterFliegen) {
            this.txtRotationszeit.setText(this.parseDouble(((ErgebnisHelikopterFliegen)ergebnis).getRotationszeit()));
        }
    }

    private void setLabels(Ergebnis ergebnis) {
        this.lblPersonal.setText(this.setFirstLetterOfStringToUpperCase(ergebnis.getLabelPersonal1()));
        this.lblMaschine1.setText(this.setFirstLetterOfStringToUpperCase(ergebnis.getLabelMaschine1()));
        this.lblMaschine2.setText(this.setFirstLetterOfStringToUpperCase(ergebnis.getLabelMaschine2()));
        this.lblMaschine3.setText(this.setFirstLetterOfStringToUpperCase(ergebnis.getLabelMaschine3()));
    }

    private String setFirstLetterOfStringToUpperCase(String inputString) {
        if (inputString == null || inputString.isEmpty()) {
            return inputString;
        }
        String result = String.valueOf(inputString.substring(0, 1).toUpperCase()) + inputString.substring(1, inputString.length());
        return result;
    }

    @Override
    public void setDecimalFormat(DecimalFormat decimalFormat) {
        super.setDecimalFormat(decimalFormat);
        this.lblProduktivitaet2.setDecimalFormat(decimalFormat);
    }

    public void setZeitMaschine2Unit(String label) {
        this.lblZeitMaschine2.setText(label);
    }

    public void setZeitMaschine2UnitInfo(String label) {
        this.lblZeitMaschine2_Info.setToolTipText(label);
    }

    public void setLabelUmsetzen(String label) {
        this.lblUmsetzen.setText(label);
    }

    public void setLabelKostenProM3(String label) {
        this.lblKostenproM3.setText(label);
    }

    public void setLabelProduktivitaet(String label) {
        this.lblProduktivitaet.setText(label);
    }

    public void setLabelProduktivitaet2(String label) {
        this.lblProduktivitaet2.setUnit(label);
    }

    public void setHintProduktivitaet(String text) {
        this.lblProduktivitaet_Info.setToolTipText(text);
    }

    public void hideDauerDerArbeit() {
        this.lblDauerDerArbeit.setForeground(this.getBackground());
        this.txtZeitDauerDerArbeit.setEnabled(false);
        this.txtZeitDauerDerArbeit.setForeground(this.getBackground());
        this.txtZeitDauerDerArbeit.setBackground(this.getBackground());
        this.txtZeitDauerDerArbeit.setBorder(BorderFactory.createEmptyBorder());
        this.txtZeitDauerDerArbeit.setDisabledTextColor(this.getBackground());
        this.lblZeitDauerDerArbeit.setVisible(false);
        this.lblZeitDauerDerArbeit_Info.setVisible(false);
    }

    public static class Builder {
        private boolean enableRowPersonal;
        private boolean enableRowMaschine1;
        private boolean enableRowMaschine2;
        private boolean enableRowMaschine3;
        private boolean enableRowUmsetzen;
        private boolean enableRowProduktivitaet;
        private boolean enableRowRotationszeit;
        private boolean enableColumnProM3;
        private boolean showHintKostenProM3;
        private boolean showHintProduktivitaet;

        public Builder enableRowPersonal() {
            this.enableRowPersonal = true;
            return this;
        }

        public Builder enableRowMaschine1() {
            this.enableRowMaschine1 = true;
            return this;
        }

        public Builder enableRowMaschine2() {
            this.enableRowMaschine2 = true;
            return this;
        }

        public Builder enableRowMaschine3() {
            this.enableRowMaschine3 = true;
            return this;
        }

        public Builder enableRowUmsetzen() {
            this.enableRowUmsetzen = true;
            return this;
        }

        public Builder enableRowProduktivitaet() {
            this.enableRowProduktivitaet = true;
            return this;
        }

        public Builder enableRowRotationszeit() {
            this.enableRowRotationszeit = true;
            return this;
        }

        public Builder enableColumnProM3() {
            this.enableColumnProM3 = true;
            return this;
        }

        public Builder showHintKostenProM3() {
            this.showHintKostenProM3 = true;
            return this;
        }

        public Builder showHintProduktivitaet() {
            this.showHintProduktivitaet = true;
            return this;
        }

        public ErgebnisPanel build() {
            return new ErgebnisPanel(this);
        }
    }
}

