/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.hepromo.gui;

import ch.wsl.fps.hepromo.gui.GuiStrings;
import ch.wsl.fps.hepromo.gui.HeProMoWindow2014;
import ch.wsl.fps.hepromo.model.modelle.AbstractModel;
import ch.wsl.fps.hepromo.model.modelle.ModelForwarder;
import ch.wsl.fps.hepromo.model.modelle.ModelForwarder2018;
import ch.wsl.fps.hepromo.model.modelle.ModelHacker2018;
import ch.wsl.fps.hepromo.model.modelle.ModelHackschnitzelTransport2018;
import ch.wsl.fps.hepromo.model.modelle.ModelHelikopterAufarbeiten;
import ch.wsl.fps.hepromo.model.modelle.ModelHelikopterFliegen;
import ch.wsl.fps.hepromo.model.modelle.ModelHelikopterGesamt;
import ch.wsl.fps.hepromo.model.modelle.ModelKombiseilgeraet2018;
import ch.wsl.fps.hepromo.model.modelle.ModelKonventionellerSeilkranDemontage;
import ch.wsl.fps.hepromo.model.modelle.ModelKonventionellerSeilkranGesamt;
import ch.wsl.fps.hepromo.model.modelle.ModelKonventionellerSeilkranLagerplatz;
import ch.wsl.fps.hepromo.model.modelle.ModelKonventionellerSeilkranMontage;
import ch.wsl.fps.hepromo.model.modelle.ModelKonventionellerSeilkranPlanung;
import ch.wsl.fps.hepromo.model.modelle.ModelKonventionellerSeilkranSeilen;
import ch.wsl.fps.hepromo.model.modelle.ModelMobilerHacker;
import ch.wsl.fps.hepromo.model.modelle.ModelMobilseilkranGesamt;
import ch.wsl.fps.hepromo.model.modelle.ModelMobilseilkranInstallation;
import ch.wsl.fps.hepromo.model.modelle.ModelMobilseilkranLagerplatz;
import ch.wsl.fps.hepromo.model.modelle.ModelMobilseilkranPlanung;
import ch.wsl.fps.hepromo.model.modelle.ModelMobilseilkranSeilen;
import ch.wsl.fps.hepromo.model.modelle.ModelMotormanuellEntasten;
import ch.wsl.fps.hepromo.model.modelle.ModelMotormanuellEntrindenMitBiber;
import ch.wsl.fps.hepromo.model.modelle.ModelMotormanuellEntrindenVonHand;
import ch.wsl.fps.hepromo.model.modelle.ModelMotormanuellFaellen;
import ch.wsl.fps.hepromo.model.modelle.ModelMotormanuellGesamt;
import ch.wsl.fps.hepromo.model.modelle.ModelMotormanuellGesamt2014;
import ch.wsl.fps.hepromo.model.modelle.ModelMotormanuellIhLangAufarbeiten;
import ch.wsl.fps.hepromo.model.modelle.ModelMotormanuellSchichtholzAufarbeiten;
import ch.wsl.fps.hepromo.model.modelle.ModelMotormanuellStammholzAufarbeiten;
import ch.wsl.fps.hepromo.model.modelle.ModelRadharvester;
import ch.wsl.fps.hepromo.model.modelle.ModelRadharvester2014;
import ch.wsl.fps.hepromo.model.modelle.ModelSchlepper;
import ch.wsl.fps.hepromo.model.modelle.ModelSchlepper2014;
import ch.wsl.fps.hepromo.model.modelle.ModelVorruecken2018;
import java.awt.Component;
import java.awt.Desktop;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;

public class DocumentationBroker {
    public static final String DOKU_DIR = "Dokumentation/";
    protected static final HashMap<Object, String[]> filenames = new HashMap();

    static {
        filenames.put(ModelMotormanuellGesamt2014.class, new String[]{"Motormanuell2014A.pdf", "Motormanuell2014B.pdf"});
        filenames.put(ModelRadharvester2014.class, new String[]{"Radharvester2014A.pdf", "Radharvester2014B.pdf"});
        filenames.put(ModelSchlepper2014.class, new String[]{"Schlepper2014A.pdf", "Schlepper2014B.pdf"});
        filenames.put(ModelMotormanuellGesamt.class, new String[]{"MotormanuellA.pdf", "MotormanuellGesamtB.pdf"});
        filenames.put(ModelMotormanuellFaellen.class, new String[]{"MotormanuellA.pdf", "MotormanuellFaellenB.pdf"});
        filenames.put(ModelMotormanuellEntasten.class, new String[]{"MotormanuellA.pdf", "MotormanuellEntastenB.pdf"});
        filenames.put(ModelMotormanuellEntrindenVonHand.class, new String[]{"MotormanuellA.pdf", "MotormanuellEntrindenVonHandB.pdf"});
        filenames.put(ModelMotormanuellEntrindenMitBiber.class, new String[]{"MotormanuellA.pdf", "MotormanuellEntrindenMitBiberB.pdf"});
        filenames.put(ModelMotormanuellIhLangAufarbeiten.class, new String[]{"MotormanuellA.pdf", "MotormanuellIhLangAufarbeitenB.pdf"});
        filenames.put(ModelMotormanuellSchichtholzAufarbeiten.class, new String[]{"MotormanuellA.pdf", "MotormanuellSchichtholzAufarbeitenB.pdf"});
        filenames.put(ModelMotormanuellStammholzAufarbeiten.class, new String[]{"MotormanuellA.pdf", "MotormanuellStammholzAufarbeitenB.pdf"});
        filenames.put(ModelRadharvester.class, new String[]{"RadharvesterA.pdf", "RadharvesterB.pdf"});
        filenames.put(ModelSchlepper.class, new String[]{"SchlepperA.pdf", "SchlepperB.pdf"});
        filenames.put(ModelMobilerHacker.class, new String[]{"MobilerHackerA.pdf", "MobilerHackerB.pdf"});
        filenames.put(ModelForwarder.class, new String[]{"ForwarderA.pdf", "ForwarderB.pdf"});
        filenames.put(ModelHelikopterAufarbeiten.class, new String[]{"HelikopterA.pdf", "HelikopterGesamtB.pdf"});
        filenames.put(ModelHelikopterFliegen.class, new String[]{"HelikopterA.pdf", "HelikopterFliegenB.pdf"});
        filenames.put(ModelHelikopterGesamt.class, new String[]{"HelikopterA.pdf", "HelikopterGesamtB.pdf"});
        filenames.put(ModelKonventionellerSeilkranGesamt.class, new String[]{"KonvSeilkranA.pdf", "KonvSeilkranGesamtB.pdf"});
        filenames.put(ModelKonventionellerSeilkranPlanung.class, new String[]{"KonvSeilkranA.pdf", "SeilkranPlanungB.pdf"});
        filenames.put(ModelKonventionellerSeilkranMontage.class, new String[]{"KonvSeilkranA.pdf", "KonvSeilkranMontageB.pdf"});
        filenames.put(ModelKonventionellerSeilkranSeilen.class, new String[]{"KonvSeilkranA.pdf", "KonvSeilkranSeilenB.pdf"});
        filenames.put(ModelKonventionellerSeilkranDemontage.class, new String[]{"KonvSeilkranA.pdf", "KonvSeilkranDemontageB.pdf"});
        filenames.put(ModelKonventionellerSeilkranLagerplatz.class, new String[]{"KonvSeilkranA.pdf", "SeilkranLagerplatzB.pdf"});
        filenames.put(ModelMobilseilkranGesamt.class, new String[]{"MobilSeilkranA.pdf", "MobilSeilkranGesamtB.pdf"});
        filenames.put(ModelMobilseilkranPlanung.class, new String[]{"MobilSeilkranA.pdf", "SeilkranPlanungB.pdf"});
        filenames.put(ModelMobilseilkranInstallation.class, new String[]{"MobilSeilkranA.pdf", "MobilSeilkranInstallationB.pdf"});
        filenames.put(ModelMobilseilkranSeilen.class, new String[]{"MobilSeilkranA.pdf", "MobilSeilkranSeilenB.pdf"});
        filenames.put(ModelMobilseilkranLagerplatz.class, new String[]{"MobilSeilkranA.pdf", "SeilkranLagerplatzB.pdf"});
        filenames.put(ModelHacker2018.class, new String[]{"Hacker2018A.pdf"});
        filenames.put(ModelHackschnitzelTransport2018.class, new String[]{"HackschnitzelTransport2018A.pdf"});
        filenames.put(ModelKombiseilgeraet2018.class, new String[]{"Kombiseilgeraet2018A.pdf", "Kombiseilgeraet2018B.pdf"});
        filenames.put(ModelVorruecken2018.class, new String[]{"Vorruecken2018A.pdf", "Vorruecken2018B.pdf"});
        filenames.put(ModelForwarder2018.class, new String[]{"Forwarder2018A.pdf", "Forwarder2018B.pdf"});
        filenames.put((Object)Documentation.Biomasseschaetzer2018, new String[]{"Biomasseschaetzer2018A.pdf"});
        filenames.put((Object)Documentation.Energieholzschaetzer2018, new String[]{"Energieholzschaetzer2018A.pdf"});
        filenames.put((Object)Documentation.Schaftholzschaetzer2018, new String[]{"Schaftholzschaetzer2018A.pdf"});
    }

    private DocumentationBroker() {
    }

    private static void openDocumentationPdfFile(Object modelKey, int index) {
        if (index < 0) {
            return;
        }
        if (!DocumentationBroker.exists(modelKey, index)) {
            SwingUtilities.invokeLater(() -> {
                String message = "Dokumentation nicht verf\u00fcgbar!";
                JOptionPane.showMessageDialog(null, message, "Fehler", 0);
            });
            return;
        }
        String filename = DOKU_DIR + filenames.get(modelKey)[index];
        DocumentationBroker.openDocumentationPdfFile(filename);
    }

    public static boolean exists(AbstractModel model) {
        return filenames.get(model.getClass()) != null && filenames.get(model.getClass()).length > 0;
    }

    private static boolean exists(Object modelKey, int index) {
        return filenames.get(modelKey) != null && index >= 0 && filenames.get(modelKey).length > index;
    }

    private static void openDocumentationPdfFile(String path) {
        DocumentationBroker.copyFileFromJarToFilesystemIfNecessary(path);
        DocumentationBroker.generateReadMeFile();
        File file = new File(path);
        try {
            Desktop.getDesktop().open(file);
        }
        catch (Exception e1) {
            e1.printStackTrace();
            JOptionPane.showMessageDialog(null, e1.getMessage(), "Fehler beim \u00d6ffnen der Datei", 0);
        }
    }

    private static void generateReadMeFile() {
        File file = new File("Dokumentation/README.txt");
        if (!file.exists()) {
            PrintWriter writer = null;
            try {
                writer = new PrintWriter(file);
                writer.println(GuiStrings.getString("DocumentationBroker.ReadMeText"));
                writer.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    private static void copyFileFromJarToFilesystemIfNecessary(String path) {
        if (!DocumentationBroker.isStartedFromJar()) {
            return;
        }
        File fileInFilesystem = new File(path);
        if (!fileInFilesystem.exists()) {
            System.out.println("File in file system does not exist. File will be copied from jar.");
            DocumentationBroker.copyFileFromJarToFilesystem(path);
        } else if (DocumentationBroker.hasFilesystemFileDifferentDateThanFileInJar(path)) {
            System.out.println("File in file system has different last-modified date than file in jar. File in file system will be replaced.");
            DocumentationBroker.copyFileFromJarToFilesystem(path);
        } else {
            return;
        }
    }

    private static boolean isStartedFromJar() {
        URL url = DocumentationBroker.class.getResource("DocumentationBroker.class");
        boolean isStartedFromJar = url.toString().startsWith("jar") || url.toString().startsWith("rsrc");
        return isStartedFromJar;
    }

    private static boolean hasFilesystemFileDifferentDateThanFileInJar(String path) {
        File fileInFilesystem = new File(path);
        long fileInFilesystemLastModified = -2L;
        long fileInJarLastModified = -2L;
        try {
            fileInFilesystemLastModified = fileInFilesystem.lastModified();
            fileInJarLastModified = DocumentationBroker.getJarFileLastModified(path);
        }
        catch (Exception e) {
            e.printStackTrace();
            return true;
        }
        if (fileInFilesystemLastModified <= 0L || fileInJarLastModified <= 0L) {
            return true;
        }
        return fileInFilesystemLastModified != fileInJarLastModified;
    }

    private static long getJarFileLastModified(String filePath) {
        filePath = "/" + filePath;
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (JarFile jar = DocumentationBroker.getJarFile();){
                if (jar != null) {
                    Enumeration<JarEntry> enumEntries = jar.entries();
                    while (enumEntries.hasMoreElements()) {
                        JarEntry file = enumEntries.nextElement();
                        if (!file.getName().equals(filePath.substring(1))) continue;
                        long time = file.getTime();
                        return time;
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1L;
    }

    private static JarFile getJarFile() {
        JarFile jar = null;
        try {
            jar = new JarFile("HeProMo.jar");
            return jar;
        }
        catch (Exception exception) {
            try {
                String jarFilePath = ClassLoader.getSystemClassLoader().getResource(".").toURI().getPath().replaceFirst("/", "");
                jar = new JarFile(String.valueOf(jarFilePath) + File.separator + "HeProMo.jar");
                return jar;
            }
            catch (Exception exception2) {
                return null;
            }
        }
    }

    private static void copyFileFromJarToFilesystem(String path) {
        File fileInFilesystem = new File(path);
        try {
            Throwable throwable = null;
            Object var3_6 = null;
            try (InputStream in = DocumentationBroker.class.getClassLoader().getResourceAsStream(path);){
                if (in == null) {
                    System.err.println("file '" + path + "' not found in jar");
                    return;
                }
                String[] dirs = path.split("\\\\|/");
                String dir = "";
                int i = 0;
                while (i < dirs.length - 1) {
                    dir = String.valueOf(dir) + dirs[i] + "/";
                    ++i;
                }
                File f = new File(dir);
                f.mkdirs();
                byte[] buffer = new byte[4096];
                Throwable throwable2 = null;
                Object var11_16 = null;
                try (FileOutputStream out = new FileOutputStream(fileInFilesystem);){
                    int readBytes;
                    while ((readBytes = in.read(buffer)) > 0) {
                        out.write(buffer, 0, readBytes);
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        long lastModified = DocumentationBroker.getJarFileLastModified(path);
        if (lastModified >= 0L) {
            fileInFilesystem.setLastModified(lastModified);
        }
    }

    public static void showDocumentation(Documentation documentation, Component parentComponent, JButton btnDokumentation) {
        DocumentationBroker.showDocumentationGeneric((Object)documentation, false, parentComponent, btnDokumentation);
    }

    public static void showDocumentation(AbstractModel model, Component parentComponent, JButton btnDokumentation) {
        boolean is2014Text = parentComponent instanceof HeProMoWindow2014;
        DocumentationBroker.showDocumentationGeneric(model.getClass(), is2014Text, parentComponent, btnDokumentation);
    }

    private static void showDocumentationGeneric(final Object modelKey, final boolean is2014Text, final Component parentComponent, final JButton btnDokumentation) {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new RuntimeException("not in EDT");
        }
        btnDokumentation.setEnabled(false);
        btnDokumentation.setText(GuiStrings.getString("HeProMoWindow.btnBitteWarten"));
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                DocumentationBroker.showDocumetation(modelKey, is2014Text, parentComponent);
                return null;
            }

            @Override
            protected void done() {
                btnDokumentation.setEnabled(true);
                btnDokumentation.setText(GuiStrings.getString("HeProMoWindow.btnGrundlagen"));
                btnDokumentation.requestFocusInWindow();
            }
        };
        worker.execute();
    }

    private static void showDocumetation(Object modelKey, boolean is2014Text, Component parentComponent) {
        String teilB_lang;
        String teilA_lang = is2014Text ? GuiStrings.getString("DocumentationBroker.TeilA_lang_2014") : GuiStrings.getString("DocumentationBroker.TeilA_lang");
        String string = teilB_lang = is2014Text ? GuiStrings.getString("DocumentationBroker.TeilB_lang_2014") : GuiStrings.getString("DocumentationBroker.TeilB_lang");
        if (DocumentationBroker.exists(modelKey, 1)) {
            Object[] options = new Object[]{GuiStrings.getString("DocumentationBroker.TeilA"), GuiStrings.getString("DocumentationBroker.TeilB")};
            int selection = JOptionPane.showOptionDialog(parentComponent, "<html>" + GuiStrings.getString("DocumentationBroker.WelchenDokuTeilOeffnen") + "<br>" + "<li>" + teilA_lang + "</li>" + "<li>" + teilB_lang + "</li>" + "</html", GuiStrings.getString("DocumentationBroker.DialogTitleDokuOeffnen"), 1, 3, null, options, options[0]);
            DocumentationBroker.openDocumentationPdfFile(modelKey, selection);
        } else {
            DocumentationBroker.openDocumentationPdfFile(modelKey, 0);
        }
    }

    public static enum Documentation {
        Biomasseschaetzer2018,
        Energieholzschaetzer2018,
        Schaftholzschaetzer2018;

    }
}

