/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.juwapfl.util;

import ch.wsl.fps.juwapfl.Messages;
import ch.wsl.fps.juwapfl.gui.JuWaPflExceptionHandler;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactory;

public class DatenblattCreator {
    private static final String DEFAULT_XSLT_FILE_PATH = "data/kalkulation2fo-templates.xsl";
    private static final Object classLevelLock = new Object();
    private static volatile boolean isAlreadyPreinitialized = false;
    private static final String CHARSET = "UTF-8";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void preInitializeInSeparateThread() {
        Object object = classLevelLock;
        synchronized (object) {
            if (!isAlreadyPreinitialized) {
                new Thread(() -> {
                    DatenblattCreator instance = new DatenblattCreator();
                    String emptyXMLString = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><kalkulation></kalkulation>";
                    instance.generatePdf(emptyXMLString, null, DEFAULT_XSLT_FILE_PATH);
                    isAlreadyPreinitialized = true;
                }).start();
            }
        }
    }

    public void create(String xmlString, File pdfFile, String xsltFilePath) {
        String finalXMLString = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<kalkulation>\n" + xmlString + "</kalkulation>";
        this.generatePdf(finalXMLString, pdfFile, xsltFilePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void generatePdf(String xmlString, File pdfFile, String xsltFilePath) {
        Object object = classLevelLock;
        synchronized (object) {
            block16: {
                Logger fopLogger = Logger.getLogger("org.apache.fop");
                fopLogger.setLevel(Level.OFF);
                try {
                    FopFactory fopFactory = FopFactory.newInstance((URI)new File(".").toURI());
                    OutputStream out = this.getOutputStream(pdfFile);
                    try {
                        Fop fop = fopFactory.newFop("application/pdf", out);
                        TransformerFactory factory = TransformerFactory.newInstance();
                        factory.setURIResolver((href, base) -> {
                            InputStream is = this.getClass().getClassLoader().getResourceAsStream(href);
                            if (is == null) {
                                try {
                                    is = new FileInputStream(href);
                                }
                                catch (FileNotFoundException e) {
                                    JuWaPflExceptionHandler.handle(e);
                                }
                            }
                            return new StreamSource(is);
                        });
                        Transformer transformer = factory.newTransformer(new StreamSource(this.openFile(xsltFilePath)));
                        transformer.setOutputProperty("encoding", CHARSET);
                        StreamSource src = new StreamSource(new ByteArrayInputStream(xmlString.getBytes(CHARSET)));
                        SAXResult res = new SAXResult(fop.getDefaultHandler());
                        transformer.transform(src, res);
                        if (pdfFile != null) {
                            System.out.println("Datenblatt erfolgreich erstellt.");
                        }
                    }
                    catch (FOPException e) {
                        JuWaPflExceptionHandler.handle(e);
                        out.close();
                        break block16;
                    }
                    catch (TransformerException e) {
                        JuWaPflExceptionHandler.handle(e);
                        break block16;
                    }
                    catch (TransformerFactoryConfigurationError e) {
                        JuWaPflExceptionHandler.handle(e);
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                        out.close();
                        break block16;
                    }
                    {
                        finally {
                            out.close();
                        }
                    }
                    out.close();
                }
                catch (FileNotFoundException e) {
                    String msg = String.valueOf(Messages.getString("DatenblattCreator.FehlerBeimErstellenDerDatei")) + "\n" + e.getLocalizedMessage();
                    JOptionPane.showMessageDialog(null, msg, Messages.getString("Common.TitelErrorMessage"), 0);
                }
                catch (IOException e) {
                    JuWaPflExceptionHandler.handle(e);
                }
            }
        }
    }

    private OutputStream getOutputStream(File pdfFile) throws FileNotFoundException {
        if (pdfFile == null) {
            return new NullOutputStream();
        }
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(pdfFile));
        return out;
    }

    private BufferedReader openFile(String filePath) {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(filePath);
        if (is != null) {
            try {
                return new BufferedReader(new InputStreamReader(is, CHARSET));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                return new BufferedReader(new InputStreamReader(is));
            }
        }
        File file = new File(filePath);
        try {
            try {
                return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), CHARSET));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                return new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            }
        }
        catch (FileNotFoundException e) {
            JuWaPflExceptionHandler.handle(e);
            return null;
        }
    }

    private class NullOutputStream
    extends OutputStream {
        private NullOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
        }
    }
}

