/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.juwapfl.model;

import ch.wsl.fps.juwapfl.model.AbstractJuwapflModelTest;
import ch.wsl.fps.juwapfl.model.WildschutzErgebnis;
import ch.wsl.fps.juwapfl.model.WildschutzMockErgebnis;
import ch.wsl.fps.juwapfl.model.WildschutzModel;
import org.testng.annotations.Test;

public class WildschutzModelTest
extends AbstractJuwapflModelTest {
    @Override
    protected String getCsvPath() {
        return "testcases/Wildschutz.csv";
    }

    @Override
    protected WildschutzModel parseInputData(String[] testcase) {
        WildschutzModel result = new WildschutzModel();
        result.setSchutztyp(WildschutzModel.Schutztyp.valueOf(testcase[0]));
        result.setSubtyp(WildschutzModel.Subtyp.valueOf(testcase[1]));
        result.setWuchshuellentyp(WildschutzModel.Wuchshuellentyp.valueOf(testcase[2]));
        result.setAnzahlPflanzen(Integer.valueOf(testcase[3]));
        result.setZaunlaenge_m(Integer.valueOf(testcase[4]));
        result.setKostenPersonalProPerson(Integer.valueOf(testcase[5]));
        result.setFaktorWegzeitenUndPausen(Double.valueOf(testcase[6]));
        result.setFahrzeugkostenAufbauPauschal(Double.valueOf(testcase[7]));
        result.setFahrzeugkostenUnterhaltPauschal(Double.valueOf(testcase[8]));
        result.setFahrzeugkostenAbbauPauschal(Double.valueOf(testcase[9]));
        result.setKorrekturfaktorZeitaufwand(Double.valueOf(testcase[10]));
        result.setKorrekturfaktorMaterialkosten(Double.valueOf(testcase[11]));
        return result;
    }

    @Override
    protected WildschutzMockErgebnis parseExpectedValues(String[] testcase) {
        double[] values = this.getDoubleValues(testcase, 12);
        WildschutzMockErgebnis result = new WildschutzMockErgebnis();
        int i = 0;
        result.setZeitPersonalAufbau_min(values[i++]);
        result.setZeitPersonalUnterhalt_min(values[i++]);
        result.setZeitPersonalAbbau_min(values[i++]);
        result.setZeitPersonalGesamt_min(values[i++]);
        result.setKostenPersonalAufbau(values[i++]);
        result.setKostenPersonalUnterhalt(values[i++]);
        result.setKostenPersonalAbbau(values[i++]);
        result.setKostenPersonalGesamt(values[i++]);
        result.setKostenFahrtenAufbau(values[i++]);
        result.setKostenFahrtenUnterhalt(values[i++]);
        result.setKostenFahrtenAbbau(values[i++]);
        result.setKostenFahrtenGesamt(values[i++]);
        result.setKostenMaterialAufbau(values[i++]);
        result.setKostenMaterialUnterhalt(values[i++]);
        result.setKostenMaterialAbbau(values[i++]);
        result.setKostenMaterialGesamt(values[i++]);
        result.setKostenGesamtAufbau(values[i++]);
        result.setKostenGesamtUnterhalt(values[i++]);
        result.setKostenGesamtAbbau(values[i++]);
        result.setKostenGesamtGesamt(values[i++]);
        return result;
    }

    @Test(dataProvider="csvData")
    public void testZeitPersonalAufbau_min(String testcaseName, WildschutzErgebnis actualOutput, WildschutzMockErgebnis expectedOutput) {
        this.assertEqualsDynamicDeltaMinutes(actualOutput.getZeitPersonalAufbau_min(), expectedOutput.getZeitPersonalAufbau_min());
    }

    @Test(dataProvider="csvData")
    public void testZeitPersonalUnterhalt_min(String testcaseName, WildschutzErgebnis actualOutput, WildschutzMockErgebnis expectedOutput) {
        this.assertEqualsDynamicDeltaMinutes(actualOutput.getZeitPersonalUnterhalt_min(), expectedOutput.getZeitPersonalUnterhalt_min());
    }

    @Test(dataProvider="csvData")
    public void testZeitPersonalAbbau_min(String testcaseName, WildschutzErgebnis actualOutput, WildschutzMockErgebnis expectedOutput) {
        this.assertEqualsDynamicDeltaMinutes(actualOutput.getZeitPersonalAbbau_min(), expectedOutput.getZeitPersonalAbbau_min());
    }

    @Test(dataProvider="csvData")
    public void testZeitPersonalGesamt_min(String testcaseName, WildschutzErgebnis actualOutput, WildschutzMockErgebnis expectedOutput) {
        this.assertEqualsDynamicDeltaMinutes(actualOutput.getZeitPersonalGesamt_min(), expectedOutput.getZeitPersonalGesamt_min());
    }

    @Test(dataProvider="csvData")
    public void testKostenPersonalAufbau(String testcaseName, WildschutzErgebnis actualOutput, WildschutzMockErgebnis expectedOutput) {
        this.assertEqualsDynamicDelta(actualOutput.getKostenPersonalAufbau(), expectedOutput.getKostenPersonalAufbau());
    }

    @Test(dataProvider="csvData")
    public void testKostenPersonalUnterhalt(String testcaseName, WildschutzErgebnis actualOutput, WildschutzMockErgebnis expectedOutput) {
        this.assertEqualsDynamicDelta(actualOutput.getKostenPersonalUnterhalt(), expectedOutput.getKostenPersonalUnterhalt());
    }

    @Test(dataProvider="csvData")
    public void testKostenPersonalAbbau(String testcaseName, WildschutzErgebnis actualOutput, WildschutzMockErgebnis expectedOutput) {
        this.assertEqualsDynamicDelta(actualOutput.getKostenPersonalAbbau(), expectedOutput.getKostenPersonalAbbau());
    }

    @Test(dataProvider="csvData")
    public void testKostenPersonalGesamt(String testcaseName, WildschutzErgebnis actualOutput, WildschutzMockErgebnis expectedOutput) {
        this.assertEqualsDynamicDelta(actualOutput.getKostenPersonalGesamt(), expectedOutput.getKostenPersonalGesamt());
    }

    @Test(dataProvider="csvData")
    public void testKostenFahrtenAufbau(String testcaseName, WildschutzErgebnis actualOutput, WildschutzMockErgebnis expectedOutput) {
        this.assertEqualsDynamicDelta(actualOutput.getKostenFahrtenAufbau(), expectedOutput.getKostenFahrtenAufbau());
    }

    @Test(dataProvider="csvData")
    public void testKostenFahrtenUnterhalt(String testcaseName, WildschutzErgebnis actualOutput, WildschutzMockErgebnis expectedOutput) {
        this.assertEqualsDynamicDelta(actualOutput.getKostenFahrtenUnterhalt(), expectedOutput.getKostenFahrtenUnterhalt());
    }

    @Test(dataProvider="csvData")
    public void testKostenFahrtenAbbau(String testcaseName, WildschutzErgebnis actualOutput, WildschutzMockErgebnis expectedOutput) {
        this.assertEqualsDynamicDelta(actualOutput.getKostenFahrtenAbbau(), expectedOutput.getKostenFahrtenAbbau());
    }

    @Test(dataProvider="csvData")
    public void testKostenFahrtenGesamt(String testcaseName, WildschutzErgebnis actualOutput, WildschutzMockErgebnis expectedOutput) {
        this.assertEqualsDynamicDelta(actualOutput.getKostenFahrtenGesamt(), expectedOutput.getKostenFahrtenGesamt());
    }

    @Test(dataProvider="csvData")
    public void testKostenMaterialAufbau(String testcaseName, WildschutzErgebnis actualOutput, WildschutzMockErgebnis expectedOutput) {
        this.assertEqualsDynamicDelta(actualOutput.getKostenMaterialAufbau(), expectedOutput.getKostenMaterialAufbau());
    }

    @Test(dataProvider="csvData")
    public void testKostenMaterialUnterhalt(String testcaseName, WildschutzErgebnis actualOutput, WildschutzMockErgebnis expectedOutput) {
        this.assertEqualsDynamicDelta(actualOutput.getKostenMaterialUnterhalt(), expectedOutput.getKostenMaterialUnterhalt());
    }

    @Test(dataProvider="csvData")
    public void testKostenMaterialAbbau(String testcaseName, WildschutzErgebnis actualOutput, WildschutzMockErgebnis expectedOutput) {
        this.assertEqualsDynamicDelta(actualOutput.getKostenMaterialAbbau(), expectedOutput.getKostenMaterialAbbau());
    }

    @Test(dataProvider="csvData")
    public void testKostenMaterialGesamt(String testcaseName, WildschutzErgebnis actualOutput, WildschutzMockErgebnis expectedOutput) {
        this.assertEqualsDynamicDelta(actualOutput.getKostenMaterialGesamt(), expectedOutput.getKostenMaterialGesamt());
    }

    @Test(dataProvider="csvData")
    public void testKostenGesamtAufbau(String testcaseName, WildschutzErgebnis actualOutput, WildschutzMockErgebnis expectedOutput) {
        this.assertEqualsDynamicDelta(actualOutput.getKostenGesamtAufbau(), expectedOutput.getKostenGesamtAufbau());
    }

    @Test(dataProvider="csvData")
    public void testKostenGesamtUnterhalt(String testcaseName, WildschutzErgebnis actualOutput, WildschutzMockErgebnis expectedOutput) {
        this.assertEqualsDynamicDelta(actualOutput.getKostenGesamtUnterhalt(), expectedOutput.getKostenGesamtUnterhalt());
    }

    @Test(dataProvider="csvData")
    public void testKostenGesamtAbbau(String testcaseName, WildschutzErgebnis actualOutput, WildschutzMockErgebnis expectedOutput) {
        this.assertEqualsDynamicDelta(actualOutput.getKostenGesamtAbbau(), expectedOutput.getKostenGesamtAbbau());
    }

    @Test(dataProvider="csvData")
    public void testKostenGesamtGesamt(String testcaseName, WildschutzErgebnis actualOutput, WildschutzMockErgebnis expectedOutput) {
        this.assertEqualsDynamicDelta(actualOutput.getKostenGesamtGesamt(), expectedOutput.getKostenGesamtGesamt());
    }
}

