/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.juwapfl.model;

import ch.wsl.fps.juwapfl.Messages;
import ch.wsl.fps.juwapfl.model.AbstractModel;
import ch.wsl.fps.juwapfl.model.WildschutzErgebnis;
import java.text.DecimalFormat;

public class WildschutzModel
extends AbstractModel {
    private Schutztyp schutztyp;
    private Subtyp subtyp;
    private Wuchshuellentyp wuchshuellentyp;
    private int anzahlPflanzen;
    private int zaunlaenge_m;
    private int kostenPersonalProPerson;
    private double faktorWegzeitenUndPausen;
    private double korrekturfaktorZeitaufwand;
    private double korrekturfaktorMaterialkosten;
    private double fahrzeugkostenAufbauPauschal;
    private double fahrzeugkostenUnterhaltPauschal;
    private double fahrzeugkostenAbbauPauschal;

    public void setSchutztyp(Schutztyp schutztyp) {
        this.schutztyp = schutztyp;
    }

    public void setSubtyp(Subtyp subtyp) {
        this.subtyp = subtyp;
    }

    public void setWuchshuellentyp(Wuchshuellentyp wuchshuellentyp) {
        this.wuchshuellentyp = wuchshuellentyp;
    }

    public void setAnzahlPflanzen(int anzahlPflanzen) {
        this.anzahlPflanzen = anzahlPflanzen;
    }

    public void setZaunlaenge_m(int zaunlaenge_m) {
        this.zaunlaenge_m = zaunlaenge_m;
    }

    public void setKostenPersonalProPerson(int kostenPersonalProPerson) {
        this.kostenPersonalProPerson = kostenPersonalProPerson;
    }

    public void setFaktorWegzeitenUndPausen(double faktorWegzeitenUndPausen) {
        this.faktorWegzeitenUndPausen = faktorWegzeitenUndPausen;
    }

    public void setKorrekturfaktorZeitaufwand(double korrekturfaktorZeitaufwand) {
        this.korrekturfaktorZeitaufwand = korrekturfaktorZeitaufwand;
    }

    public void setKorrekturfaktorMaterialkosten(double korrekturfaktorMaterialkosten) {
        this.korrekturfaktorMaterialkosten = korrekturfaktorMaterialkosten;
    }

    public void setFahrzeugkostenAufbauPauschal(double fahrzeugkostenAufbauPauschal) {
        this.fahrzeugkostenAufbauPauschal = fahrzeugkostenAufbauPauschal;
    }

    public void setFahrzeugkostenUnterhaltPauschal(double fahrzeugkostenUnterhaltPauschal) {
        this.fahrzeugkostenUnterhaltPauschal = fahrzeugkostenUnterhaltPauschal;
    }

    public void setFahrzeugkostenAbbauPauschal(double fahrzeugkostenAbbauPauschal) {
        this.fahrzeugkostenAbbauPauschal = fahrzeugkostenAbbauPauschal;
    }

    @Override
    public WildschutzErgebnis getErgebnis() {
        double kostenMaterialAbbau;
        double kostenMaterialUnterhalt;
        double kostenMaterialAufbau;
        double zeitaufwandAbbau_min;
        double zeitaufwandUnterhalt_min;
        double zeitaufwandAufbau_min;
        WildschutzErgebnis ergebnis = new WildschutzErgebnis();
        if (this.schutztyp == Schutztyp.WUCHSHUELLE) {
            double zeitaufwandAufbau_minProBaum = 2.0;
            double zeitaufwandUnterhalt_minProBaum = 8.0;
            double zeitaufwandAbbau_minProBaum = 3.0;
            double kostenMaterialAufbau_proBaum = 0.0;
            double kostenMaterialAbbau_proBaum = 0.035;
            if (this.subtyp == Subtyp.REHWILDSICHER_ABBAUBAR || this.subtyp == Subtyp.REHWILDSICHER_NICHT_ABBAUBAR) {
                kostenMaterialAufbau_proBaum = this.wuchshuellentyp.getKosten() + 0.85 + 0.06;
            } else if (this.subtyp == Subtyp.ROTWILDSICHER_ABBAUBAR || this.subtyp == Subtyp.ROTWILDSICHER_NICHT_ABBAUBAR) {
                kostenMaterialAufbau_proBaum = this.wuchshuellentyp.getKosten() + 1.95 + 0.06;
            } else {
                throw new IllegalStateException("unknown subtyp: " + (Object)((Object)this.subtyp));
            }
            zeitaufwandAufbau_min = zeitaufwandAufbau_minProBaum * (double)this.anzahlPflanzen * 1.1 * this.faktorWegzeitenUndPausen;
            zeitaufwandUnterhalt_min = zeitaufwandUnterhalt_minProBaum * (double)this.anzahlPflanzen * 1.1 * this.faktorWegzeitenUndPausen;
            zeitaufwandAbbau_min = zeitaufwandAbbau_minProBaum * (double)this.anzahlPflanzen * 1.1 * this.faktorWegzeitenUndPausen;
            kostenMaterialAufbau = kostenMaterialAufbau_proBaum * (double)this.anzahlPflanzen;
            kostenMaterialUnterhalt = 0.0;
            kostenMaterialAbbau = kostenMaterialAbbau_proBaum * (double)this.anzahlPflanzen;
        } else if (this.schutztyp == Schutztyp.KUNSTSTOFFKORB) {
            double zeitaufwandAufbau_minProBaum = 3.0;
            double zeitaufwandUnterhalt_minProBaum = 2.0;
            double zeitaufwandAbbau_minProBaum = 3.0;
            double kostenMaterialAufbau_proBaum = 0.0;
            double kostenMaterialAbbau_proBaum = 0.2;
            if (this.subtyp != Subtyp.REHWILDSICHER) {
                throw new IllegalStateException("unknown subtyp: " + (Object)((Object)this.subtyp));
            }
            kostenMaterialAufbau_proBaum = 8.56;
            zeitaufwandAufbau_min = zeitaufwandAufbau_minProBaum * (double)this.anzahlPflanzen * 1.1 * this.faktorWegzeitenUndPausen;
            zeitaufwandUnterhalt_min = zeitaufwandUnterhalt_minProBaum * (double)this.anzahlPflanzen * 1.1 * this.faktorWegzeitenUndPausen;
            zeitaufwandAbbau_min = zeitaufwandAbbau_minProBaum * (double)this.anzahlPflanzen * 1.1 * this.faktorWegzeitenUndPausen;
            kostenMaterialAufbau = kostenMaterialAufbau_proBaum * (double)this.anzahlPflanzen;
            kostenMaterialUnterhalt = 0.0;
            kostenMaterialAbbau = kostenMaterialAbbau_proBaum * (double)this.anzahlPflanzen;
        } else if (this.schutztyp == Schutztyp.DRAHTKORB_LEICHT) {
            double zeitaufwandAufbau_minProBaum = 5.0;
            double zeitaufwandUnterhalt_minProBaum = 2.0;
            double zeitaufwandAbbau_minProBaum = 3.0;
            double kostenMaterialAufbau_proBaum = 0.0;
            double kostenMaterialAbbau_proBaum = 0.2;
            if (this.subtyp == Subtyp.REHWILDSICHER) {
                kostenMaterialAufbau_proBaum = 5.05;
            } else if (this.subtyp == Subtyp.ROTWILDSICHER) {
                kostenMaterialAufbau_proBaum = 10.35;
            } else {
                throw new IllegalStateException("unknown subtyp: " + (Object)((Object)this.subtyp));
            }
            zeitaufwandAufbau_min = zeitaufwandAufbau_minProBaum * (double)this.anzahlPflanzen * 1.1 * this.faktorWegzeitenUndPausen;
            zeitaufwandUnterhalt_min = zeitaufwandUnterhalt_minProBaum * (double)this.anzahlPflanzen * 1.1 * this.faktorWegzeitenUndPausen;
            zeitaufwandAbbau_min = zeitaufwandAbbau_minProBaum * (double)this.anzahlPflanzen * 1.1 * this.faktorWegzeitenUndPausen;
            kostenMaterialAufbau = kostenMaterialAufbau_proBaum * (double)this.anzahlPflanzen;
            kostenMaterialUnterhalt = 0.0;
            kostenMaterialAbbau = kostenMaterialAbbau_proBaum * (double)this.anzahlPflanzen;
        } else if (this.schutztyp == Schutztyp.DRAHTKORB_MASSIV) {
            double zeitaufwandAufbau_minProBaum = 44.0;
            double zeitaufwandUnterhalt_minProBaum = 53.0;
            double zeitaufwandAbbau_minProBaum = 9.0;
            double kostenMaterialAufbau_proBaum = 0.0;
            if (this.subtyp == Subtyp.REHWILDSICHER) {
                kostenMaterialAufbau_proBaum = 10.0;
            } else if (this.subtyp == Subtyp.ROTWILDSICHER) {
                kostenMaterialAufbau_proBaum = 17.299999999999997;
            } else {
                throw new IllegalStateException("unknown subtyp: " + (Object)((Object)this.subtyp));
            }
            zeitaufwandAufbau_min = zeitaufwandAufbau_minProBaum * (double)this.anzahlPflanzen * 1.1 * this.faktorWegzeitenUndPausen;
            zeitaufwandUnterhalt_min = zeitaufwandUnterhalt_minProBaum * (double)this.anzahlPflanzen * 1.1 * this.faktorWegzeitenUndPausen;
            zeitaufwandAbbau_min = zeitaufwandAbbau_minProBaum * (double)this.anzahlPflanzen * 1.1 * this.faktorWegzeitenUndPausen;
            kostenMaterialAufbau = kostenMaterialAufbau_proBaum * (double)this.anzahlPflanzen;
            kostenMaterialUnterhalt = 0.0;
            kostenMaterialAbbau = 0.0;
        } else if (this.schutztyp == Schutztyp.EINZELSCHUTZ_HOLZ) {
            double zeitaufwandAufbau_minProBaum = 3.0;
            double zeitaufwandUnterhalt_minProBaum = 2.0;
            double zeitaufwandAbbau_minProBaum = 0.0;
            double kostenMaterialAufbau_proBaum = 0.0;
            if (this.subtyp != Subtyp.REHWILDSICHER) {
                throw new IllegalStateException("unknown subtyp: " + (Object)((Object)this.subtyp));
            }
            kostenMaterialAufbau_proBaum = 7.35;
            zeitaufwandAufbau_min = zeitaufwandAufbau_minProBaum * (double)this.anzahlPflanzen * 1.1 * this.faktorWegzeitenUndPausen;
            zeitaufwandUnterhalt_min = zeitaufwandUnterhalt_minProBaum * (double)this.anzahlPflanzen * 1.1 * this.faktorWegzeitenUndPausen;
            zeitaufwandAbbau_min = zeitaufwandAbbau_minProBaum * (double)this.anzahlPflanzen * 1.1 * this.faktorWegzeitenUndPausen;
            kostenMaterialAufbau = kostenMaterialAufbau_proBaum * (double)this.anzahlPflanzen;
            kostenMaterialUnterhalt = 0.0;
            kostenMaterialAbbau = 0.0;
        } else if (this.schutztyp == Schutztyp.TRIEBSCHUTZMANSCHETTE) {
            double zeitaufwandAufbau_minProBaum = 0.5;
            double zeitaufwandUnterhalt_minProBaum = 0.2;
            double zeitaufwandAbbau_minProBaum = 0.2;
            double kostenMaterialAufbau_proBaum = 0.2;
            double kostenMaterialAbbau_proBaum = 0.01;
            zeitaufwandAufbau_min = zeitaufwandAufbau_minProBaum * (double)this.anzahlPflanzen * 1.1 * this.faktorWegzeitenUndPausen;
            zeitaufwandUnterhalt_min = zeitaufwandUnterhalt_minProBaum * (double)this.anzahlPflanzen * 1.1 * this.faktorWegzeitenUndPausen;
            zeitaufwandAbbau_min = zeitaufwandAbbau_minProBaum * (double)this.anzahlPflanzen * 1.1 * this.faktorWegzeitenUndPausen;
            kostenMaterialAufbau = kostenMaterialAufbau_proBaum * (double)this.anzahlPflanzen;
            kostenMaterialUnterhalt = 0.0;
            kostenMaterialAbbau = kostenMaterialAbbau_proBaum * (double)this.anzahlPflanzen;
        } else if (this.schutztyp == Schutztyp.CHEMISCHER_SCHUTZ) {
            double zeitaufwandAufbau_minProBaum = 5.0;
            double zeitaufwandUnterhalt_minProBaum = 0.0;
            double zeitaufwandAbbau_minProBaum = 0.0;
            double kostenMaterialAufbau_proBaum = 0.2;
            zeitaufwandAufbau_min = zeitaufwandAufbau_minProBaum * (double)this.anzahlPflanzen * 1.1 * this.faktorWegzeitenUndPausen;
            zeitaufwandUnterhalt_min = zeitaufwandUnterhalt_minProBaum * (double)this.anzahlPflanzen * 1.1 * this.faktorWegzeitenUndPausen;
            zeitaufwandAbbau_min = zeitaufwandAbbau_minProBaum * (double)this.anzahlPflanzen * 1.1 * this.faktorWegzeitenUndPausen;
            kostenMaterialAufbau = kostenMaterialAufbau_proBaum * (double)this.anzahlPflanzen;
            kostenMaterialUnterhalt = 0.0;
            kostenMaterialAbbau = 0.0;
        } else if (this.schutztyp == Schutztyp.SCHAELSCHUTZ) {
            double zeitaufwandAufbau_minProBaum = 11.5;
            double zeitaufwandUnterhalt_minProBaum = 8.9;
            double zeitaufwandAbbau_minProBaum = 2.7;
            double kostenMaterialAufbau_proBaum = 4.0;
            zeitaufwandAufbau_min = zeitaufwandAufbau_minProBaum * (double)this.anzahlPflanzen * 1.1 * this.faktorWegzeitenUndPausen;
            zeitaufwandUnterhalt_min = zeitaufwandUnterhalt_minProBaum * (double)this.anzahlPflanzen * 1.1 * this.faktorWegzeitenUndPausen;
            zeitaufwandAbbau_min = zeitaufwandAbbau_minProBaum * (double)this.anzahlPflanzen * 1.1 * this.faktorWegzeitenUndPausen;
            kostenMaterialAufbau = kostenMaterialAufbau_proBaum * (double)this.anzahlPflanzen;
            kostenMaterialUnterhalt = 0.0;
            kostenMaterialAbbau = 0.0;
        } else if (this.schutztyp == Schutztyp.FLAECHENSCHUTZ) {
            double zeitaufwandAufbau_minProLfm = 0.0;
            double zeitaufwandUnterhalt_minProLfm = 0.0;
            double zeitaufwandAbbau_minProLfm = 5.5;
            double kostenMaterialAufbau_proLfm = 0.0;
            switch (this.subtyp) {
                case REHWILDSICHER_HOLZPFAHL: {
                    zeitaufwandAufbau_minProLfm = 8.9;
                    zeitaufwandUnterhalt_minProLfm = 27.0;
                    kostenMaterialAufbau_proLfm = 3.9875;
                    break;
                }
                case ROTWILDSICHER_HOLZPFAHL: {
                    zeitaufwandAufbau_minProLfm = 22.2;
                    zeitaufwandUnterhalt_minProLfm = 36.0;
                    kostenMaterialAufbau_proLfm = 7.65;
                    break;
                }
                case REHWILDSICHER_EISENPFAHL: {
                    zeitaufwandAufbau_minProLfm = 6.9;
                    zeitaufwandUnterhalt_minProLfm = 27.0;
                    kostenMaterialAufbau_proLfm = 5.0;
                    break;
                }
                case ROTWILDSICHER_EISENPFAHL: {
                    zeitaufwandAufbau_minProLfm = 17.2;
                    zeitaufwandUnterhalt_minProLfm = 36.0;
                    kostenMaterialAufbau_proLfm = 8.71;
                    break;
                }
                default: {
                    throw new RuntimeException("Unzul\u00e4asiger Subtyp: " + (Object)((Object)this.subtyp));
                }
            }
            zeitaufwandAufbau_min = zeitaufwandAufbau_minProLfm * (double)this.zaunlaenge_m * 1.1 * this.faktorWegzeitenUndPausen;
            zeitaufwandUnterhalt_min = zeitaufwandUnterhalt_minProLfm * (double)this.zaunlaenge_m * 1.1 * this.faktorWegzeitenUndPausen;
            zeitaufwandAbbau_min = zeitaufwandAbbau_minProLfm * (double)this.zaunlaenge_m * 1.1 * this.faktorWegzeitenUndPausen;
            kostenMaterialAufbau = kostenMaterialAufbau_proLfm * (double)this.zaunlaenge_m;
            kostenMaterialUnterhalt = 0.0;
            kostenMaterialAbbau = 0.0;
        } else {
            throw new IllegalStateException("unknown schutztyp: " + (Object)((Object)this.schutztyp));
        }
        zeitaufwandAufbau_min *= this.korrekturfaktorZeitaufwand;
        zeitaufwandUnterhalt_min *= this.korrekturfaktorZeitaufwand;
        zeitaufwandAbbau_min *= this.korrekturfaktorZeitaufwand;
        kostenMaterialAufbau *= this.korrekturfaktorMaterialkosten;
        kostenMaterialUnterhalt *= this.korrekturfaktorMaterialkosten;
        kostenMaterialAbbau *= this.korrekturfaktorMaterialkosten;
        ergebnis.setZeitPersonalAufbau_min(zeitaufwandAufbau_min);
        ergebnis.setZeitPersonalUnterhalt_min(zeitaufwandUnterhalt_min);
        ergebnis.setZeitPersonalAbbau_min(zeitaufwandAbbau_min);
        ergebnis.setKostenPersonalAufbau(zeitaufwandAufbau_min * (double)this.kostenPersonalProPerson / 60.0);
        ergebnis.setKostenPersonalUnterhalt(zeitaufwandUnterhalt_min * (double)this.kostenPersonalProPerson / 60.0);
        ergebnis.setKostenPersonalAbbau(zeitaufwandAbbau_min * (double)this.kostenPersonalProPerson / 60.0);
        ergebnis.setKostenFahrtenAufbau(this.fahrzeugkostenAufbauPauschal);
        ergebnis.setKostenFahrtenUnterhalt(this.fahrzeugkostenUnterhaltPauschal);
        ergebnis.setKostenFahrtenAbbau(this.fahrzeugkostenAbbauPauschal);
        ergebnis.setKostenMaterialAufbau(kostenMaterialAufbau);
        ergebnis.setKostenMaterialUnterhalt(kostenMaterialUnterhalt);
        ergebnis.setKostenMaterialAbbau(kostenMaterialAbbau);
        return ergebnis;
    }

    public static enum Schutztyp {
        WUCHSHUELLE,
        KUNSTSTOFFKORB,
        DRAHTKORB_LEICHT,
        DRAHTKORB_MASSIV,
        EINZELSCHUTZ_HOLZ,
        TRIEBSCHUTZMANSCHETTE,
        CHEMISCHER_SCHUTZ,
        SCHAELSCHUTZ,
        FLAECHENSCHUTZ;


        public String toString() {
            switch (this) {
                case WUCHSHUELLE: {
                    return Messages.getString("Wildschutz.Schutztyp.Wuchshuelle");
                }
                case KUNSTSTOFFKORB: {
                    return Messages.getString("Wildschutz.Schutztyp.Kunststoffkorb");
                }
                case DRAHTKORB_LEICHT: {
                    return Messages.getString("Wildschutz.Schutztyp.DrahtkorbLeicht");
                }
                case DRAHTKORB_MASSIV: {
                    return Messages.getString("Wildschutz.Schutztyp.DrahtkorbMassiv");
                }
                case EINZELSCHUTZ_HOLZ: {
                    return Messages.getString("Wildschutz.Schutztyp.EinzelschutzHolz");
                }
                case TRIEBSCHUTZMANSCHETTE: {
                    return Messages.getString("Wildschutz.Schutztyp.Triebschutzmanschette");
                }
                case CHEMISCHER_SCHUTZ: {
                    return Messages.getString("Wildschutz.Schutztyp.ChemischerSchutz");
                }
                case SCHAELSCHUTZ: {
                    return Messages.getString("Wildschutz.Schutztyp.Schaelschutz");
                }
                case FLAECHENSCHUTZ: {
                    return Messages.getString("Wildschutz.Schutztyp.Flaechenschutz");
                }
            }
            throw new RuntimeException(this.name());
        }

        public static Schutztyp getDefault() {
            return WUCHSHUELLE;
        }
    }

    public static enum Subtyp {
        REHWILDSICHER_ABBAUBAR,
        REHWILDSICHER_NICHT_ABBAUBAR,
        ROTWILDSICHER_ABBAUBAR,
        ROTWILDSICHER_NICHT_ABBAUBAR,
        REHWILDSICHER,
        ROTWILDSICHER,
        REHWILDSICHER_HOLZPFAHL,
        ROTWILDSICHER_HOLZPFAHL,
        REHWILDSICHER_EISENPFAHL,
        ROTWILDSICHER_EISENPFAHL;


        public String toString() {
            switch (this) {
                case REHWILDSICHER_ABBAUBAR: {
                    return Messages.getString("Wildschutz.Subtyp.rehwildsicherAbbaubar");
                }
                case REHWILDSICHER_NICHT_ABBAUBAR: {
                    return Messages.getString("Wildschutz.Subtyp.rehwildsicherNichtAbbaubar");
                }
                case ROTWILDSICHER_ABBAUBAR: {
                    return Messages.getString("Wildschutz.Subtyp.rotwildsicherAbbaubar");
                }
                case ROTWILDSICHER_NICHT_ABBAUBAR: {
                    return Messages.getString("Wildschutz.Subtyp.rotwildsicherNichtAbbaubar");
                }
                case REHWILDSICHER: {
                    return Messages.getString("Wildschutz.Subtyp.rehwildsicher");
                }
                case ROTWILDSICHER: {
                    return Messages.getString("Wildschutz.Subtyp.rotwildsicher");
                }
                case REHWILDSICHER_HOLZPFAHL: {
                    return Messages.getString("Wildschutz.Subtyp.rehwildsicherHolzpfahl");
                }
                case ROTWILDSICHER_HOLZPFAHL: {
                    return Messages.getString("Wildschutz.Subtyp.rotwildsicherHolzpfahl");
                }
                case REHWILDSICHER_EISENPFAHL: {
                    return Messages.getString("Wildschutz.Subtyp.rehwildsicherEisenpfahl");
                }
                case ROTWILDSICHER_EISENPFAHL: {
                    return Messages.getString("Wildschutz.Subtyp.rotwildsicherEisenpfahl");
                }
            }
            throw new RuntimeException(this.name());
        }

        public static Subtyp[] getValues(Schutztyp schutztyp) {
            if (schutztyp == null) {
                return new Subtyp[0];
            }
            switch (schutztyp) {
                case WUCHSHUELLE: {
                    return new Subtyp[]{REHWILDSICHER_ABBAUBAR, REHWILDSICHER_NICHT_ABBAUBAR, ROTWILDSICHER_ABBAUBAR, ROTWILDSICHER_NICHT_ABBAUBAR};
                }
                case KUNSTSTOFFKORB: 
                case EINZELSCHUTZ_HOLZ: {
                    return new Subtyp[]{REHWILDSICHER};
                }
                case DRAHTKORB_LEICHT: 
                case DRAHTKORB_MASSIV: {
                    return new Subtyp[]{REHWILDSICHER, ROTWILDSICHER};
                }
                case TRIEBSCHUTZMANSCHETTE: 
                case CHEMISCHER_SCHUTZ: 
                case SCHAELSCHUTZ: {
                    return new Subtyp[0];
                }
                case FLAECHENSCHUTZ: {
                    return new Subtyp[]{REHWILDSICHER_HOLZPFAHL, ROTWILDSICHER_HOLZPFAHL, REHWILDSICHER_EISENPFAHL, ROTWILDSICHER_EISENPFAHL};
                }
            }
            throw new RuntimeException("unknown Schutztyp: " + schutztyp.name());
        }
    }

    public static enum Wuchshuellentyp {
        TUBEX_VENTEX_90(2.2),
        TUBEX_VENTEX_120(2.4),
        TUBEX_VENTEX_150(3.0),
        PLANT_SAVER_90(1.2),
        PLANT_SAVER_120(1.6),
        PLANT_SAVER_150(1.9),
        TUBEX_VENTEX_12D(3.2),
        FORTE_TUBE_120(1.8),
        FORTE_TUBE_150(2.6),
        TUBEX_VENTEX_180(3.8),
        FORTE_TUBE_180(3.5),
        PLANT_SAVER_180(2.1);

        private final double kosten;
        private final DecimalFormat format = new DecimalFormat("0.00");

        private Wuchshuellentyp(double kosten) {
            this.kosten = kosten;
        }

        public String toString() {
            String suffix = " (" + this.format.format(this.kosten) + " " + Messages.getString("Wildschutz.Wuchshuellentyp.CHFproStueck") + ")";
            switch (this) {
                case TUBEX_VENTEX_90: {
                    return "Tubex Ventex 90 cm" + suffix;
                }
                case TUBEX_VENTEX_120: {
                    return "Tubex Ventex 120 cm" + suffix;
                }
                case TUBEX_VENTEX_150: {
                    return "Tubex Ventex 150 cm" + suffix;
                }
                case PLANT_SAVER_90: {
                    return "Plant Saver \"Microvent VarioWING\" 90 cm" + suffix;
                }
                case PLANT_SAVER_120: {
                    return "Plant Saver \"Microvent VarioWING\" 120 cm" + suffix;
                }
                case PLANT_SAVER_150: {
                    return "Plant Saver \"Microvent VarioWING\" 150 cm" + suffix;
                }
                case TUBEX_VENTEX_12D: {
                    return "Tubex Ventex 120 cm " + Messages.getString("Wildschutz.Wuchshuellentyp.SuffixAbbaubar") + suffix;
                }
                case FORTE_TUBE_120: {
                    return "Forte Tube Makrovent 120 cm " + Messages.getString("Wildschutz.Wuchshuellentyp.SuffixAbbaubar") + suffix;
                }
                case FORTE_TUBE_150: {
                    return "Forte Tube Makrovent 150 cm " + Messages.getString("Wildschutz.Wuchshuellentyp.SuffixAbbaubar") + suffix;
                }
                case TUBEX_VENTEX_180: {
                    return "Tubex Ventex 180 cm" + suffix;
                }
                case FORTE_TUBE_180: {
                    return "Forte Tube Makrovent 180 cm " + Messages.getString("Wildschutz.Wuchshuellentyp.SuffixAbbaubar") + suffix;
                }
                case PLANT_SAVER_180: {
                    return "Plant Saver \"Microvent VarioWING\" 180 cm" + suffix;
                }
            }
            throw new RuntimeException(this.name());
        }

        public double getKosten() {
            return this.kosten;
        }

        public static Wuchshuellentyp[] getValues(Subtyp subtyp) {
            if (subtyp == null) {
                return new Wuchshuellentyp[0];
            }
            switch (subtyp) {
                case REHWILDSICHER_ABBAUBAR: {
                    return new Wuchshuellentyp[]{TUBEX_VENTEX_12D, FORTE_TUBE_120, FORTE_TUBE_150};
                }
                case REHWILDSICHER_NICHT_ABBAUBAR: {
                    return new Wuchshuellentyp[]{TUBEX_VENTEX_90, TUBEX_VENTEX_120, TUBEX_VENTEX_150, PLANT_SAVER_90, PLANT_SAVER_120, PLANT_SAVER_150};
                }
                case ROTWILDSICHER_ABBAUBAR: {
                    return new Wuchshuellentyp[]{FORTE_TUBE_180};
                }
                case ROTWILDSICHER_NICHT_ABBAUBAR: {
                    return new Wuchshuellentyp[]{TUBEX_VENTEX_180, PLANT_SAVER_180};
                }
            }
            throw new RuntimeException("unknown subtyp: " + subtyp.name());
        }

        public static Wuchshuellentyp getDefault(Subtyp subtyp) {
            if (subtyp == null) {
                return null;
            }
            switch (subtyp) {
                case REHWILDSICHER_ABBAUBAR: {
                    return TUBEX_VENTEX_12D;
                }
                case REHWILDSICHER_NICHT_ABBAUBAR: {
                    return TUBEX_VENTEX_120;
                }
                case ROTWILDSICHER_ABBAUBAR: {
                    return FORTE_TUBE_180;
                }
                case ROTWILDSICHER_NICHT_ABBAUBAR: {
                    return TUBEX_VENTEX_180;
                }
            }
            throw new RuntimeException("unknown subtyp: " + subtyp.name());
        }
    }
}

