/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.juwapfl.model;

import ch.wsl.fps.juwapfl.model.AbstractJuwapflModelTest;
import ch.wsl.fps.juwapfl.model.RueckegassenErgebnis;
import ch.wsl.fps.juwapfl.model.RueckegassenMockErgebnis;
import ch.wsl.fps.juwapfl.model.RueckegassenModel;
import org.testng.annotations.Test;

public class RueckegassenModelTest
extends AbstractJuwapflModelTest {
    @Override
    protected String getCsvPath() {
        return "testcases/Rueckegassen.csv";
    }

    @Override
    protected RueckegassenModel parseInputData(String[] testcase) {
        RueckegassenModel result = new RueckegassenModel();
        result.setFlaeche_ha(Double.valueOf(testcase[0]));
        result.setVerhaeltnisse(RueckegassenModel.Verhaeltnisse.valueOf(testcase[1]));
        result.setAbstandRueckegassen_m(Integer.valueOf(testcase[2]));
        result.setHilfskraft(RueckegassenModel.Hilfskraft.valueOf(testcase[3]));
        result.setOrtskenntnisse(RueckegassenModel.Ortskenntnisse.valueOf(testcase[4]));
        result.setUebungPlanungsverfahren(RueckegassenModel.UebungPlanungsverfahren.valueOf(testcase[5]));
        result.setKostenHauptperson_proH(Double.valueOf(testcase[6]));
        result.setKostenHilfskraft_proH(Double.valueOf(testcase[7]));
        result.setFaktorWegzeitenUndPausen(Double.valueOf(testcase[8]));
        result.setKostenGeraete_proH(Double.valueOf(testcase[9]));
        return result;
    }

    @Override
    protected RueckegassenMockErgebnis parseExpectedValues(String[] testcase) {
        double[] values = this.getDoubleValues(testcase, 10);
        RueckegassenMockErgebnis result = new RueckegassenMockErgebnis();
        int i = 0;
        result.setZeitaufwandHauptperson_minProHektar(values[i++] * 60.0);
        result.setZeitaufwandHauptperson_minGesamtflaeche(values[i++] * 60.0);
        result.setZeitaufwandHilfskraft_minProHektar(values[i++] * 60.0);
        result.setZeitaufwandHilfskraft_minGesamtflaeche(values[i++] * 60.0);
        result.setKostenHauptperson_proHektar(values[i++]);
        result.setKostenHauptperson_Gesamtflaeche(values[i++]);
        result.setKostenHilfskraft_proHektar(values[i++]);
        result.setKostenHilfskraft_Gesamtflaeche(values[i++]);
        result.setKostenMaterial_proHektar(values[i++]);
        result.setKostenMaterial_Gesamtflaeche(values[i++]);
        result.setKostenGesamt_proHektar(values[i++]);
        result.setKostenGesamt_Gesamtflaeche(values[i++]);
        return result;
    }

    @Test(dataProvider="csvData")
    public void testZeitaufwandHauptperson_minProHektar(String testcaseName, RueckegassenErgebnis actualOutput, RueckegassenMockErgebnis expectedOutput) {
        this.assertEqualsDynamicDeltaMinutes(actualOutput.getZeitaufwandHauptperson_minProHektar(), expectedOutput.getZeitaufwandHauptperson_minProHektar());
    }

    @Test(dataProvider="csvData")
    public void testZeitaufwandHauptperson_minGesamtflaeche(String testcaseName, RueckegassenErgebnis actualOutput, RueckegassenMockErgebnis expectedOutput) {
        this.assertEqualsDynamicDeltaMinutes(actualOutput.getZeitaufwandHauptperson_minGesamtflaeche(), expectedOutput.getZeitaufwandHauptperson_minGesamtflaeche());
    }

    @Test(dataProvider="csvData")
    public void testZeitaufwandHilfskraft_minProHektar(String testcaseName, RueckegassenErgebnis actualOutput, RueckegassenMockErgebnis expectedOutput) {
        this.assertEqualsDynamicDeltaMinutes(actualOutput.getZeitaufwandHilfskraft_minProHektar(), expectedOutput.getZeitaufwandHilfskraft_minProHektar());
    }

    @Test(dataProvider="csvData")
    public void testZeitaufwandHilfskraft_minGesamtflaeche(String testcaseName, RueckegassenErgebnis actualOutput, RueckegassenMockErgebnis expectedOutput) {
        this.assertEqualsDynamicDeltaMinutes(actualOutput.getZeitaufwandHilfskraft_minGesamtflaeche(), expectedOutput.getZeitaufwandHilfskraft_minGesamtflaeche());
    }

    @Test(dataProvider="csvData")
    public void testKostenHauptperson_proHektar(String testcaseName, RueckegassenErgebnis actualOutput, RueckegassenMockErgebnis expectedOutput) {
        this.assertEqualsDynamicDeltaMinutes(actualOutput.getKostenHauptperson_proHektar(), expectedOutput.getKostenHauptperson_proHektar());
    }

    @Test(dataProvider="csvData")
    public void testKostenHauptperson_Gesamtflaeche(String testcaseName, RueckegassenErgebnis actualOutput, RueckegassenMockErgebnis expectedOutput) {
        this.assertEqualsDynamicDeltaMinutes(actualOutput.getKostenHauptperson_Gesamtflaeche(), expectedOutput.getKostenHauptperson_Gesamtflaeche());
    }

    @Test(dataProvider="csvData")
    public void testKostenHilfskraft_proHektar(String testcaseName, RueckegassenErgebnis actualOutput, RueckegassenMockErgebnis expectedOutput) {
        this.assertEqualsDynamicDeltaMinutes(actualOutput.getKostenHilfskraft_proHektar(), expectedOutput.getKostenHilfskraft_proHektar());
    }

    @Test(dataProvider="csvData")
    public void testKostenHilfskraft_Gesamtflaeche(String testcaseName, RueckegassenErgebnis actualOutput, RueckegassenMockErgebnis expectedOutput) {
        this.assertEqualsDynamicDeltaMinutes(actualOutput.getKostenHilfskraft_Gesamtflaeche(), expectedOutput.getKostenHilfskraft_Gesamtflaeche());
    }

    @Test(dataProvider="csvData")
    public void testKostenMaterial_proHektar(String testcaseName, RueckegassenErgebnis actualOutput, RueckegassenMockErgebnis expectedOutput) {
        this.assertEqualsDynamicDeltaMinutes(actualOutput.getKostenMaterial_proHektar(), expectedOutput.getKostenMaterial_proHektar());
    }

    @Test(dataProvider="csvData")
    public void testKostenMaterial_Gesamtflaeche(String testcaseName, RueckegassenErgebnis actualOutput, RueckegassenMockErgebnis expectedOutput) {
        this.assertEqualsDynamicDeltaMinutes(actualOutput.getKostenMaterial_Gesamtflaeche(), expectedOutput.getKostenMaterial_Gesamtflaeche());
    }

    @Test(dataProvider="csvData")
    public void testKostenGesamt_proHektar(String testcaseName, RueckegassenErgebnis actualOutput, RueckegassenMockErgebnis expectedOutput) {
        this.assertEqualsDynamicDeltaMinutes(actualOutput.getKostenGesamt_proHektar(), expectedOutput.getKostenGesamt_proHektar());
    }

    @Test(dataProvider="csvData")
    public void testKostenGesamt_Gesamtflaeche(String testcaseName, RueckegassenErgebnis actualOutput, RueckegassenMockErgebnis expectedOutput) {
        this.assertEqualsDynamicDeltaMinutes(actualOutput.getKostenGesamt_Gesamtflaeche(), expectedOutput.getKostenGesamt_Gesamtflaeche());
    }
}

