/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.juwapfl.model;

import ch.wsl.fps.juwapfl.Messages;
import ch.wsl.fps.juwapfl.model.AbstractModel;
import ch.wsl.fps.juwapfl.model.PflanzungErgebnis;
import ch.wsl.fps.juwapfl.model.PflanzungWinkelpflanzungModel;

public class PflanzungModel
extends AbstractModel {
    private static final double zeitaufwandPflanzungBuchenbuehlerEinfach_PflProH = 120.0;
    private static final double zeitaufwandPflanzungBuchenbuehlerMittel_PflProH = 100.0;
    private static final double zeitaufwandPflanzungBuchenbuehlerSchwierig_PflProH = 80.0;
    private static final double zeitaufwandPflanzungRhodenerKlemmSpaltpflanzungEinfach_PflProH = 81.0;
    private static final double zeitaufwandPflanzungRhodenerKlemmSpaltpflanzungMittel_PflProH = 65.0;
    private static final double zeitaufwandPflanzungRhodenerKlemmSpaltpflanzungSchwierig_PflProH = 49.0;
    private static final double zeitaufwandPflanzungRhodenerLochpflanzungEinfach_PflProH = 65.0;
    private static final double zeitaufwandPflanzungRhodenerLochpflanzungMittel_PflProH = 43.0;
    private static final double zeitaufwandPflanzungRhodenerLochpflanzungSchwierig_PflProH = 27.0;
    private static final double zeitaufwandPflanzungRhodenerTopfpflanzungEinfach_PflProH = 65.0;
    private static final double zeitaufwandPflanzungRhodenerTopfpflanzungMittel_PflProH = 52.0;
    private static final double zeitaufwandPflanzungRhodenerTopfpflanzungSchwierig_PflProH = 37.0;
    private static final double zeitaufwandPflanzungHohlspatenKlemmSpaltpflanzungEinfach_PflProH = 65.0;
    private static final double zeitaufwandPflanzungHohlspatenKlemmSpaltpflanzungMittel_PflProH = 54.0;
    private static final double zeitaufwandPflanzungHohlspatenKlemmSpaltpflanzungSchwierig_PflProH = 43.0;
    private static final double zeitaufwandPflanzungHohlspatenLochpflanzungEinfach_PflProH = 54.0;
    private static final double zeitaufwandPflanzungHohlspatenLochpflanzungMittel_PflProH = 43.0;
    private static final double zeitaufwandPflanzungHohlspatenLochpflanzungSchwierig_PflProH = 27.0;
    private static final double zeitaufwandPflanzungHohlspatenTopfpflanzungEinfach_PflProH = 60.0;
    private static final double zeitaufwandPflanzungHohlspatenTopfpflanzungMittel_PflProH = 45.0;
    private static final double zeitaufwandPflanzungHohlspatenTopfpflanzungSchwierig_PflProH = 30.0;
    private static final double zeitaufwandPflanzungWiedehopfhaueWinkelpflanzungNadelholz_PflProH = 100.0;
    private static final double zeitaufwandPflanzungWiedehopfhaueWinkelpflanzungLaubholz_PflProH = 120.0;
    private static final double zeitaufwandPflanzungWiedehopfhaueLochpflanzungEinfach_PflProH = 56.0;
    private static final double zeitaufwandPflanzungWiedehopfhaueLochpflanzungMittel_PflProH = 45.0;
    private static final double zeitaufwandPflanzungWiedehopfhaueLochpflanzungSchwierig_PflProH = 28.0;
    private static final double zeitaufwandPflanzungErdbohrerManuellEinfach_PflProH = 27.0;
    private static final double zeitaufwandPflanzungErdbohrerManuellMittel_PflProH = 14.0;
    private static final double zeitaufwandPflanzungErdbohrerManuellSchwierig_PflProH = 10.0;
    private static final double zeitaufwandPflanzungErdbohrerMaschinellEinfach_PflProH = 71.0;
    private static final double zeitaufwandPflanzungErdbohrerMaschinellMittel_PflProH = 40.0;
    private static final double zeitaufwandPflanzungErdbohrerMaschinellSchwierig_PflProH = 29.0;
    private static final double zeitaufwandPflanzungAnbaugeraetEinfach_PflProH = 143.0;
    private static final double zeitaufwandPflanzungAnbaugeraetMittel_PflProH = 77.0;
    private static final double zeitaufwandPflanzungAnbaugeraetSchwierig_PflProH = 56.0;
    private int anzahlPflanzen;
    private Pflanzwerkzeug pflanzwerkzeug;
    private Pflanztechnik pflanztechnik;
    private Baumart baumart;
    private Schwierigkeitsgrad schwierigkeitsgrad;
    private PflanzungWinkelpflanzungModel winkelpflanzungModel;
    private double zeitBeschaffung_h;
    private double kostenProPflanze;
    private double zeitTransport_h;
    private double kostenTransportmittel;
    private double zeitPflanzung_PflProH;
    private double anteilMaschinenlaufzeit_Prz;
    private double kostensatzGeraet_proH;
    private double zeitUnterhalt_Prozent;
    private int kostenPersonalProPerson_proH;
    private double faktorWegzeitenUndPausen;

    public int getAnzahlPflanzen() {
        return this.anzahlPflanzen;
    }

    public void setAnzahlPflanzen(int anzahlPflanzen) {
        this.anzahlPflanzen = anzahlPflanzen;
    }

    public void setPflanzwerkzeug(Pflanzwerkzeug pflanzwerkzeug) {
        this.pflanzwerkzeug = pflanzwerkzeug;
    }

    public void setPflanztechnik(Pflanztechnik pflanztechnik) {
        this.pflanztechnik = pflanztechnik;
    }

    public void setBaumart(Baumart baumart) {
        this.baumart = baumart;
    }

    public void setSchwierigkeitsgrad(Schwierigkeitsgrad schwierigkeitsgrad) {
        this.schwierigkeitsgrad = schwierigkeitsgrad;
    }

    public void setWinkelpflanzungModel(PflanzungWinkelpflanzungModel winkelpflanzungModel) {
        this.winkelpflanzungModel = winkelpflanzungModel;
    }

    public void setZeitBeschaffung_h(double zeitBeschaffung_h) {
        this.zeitBeschaffung_h = zeitBeschaffung_h;
    }

    public void setKostenProPflanze(double kostenProPflanze) {
        this.kostenProPflanze = kostenProPflanze;
    }

    public void setZeitTransport_h(double zeitTransport_h) {
        this.zeitTransport_h = zeitTransport_h;
    }

    public void setKostenTransportmittel(double kostenTransportmittel) {
        this.kostenTransportmittel = kostenTransportmittel;
    }

    public void setZeitPflanzung_PflProH(double zeitPflanzung_PflProH) {
        this.zeitPflanzung_PflProH = zeitPflanzung_PflProH;
    }

    public void setAnteilMaschinenlaufzeit_Prz(double anteilMaschinenlaufzeit_Prz) {
        this.anteilMaschinenlaufzeit_Prz = anteilMaschinenlaufzeit_Prz;
    }

    public void setKostensatzGeraet_proH(double kostensatzGeraet_proH) {
        this.kostensatzGeraet_proH = kostensatzGeraet_proH;
    }

    public void setZeitUnterhalt_Prozent(double zeitUnterhalt_Prozent) {
        this.zeitUnterhalt_Prozent = zeitUnterhalt_Prozent;
    }

    public void setKostenPersonalProPerson_proH(int kostenPersonalProPerson_proH) {
        this.kostenPersonalProPerson_proH = kostenPersonalProPerson_proH;
    }

    public void setFaktorWegzeitenUndPausen(double faktorWegzeitenUndPausen) {
        this.faktorWegzeitenUndPausen = faktorWegzeitenUndPausen;
    }

    @Override
    public PflanzungErgebnis getErgebnis() {
        PflanzungErgebnis ergebnis = new PflanzungErgebnis();
        int anzahlPersonen = this.pflanztechnik == Pflanztechnik.MASCHINELL ? 2 : 1;
        double zeitUnterhalt_Faktor = this.zeitUnterhalt_Prozent / 100.0;
        double zeitPflanzung_h = (double)this.anzahlPflanzen / this.zeitPflanzung_PflProH;
        ergebnis.setZeitPersonalBeschaffung_min(this.zeitBeschaffung_h * 60.0);
        ergebnis.setZeitPersonalTransport_min(this.zeitTransport_h * 60.0);
        ergebnis.setZeitPersonalPflanzung_min(zeitPflanzung_h * 60.0 * this.faktorWegzeitenUndPausen * 1.1);
        ergebnis.setZeitPersonalUnterhalt_min(zeitPflanzung_h * 60.0 * this.faktorWegzeitenUndPausen * 1.1 * zeitUnterhalt_Faktor);
        ergebnis.setZeitGeraetePflanzung_min(zeitPflanzung_h * 60.0 * (this.anteilMaschinenlaufzeit_Prz / 100.0));
        ergebnis.setKostenPersonalBeschaffung(this.zeitBeschaffung_h * (double)this.kostenPersonalProPerson_proH);
        ergebnis.setKostenPersonalTransport(this.zeitTransport_h * (double)this.kostenPersonalProPerson_proH);
        ergebnis.setKostenPersonalPflanzung(zeitPflanzung_h * this.faktorWegzeitenUndPausen * 1.1 * (double)this.kostenPersonalProPerson_proH * (double)anzahlPersonen);
        ergebnis.setKostenPersonalUnterhalt(zeitPflanzung_h * this.faktorWegzeitenUndPausen * 1.1 * zeitUnterhalt_Faktor * (double)this.kostenPersonalProPerson_proH);
        ergebnis.setKostenTransportmittelTransport(this.kostenTransportmittel);
        ergebnis.setKostenPflanzenBeschaffung((double)this.anzahlPflanzen * this.kostenProPflanze);
        ergebnis.setKostenGeraetePflanzung(zeitPflanzung_h * (this.anteilMaschinenlaufzeit_Prz / 100.0) * this.kostensatzGeraet_proH);
        return ergebnis;
    }

    public static double getDefaultKostenProPflanze(Pflanzwerkzeug pflanzwerkzeug, Pflanztechnik pflanztechnik) {
        switch (pflanzwerkzeug) {
            case BUCHENBUEHLER_PFLANZHAUE: {
                return 2.4;
            }
            case RHODENER_PFLANZHAUE: 
            case HOHLSPATEN: {
                if (pflanztechnik == Pflanztechnik.KLEMM_ODER_SPALTPFLANZUNG) {
                    return 2.4;
                }
                if (pflanztechnik == Pflanztechnik.LOCHPFLANZUNG) {
                    return 3.5;
                }
                if (pflanztechnik == Pflanztechnik.TOPFPFLANZUNG) {
                    return 3.5;
                }
                throw new RuntimeException(String.valueOf(pflanzwerkzeug.name()) + " " + pflanztechnik.name());
            }
            case WIEDEHOPFHAUE: {
                return 2.4;
            }
            case ERDBOHRER: 
            case ANBAUGERAET: {
                return 3.5;
            }
        }
        throw new RuntimeException(pflanzwerkzeug.name());
    }

    public static double getDefaultZeitaufwandPflanzung_PflProH(Pflanzwerkzeug pflanzwerkzeug, Pflanztechnik pflanztechnik, Baumart baumart, Schwierigkeitsgrad schwierigkeit, PflanzungWinkelpflanzungModel winkelpflanzungModel) {
        switch (pflanzwerkzeug) {
            case BUCHENBUEHLER_PFLANZHAUE: {
                switch (schwierigkeit) {
                    case EINFACH: {
                        return 120.0;
                    }
                    case MITTEL: {
                        return 100.0;
                    }
                    case SCHWIERIG: {
                        return 80.0;
                    }
                }
                throw new RuntimeException(schwierigkeit.name());
            }
            case RHODENER_PFLANZHAUE: {
                if (pflanztechnik == Pflanztechnik.KLEMM_ODER_SPALTPFLANZUNG) {
                    switch (schwierigkeit) {
                        case EINFACH: {
                            return 81.0;
                        }
                        case MITTEL: {
                            return 65.0;
                        }
                        case SCHWIERIG: {
                            return 49.0;
                        }
                    }
                    throw new RuntimeException(schwierigkeit.name());
                }
                if (pflanztechnik == Pflanztechnik.LOCHPFLANZUNG) {
                    switch (schwierigkeit) {
                        case EINFACH: {
                            return 65.0;
                        }
                        case MITTEL: {
                            return 43.0;
                        }
                        case SCHWIERIG: {
                            return 27.0;
                        }
                    }
                    throw new RuntimeException(schwierigkeit.name());
                }
                if (pflanztechnik == Pflanztechnik.TOPFPFLANZUNG) {
                    switch (schwierigkeit) {
                        case EINFACH: {
                            return 65.0;
                        }
                        case MITTEL: {
                            return 52.0;
                        }
                        case SCHWIERIG: {
                            return 37.0;
                        }
                    }
                    throw new RuntimeException(schwierigkeit.name());
                }
                throw new RuntimeException(String.valueOf(pflanzwerkzeug.name()) + " " + pflanztechnik.name());
            }
            case HOHLSPATEN: {
                if (pflanztechnik == Pflanztechnik.KLEMM_ODER_SPALTPFLANZUNG) {
                    switch (schwierigkeit) {
                        case EINFACH: {
                            return 65.0;
                        }
                        case MITTEL: {
                            return 54.0;
                        }
                        case SCHWIERIG: {
                            return 43.0;
                        }
                    }
                    throw new RuntimeException(schwierigkeit.name());
                }
                if (pflanztechnik == Pflanztechnik.LOCHPFLANZUNG) {
                    switch (schwierigkeit) {
                        case EINFACH: {
                            return 54.0;
                        }
                        case MITTEL: {
                            return 43.0;
                        }
                        case SCHWIERIG: {
                            return 27.0;
                        }
                    }
                    throw new RuntimeException(schwierigkeit.name());
                }
                if (pflanztechnik == Pflanztechnik.TOPFPFLANZUNG) {
                    switch (schwierigkeit) {
                        case EINFACH: {
                            return 60.0;
                        }
                        case MITTEL: {
                            return 45.0;
                        }
                        case SCHWIERIG: {
                            return 30.0;
                        }
                    }
                    throw new RuntimeException(schwierigkeit.name());
                }
                throw new RuntimeException(String.valueOf(pflanzwerkzeug.name()) + " " + pflanztechnik.name());
            }
            case WIEDEHOPFHAUE: {
                if (pflanztechnik == Pflanztechnik.WINKELPFLANZUNG) {
                    return PflanzungModel.getDefaultZeitaufwandWinkelpflanzung_PflProH(baumart, winkelpflanzungModel);
                }
                if (pflanztechnik == Pflanztechnik.LOCHPFLANZUNG) {
                    switch (schwierigkeit) {
                        case EINFACH: {
                            return 56.0;
                        }
                        case MITTEL: {
                            return 45.0;
                        }
                        case SCHWIERIG: {
                            return 28.0;
                        }
                    }
                    throw new RuntimeException(schwierigkeit.name());
                }
                throw new RuntimeException(pflanztechnik.name());
            }
            case ERDBOHRER: {
                if (pflanztechnik == Pflanztechnik.MANUELL) {
                    switch (schwierigkeit) {
                        case EINFACH: {
                            return 27.0;
                        }
                        case MITTEL: {
                            return 14.0;
                        }
                        case SCHWIERIG: {
                            return 10.0;
                        }
                    }
                    throw new RuntimeException(schwierigkeit.name());
                }
                if (pflanztechnik == Pflanztechnik.MASCHINELL) {
                    switch (schwierigkeit) {
                        case EINFACH: {
                            return 71.0;
                        }
                        case MITTEL: {
                            return 40.0;
                        }
                        case SCHWIERIG: {
                            return 29.0;
                        }
                    }
                    throw new RuntimeException(schwierigkeit.name());
                }
                throw new RuntimeException(String.valueOf(pflanzwerkzeug.name()) + " " + pflanztechnik.name());
            }
            case ANBAUGERAET: {
                switch (schwierigkeit) {
                    case EINFACH: {
                        return 143.0;
                    }
                    case MITTEL: {
                        return 77.0;
                    }
                    case SCHWIERIG: {
                        return 56.0;
                    }
                }
                throw new RuntimeException(schwierigkeit.name());
            }
        }
        throw new RuntimeException(pflanzwerkzeug.name());
    }

    private static double getDefaultZeitaufwandWinkelpflanzung_PflProH(Baumart baumart, PflanzungWinkelpflanzungModel winkelpflanzungModel) {
        double grundgeschwindigkeit_PflProH;
        if (baumart == Baumart.NADELHOLZ) {
            grundgeschwindigkeit_PflProH = 100.0;
        } else if (baumart == Baumart.LAUBHOLZ) {
            grundgeschwindigkeit_PflProH = 120.0;
        } else {
            throw new RuntimeException("Baumart: " + (Object)((Object)baumart));
        }
        double grundzeit_hPro100Pflanzen = 100.0 / grundgeschwindigkeit_PflProH;
        grundzeit_hPro100Pflanzen += winkelpflanzungModel.getBodenvegetation().getDefaultZuschlag_hPro100Pflanzen(baumart);
        grundzeit_hPro100Pflanzen += winkelpflanzungModel.getSchlagabraum().getDefaultZuschlag_hPro100Pflanzen(baumart);
        grundzeit_hPro100Pflanzen += winkelpflanzungModel.getHangneigung().getDefaultZuschlag_hPro100Pflanzen(baumart);
        grundzeit_hPro100Pflanzen += winkelpflanzungModel.getPflanzenhoehe().getDefaultZuschlag_hPro100Pflanzen(baumart);
        double geschwindigkeit_PflProH = 100.0 / (grundzeit_hPro100Pflanzen += winkelpflanzungModel.getTransportdistanz().getDefaultZuschlag_hPro100Pflanzen(baumart));
        geschwindigkeit_PflProH = (double)Math.round(geschwindigkeit_PflProH * 10.0) / 10.0;
        return geschwindigkeit_PflProH;
    }

    public static int getDefaultAnteilMaschinenlaufzeit_Prz(Pflanzwerkzeug pflanzwerkzeug, Pflanztechnik pflanztechnik, Schwierigkeitsgrad schwierigkeit) {
        if (pflanztechnik == Pflanztechnik.MASCHINELL) {
            if (pflanzwerkzeug == Pflanzwerkzeug.ERDBOHRER) {
                switch (schwierigkeit) {
                    case EINFACH: {
                        return 40;
                    }
                    case MITTEL: {
                        return 25;
                    }
                    case SCHWIERIG: {
                        return 20;
                    }
                }
                throw new RuntimeException(schwierigkeit.name());
            }
            if (pflanzwerkzeug == Pflanzwerkzeug.ANBAUGERAET) {
                switch (schwierigkeit) {
                    case EINFACH: {
                        return 70;
                    }
                    case MITTEL: {
                        return 50;
                    }
                    case SCHWIERIG: {
                        return 40;
                    }
                }
                throw new RuntimeException(schwierigkeit.name());
            }
            throw new RuntimeException(pflanzwerkzeug.name());
        }
        return 0;
    }

    public static double getDefaultKostensatzGeraet_proH(Pflanzwerkzeug pflanzwerkzeug, Pflanztechnik pflanztechnik) {
        if (pflanzwerkzeug == Pflanzwerkzeug.ERDBOHRER && pflanztechnik == Pflanztechnik.MASCHINELL) {
            return 15.0;
        }
        if (pflanzwerkzeug == Pflanzwerkzeug.ANBAUGERAET) {
            return 35.0;
        }
        return 0.0;
    }

    public static enum Baumart {
        NADELHOLZ,
        LAUBHOLZ;


        public String toString() {
            switch (this) {
                case NADELHOLZ: {
                    return Messages.getString("Pflanzung.Baumart.Nadelholz");
                }
                case LAUBHOLZ: {
                    return Messages.getString("Pflanzung.Baumart.Laubholz");
                }
            }
            throw new RuntimeException(this.name());
        }

        public static Baumart getDefault() {
            return NADELHOLZ;
        }
    }

    public static enum Pflanztechnik {
        KLEMM_ODER_SPALTPFLANZUNG,
        WINKELPFLANZUNG,
        LOCHPFLANZUNG,
        TOPFPFLANZUNG,
        MANUELL,
        MASCHINELL;


        public String toString() {
            switch (this) {
                case KLEMM_ODER_SPALTPFLANZUNG: {
                    return Messages.getString("Pflanzung.Pflanztechnik.KlemmSpaltpflanzung");
                }
                case WINKELPFLANZUNG: {
                    return Messages.getString("Pflanzung.Pflanztechnik.Winkelpflanzung");
                }
                case LOCHPFLANZUNG: {
                    return Messages.getString("Pflanzung.Pflanztechnik.Lochpflanzung");
                }
                case TOPFPFLANZUNG: {
                    return Messages.getString("Pflanzung.Pflanztechnik.Topfpflanzung");
                }
                case MANUELL: {
                    return Messages.getString("Pflanzung.Pflanztechnik.manuell");
                }
                case MASCHINELL: {
                    return Messages.getString("Pflanzung.Pflanztechnik.maschinell");
                }
            }
            throw new RuntimeException(this.name());
        }

        public static Pflanztechnik getDefault() {
            return KLEMM_ODER_SPALTPFLANZUNG;
        }

        public static Pflanztechnik[] getPflanztechniken(Pflanzwerkzeug pflanzwerkzeug) {
            switch (pflanzwerkzeug) {
                case BUCHENBUEHLER_PFLANZHAUE: {
                    return new Pflanztechnik[]{KLEMM_ODER_SPALTPFLANZUNG};
                }
                case RHODENER_PFLANZHAUE: 
                case HOHLSPATEN: {
                    return new Pflanztechnik[]{KLEMM_ODER_SPALTPFLANZUNG, LOCHPFLANZUNG, TOPFPFLANZUNG};
                }
                case WIEDEHOPFHAUE: {
                    return new Pflanztechnik[]{WINKELPFLANZUNG, LOCHPFLANZUNG};
                }
                case ERDBOHRER: {
                    return new Pflanztechnik[]{MANUELL, MASCHINELL};
                }
                case ANBAUGERAET: {
                    return new Pflanztechnik[]{MASCHINELL};
                }
            }
            throw new RuntimeException(pflanzwerkzeug.name());
        }
    }

    public static enum Pflanzwerkzeug {
        BUCHENBUEHLER_PFLANZHAUE,
        RHODENER_PFLANZHAUE,
        HOHLSPATEN,
        WIEDEHOPFHAUE,
        ERDBOHRER,
        ANBAUGERAET;


        public String toString() {
            switch (this) {
                case BUCHENBUEHLER_PFLANZHAUE: {
                    return Messages.getString("Pflanzung.Pflanzwerkzeug.BuchenbuehlerPflanzhaue");
                }
                case RHODENER_PFLANZHAUE: {
                    return Messages.getString("Pflanzung.Pflanzwerkzeug.RhodenerPflanzhaue");
                }
                case HOHLSPATEN: {
                    return Messages.getString("Pflanzung.Pflanzwerkzeug.Hohlspaten");
                }
                case WIEDEHOPFHAUE: {
                    return Messages.getString("Pflanzung.Pflanzwerkzeug.Wiedehopfhaue");
                }
                case ERDBOHRER: {
                    return Messages.getString("Pflanzung.Pflanzwerkzeug.Erdbohrer");
                }
                case ANBAUGERAET: {
                    return Messages.getString("Pflanzung.Pflanzwerkzeug.Anbaugeraet");
                }
            }
            throw new RuntimeException(this.name());
        }

        public static Pflanzwerkzeug getDefault() {
            return BUCHENBUEHLER_PFLANZHAUE;
        }
    }

    public static enum Schwierigkeitsgrad {
        EINFACH,
        MITTEL,
        SCHWIERIG;


        public String toString() {
            switch (this) {
                case EINFACH: {
                    return Messages.getString("Pflanzung.Schwierigkeitsgrad.einfach");
                }
                case MITTEL: {
                    return Messages.getString("Pflanzung.Schwierigkeitsgrad.mittel");
                }
                case SCHWIERIG: {
                    return Messages.getString("Pflanzung.Schwierigkeitsgrad.schwierig");
                }
            }
            throw new RuntimeException(this.name());
        }

        public static Schwierigkeitsgrad getDefault() {
            return EINFACH;
        }
    }
}

