/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.juwapfl.model;

import ch.wsl.fps.juwapfl.model.AbstractJuwapflModelTest;
import ch.wsl.fps.juwapfl.model.AustrichternErgebnis;
import ch.wsl.fps.juwapfl.model.AustrichternMockErgebnis;
import ch.wsl.fps.juwapfl.model.AustrichternModel;
import org.testng.annotations.Test;

public class AustrichternModelTest
extends AbstractJuwapflModelTest {
    @Override
    protected String getCsvPath() {
        return "testcases/Austrichtern.csv";
    }

    @Override
    protected AustrichternModel parseInputData(String[] testcase) {
        AustrichternModel result = new AustrichternModel();
        result.setFlaeche_ha(Double.valueOf(testcase[0]));
        result.setMaschinenGeraete(AustrichternModel.MaschinenGeraete.valueOf(testcase[1]));
        result.setAnzahlPflanzenProHa(Integer.valueOf(testcase[2]));
        result.setVerunkrautung(AustrichternModel.Verunkrautung.valueOf(testcase[3]));
        result.setHangneigung(AustrichternModel.Hangneigung.valueOf(testcase[4]));
        result.setRueckegassenVorhanden(AustrichternModel.RueckegassenVorhanden.valueOf(testcase[5]));
        result.setSchutzsystem(AustrichternModel.Schutzsystem.valueOf(testcase[6]));
        result.setTemperatur(AustrichternModel.Temperatur.valueOf(testcase[7]));
        result.setKostenPersonal_proH(Double.valueOf(testcase[8]));
        result.setKostenMotorsaege_proLiter(Double.valueOf(testcase[9]));
        result.setKostenSichel_proHektar(Double.valueOf(testcase[10]));
        result.setFaktorWegzeitenUndPausen(Double.valueOf(testcase[11]));
        return result;
    }

    @Override
    protected AustrichternMockErgebnis parseExpectedValues(String[] testcase) {
        double[] values = this.getDoubleValues(testcase, 12);
        AustrichternMockErgebnis result = new AustrichternMockErgebnis();
        int i = 0;
        result.setZeitaufwandPersonal_minProBaum(values[i++]);
        result.setZeitaufwandPersonal_minProHektar(values[i++]);
        result.setZeitaufwandPersonal_minProBestand(values[i++]);
        result.setKostenPersonal_proBaum(values[i++]);
        result.setKostenPersonal_proHektar(values[i++]);
        result.setKostenPersonal_proBestand(values[i++]);
        result.setKostenMaschinenGeraete_proBaum(values[i++]);
        result.setKostenMaschinenGeraete_proHektar(values[i++]);
        result.setKostenMaschinenGeraete_proBestand(values[i++]);
        result.setKostenGesamt_proBaum(values[i++]);
        result.setKostenGesamt_proHektar(values[i++]);
        result.setKostenGesamt_proBestand(values[i++]);
        return result;
    }

    @Test(dataProvider="csvData")
    public void testZeitaufwandPersonal_minProBaum(String testcaseName, AustrichternErgebnis actualOutput, AustrichternMockErgebnis expectedOutput) {
        this.assertEqualsDynamicDeltaMinutes(actualOutput.getZeitaufwandPersonal_minProBaum(), expectedOutput.getZeitaufwandPersonal_minProBaum());
    }

    @Test(dataProvider="csvData")
    public void testZeitaufwandPersonal_minProHektar(String testcaseName, AustrichternErgebnis actualOutput, AustrichternMockErgebnis expectedOutput) {
        this.assertEqualsDynamicDeltaMinutes(actualOutput.getZeitaufwandPersonal_minProHektar(), expectedOutput.getZeitaufwandPersonal_minProHektar());
    }

    @Test(dataProvider="csvData")
    public void testZeitaufwandPersonal_minProBestand(String testcaseName, AustrichternErgebnis actualOutput, AustrichternMockErgebnis expectedOutput) {
        this.assertEqualsDynamicDeltaMinutes(actualOutput.getZeitaufwandPersonal_minProBestand(), expectedOutput.getZeitaufwandPersonal_minProBestand());
    }

    @Test(dataProvider="csvData")
    public void testKostenPersonal_proBaum(String testcaseName, AustrichternErgebnis actualOutput, AustrichternMockErgebnis expectedOutput) {
        this.assertEqualsDynamicDelta(actualOutput.getKostenPersonal_proBaum(), expectedOutput.getKostenPersonal_proBaum());
    }

    @Test(dataProvider="csvData")
    public void testKostenPersonal_proHektar(String testcaseName, AustrichternErgebnis actualOutput, AustrichternMockErgebnis expectedOutput) {
        this.assertEqualsDynamicDelta(actualOutput.getKostenPersonal_proHektar(), expectedOutput.getKostenPersonal_proHektar());
    }

    @Test(dataProvider="csvData")
    public void testKostenPersonal_proBestand(String testcaseName, AustrichternErgebnis actualOutput, AustrichternMockErgebnis expectedOutput) {
        this.assertEqualsDynamicDelta(actualOutput.getKostenPersonal_proBestand(), expectedOutput.getKostenPersonal_proBestand());
    }

    @Test(dataProvider="csvData")
    public void testKostenMaschinenGeraete_proBaum(String testcaseName, AustrichternErgebnis actualOutput, AustrichternMockErgebnis expectedOutput) {
        this.assertEqualsDynamicDelta(actualOutput.getKostenMaschinenGeraete_proBaum(), expectedOutput.getKostenMaschinenGeraete_proBaum());
    }

    @Test(dataProvider="csvData")
    public void testKostenMaschinenGeraete_proHektar(String testcaseName, AustrichternErgebnis actualOutput, AustrichternMockErgebnis expectedOutput) {
        this.assertEqualsDynamicDelta(actualOutput.getKostenMaschinenGeraete_proHektar(), expectedOutput.getKostenMaschinenGeraete_proHektar());
    }

    @Test(dataProvider="csvData")
    public void testKostenMaschinenGeraete_proBestand(String testcaseName, AustrichternErgebnis actualOutput, AustrichternMockErgebnis expectedOutput) {
        this.assertEqualsDynamicDelta(actualOutput.getKostenMaschinenGeraete_proBestand(), expectedOutput.getKostenMaschinenGeraete_proBestand());
    }

    @Test(dataProvider="csvData")
    public void testKostenGesamt_proBaum(String testcaseName, AustrichternErgebnis actualOutput, AustrichternMockErgebnis expectedOutput) {
        this.assertEqualsDynamicDelta(actualOutput.getKostenGesamt_proBaum(), expectedOutput.getKostenGesamt_proBaum());
    }

    @Test(dataProvider="csvData")
    public void testKostenGesamt_proHektar(String testcaseName, AustrichternErgebnis actualOutput, AustrichternMockErgebnis expectedOutput) {
        this.assertEqualsDynamicDelta(actualOutput.getKostenGesamt_proHektar(), expectedOutput.getKostenGesamt_proHektar());
    }

    @Test(dataProvider="csvData")
    public void testKostenGesamt_proBestand(String testcaseName, AustrichternErgebnis actualOutput, AustrichternMockErgebnis expectedOutput) {
        this.assertEqualsDynamicDelta(actualOutput.getKostenGesamt_proBestand(), expectedOutput.getKostenGesamt_proBestand());
    }
}

