/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.juwapfl.model;

import ch.wsl.fps.juwapfl.Messages;
import ch.wsl.fps.juwapfl.model.AbstractModel;
import ch.wsl.fps.juwapfl.model.AustrichternErgebnis;

public class AustrichternModel
extends AbstractModel {
    public static final double DEFAULT_KOSTEN_SICHEL_PRO_HA = 0.6;
    private double flaeche_ha;
    private MaschinenGeraete maschinenGeraete;
    private int anzahlPflanzenProHa;
    private Verunkrautung verunkrautung;
    private Hangneigung hangneigung;
    private RueckegassenVorhanden rueckegassenVorhanden;
    private Schutzsystem schutzsystem;
    private Temperatur temperatur;
    private double kostenPersonal_proH;
    private double kostenMotorsaege_proLiter;
    private double kostenSichel_proHektar;
    private double faktorWegzeitenUndPausen;

    public void setFlaeche_ha(double flaeche_ha) {
        this.flaeche_ha = flaeche_ha;
    }

    public void setMaschinenGeraete(MaschinenGeraete maschinenGeraete) {
        this.maschinenGeraete = maschinenGeraete;
    }

    public void setAnzahlPflanzenProHa(int anzahlPflanzenProHa) {
        this.anzahlPflanzenProHa = anzahlPflanzenProHa;
    }

    public void setVerunkrautung(Verunkrautung verunkrautung) {
        this.verunkrautung = verunkrautung;
    }

    public void setHangneigung(Hangneigung hangneigung) {
        this.hangneigung = hangneigung;
    }

    public void setRueckegassenVorhanden(RueckegassenVorhanden rueckegassenVorhanden) {
        this.rueckegassenVorhanden = rueckegassenVorhanden;
    }

    public void setSchutzsystem(Schutzsystem schutzsystem) {
        this.schutzsystem = schutzsystem;
    }

    public void setTemperatur(Temperatur temperatur) {
        this.temperatur = temperatur;
    }

    public void setKostenPersonal_proH(double kostenPersonal_proH) {
        this.kostenPersonal_proH = kostenPersonal_proH;
    }

    public void setKostenMotorsaege_proLiter(double kostenMotorsaege_proLiter) {
        this.kostenMotorsaege_proLiter = kostenMotorsaege_proLiter;
    }

    public void setKostenSichel_proHektar(double kostenSichel_proHektar) {
        this.kostenSichel_proHektar = kostenSichel_proHektar;
    }

    public void setFaktorWegzeitenUndPausen(double faktorWegzeitenUndPausen) {
        this.faktorWegzeitenUndPausen = faktorWegzeitenUndPausen;
    }

    @Override
    public AustrichternErgebnis getErgebnis() {
        AustrichternErgebnis ergebnis = new AustrichternErgebnis();
        double psh15_basic = 0.004 * (double)this.anzahlPflanzenProHa + 4.0;
        double kf1 = this.verunkrautung.getKorrekturfaktor();
        double kf2 = this.hangneigung.getKorrekturfaktor();
        double kf3 = this.rueckegassenVorhanden.getKorrekturfaktor();
        double kf4 = this.schutzsystem.getKorrekturfaktor();
        double kf5 = this.temperatur.getKorrekturfaktor();
        double psh15_proHa = psh15_basic * kf1 * kf2 * kf3 * kf4 * kf5;
        double wpsh_proHa = psh15_proHa * 1.1 * this.faktorWegzeitenUndPausen;
        double kostenPersonalProHa = wpsh_proHa * this.kostenPersonal_proH;
        double treibstoffverbrauchProHa = 0.4722 * psh15_proHa + 0.9475;
        double kostenMotorsaegeProHa = treibstoffverbrauchProHa * this.kostenMotorsaege_proLiter;
        double geraetekostenSichelProHa = this.kostenSichel_proHektar;
        double kostenMaschinenGeraete_proHa = 0.0;
        if (this.maschinenGeraete == MaschinenGeraete.FREISCHNEIDER_MOTORSAEGE) {
            kostenMaschinenGeraete_proHa = kostenMotorsaegeProHa;
        } else if (this.maschinenGeraete == MaschinenGeraete.SICHEL) {
            kostenMaschinenGeraete_proHa = geraetekostenSichelProHa;
        }
        ergebnis.setFlaecheBestand_ha(this.flaeche_ha);
        ergebnis.setAnzahlPflanzenProHektar(this.anzahlPflanzenProHa);
        ergebnis.setZeitPersonal_WPSHProHa(wpsh_proHa);
        ergebnis.setKostenPersonal_proHa(kostenPersonalProHa);
        ergebnis.setKostenMaschinenGeraete_proHa(kostenMaschinenGeraete_proHa);
        ergebnis.setKostenGesamt_proHa(kostenPersonalProHa + kostenMaschinenGeraete_proHa);
        return ergebnis;
    }

    public static enum Hangneigung {
        HN_0_BIS_24_PROZENT,
        HN_25_BIS_44_PROZENT,
        HN_45_BIS_64_PROZENT,
        HN_65_BIS_84_PROZENT,
        HN_85_BIS_200_PROZENT;


        public String toString() {
            switch (this) {
                case HN_0_BIS_24_PROZENT: {
                    return "0 - 24%";
                }
                case HN_25_BIS_44_PROZENT: {
                    return "25 - 44%";
                }
                case HN_45_BIS_64_PROZENT: {
                    return "45 - 64%";
                }
                case HN_65_BIS_84_PROZENT: {
                    return "65 - 84%";
                }
                case HN_85_BIS_200_PROZENT: {
                    return ">= 85%";
                }
            }
            throw new RuntimeException(this.name());
        }

        public static Hangneigung getDefault() {
            return HN_0_BIS_24_PROZENT;
        }

        public double getKorrekturfaktor() {
            switch (this) {
                case HN_0_BIS_24_PROZENT: {
                    return 1.0;
                }
                case HN_25_BIS_44_PROZENT: {
                    return 1.1;
                }
                case HN_45_BIS_64_PROZENT: {
                    return 1.25;
                }
                case HN_65_BIS_84_PROZENT: {
                    return 1.5;
                }
                case HN_85_BIS_200_PROZENT: {
                    return 2.0;
                }
            }
            throw new IllegalStateException(this.name());
        }
    }

    public static enum MaschinenGeraete {
        FREISCHNEIDER_MOTORSAEGE,
        SICHEL;


        public String toString() {
            switch (this) {
                case FREISCHNEIDER_MOTORSAEGE: {
                    return Messages.getString("Austrichtern.FreischneiderMotorsaege");
                }
                case SICHEL: {
                    return Messages.getString("Austrichtern.Sichel");
                }
            }
            throw new RuntimeException(this.name());
        }

        public static MaschinenGeraete getDefault() {
            return FREISCHNEIDER_MOTORSAEGE;
        }
    }

    public static enum RueckegassenVorhanden {
        JA,
        NEIN;


        public String toString() {
            switch (this) {
                case JA: {
                    return Messages.getString("Austrichtern.RueckegassenVorhanden.ja");
                }
                case NEIN: {
                    return Messages.getString("Austrichtern.RueckegassenVorhanden.nein");
                }
            }
            throw new RuntimeException(this.name());
        }

        public static RueckegassenVorhanden getDefault() {
            return JA;
        }

        public double getKorrekturfaktor() {
            switch (this) {
                case JA: {
                    return 1.0;
                }
                case NEIN: {
                    return 1.1;
                }
            }
            throw new IllegalStateException(this.name());
        }
    }

    public static enum Schutzsystem {
        EINZELSCHUTZ,
        ZAUN,
        KEIN_WILDSCHUTZ;


        public String toString() {
            switch (this) {
                case EINZELSCHUTZ: {
                    return Messages.getString("Austrichtern.Schutzsystem.Einzelschutz");
                }
                case ZAUN: {
                    return Messages.getString("Austrichtern.Schutzsystem.Zaun");
                }
                case KEIN_WILDSCHUTZ: {
                    return Messages.getString("Austrichtern.Schutzsystem.KeinWildschutz");
                }
            }
            throw new RuntimeException(this.name());
        }

        public static Schutzsystem getDefault() {
            return EINZELSCHUTZ;
        }

        public double getKorrekturfaktor() {
            switch (this) {
                case EINZELSCHUTZ: {
                    return 1.0;
                }
                case ZAUN: 
                case KEIN_WILDSCHUTZ: {
                    return 1.2;
                }
            }
            throw new IllegalStateException(this.name());
        }
    }

    public static enum Temperatur {
        ANGENEHM,
        WARM,
        HEISS;


        public String toString() {
            switch (this) {
                case ANGENEHM: {
                    return Messages.getString("Austrichtern.Temperatur.angenehm");
                }
                case WARM: {
                    return Messages.getString("Austrichtern.Temperatur.warm");
                }
                case HEISS: {
                    return Messages.getString("Austrichtern.Temperatur.heiss");
                }
            }
            throw new RuntimeException(this.name());
        }

        public static Temperatur getDefault() {
            return WARM;
        }

        public double getKorrekturfaktor() {
            switch (this) {
                case ANGENEHM: {
                    return 0.9;
                }
                case WARM: {
                    return 1.0;
                }
                case HEISS: {
                    return 1.2;
                }
            }
            throw new IllegalStateException(this.name());
        }
    }

    public static enum Verunkrautung {
        SCHWACH,
        MITTEL,
        STARK,
        EXTREM_STARK;


        public String toString() {
            switch (this) {
                case SCHWACH: {
                    return Messages.getString("Austrichtern.Verunkrautung.schwach");
                }
                case MITTEL: {
                    return Messages.getString("Austrichtern.Verunkrautung.mittel");
                }
                case STARK: {
                    return Messages.getString("Austrichtern.Verunkrautung.stark");
                }
                case EXTREM_STARK: {
                    return Messages.getString("Austrichtern.Verunkrautung.extremStark");
                }
            }
            throw new RuntimeException(this.name());
        }

        public static Verunkrautung getDefault() {
            return MITTEL;
        }

        public double getKorrekturfaktor() {
            switch (this) {
                case SCHWACH: {
                    return 0.8;
                }
                case MITTEL: {
                    return 1.0;
                }
                case STARK: {
                    return 1.4;
                }
                case EXTREM_STARK: {
                    return 2.0;
                }
            }
            throw new IllegalStateException(this.name());
        }
    }
}

