/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.juwapfl.model;

import ch.wsl.fps.juwapfl.model.AbstractErgebnis;
import ch.wsl.fps.juwapfl.model.AbstractModel;
import ch.wsl.fps.juwapfl.util.CsvReader;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;

public abstract class AbstractJuwapflModelTest {
    protected static final String TESTCASES_CSV_FOLDER = "testcases/";
    private static final double DEFAULT_DELTA = 0.0051;
    private static final double DEFAULT_DELTA_MINUTES = 0.51;
    private static final boolean ADAPT_DELTA = true;
    private Object[][] testData;

    @BeforeClass
    public void initTestData() {
        CsvReader csv = new CsvReader(";", "#", true);
        String fileName = this.getCsvPath();
        List<String[]> testcases = csv.readFile(fileName);
        int nrOfTestcases = testcases.size();
        Object[][] testData = new Object[nrOfTestcases][3];
        int i = 0;
        while (i < nrOfTestcases) {
            AbstractModel inputData = this.parseInputData(testcases.get(i));
            AbstractErgebnis expectedOutput = this.parseExpectedValues(testcases.get(i));
            AbstractErgebnis actualOutput = null;
            try {
                actualOutput = inputData.getErgebnis();
                actualOutput.printErgebnis();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            testData[i][0] = "Testcase " + (i + 1);
            testData[i][1] = actualOutput;
            testData[i][2] = expectedOutput;
            ++i;
        }
        this.testData = testData;
    }

    protected abstract String getCsvPath();

    protected abstract AbstractModel parseInputData(String[] var1);

    protected abstract AbstractErgebnis parseExpectedValues(String[] var1);

    @DataProvider(name="csvData")
    public final Object[][] getTestData() {
        return this.testData;
    }

    protected double[] getDoubleValues(String[] testcase, int firstCol) {
        int numberOfFields = testcase.length - firstCol;
        double[] result = new double[numberOfFields];
        int i = firstCol;
        while (i < testcase.length) {
            result[i - firstCol] = Double.valueOf(testcase[i]);
            ++i;
        }
        return result;
    }

    protected void assertEqualsDynamicDelta(double actual, double expected) {
        if (expected < 10000.0) {
            this.assertEqualsDynamicAbsoluteDelta(actual, expected);
        } else {
            this.assertEqualsDynamicRelativeDelta(actual, expected);
        }
    }

    protected void assertEqualsDynamicDeltaMinutes(double actual, double expected) {
        Assert.assertEquals((double)actual, (double)expected, (double)0.51);
    }

    private final void assertEqualsDynamicAbsoluteDelta(double actual, double expected) {
        double delta = 0.0051;
        if (expected > 1000.0) {
            delta *= 2.0;
        }
        Assert.assertEquals((double)actual, (double)expected, (double)delta);
    }

    private final void assertEqualsDynamicRelativeDelta(double actual, double expected) {
        double relativeDelta = 1.00005;
        double absoluteDelta = expected * (relativeDelta - 1.0);
        Assert.assertEquals((double)actual, (double)expected, (double)absoluteDelta);
    }
}

