/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.juwapfl.gui.panel.input;

import ch.wsl.fps.juwapfl.Messages;
import ch.wsl.fps.juwapfl.gui.Utilities;
import ch.wsl.fps.juwapfl.gui.main.AbstractMainWindow;
import ch.wsl.fps.juwapfl.gui.main.ZBaumDurchforstungMainWindow;
import ch.wsl.fps.juwapfl.gui.panel.input.AbstractInputPanel;
import ch.wsl.fps.juwapfl.gui.panel.input.ZBaumDurchforstungBestandPanel;
import ch.wsl.fps.juwapfl.model.ZBaumDurchforstungModel;
import java.awt.GridLayout;
import java.util.Arrays;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class ZBaumDurchforstungKronenschnittPanel
extends AbstractInputPanel {
    private final ZBaumDurchforstungMainWindow mainWindow;
    private final ZBaumDurchforstungBestandPanel panelBestand;
    private final JSpinner txtAnzahlZBaeumeMitKronenschnittProHektare = new JSpinner(new SpinnerNumberModel(0, 0, 50, 1));
    private final JComboBox<ZBaumDurchforstungModel.AusfuehrungshoeheKronenschnitt> cmbAusfuehrungshoeheKronenschnitt = new JComboBox<ZBaumDurchforstungModel.AusfuehrungshoeheKronenschnitt>(ZBaumDurchforstungModel.AusfuehrungshoeheKronenschnitt.values());

    public ZBaumDurchforstungKronenschnittPanel(ZBaumDurchforstungMainWindow mainWindow, ZBaumDurchforstungBestandPanel panelBestand) {
        super(Messages.getString("ZBaumDurchforstung.Kronenschnitt"));
        AbstractMainWindow.adjustJSpinnerFormatter(this.txtAnzahlZBaeumeMitKronenschnittProHektare, false);
        this.mainWindow = mainWindow;
        this.panelBestand = panelBestand;
        this.setLayout(new GridLayout(0, 2, 5, 0));
        this.add(new JLabel(Messages.getString("ZBaumDurchforstung.AnzahlZBaeumeMitKronenschnittProHa")));
        this.add(Utilities.getPanelWithoutInfoButton(this.txtAnzahlZBaeumeMitKronenschnittProHektare));
        this.add(new JLabel(Messages.getString("ZBaumDurchforstung.AusfuehrungshoeheKronenschnitt")));
        this.add(Utilities.getPanelWithoutInfoButton(this.cmbAusfuehrungshoeheKronenschnitt));
        this.cmbAusfuehrungshoeheKronenschnitt.setSelectedItem((Object)ZBaumDurchforstungModel.AusfuehrungshoeheKronenschnitt.getDefault());
        this.initListeners();
    }

    private void initListeners() {
        this.txtAnzahlZBaeumeMitKronenschnittProHektare.addChangeListener(this.mainWindow.getDefaultChangeListener());
        this.txtAnzahlZBaeumeMitKronenschnittProHektare.addChangeListener(event -> {
            int anzahlZ = this.panelBestand.getAnzahlZBaeumeProHektare();
            int anzahlZMitKS = (Integer)this.txtAnzahlZBaeumeMitKronenschnittProHektare.getValue();
            if (anzahlZMitKS > anzahlZ) {
                String msg = Messages.getString("ZBaumDurchforstung.WarnungAnzahlZBaeume");
                JOptionPane.showMessageDialog(this, msg);
            }
        });
        this.cmbAusfuehrungshoeheKronenschnitt.addActionListener(this.mainWindow.getDefaultActionListener());
    }

    public void onInputChangedBeforeCalculation() {
        ZBaumDurchforstungModel.Entwicklungsstufe entwicklungsstufe = this.panelBestand.getEntwicklungsstufe();
        if (entwicklungsstufe == ZBaumDurchforstungModel.Entwicklungsstufe.DICKUNG) {
            this.txtAnzahlZBaeumeMitKronenschnittProHektare.setEnabled(true);
            int anzahlZ = this.panelBestand.getAnzahlZBaeumeProHektare();
            int anzahlZMitKS = (Integer)this.txtAnzahlZBaeumeMitKronenschnittProHektare.getValue();
            if (anzahlZMitKS > anzahlZ) {
                this.txtAnzahlZBaeumeMitKronenschnittProHektare.setValue(anzahlZ);
            }
        } else if (entwicklungsstufe == ZBaumDurchforstungModel.Entwicklungsstufe.STANGENHOLZ_1) {
            this.txtAnzahlZBaeumeMitKronenschnittProHektare.setEnabled(false);
            this.txtAnzahlZBaeumeMitKronenschnittProHektare.setValue(0);
        }
        if (entwicklungsstufe == ZBaumDurchforstungModel.Entwicklungsstufe.DICKUNG) {
            this.cmbAusfuehrungshoeheKronenschnitt.setEnabled(true);
            if (this.cmbAusfuehrungshoeheKronenschnitt.getItemCount() == 1) {
                this.cmbAusfuehrungshoeheKronenschnitt.removeAllItems();
                Arrays.asList(ZBaumDurchforstungModel.AusfuehrungshoeheKronenschnitt.values(ZBaumDurchforstungModel.Entwicklungsstufe.DICKUNG)).forEach(item -> this.cmbAusfuehrungshoeheKronenschnitt.addItem((ZBaumDurchforstungModel.AusfuehrungshoeheKronenschnitt)((Object)item)));
                this.cmbAusfuehrungshoeheKronenschnitt.setSelectedItem((Object)ZBaumDurchforstungModel.AusfuehrungshoeheKronenschnitt.getDefault());
            }
        } else if (entwicklungsstufe == ZBaumDurchforstungModel.Entwicklungsstufe.STANGENHOLZ_1) {
            this.cmbAusfuehrungshoeheKronenschnitt.setEnabled(false);
            this.cmbAusfuehrungshoeheKronenschnitt.removeAllItems();
            this.cmbAusfuehrungshoeheKronenschnitt.addItem(ZBaumDurchforstungModel.AusfuehrungshoeheKronenschnitt.NICHT_VERFUEGBAR);
            this.cmbAusfuehrungshoeheKronenschnitt.setSelectedItem((Object)ZBaumDurchforstungModel.AusfuehrungshoeheKronenschnitt.NICHT_VERFUEGBAR);
        }
    }

    public Integer getAnzahlZBaeumeMitKronenschnittProHektare() {
        return (Integer)this.txtAnzahlZBaeumeMitKronenschnittProHektare.getValue();
    }

    public ZBaumDurchforstungModel.AusfuehrungshoeheKronenschnitt getAusfuehrungshoeheKronenschnitt() {
        return this.cmbAusfuehrungshoeheKronenschnitt.getItemAt(this.cmbAusfuehrungshoeheKronenschnitt.getSelectedIndex());
    }

    @Override
    public String getAsXmlString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<section name=\"" + Messages.getString("ZBaumDurchforstung.Kronenschnitt") + "\"> ");
        sb.append(this.getXmlEntry(Messages.getString("ZBaumDurchforstung.AnzahlZBaeumeMitKronenschnittProHa"), this.getAnzahlZBaeumeMitKronenschnittProHektare()));
        sb.append(this.getXmlEntry(Messages.getString("ZBaumDurchforstung.AusfuehrungshoeheKronenschnitt"), (Object)this.getAusfuehrungshoeheKronenschnitt()));
        sb.append("</section> ");
        return sb.toString();
    }
}

