/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.juwapfl.gui.panel.input;

import ch.wsl.fps.juwapfl.Messages;
import ch.wsl.fps.juwapfl.gui.Utilities;
import ch.wsl.fps.juwapfl.gui.main.AbstractMainWindow;
import ch.wsl.fps.juwapfl.gui.main.ZBaumDurchforstungMainWindow;
import ch.wsl.fps.juwapfl.gui.panel.input.AbstractInputPanel;
import ch.wsl.fps.juwapfl.model.ZBaumDurchforstungModel;
import java.awt.GridLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class ZBaumDurchforstungBestandPanel
extends AbstractInputPanel {
    private final ZBaumDurchforstungMainWindow mainWindow;
    private final JSpinner txtFlaeche_ha = new JSpinner(new SpinnerNumberModel(0.8, 0.1, 10.0, 0.1));
    private final JComboBox<ZBaumDurchforstungModel.Entwicklungsstufe> cmbEntwicklungsstufe = new JComboBox<ZBaumDurchforstungModel.Entwicklungsstufe>(ZBaumDurchforstungModel.Entwicklungsstufe.values());
    private final JSpinner txtAnzahlZBaeumeProHektar = new JSpinner(new SpinnerNumberModel(80, 1, 2000, 1));
    private final JSpinner txtAnzahlKonkurrentenProZBaum = new JSpinner(new SpinnerNumberModel(2.5, 1.0, 15.0, 0.5));
    private final JComboBox<ZBaumDurchforstungModel.Baendeln> cmbBaendeln = new JComboBox<ZBaumDurchforstungModel.Baendeln>(ZBaumDurchforstungModel.Baendeln.values());
    private final JComboBox<ZBaumDurchforstungModel.Hangneigung> cmbHangneigung = new JComboBox<ZBaumDurchforstungModel.Hangneigung>(ZBaumDurchforstungModel.Hangneigung.values());
    private final JComboBox<ZBaumDurchforstungModel.Belaubung> cmbBelaubung = new JComboBox<ZBaumDurchforstungModel.Belaubung>(ZBaumDurchforstungModel.Belaubung.values());
    private final JComboBox<ZBaumDurchforstungModel.Verunkrautung> cmbVerunkrautung = new JComboBox<ZBaumDurchforstungModel.Verunkrautung>(ZBaumDurchforstungModel.Verunkrautung.values());
    private final JComboBox<ZBaumDurchforstungModel.RueckegassenVorhanden> cmbRueckegassenVorhanden = new JComboBox<ZBaumDurchforstungModel.RueckegassenVorhanden>(ZBaumDurchforstungModel.RueckegassenVorhanden.values());
    private final JComboBox<ZBaumDurchforstungModel.Temperatur> cmbTemperatur = new JComboBox<ZBaumDurchforstungModel.Temperatur>(ZBaumDurchforstungModel.Temperatur.values());
    private final JComboBox<ZBaumDurchforstungModel.Zersaegen> cmbZersaegen = new JComboBox<ZBaumDurchforstungModel.Zersaegen>(ZBaumDurchforstungModel.Zersaegen.values());

    public ZBaumDurchforstungBestandPanel(ZBaumDurchforstungMainWindow mainWindow) {
        super(Messages.getString("ZBaumDurchforstung.Bestand"));
        AbstractMainWindow.adjustJSpinnerFormatter(this.txtFlaeche_ha, false);
        AbstractMainWindow.adjustJSpinnerFormatter(this.txtAnzahlZBaeumeProHektar, false);
        AbstractMainWindow.adjustJSpinnerFormatter(this.txtAnzahlKonkurrentenProZBaum, false);
        this.mainWindow = mainWindow;
        this.setLayout(new GridLayout(0, 2, 5, 0));
        this.add(new JLabel(Messages.getString("ZBaumDurchforstung.Flaeche")));
        this.add(Utilities.getPanelWithoutInfoButton(this.txtFlaeche_ha));
        this.add(new JLabel(Messages.getString("ZBaumDurchforstung.Entwicklungsstufe")));
        String infoTextEntwicklungsstufe = Messages.getString("ZBaumDurchforstung.InfoButtonEntwicklungsstufe");
        this.add(Utilities.getPanelWithInfoButton(this.cmbEntwicklungsstufe, infoTextEntwicklungsstufe));
        this.add(new JLabel(Messages.getString("ZBaumDurchforstung.AnzahlZBaeumeProHa")));
        this.add(Utilities.getPanelWithoutInfoButton(this.txtAnzahlZBaeumeProHektar));
        this.add(new JLabel(Messages.getString("ZBaumDurchforstung.AnzahlKonkurrentenProZBaum")));
        this.add(Utilities.getPanelWithoutInfoButton(this.txtAnzahlKonkurrentenProZBaum));
        this.add(new JLabel(Messages.getString("ZBaumDurchforstung.Baendeln")));
        this.add(Utilities.getPanelWithoutInfoButton(this.cmbBaendeln));
        this.add(new JLabel(Messages.getString("ZBaumDurchforstung.Hangneigung")));
        this.add(Utilities.getPanelWithoutInfoButton(this.cmbHangneigung));
        this.add(new JLabel(Messages.getString("ZBaumDurchforstung.Belaubung")));
        this.add(Utilities.getPanelWithoutInfoButton(this.cmbBelaubung));
        this.add(new JLabel(Messages.getString("ZBaumDurchforstung.Verunkrautung")));
        this.add(Utilities.getPanelWithoutInfoButton(this.cmbVerunkrautung));
        this.add(new JLabel(Messages.getString("ZBaumDurchforstung.RueckegassenVorhanden")));
        this.add(Utilities.getPanelWithoutInfoButton(this.cmbRueckegassenVorhanden));
        this.add(new JLabel(Messages.getString("ZBaumDurchforstung.Lufttemperatur")));
        this.add(Utilities.getPanelWithoutInfoButton(this.cmbTemperatur));
        this.add(new JLabel(Messages.getString("ZBaumDurchforstung.Zersaegen")));
        String msg = "<html><li><b>" + Messages.getString("ZBaumDurchforstung.Zersaegen.minimal") + ":</b> " + Messages.getString("ZBaumDurchforstung.Zersaegen.Hinweis.minimal") + "</li>" + "<li><b>" + Messages.getString("ZBaumDurchforstung.Zersaegen.mittel") + ":</b> " + Messages.getString("ZBaumDurchforstung.Zersaegen.Hinweis.mittel") + "</li>" + "<li><b>" + Messages.getString("ZBaumDurchforstung.Zersaegen.hoch") + ":</b> " + Messages.getString("ZBaumDurchforstung.Zersaegen.Hinweis.hoch") + "</li>" + "<li><b>" + Messages.getString("ZBaumDurchforstung.Zersaegen.extrem") + ":</b> " + Messages.getString("ZBaumDurchforstung.Zersaegen.Hinweis.extrem") + "</li>" + "</html>";
        this.add(Utilities.getPanelWithInfoButton(this.cmbZersaegen, msg));
        this.cmbEntwicklungsstufe.setSelectedItem((Object)ZBaumDurchforstungModel.Entwicklungsstufe.getDefault());
        this.cmbBaendeln.setSelectedItem((Object)ZBaumDurchforstungModel.Baendeln.getDefault());
        this.cmbHangneigung.setSelectedItem((Object)ZBaumDurchforstungModel.Hangneigung.getDefault());
        this.cmbBelaubung.setSelectedItem((Object)ZBaumDurchforstungModel.Belaubung.getDefault());
        this.cmbVerunkrautung.setSelectedItem((Object)ZBaumDurchforstungModel.Verunkrautung.getDefault());
        this.cmbRueckegassenVorhanden.setSelectedItem((Object)ZBaumDurchforstungModel.RueckegassenVorhanden.getDefault());
        this.cmbTemperatur.setSelectedItem((Object)ZBaumDurchforstungModel.Temperatur.getDefault());
        this.cmbZersaegen.setSelectedItem((Object)ZBaumDurchforstungModel.Zersaegen.getDefault());
        this.initListeners();
    }

    private void initListeners() {
        this.txtFlaeche_ha.addChangeListener(this.mainWindow.getDefaultChangeListener());
        this.cmbEntwicklungsstufe.addActionListener(this.mainWindow.getDefaultActionListener());
        this.txtAnzahlZBaeumeProHektar.addChangeListener(this.mainWindow.getDefaultChangeListener());
        this.txtAnzahlKonkurrentenProZBaum.addChangeListener(this.mainWindow.getDefaultChangeListener());
        this.cmbBaendeln.addActionListener(this.mainWindow.getDefaultActionListener());
        this.cmbHangneigung.addActionListener(this.mainWindow.getDefaultActionListener());
        this.cmbBelaubung.addActionListener(this.mainWindow.getDefaultActionListener());
        this.cmbVerunkrautung.addActionListener(this.mainWindow.getDefaultActionListener());
        this.cmbRueckegassenVorhanden.addActionListener(this.mainWindow.getDefaultActionListener());
        this.cmbTemperatur.addActionListener(this.mainWindow.getDefaultActionListener());
        this.cmbZersaegen.addActionListener(this.mainWindow.getDefaultActionListener());
    }

    public void onInputChangedBeforeCalculation() {
        this.adaptCmbVerunkrautung();
    }

    private void adaptCmbVerunkrautung() {
        if (this.getEntwicklungsstufe() == ZBaumDurchforstungModel.Entwicklungsstufe.STANGENHOLZ_1 && this.getVerunkrautung() == ZBaumDurchforstungModel.Verunkrautung.EXTREM_STARK) {
            this.cmbVerunkrautung.setSelectedItem((Object)ZBaumDurchforstungModel.Verunkrautung.STARK);
        }
        if (this.getEntwicklungsstufe() == ZBaumDurchforstungModel.Entwicklungsstufe.DICKUNG && this.cmbVerunkrautung.getItemCount() == 3) {
            this.cmbVerunkrautung.addItem(ZBaumDurchforstungModel.Verunkrautung.EXTREM_STARK);
        } else if (this.getEntwicklungsstufe() == ZBaumDurchforstungModel.Entwicklungsstufe.STANGENHOLZ_1) {
            this.cmbVerunkrautung.removeItem((Object)ZBaumDurchforstungModel.Verunkrautung.EXTREM_STARK);
        }
    }

    public Double getFlaeche_ha() {
        return (Double)this.txtFlaeche_ha.getValue();
    }

    public ZBaumDurchforstungModel.Entwicklungsstufe getEntwicklungsstufe() {
        return this.cmbEntwicklungsstufe.getItemAt(this.cmbEntwicklungsstufe.getSelectedIndex());
    }

    public Integer getAnzahlZBaeumeProHektare() {
        return (Integer)this.txtAnzahlZBaeumeProHektar.getValue();
    }

    public Double getAnzahlKonkurrentenProZBaum() {
        return (Double)this.txtAnzahlKonkurrentenProZBaum.getValue();
    }

    public ZBaumDurchforstungModel.Baendeln getBaendeln() {
        return this.cmbBaendeln.getItemAt(this.cmbBaendeln.getSelectedIndex());
    }

    public ZBaumDurchforstungModel.Hangneigung getHangneigung() {
        return this.cmbHangneigung.getItemAt(this.cmbHangneigung.getSelectedIndex());
    }

    public ZBaumDurchforstungModel.Belaubung getBelaubung() {
        return this.cmbBelaubung.getItemAt(this.cmbBelaubung.getSelectedIndex());
    }

    public ZBaumDurchforstungModel.Verunkrautung getVerunkrautung() {
        return this.cmbVerunkrautung.getItemAt(this.cmbVerunkrautung.getSelectedIndex());
    }

    public ZBaumDurchforstungModel.RueckegassenVorhanden getRueckegassenVorhanden() {
        return this.cmbRueckegassenVorhanden.getItemAt(this.cmbRueckegassenVorhanden.getSelectedIndex());
    }

    public ZBaumDurchforstungModel.Temperatur getTemperatur() {
        return this.cmbTemperatur.getItemAt(this.cmbTemperatur.getSelectedIndex());
    }

    public ZBaumDurchforstungModel.Zersaegen getZersaegen() {
        return this.cmbZersaegen.getItemAt(this.cmbZersaegen.getSelectedIndex());
    }

    @Override
    public String getAsXmlString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<section name=\"" + Messages.getString("ZBaumDurchforstung.Bestand") + "\"> ");
        sb.append(this.getXmlEntry(Messages.getString("ZBaumDurchforstung.Flaeche"), this.getFlaeche_ha()));
        sb.append(this.getXmlEntry(Messages.getString("ZBaumDurchforstung.Entwicklungsstufe"), (Object)this.getEntwicklungsstufe()));
        sb.append(this.getXmlEntry(Messages.getString("ZBaumDurchforstung.AnzahlZBaeumeProHa"), this.getAnzahlZBaeumeProHektare()));
        sb.append(this.getXmlEntry(Messages.getString("ZBaumDurchforstung.AnzahlKonkurrentenProZBaum"), this.getAnzahlKonkurrentenProZBaum()));
        sb.append(this.getXmlEntry(Messages.getString("ZBaumDurchforstung.Baendeln"), (Object)this.getBaendeln()));
        sb.append(this.getXmlEntry(Messages.getString("ZBaumDurchforstung.Hangneigung"), (Object)this.getHangneigung()));
        sb.append(this.getXmlEntry(Messages.getString("ZBaumDurchforstung.Belaubung"), (Object)this.getBelaubung()));
        sb.append(this.getXmlEntry(Messages.getString("ZBaumDurchforstung.Verunkrautung"), (Object)this.getVerunkrautung()));
        sb.append(this.getXmlEntry(Messages.getString("ZBaumDurchforstung.RueckegassenVorhanden"), (Object)this.getRueckegassenVorhanden()));
        sb.append(this.getXmlEntry(Messages.getString("ZBaumDurchforstung.Lufttemperatur"), (Object)this.getTemperatur()));
        sb.append(this.getXmlEntry(Messages.getString("ZBaumDurchforstung.Zersaegen"), (Object)this.getZersaegen()));
        sb.append("</section> ");
        return sb.toString();
    }
}

