/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.juwapfl.gui.panel.input;

import ch.wsl.fps.juwapfl.Messages;
import ch.wsl.fps.juwapfl.gui.Utilities;
import ch.wsl.fps.juwapfl.gui.main.AbstractMainWindow;
import ch.wsl.fps.juwapfl.gui.main.WildschutzMainWindow;
import ch.wsl.fps.juwapfl.gui.panel.input.AbstractInputPanel;
import ch.wsl.fps.juwapfl.model.WildschutzModel;
import java.awt.GridLayout;
import java.util.Arrays;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class WildschutzPanel
extends AbstractInputPanel {
    private final WildschutzMainWindow mainWindow;
    private final JComboBox<WildschutzModel.Schutztyp> cmbSchutztyp = new JComboBox<WildschutzModel.Schutztyp>(WildschutzModel.Schutztyp.values());
    private final JComboBox<WildschutzModel.Subtyp> cmbSubtyp = new JComboBox();
    private final JComboBox<WildschutzModel.Wuchshuellentyp> cmbWuchshuellentyp = new JComboBox();
    private final JSpinner txtAnzahlPflanzen = new JSpinner(new SpinnerNumberModel(50, 1, 10000, 1));
    private final JSpinner txtZaunlaenge_m = new JSpinner(new SpinnerNumberModel(100, 1, 10000, 1));
    private boolean isInModusKostenVergleich;

    public WildschutzPanel(WildschutzMainWindow mainWindow) {
        super(Messages.getString("Wildschutz.Wildschutz"));
        AbstractMainWindow.adjustJSpinnerFormatter(this.txtAnzahlPflanzen, false);
        AbstractMainWindow.adjustJSpinnerFormatter(this.txtZaunlaenge_m, false);
        this.isInModusKostenVergleich = false;
        this.mainWindow = mainWindow;
        this.setLayout(new GridLayout(0, 2, 5, 0));
        this.add(new JLabel(Messages.getString("Wildschutz.Schutztyp")));
        this.add(Utilities.getPanelWithoutInfoButton(this.cmbSchutztyp));
        this.add(new JLabel(Messages.getString("Wildschutz.Subtyp")));
        this.add(Utilities.getPanelWithoutInfoButton(this.cmbSubtyp));
        this.add(new JLabel(Messages.getString("Wildschutz.Wuchshuellentyp")));
        this.add(Utilities.getPanelWithoutInfoButton(this.cmbWuchshuellentyp));
        this.add(new JLabel(Messages.getString("Wildschutz.AnzahlPflanzen")));
        this.add(Utilities.getPanelWithoutInfoButton(this.txtAnzahlPflanzen));
        this.add(new JLabel(Messages.getString("Wildschutz.Zaunlaenge")));
        this.add(Utilities.getPanelWithoutInfoButton(this.txtZaunlaenge_m));
        this.cmbSchutztyp.setSelectedItem((Object)WildschutzModel.Schutztyp.getDefault());
        this.cmbSchutztyp.setMaximumRowCount(10);
        this.onInputChangedBeforeCalculation();
        this.initListeners();
    }

    private void initListeners() {
        this.cmbSchutztyp.addActionListener(this.mainWindow.getDefaultActionListener());
        this.cmbSubtyp.addActionListener(this.mainWindow.getDefaultActionListener());
        this.cmbWuchshuellentyp.addActionListener(this.mainWindow.getDefaultActionListener());
        this.txtAnzahlPflanzen.addChangeListener(this.mainWindow.getDefaultChangeListener());
        this.txtZaunlaenge_m.addChangeListener(this.mainWindow.getDefaultChangeListener());
    }

    public void onInputChangedBeforeCalculation() {
        boolean updateOfCmbSubtypNecessary = false;
        if (this.cmbSubtyp.getItemCount() != WildschutzModel.Subtyp.getValues(this.getSchutztyp()).length) {
            updateOfCmbSubtypNecessary = true;
        } else {
            int i = 0;
            while (i < this.cmbSubtyp.getItemCount()) {
                if (this.cmbSubtyp.getItemAt(i) != WildschutzModel.Subtyp.getValues(this.getSchutztyp())[i]) {
                    updateOfCmbSubtypNecessary = true;
                    break;
                }
                ++i;
            }
        }
        if (updateOfCmbSubtypNecessary) {
            this.cmbSubtyp.removeAllItems();
            Arrays.asList(WildschutzModel.Subtyp.getValues(this.getSchutztyp())).forEach(this.cmbSubtyp::addItem);
            this.cmbSubtyp.setEnabled(this.cmbSubtyp.getItemCount() > 1);
        }
        this.cmbWuchshuellentyp.setEnabled(this.cmbSchutztyp.getSelectedItem() == WildschutzModel.Schutztyp.WUCHSHUELLE);
        if (this.cmbSchutztyp.getSelectedItem() != WildschutzModel.Schutztyp.WUCHSHUELLE) {
            this.cmbWuchshuellentyp.removeAllItems();
        } else {
            boolean updateOfCmbWuchshuellentypNecessary = false;
            if (this.cmbWuchshuellentyp.getItemCount() != WildschutzModel.Wuchshuellentyp.getValues(this.getSubtyp()).length) {
                updateOfCmbWuchshuellentypNecessary = true;
            } else {
                int i = 0;
                while (i < this.cmbWuchshuellentyp.getItemCount()) {
                    if (this.cmbWuchshuellentyp.getItemAt(i) != WildschutzModel.Wuchshuellentyp.getValues(this.getSubtyp())[i]) {
                        updateOfCmbWuchshuellentypNecessary = true;
                        break;
                    }
                    ++i;
                }
            }
            if (updateOfCmbWuchshuellentypNecessary) {
                this.cmbWuchshuellentyp.removeAllItems();
                Arrays.asList(WildschutzModel.Wuchshuellentyp.getValues(this.getSubtyp())).forEach(this.cmbWuchshuellentyp::addItem);
                this.cmbWuchshuellentyp.setSelectedItem((Object)WildschutzModel.Wuchshuellentyp.getDefault(this.getSubtyp()));
                this.cmbWuchshuellentyp.setEnabled(this.cmbWuchshuellentyp.getItemCount() > 1);
            }
        }
        if (this.cmbSchutztyp.getSelectedItem() == null) {
            this.txtAnzahlPflanzen.setEnabled(false);
            this.txtZaunlaenge_m.setEnabled(this.isInModusKostenVergleich);
        } else if (this.cmbSchutztyp.getSelectedItem() == WildschutzModel.Schutztyp.FLAECHENSCHUTZ) {
            this.txtAnzahlPflanzen.setEnabled(false);
            this.txtZaunlaenge_m.setEnabled(true);
        } else {
            this.txtAnzahlPflanzen.setEnabled(true);
            this.txtZaunlaenge_m.setEnabled(this.isInModusKostenVergleich);
        }
    }

    public void setModusKostenvergleich(boolean flag) {
        this.isInModusKostenVergleich = flag;
        this.txtZaunlaenge_m.setEnabled(this.isInModusKostenVergleich);
        if (this.isInModusKostenVergleich) {
            this.cmbSchutztyp.removeItem((Object)WildschutzModel.Schutztyp.FLAECHENSCHUTZ);
        } else {
            this.cmbSchutztyp.addItem(WildschutzModel.Schutztyp.FLAECHENSCHUTZ);
        }
    }

    public WildschutzModel.Schutztyp getSchutztyp() {
        return this.cmbSchutztyp.getItemAt(this.cmbSchutztyp.getSelectedIndex());
    }

    public WildschutzModel.Subtyp getSubtyp() {
        return this.cmbSubtyp.getItemAt(this.cmbSubtyp.getSelectedIndex());
    }

    public WildschutzModel.Wuchshuellentyp getWuchshuellentyp() {
        return this.cmbWuchshuellentyp.getItemAt(this.cmbWuchshuellentyp.getSelectedIndex());
    }

    public Integer getAnzahlPflanzen() {
        return (Integer)this.txtAnzahlPflanzen.getValue();
    }

    public Integer getZaunlaenge_m() {
        return (Integer)this.txtZaunlaenge_m.getValue();
    }

    @Override
    public String getAsXmlString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<section name=\"" + Messages.getString("Wildschutz.Wildschutz") + "\"> ");
        sb.append(this.getXmlEntry(Messages.getString("Wildschutz.Schutztyp"), (Object)this.getSchutztyp()));
        if (this.getSchutztyp() != WildschutzModel.Schutztyp.CHEMISCHER_SCHUTZ && this.getSchutztyp() != WildschutzModel.Schutztyp.SCHAELSCHUTZ) {
            sb.append(this.getXmlEntry(Messages.getString("Wildschutz.Subtyp"), (Object)this.getSubtyp()));
        }
        if (this.getSchutztyp() == WildschutzModel.Schutztyp.WUCHSHUELLE) {
            sb.append(this.getXmlEntry(Messages.getString("Wildschutz.Wuchshuellentyp"), (Object)this.getWuchshuellentyp()));
        }
        if (this.getSchutztyp() != WildschutzModel.Schutztyp.FLAECHENSCHUTZ) {
            sb.append(this.getXmlEntry(Messages.getString("Wildschutz.AnzahlPflanzen"), this.getAnzahlPflanzen()));
        }
        if (this.getSchutztyp() == WildschutzModel.Schutztyp.FLAECHENSCHUTZ) {
            sb.append(this.getXmlEntry(Messages.getString("Wildschutz.Zaunlaenge"), this.getZaunlaenge_m()));
        }
        sb.append("</section> ");
        return sb.toString();
    }
}

