/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.juwapfl.gui.panel.input;

import ch.wsl.fps.juwapfl.Messages;
import ch.wsl.fps.juwapfl.gui.Utilities;
import ch.wsl.fps.juwapfl.gui.main.AbstractMainWindow;
import ch.wsl.fps.juwapfl.gui.panel.input.AbstractInputPanel;
import java.awt.GridLayout;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class WildschutzKorrekturfaktorenPanel
extends AbstractInputPanel {
    private final AbstractMainWindow mainWindow;
    private final JSpinner txtKorrekturfaktorZeitaufwand = new JSpinner(new SpinnerNumberModel(1.0, 0.0, 10.0, 0.1));
    private final JSpinner txtKorrekturfaktorMaterialkosten = new JSpinner(new SpinnerNumberModel(1.0, 0.0, 10.0, 0.1));

    public WildschutzKorrekturfaktorenPanel(AbstractMainWindow mainWindow) {
        super(Messages.getString("Wildschutz.Korrekturfaktoren"));
        this.mainWindow = mainWindow;
        this.setLayout(new GridLayout(0, 2, 5, 0));
        this.add(new JLabel(Messages.getString("Wildschutz.KorrekturfaktorZeitaufwand")));
        String infoButtonTextZeit = Messages.getString("Wildschutz.InfoButtonKorrekturfaktorZeitaufwand");
        this.add(Utilities.getPanelWithInfoButton(this.txtKorrekturfaktorZeitaufwand, infoButtonTextZeit));
        this.add(new JLabel(Messages.getString("Wildschutz.KorrekturfaktorMaterialkosten")));
        String infoButtonTextMaterial = Messages.getString("Wildschutz.InfoButtonKorrekturfaktorMaterialkosten");
        this.add(Utilities.getPanelWithInfoButton(this.txtKorrekturfaktorMaterialkosten, infoButtonTextMaterial));
        this.initFields();
        this.initListeners();
    }

    private void initFields() {
        this.txtKorrekturfaktorZeitaufwand.setEditor(new JSpinner.NumberEditor(this.txtKorrekturfaktorZeitaufwand, "0.00"));
        this.txtKorrekturfaktorMaterialkosten.setEditor(new JSpinner.NumberEditor(this.txtKorrekturfaktorMaterialkosten, "0.00"));
        AbstractMainWindow.adjustJSpinnerFormatter(this.txtKorrekturfaktorZeitaufwand, false);
        AbstractMainWindow.adjustJSpinnerFormatter(this.txtKorrekturfaktorMaterialkosten, false);
    }

    private void initListeners() {
        this.txtKorrekturfaktorZeitaufwand.addChangeListener(this.mainWindow.getDefaultChangeListener());
        this.txtKorrekturfaktorMaterialkosten.addChangeListener(this.mainWindow.getDefaultChangeListener());
    }

    public Double getKorrekturfaktorZeitaufwand() {
        return (Double)this.txtKorrekturfaktorZeitaufwand.getValue();
    }

    public Double getKorrekturfaktorMaterialkosten() {
        return (Double)this.txtKorrekturfaktorMaterialkosten.getValue();
    }

    @Override
    public String getAsXmlString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<section name=\"" + Messages.getString("Wildschutz.Korrekturfaktoren") + "\"> ");
        sb.append(this.getXmlEntry(Messages.getString("Wildschutz.KorrekturfaktorZeitaufwand"), this.getKorrekturfaktorZeitaufwand()));
        sb.append(this.getXmlEntry(Messages.getString("Wildschutz.KorrekturfaktorMaterialkosten"), this.getKorrekturfaktorMaterialkosten()));
        sb.append("</section> ");
        return sb.toString();
    }
}

