/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.juwapfl.gui.panel.input;

import ch.wsl.fps.juwapfl.Messages;
import ch.wsl.fps.juwapfl.gui.panel.ergebnis.AbstractErgebnisPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.annotations.XYPointerAnnotation;
import org.jfree.chart.annotations.XYPolygonAnnotation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.ui.TextAnchor;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class WildschutzChartPanel
extends JPanel {
    private final JFreeChart chart;
    private final XYSeries dataLine = new XYSeries((Comparable)((Object)"dataLine"));
    private final XYSeries dataPoint = new XYSeries((Comparable)((Object)"dataPoint"));
    private double anzahlPflanzenBeiZaunlaenge500 = 1000.0;
    private double anzahlPflanzen = 0.0;
    private double zaunlaenge = 0.0;
    private static final int ALPHA = 48;
    private static final Color COLOR_A = new Color(255, 255, 0, 48);
    private static final Color COLOR_B = new Color(0, 0, 255, 48);

    public WildschutzChartPanel() {
        String title = Messages.getString("Wildschutz.TitelKostenvergleich");
        String categoryAxisLabel = Messages.getString("Wildschutz.Zaunlaenge");
        String valueAxisLabel = Messages.getString("Wildschutz.AnzahlPflanzen");
        XYSeriesCollection dataset = new XYSeriesCollection(this.dataLine);
        dataset.addSeries(this.dataPoint);
        this.chart = ChartFactory.createXYLineChart((String)title, (String)categoryAxisLabel, (String)valueAxisLabel, (XYDataset)dataset);
        this.chart.removeLegend();
        this.chart.getTitle().setFont(this.chart.getTitle().getFont().deriveFont(14.0f));
        this.chart.getXYPlot().getDomainAxis().setLabelFont(this.chart.getXYPlot().getDomainAxis().getLabelFont().deriveFont(12.0f));
        this.chart.getXYPlot().getRangeAxis().setLabelFont(this.chart.getXYPlot().getRangeAxis().getLabelFont().deriveFont(12.0f));
        this.chart.getXYPlot().getDomainAxis().setRange(0.0, 500.0);
        this.chart.getXYPlot().getRangeAxis().setRange(0.0, 1000.0);
        XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer(true, true);
        renderer.setSeriesLinesVisible(1, false);
        renderer.setSeriesPaint(0, (Paint)Color.BLACK);
        renderer.setSeriesPaint(1, (Paint)Color.BLACK);
        renderer.setSeriesShape(1, (Shape)new Ellipse2D.Double(-3.0, -3.0, 6.0, 6.0));
        this.chart.getXYPlot().setRenderer((XYItemRenderer)renderer);
        this.chart.setBackgroundPaint((Paint)AbstractErgebnisPanel.ERGEBNIS_PANEL_BACKGROUND_COLOR);
        ChartPanel chartPanel = new ChartPanel(this.chart);
        chartPanel.setPreferredSize(new Dimension(550, 200));
        this.setLayout(new BorderLayout());
        this.add((Component)chartPanel, "Center");
        this.resetData();
    }

    public void setData(double anzahlPflanzenBeiZaunlaenge500, double anzahlPflanzen, double zaunlaenge) {
        this.anzahlPflanzenBeiZaunlaenge500 = anzahlPflanzenBeiZaunlaenge500;
        this.anzahlPflanzen = anzahlPflanzen;
        this.zaunlaenge = zaunlaenge;
        this.resetData();
    }

    private void resetData() {
        this.dataLine.clear();
        this.dataLine.add(0.0, 0.0);
        this.dataLine.add(5000.0, 10.0 * this.anzahlPflanzenBeiZaunlaenge500);
        this.dataPoint.clear();
        this.dataPoint.add(this.zaunlaenge, this.anzahlPflanzen);
        this.chart.getXYPlot().clearAnnotations();
        WildschutzChartPanel.setPolygons(this.chart.getXYPlot(), 500.0, this.anzahlPflanzenBeiZaunlaenge500);
        WildschutzChartPanel.setDatapoint(this.chart.getXYPlot(), this.zaunlaenge, this.anzahlPflanzen);
    }

    private static void setPolygons(XYPlot plot, double x, double y) {
        XYPolygonAnnotation polygon1 = new XYPolygonAnnotation(new double[]{0.0, 0.0, x *= 10.0, 0.0, x, y *= 10.0}, null, null, (Paint)COLOR_A);
        plot.addAnnotation((XYAnnotation)polygon1);
        XYPolygonAnnotation polygon2 = new XYPolygonAnnotation(new double[]{0.0, 0.0, 0.0, y, x, y}, null, null, (Paint)COLOR_B);
        plot.addAnnotation((XYAnnotation)polygon2);
    }

    private static void setDatapoint(XYPlot plot, double x, double y) {
        boolean isOnUpperHalf;
        XYPointerAnnotation datapoint = new XYPointerAnnotation(Messages.getString("Wildschutz.IhreEingabe"), x, y, 0.0);
        datapoint.setFont(datapoint.getFont().deriveFont(14.0f));
        datapoint.setFont(datapoint.getFont().deriveFont(1));
        datapoint.setBaseRadius(40.0);
        datapoint.setTextAnchor(TextAnchor.HALF_ASCENT_LEFT);
        boolean isOnRightHalf = x > plot.getDomainAxis().getUpperBound() / 2.0;
        boolean bl = isOnUpperHalf = y > plot.getRangeAxis().getUpperBound() / 2.0;
        if (isOnRightHalf) {
            datapoint.setTextAnchor(TextAnchor.HALF_ASCENT_RIGHT);
        }
        if (!isOnRightHalf && isOnUpperHalf) {
            datapoint.setAngle(0.7853981633974483);
        }
        if (isOnRightHalf && isOnUpperHalf) {
            datapoint.setAngle(2.356194490192345);
        }
        if (isOnRightHalf && !isOnUpperHalf) {
            datapoint.setAngle(3.9269908169872414);
        }
        if (!isOnRightHalf && !isOnUpperHalf) {
            datapoint.setAngle(5.497787143782138);
        }
        plot.addAnnotation((XYAnnotation)datapoint);
    }
}

