/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.juwapfl.gui.panel.input;

import ch.wsl.fps.juwapfl.Messages;
import ch.wsl.fps.juwapfl.gui.CurrencySensitive;
import ch.wsl.fps.juwapfl.gui.Utilities;
import ch.wsl.fps.juwapfl.gui.controls.JFlashingSpinner;
import ch.wsl.fps.juwapfl.gui.main.AbstractMainWindow;
import ch.wsl.fps.juwapfl.gui.panel.input.AbstractInputPanel;
import ch.wsl.fps.juwapfl.model.SchneegleitenModel;
import java.awt.GridLayout;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class SchneegleitenUnterhaltPanel
extends AbstractInputPanel
implements CurrencySensitive {
    private final AbstractMainWindow mainWindow;
    private final JLabel lblFahrzeugkosten_ChfProEinheit = new JLabel();
    private final JLabel lblMaterialkosten_ChfProEinheit = new JLabel();
    private final JFlashingSpinner txtPersonalzeit_minProEinheit = new JFlashingSpinner(new SpinnerNumberModel(0.0, 0.0, 1000.0, 1.0));
    private final JSpinner txtFahrzeugkosten_ChfProEinheit = new JSpinner(new SpinnerNumberModel(0.0, 0.0, 1000.0, 1.0));
    private final JSpinner txtMaterialkosten_ChfProEinheit = new JSpinner(new SpinnerNumberModel(0.0, 0.0, 1000.0, 1.0));
    private SchneegleitenModel.Massnahme massnahme;

    public SchneegleitenUnterhaltPanel(AbstractMainWindow mainWindow) {
        super(Messages.getString("Schneegleiten.TitelZeitenKostenKontrolleUnterhalt"));
        this.mainWindow = mainWindow;
        this.setLayout(new GridLayout(0, 2, 5, 0));
        this.add(new JLabel(Messages.getString("Schneegleiten.ReineArbeitszeit")));
        this.add(Utilities.getPanelWithoutInfoButton(this.txtPersonalzeit_minProEinheit));
        this.add(this.lblFahrzeugkosten_ChfProEinheit);
        this.add(Utilities.getPanelWithoutInfoButton(this.txtFahrzeugkosten_ChfProEinheit));
        this.add(this.lblMaterialkosten_ChfProEinheit);
        this.add(Utilities.getPanelWithoutInfoButton(this.txtMaterialkosten_ChfProEinheit));
        this.initFields();
        this.initListeners();
        mainWindow.registerForCurrencyUpdates(this);
    }

    private void initFields() {
        this.txtPersonalzeit_minProEinheit.setEditor(new JSpinner.NumberEditor((JSpinner)this.txtPersonalzeit_minProEinheit, "0.00"));
        this.txtFahrzeugkosten_ChfProEinheit.setEditor(new JSpinner.NumberEditor(this.txtFahrzeugkosten_ChfProEinheit, "0.00"));
        this.txtMaterialkosten_ChfProEinheit.setEditor(new JSpinner.NumberEditor(this.txtMaterialkosten_ChfProEinheit, "0.00"));
        AbstractMainWindow.adjustJSpinnerFormatter(this.txtPersonalzeit_minProEinheit, false);
        AbstractMainWindow.adjustJSpinnerFormatter(this.txtFahrzeugkosten_ChfProEinheit, false);
        AbstractMainWindow.adjustJSpinnerFormatter(this.txtMaterialkosten_ChfProEinheit, false);
    }

    private void initListeners() {
        this.txtPersonalzeit_minProEinheit.addChangeListener(this.mainWindow.getDefaultChangeListener());
        this.txtFahrzeugkosten_ChfProEinheit.addChangeListener(this.mainWindow.getDefaultChangeListener());
        this.txtMaterialkosten_ChfProEinheit.addChangeListener(this.mainWindow.getDefaultChangeListener());
    }

    public void onInputChangedBeforeCalculation(SchneegleitenModel.Massnahme massnahme) {
        if (this.massnahme != massnahme) {
            this.massnahme = massnahme;
            this.txtPersonalzeit_minProEinheit.setValue(SchneegleitenModel.getDefaultUnterhaltPersonalzeit_minProEinheit(massnahme));
            if (!this.mainWindow.isInitializing) {
                this.txtPersonalzeit_minProEinheit.flash();
            }
        }
    }

    public Double getPersonalzeit_minProEinheit() {
        return (Double)this.txtPersonalzeit_minProEinheit.getValue();
    }

    public Double getFahrzeugkosten_ChfProEinheit() {
        return (Double)this.txtFahrzeugkosten_ChfProEinheit.getValue();
    }

    public Double getMaterialkosten_ChfProEinheit() {
        return (Double)this.txtMaterialkosten_ChfProEinheit.getValue();
    }

    @Override
    public String getAsXmlString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<section name=\"" + Messages.getString("Schneegleiten.TitelZeitenKostenKontrolleUnterhalt") + "\"> ");
        sb.append(this.getXmlEntry(Messages.getString("Schneegleiten.ReineArbeitszeit"), this.getPersonalzeit_minProEinheit()));
        sb.append(this.getXmlEntry(String.valueOf(Messages.getString("Schneegleiten.Fahrzeugkosten")) + " [" + this.mainWindow.getCurrency() + Messages.getString("Schneegleiten.ProEinheit") + "]", this.getFahrzeugkosten_ChfProEinheit()));
        sb.append(this.getXmlEntry(String.valueOf(Messages.getString("Schneegleiten.Materialkosten")) + " [" + this.mainWindow.getCurrency() + Messages.getString("Schneegleiten.ProEinheit") + "]", this.getMaterialkosten_ChfProEinheit()));
        sb.append("</section> ");
        return sb.toString();
    }

    @Override
    public void updateCurrency() {
        this.lblFahrzeugkosten_ChfProEinheit.setText(String.valueOf(Messages.getString("Schneegleiten.Fahrzeugkosten")) + " [" + this.mainWindow.getCurrency() + Messages.getString("Schneegleiten.ProEinheit") + "]");
        this.lblMaterialkosten_ChfProEinheit.setText(String.valueOf(Messages.getString("Schneegleiten.Materialkosten")) + " [" + this.mainWindow.getCurrency() + Messages.getString("Schneegleiten.ProEinheit") + "]");
    }
}

