/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.juwapfl.gui.panel.input;

import ch.wsl.fps.juwapfl.Messages;
import ch.wsl.fps.juwapfl.gui.Utilities;
import ch.wsl.fps.juwapfl.gui.main.AbstractMainWindow;
import ch.wsl.fps.juwapfl.gui.main.SchneegleitenMainWindow;
import ch.wsl.fps.juwapfl.gui.panel.input.AbstractInputPanel;
import ch.wsl.fps.juwapfl.model.SchneegleitenModel;
import java.awt.GridLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class SchneegleitenPanel
extends AbstractInputPanel {
    private static final int DEFAULT_ANZAHL_BAUTEN = 30;
    private final SchneegleitenMainWindow mainWindow;
    private final JComboBox<SchneegleitenModel.Massnahme> cmbMassnahme = new JComboBox<SchneegleitenModel.Massnahme>(SchneegleitenModel.Massnahme.values());
    private final JLabel lblAnzahlBauten = new JLabel(Messages.getString("Schneegleiten.AnzahlBauten"));
    private final JSpinner txtAnzahlBauten = new JSpinner(new SpinnerNumberModel(30, 1, 1000, 1));
    private final JComboBox<SchneegleitenModel.Gelaendeverhaeltnisse> cmbGelaendeverhaeltnisse = new JComboBox<SchneegleitenModel.Gelaendeverhaeltnisse>(SchneegleitenModel.Gelaendeverhaeltnisse.values());

    public SchneegleitenPanel(SchneegleitenMainWindow mainWindow) {
        super(Messages.getString("Schneegleiten.Titel"));
        AbstractMainWindow.adjustJSpinnerFormatter(this.txtAnzahlBauten, false);
        this.mainWindow = mainWindow;
        this.setLayout(new GridLayout(0, 2, 5, 0));
        this.add(new JLabel(Messages.getString("Schneegleiten.Massnahme")));
        String msg = Messages.getString("Schneegleiten.InfoButtonMassnahme");
        this.add(Utilities.getPanelWithInfoButton(this.cmbMassnahme, msg));
        this.add(this.lblAnzahlBauten);
        this.add(Utilities.getPanelWithoutInfoButton(this.txtAnzahlBauten));
        this.add(new JLabel(Messages.getString("Schneegleiten.Gelaendeverhaeltnisse")));
        String infoButtonGelaendeverhaeltnisse = Messages.getString("Schneegleiten.InfoButtonGelaendeVerhaeltnisse");
        this.add(Utilities.getPanelWithInfoButton(this.cmbGelaendeverhaeltnisse, infoButtonGelaendeverhaeltnisse));
        this.cmbMassnahme.setSelectedItem((Object)SchneegleitenModel.Massnahme.getDefault());
        this.cmbGelaendeverhaeltnisse.setSelectedItem((Object)SchneegleitenModel.Gelaendeverhaeltnisse.getDefault());
        this.initListeners();
    }

    public void onInputChangedBeforeCalculation() {
        this.lblAnzahlBauten.setText(SchneegleitenPanel.getAnzahlBautenLabel(this.getMassnahme()));
    }

    private static String getAnzahlBautenLabel(SchneegleitenModel.Massnahme massnahme) {
        switch (massnahme) {
            case PFAEHLE: {
                return Messages.getString("Schneegleiten.AnzahlPfaehle");
            }
            case BERMEN: {
                return Messages.getString("Schneegleiten.AnzahlLaufmeterBermen");
            }
            case SCHWELLEN: {
                return Messages.getString("Schneegleiten.AnzahlSchwellen");
            }
            case DREIBEINBOECKE: {
                return Messages.getString("Schneegleiten.AnzahlDreibeinboecke");
            }
        }
        throw new RuntimeException("Unbekannte Massnahme: " + massnahme.name());
    }

    private void initListeners() {
        this.cmbMassnahme.addActionListener(this.mainWindow.getDefaultActionListener());
        this.txtAnzahlBauten.addChangeListener(this.mainWindow.getDefaultChangeListener());
        this.cmbGelaendeverhaeltnisse.addActionListener(this.mainWindow.getDefaultActionListener());
    }

    public SchneegleitenModel.Massnahme getMassnahme() {
        return this.cmbMassnahme.getItemAt(this.cmbMassnahme.getSelectedIndex());
    }

    public Integer getAnzahlBauten() {
        return (Integer)this.txtAnzahlBauten.getValue();
    }

    public SchneegleitenModel.Gelaendeverhaeltnisse getGelaendeverhaeltnisse() {
        return this.cmbGelaendeverhaeltnisse.getItemAt(this.cmbGelaendeverhaeltnisse.getSelectedIndex());
    }

    @Override
    public String getAsXmlString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<section name=\"" + Messages.getString("Schneegleiten.Titel") + "\"> ");
        sb.append(this.getXmlEntry(Messages.getString("Schneegleiten.Massnahme"), (Object)this.getMassnahme()));
        sb.append(this.getXmlEntry(SchneegleitenPanel.getAnzahlBautenLabel(this.getMassnahme()), this.getAnzahlBauten()));
        sb.append(this.getXmlEntry(Messages.getString("Schneegleiten.Gelaendeverhaeltnisse"), (Object)this.getGelaendeverhaeltnisse()));
        sb.append("</section> ");
        return sb.toString();
    }
}

