/*
 * Decompiled with CFR 0.152.
 */
package ch.wsl.fps.juwapfl.gui.panel.input;

import ch.wsl.fps.juwapfl.Messages;
import ch.wsl.fps.juwapfl.gui.CurrencySensitive;
import ch.wsl.fps.juwapfl.gui.Utilities;
import ch.wsl.fps.juwapfl.gui.controls.JFlashingSpinner;
import ch.wsl.fps.juwapfl.gui.main.AbstractMainWindow;
import ch.wsl.fps.juwapfl.gui.panel.input.AbstractInputPanel;
import ch.wsl.fps.juwapfl.model.SchneegleitenModel;
import java.awt.GridLayout;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class SchneegleitenErstellenPanel
extends AbstractInputPanel
implements CurrencySensitive {
    private final AbstractMainWindow mainWindow;
    private final JLabel lblMaterialkosten_ChfProEinheit = new JLabel();
    private final JLabel lblMaschinenkosten_ChfProEinheit = new JLabel();
    private final JLabel lblTransportkosten_ChfProEinheit = new JLabel();
    private final JFlashingSpinner txtPersonalzeit_minProEinheit = new JFlashingSpinner(new SpinnerNumberModel(0.0, 0.0, 1000.0, 1.0));
    private final JFlashingSpinner txtMaterialkosten_ChfProEinheit = new JFlashingSpinner(new SpinnerNumberModel(0.0, 0.0, 1000.0, 1.0));
    private final JFlashingSpinner txtMaschinenkosten_ChfProEinheit = new JFlashingSpinner(new SpinnerNumberModel(0.0, 0.0, 1000.0, 1.0));
    private final JFlashingSpinner txtTransportkosten_ChfProEinheit = new JFlashingSpinner(new SpinnerNumberModel(0.0, 0.0, 1000.0, 1.0));
    private SchneegleitenModel.Massnahme massnahme;

    public SchneegleitenErstellenPanel(AbstractMainWindow mainWindow) {
        super(Messages.getString("Schneegleiten.TitelZeitenUndKostenErstellen"));
        this.mainWindow = mainWindow;
        this.setLayout(new GridLayout(0, 2, 5, 0));
        this.add(new JLabel(Messages.getString("Schneegleiten.ReineArbeitszeit")));
        String infoButtonTextReineArbeitszeit = Messages.getString("Schneegleiten.InfoButtonReineArbeitszeit");
        this.add(Utilities.getPanelWithInfoButton(this.txtPersonalzeit_minProEinheit, infoButtonTextReineArbeitszeit));
        this.add(this.lblMaterialkosten_ChfProEinheit);
        this.add(Utilities.getPanelWithoutInfoButton(this.txtMaterialkosten_ChfProEinheit));
        this.add(this.lblMaschinenkosten_ChfProEinheit);
        this.add(Utilities.getPanelWithoutInfoButton(this.txtMaschinenkosten_ChfProEinheit));
        this.add(this.lblTransportkosten_ChfProEinheit);
        String infoButtonTextTransportkosten = Messages.getString("Schneegleiten.InfoButtonTransportkosten");
        this.add(Utilities.getPanelWithInfoButton(this.txtTransportkosten_ChfProEinheit, infoButtonTextTransportkosten));
        this.initFields();
        this.initListeners();
        mainWindow.registerForCurrencyUpdates(this);
    }

    private void initFields() {
        this.txtPersonalzeit_minProEinheit.setEditor(new JSpinner.NumberEditor((JSpinner)this.txtPersonalzeit_minProEinheit, "0.00"));
        this.txtMaterialkosten_ChfProEinheit.setEditor(new JSpinner.NumberEditor((JSpinner)this.txtMaterialkosten_ChfProEinheit, "0.00"));
        this.txtMaschinenkosten_ChfProEinheit.setEditor(new JSpinner.NumberEditor((JSpinner)this.txtMaschinenkosten_ChfProEinheit, "0.00"));
        this.txtTransportkosten_ChfProEinheit.setEditor(new JSpinner.NumberEditor((JSpinner)this.txtTransportkosten_ChfProEinheit, "0.00"));
        AbstractMainWindow.adjustJSpinnerFormatter(this.txtPersonalzeit_minProEinheit, false);
        AbstractMainWindow.adjustJSpinnerFormatter(this.txtMaterialkosten_ChfProEinheit, false);
        AbstractMainWindow.adjustJSpinnerFormatter(this.txtMaschinenkosten_ChfProEinheit, false);
        AbstractMainWindow.adjustJSpinnerFormatter(this.txtTransportkosten_ChfProEinheit, false);
    }

    private void initListeners() {
        this.txtPersonalzeit_minProEinheit.addChangeListener(this.mainWindow.getDefaultChangeListener());
        this.txtMaterialkosten_ChfProEinheit.addChangeListener(this.mainWindow.getDefaultChangeListener());
        this.txtMaschinenkosten_ChfProEinheit.addChangeListener(this.mainWindow.getDefaultChangeListener());
        this.txtTransportkosten_ChfProEinheit.addChangeListener(this.mainWindow.getDefaultChangeListener());
    }

    public void onInputChangedBeforeCalculation(SchneegleitenModel.Massnahme massnahme) {
        if (this.massnahme != massnahme) {
            this.massnahme = massnahme;
            this.txtPersonalzeit_minProEinheit.setValue(SchneegleitenModel.getDefaultErstellenPersonalzeit_minProEinheit(massnahme));
            this.txtMaterialkosten_ChfProEinheit.setValue(SchneegleitenModel.getDefaultErstellenMaterialkosten_ChfProEinheit(massnahme));
            this.txtMaschinenkosten_ChfProEinheit.setValue(SchneegleitenModel.getDefaultErstellenMaschinenkosten_ChfProEinheit(massnahme));
            if (!this.mainWindow.isInitializing) {
                this.txtPersonalzeit_minProEinheit.flash();
                this.txtMaterialkosten_ChfProEinheit.flash();
                this.txtMaschinenkosten_ChfProEinheit.flash();
            }
        }
    }

    public Double getPersonalzeit_minProEinheit() {
        return (Double)this.txtPersonalzeit_minProEinheit.getValue();
    }

    public Double getMaterialkosten_ChfProEinheit() {
        return (Double)this.txtMaterialkosten_ChfProEinheit.getValue();
    }

    public Double getMaschinenkosten_ChfProEinheit() {
        return (Double)this.txtMaschinenkosten_ChfProEinheit.getValue();
    }

    public Double getTransportkosten_ChfProEinheit() {
        return (Double)this.txtTransportkosten_ChfProEinheit.getValue();
    }

    @Override
    public String getAsXmlString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<section name=\"" + Messages.getString("Schneegleiten.TitelZeitenUndKostenErstellen") + "\"> ");
        sb.append(this.getXmlEntry(Messages.getString("Schneegleiten.ReineArbeitszeit"), this.getPersonalzeit_minProEinheit()));
        sb.append(this.getXmlEntry(String.valueOf(Messages.getString("Schneegleiten.Materialkosten")) + " [" + this.mainWindow.getCurrency() + Messages.getString("Schneegleiten.ProEinheit") + "]", this.getMaterialkosten_ChfProEinheit()));
        sb.append(this.getXmlEntry(String.valueOf(Messages.getString("Schneegleiten.Geraetekosten")) + " [" + this.mainWindow.getCurrency() + Messages.getString("Schneegleiten.ProEinheit") + "]", this.getMaschinenkosten_ChfProEinheit()));
        sb.append(this.getXmlEntry(String.valueOf(Messages.getString("Schneegleiten.Transportkosten")) + " [" + this.mainWindow.getCurrency() + Messages.getString("Schneegleiten.ProEinheit") + "]", this.getTransportkosten_ChfProEinheit()));
        sb.append("</section> ");
        return sb.toString();
    }

    @Override
    public void updateCurrency() {
        this.lblMaterialkosten_ChfProEinheit.setText(String.valueOf(Messages.getString("Schneegleiten.Materialkosten")) + " [" + this.mainWindow.getCurrency() + Messages.getString("Schneegleiten.ProEinheit") + "]");
        this.lblMaschinenkosten_ChfProEinheit.setText(String.valueOf(Messages.getString("Schneegleiten.Geraetekosten")) + " [" + this.mainWindow.getCurrency() + Messages.getString("Schneegleiten.ProEinheit") + "]");
        this.lblTransportkosten_ChfProEinheit.setText(String.valueOf(Messages.getString("Schneegleiten.Transportkosten")) + " [" + this.mainWindow.getCurrency() + Messages.getString("Schneegleiten.ProEinheit") + "]");
    }
}

